/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities;

public class Semaphore {
    private int sharedLockNum = 0;
    private boolean exclusiveLocked = false;
    public static int SHARED = 0;
    public static int EXCLUSIVE = 1;

    public synchronized void getLock(int type) throws Exception {
        if (type == SHARED) {
            while (this.exclusiveLocked) {
                this.wait();
            }
            ++this.sharedLockNum;
        } else if (type == EXCLUSIVE) {
            while (this.sharedLockNum != 0 || this.exclusiveLocked) {
                this.wait();
            }
            this.exclusiveLocked = true;
        }
    }

    public synchronized void extendToExclusive() throws Exception {
        if (this.sharedLockNum > 0) {
            --this.sharedLockNum;
        }
        if (this.sharedLockNum == 0 && !this.exclusiveLocked) {
            this.exclusiveLocked = true;
        } else {
            this.getLock(EXCLUSIVE);
        }
    }

    public synchronized void reduceToShared() throws Exception {
        this.exclusiveLocked = false;
        ++this.sharedLockNum;
    }

    public synchronized void releaseLock(int type) {
        if (type == SHARED) {
            if (this.sharedLockNum > 0) {
                --this.sharedLockNum;
                if (this.sharedLockNum == 0) {
                    this.notifyAll();
                }
            }
        } else if (type == EXCLUSIVE && this.exclusiveLocked) {
            this.exclusiveLocked = false;
            this.notifyAll();
        }
    }
}

