/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities;

import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.Utils;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InvalidValueException;

public class RestrictionChecker {
    public static final int MAX_BYTES = 2000;
    public static final int MAX_STRING = 1300;
    private static final int MAX_CONFIG_PATH_LENGTH = 256;
    private static final int MAX_CONFIG_PATH_LEVELS = 16;
    private static final int MAX_CONFIG_ENTRY_LENGTH = 256;
    private static final String[] FORBIDDEN_CONFIGNAME_CHARS = new String[]{"%", "[", "]", "#", "/"};

    public static void checkSubConfigurationPath(ConfigurationPath parentPath, String subConfigName) throws ConfigurationException {
        if (parentPath.getLevels() + 1 > 16) {
            throw new InvalidValueException("kernel_1630", new Object[]{new Integer(16)});
        }
        if (parentPath.length() + subConfigName.length() + 1 > 256) {
            throw new InvalidValueException("kernel_1633", new Object[]{new Integer(256)});
        }
        RestrictionChecker.checkConfigurationName(subConfigName);
    }

    public static void checkConfigurationPath(ConfigurationPath path) throws ConfigurationException {
        if (path.length() > 256) {
            throw new InvalidValueException("kernel_1633", new Object[]{new Integer(256)});
        }
        String[] allLevels = path.getLevelArray();
        if (allLevels.length > 16) {
            throw new InvalidValueException("kernel_1630", new Object[]{new Integer(16)});
        }
        int i = 0;
        while (i < allLevels.length) {
            RestrictionChecker.checkConfigurationName(allLevels[i]);
            ++i;
        }
    }

    public static void checkConfigurationName(String configName) throws ConfigurationException {
        if (configName == null || configName.equals("")) {
            throw new InvalidValueException("kernel_1635");
        }
        int i = 0;
        while (i < FORBIDDEN_CONFIGNAME_CHARS.length) {
            int index = configName.indexOf(FORBIDDEN_CONFIGNAME_CHARS[i]);
            if (index != -1) {
                throw new InvalidValueException("kernel_1631", new Object[]{FORBIDDEN_CONFIGNAME_CHARS[i], new Integer(index)});
            }
            ++i;
        }
        if (Utils.hasTrailingWhitespace(configName)) {
            throw new InvalidValueException("kernel_1638", new Object[]{configName});
        }
    }

    public static void checkConfigEntryName(String configName) throws ConfigurationException {
        if (configName == null || configName.equals("")) {
            throw new InvalidValueException("kernel_1636");
        }
        if (configName.length() > 256) {
            throw new InvalidValueException("kernel_1632", new Object[]{new Integer(256)});
        }
        if (Utils.hasTrailingWhitespace(configName)) {
            throw new InvalidValueException("kernel_1638", new Object[]{configName});
        }
    }
}

