/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.exception.standard.SAPNumberFormatException;
import java.util.Properties;

public class PropertyUtil {
    public Boolean getBooleanProperty(Properties properties, String name, boolean allowNull) throws NullPointerException {
        String string = properties.getProperty(name);
        if (string == null) {
            if (allowNull) {
                return null;
            }
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0008", new Object[]{name});
        }
        if ("true".equalsIgnoreCase(string = string.trim())) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        throw new SAPNumberFormatException("com.sap.exception.standard_0016", new Object[]{string, name});
    }

    public Integer getIntegerProperty(Properties properties, String name, int min, int max, boolean allowNull) throws NumberFormatException, NullPointerException {
        Integer result;
        String string = properties.getProperty(name);
        if (string == null) {
            if (allowNull) {
                return null;
            }
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0008", new Object[]{name});
        }
        try {
            int parsed = Integer.parseInt(string);
            result = new Integer(parsed);
        }
        catch (NumberFormatException e) {
            throw new SAPNumberFormatException("com.sap.exception.standard_0019", new Object[]{string, name});
        }
        if (result < min) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0009", new Object[]{name, new Integer(min), result});
        }
        if (result > max) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0010", new Object[]{name, new Integer(max), result});
        }
        return result;
    }

    public Integer getIntegerProperty(Properties properties, String name, boolean allowNull) throws NumberFormatException, NullPointerException {
        return this.getIntegerProperty(properties, name, Integer.MIN_VALUE, Integer.MAX_VALUE, allowNull);
    }

    public String getStringProperty(Properties properties, String name, int maxlength, boolean allowNull) throws NumberFormatException, NullPointerException {
        String string = properties.getProperty(name);
        if (string == null) {
            if (allowNull) {
                return null;
            }
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0008", new Object[]{name});
        }
        if (maxlength >= 0 && string.length() > maxlength) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0011", new Object[]{name, new Integer(maxlength), new Integer(string.length()), string});
        }
        return string;
    }

    public String getStringProperty(Properties properties, String name, boolean allowNull) throws NumberFormatException, NullPointerException {
        return this.getStringProperty(properties, name, -1, allowNull);
    }
}

