/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.utilities;

import com.sap.engine.lib.util.cache.Cache;
import com.sap.engine.lib.util.cache.CacheGroup;
import java.util.Comparator;
import java.util.Vector;

public class ConfigurationPath
implements Comparator {
    private static Object m_monitor = new Object();
    private static Cache m_allPaths;
    private static Vector m_levelNameCalcHelper;
    private String m_lockKey = null;
    private int m_hashCode;
    private int m_pathLength;
    private int m_levels;
    private StringWrapper m_path;
    private String[] m_levelNames;
    public static final ConfigurationPath ROOT_CONFIG_PATH;
    public static final Comparator COMPARATOR;

    private ConfigurationPath() {
        this.m_levelNames = new String[0];
        this.m_lockKey = "";
        this.m_hashCode = "".hashCode();
        this.m_path = new StringWrapper("", this.m_hashCode);
        this.m_pathLength = 0;
        this.m_levels = 0;
    }

    private ConfigurationPath(String path, String[] levelNames, String lockKey) {
        if (levelNames == null) {
            String pathtmp = path + "/";
            int i = pathtmp.indexOf("/");
            while (i != -1) {
                m_levelNameCalcHelper.add(pathtmp.substring(0, i));
                pathtmp = pathtmp.substring(i + 1);
                i = pathtmp.indexOf("/");
            }
            levelNames = m_levelNameCalcHelper.toArray(new String[0]);
            m_levelNameCalcHelper.clear();
        }
        this.m_levelNames = levelNames;
        this.m_lockKey = lockKey;
        this.m_hashCode = path.hashCode();
        this.m_path = new StringWrapper(path, this.m_hashCode);
        this.m_pathLength = path.length();
        m_allPaths.addCache((Object)this.m_path, (Object)this);
        this.m_levels = levelNames.length;
    }

    public static Comparator getComparator() {
        return COMPARATOR;
    }

    public int compare(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        String[] path1 = ((ConfigurationPath)obj1).m_levelNames;
        String[] path2 = ((ConfigurationPath)obj2).m_levelNames;
        int i1 = 0;
        int i2 = 0;
        while (i1 < path1.length && i2 < path2.length) {
            String subpath1 = path1[i1];
            String subpath2 = path2[i2];
            int cmp = subpath1.compareTo(subpath2);
            if (cmp != 0) {
                return cmp;
            }
            ++i1;
            ++i2;
        }
        if (i1 >= path1.length) {
            return -1;
        }
        return 1;
    }

    public static void init(CacheGroup group) {
        m_allPaths = new Cache(0, 100, group);
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String getLockKey() {
        if (this.m_lockKey != null) {
            return this.m_lockKey;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.m_levelNames.length) {
            buffer.append(Integer.toHexString(this.m_levelNames[i].hashCode()));
            buffer.append('/');
            ++i;
        }
        this.m_lockKey = buffer.toString();
        return this.m_lockKey;
    }

    private static ConfigurationPath getConfigurationPathInternal(String path, String[] levelNames, String lockKey, String subConfigName) {
        Object object = m_monitor;
        synchronized (object) {
            ConfigurationPath pathObj = (ConfigurationPath)m_allPaths.getByKey((Object)new StringWrapper(path));
            if (pathObj != null) {
                ConfigurationPath configurationPath = pathObj;
                return configurationPath;
            }
            if (!path.equals("")) {
                if (subConfigName != null) {
                    String[] newlevelNames = new String[levelNames.length + 1];
                    System.arraycopy(levelNames, 0, newlevelNames, 0, levelNames.length);
                    newlevelNames[levelNames.length] = subConfigName;
                    levelNames = newlevelNames;
                    if (lockKey != null) {
                        lockKey = lockKey + Integer.toHexString(subConfigName.hashCode()) + "/";
                    }
                }
                ConfigurationPath configurationPath = new ConfigurationPath(path, levelNames, lockKey);
                return configurationPath;
            }
            ConfigurationPath configurationPath = ROOT_CONFIG_PATH;
            return configurationPath;
        }
    }

    public static ConfigurationPath getConfigurationPath(String path) {
        return ConfigurationPath.getConfigurationPathInternal(path, null, null, null);
    }

    public static String getNameFromPath(String path) {
        int index = path.lastIndexOf(47) + 1;
        return path.substring(index);
    }

    public ConfigurationPath getSubConfigurationPath(String name) {
        return ConfigurationPath.getConfigurationPathInternal(this.m_path.m_str + "/" + name, this.m_levelNames, this.m_lockKey, name);
    }

    public ConfigurationPath getSubTreeConfigurationPath(String relPath) {
        return ConfigurationPath.getConfigurationPath(this.m_path.m_str + "/" + relPath);
    }

    public ConfigurationPath getRootConfigurationPath() {
        if (this.m_levels == 1) {
            return this;
        }
        return ConfigurationPath.getConfigurationPath(this.m_path.m_str.substring(0, this.m_path.m_str.indexOf("/")));
    }

    public String getPathString() {
        return this.m_path.m_str;
    }

    public String getNameFromPath() {
        return this.m_levelNames[this.m_levels - 1];
    }

    public String[] getLevelArray() {
        return this.m_levelNames;
    }

    public String getRelPathForSubPath(ConfigurationPath subPath) {
        if (!this.isArgumentSubTree(subPath)) {
            return null;
        }
        if (this.equals(subPath)) {
            return "";
        }
        return subPath.getPathString().substring(this.length() + 1);
    }

    public ConfigurationPath getParrentPath() {
        if (this == ROOT_CONFIG_PATH) {
            return null;
        }
        if (this.m_levels == 1) {
            return ROOT_CONFIG_PATH;
        }
        return ConfigurationPath.getConfigurationPathInternal(this.m_path.m_str.substring(0, this.m_path.m_str.lastIndexOf("/")), null, null, null);
    }

    public int length() {
        return this.m_pathLength;
    }

    public int getLevels() {
        return this.m_levels;
    }

    public boolean isArgumentSubTree(ConfigurationPath path) {
        if (path.m_pathLength < this.m_pathLength) {
            return false;
        }
        return (path.getPathString() + "/").startsWith(this.m_path.m_str + "/");
    }

    public String toString() {
        return this.m_path.m_str;
    }

    static {
        m_levelNameCalcHelper = new Vector();
        ROOT_CONFIG_PATH = new ConfigurationPath();
        COMPARATOR = new ConfigurationPath();
    }

    static class StringWrapper {
        private String m_str;
        private int m_hashCode;

        public StringWrapper(String str, int hashcode) {
            this.m_str = str;
            this.m_hashCode = hashcode;
        }

        public StringWrapper(String str) {
            this(str, str.hashCode());
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                return this.m_str.equals(obj);
            }
            return this.m_str.equals(((StringWrapper)obj).m_str);
        }
    }
}

