/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.security;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.addons.PropertyEntryImpl;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class Crypter
implements ConfigurationChangedListener {
    private static String SEC_KEY_FILE_NAME = "secretkey";
    private SecStoreFS m_secStore;
    private byte[] m_secretKey;
    private ConfigurationHandlerFactory m_configManager;
    private boolean m_initialized = false;
    private boolean m_ListenerInitialized = false;
    private Object m_initializeMonitor = new Object();

    public Crypter(ConfigurationHandlerFactory configManager) {
        this.m_secStore = new SecStoreFS();
        this.m_configManager = configManager;
    }

    private void provideInternalConfig(ConfigurationHandler handler) throws Exception {
        boolean exit = false;
        while (!exit) {
            Object var6_7;
            try {
                try {
                    Configuration internalCfg = handler.createRootConfiguration("configmanager_internal");
                    byte[] secKey = this.m_secStore.generateKey();
                    internalCfg.addFileAsStream(SEC_KEY_FILE_NAME, new ByteArrayInputStream(secKey));
                    handler.commit();
                    exit = true;
                }
                catch (ConfigurationLockedException locked) {
                    Environment.getInstance().getLogging().traceThrowable(3, locked.getMessage(), (Throwable)((Object)locked));
                    Thread.sleep(100L);
                    var6_7 = null;
                    handler.closeAllConfigurations();
                    continue;
                }
                catch (NameAlreadyExistsException exists) {
                    exit = true;
                    var6_7 = null;
                    handler.closeAllConfigurations();
                    continue;
                }
                var6_7 = null;
                handler.closeAllConfigurations();
            }
            catch (Throwable throwable) {
                var6_7 = null;
                handler.closeAllConfigurations();
                throw throwable;
            }
        }
    }

    private Configuration getInternalConfig(ConfigurationHandler handler, int accessType) throws Exception {
        while (true) {
            try {
                return handler.openConfiguration("configmanager_internal", accessType);
            }
            catch (ConfigurationLockedException locked) {
                Environment.getInstance().getLogging().traceThrowable(3, locked.getMessage(), (Throwable)((Object)locked));
                Thread.sleep(100L);
                continue;
            }
            catch (NameNotFoundException e) {
                this.provideInternalConfig(handler);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getSecretKeyFromConfig(Configuration internalCfg) throws ConfigurationException {
        try {
            int br;
            InputStream in = internalCfg.getFile(SEC_KEY_FILE_NAME);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            byte[] buf = new byte[2000];
            while ((br = in.read(buf)) != -1) {
                void var5_6;
                byteOut.write(buf, 0, (int)var5_6);
            }
            byteOut.flush();
            in.close();
            return byteOut.toByteArray();
        }
        catch (Exception e) {
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)((Object)e);
            }
            throw new ConfigurationException(e);
        }
    }

    private byte[] getSecretKeyFromCM() throws ConfigurationException {
        ConfigurationHandler cmConnection = this.m_configManager.getConfigurationHandler();
        try {
            try {
                Configuration internalCfg = this.getInternalConfig(cmConnection, 0);
                byte[] byArray = this.getSecretKeyFromConfig(internalCfg);
                Object var5_5 = null;
                cmConnection.closeAllConfigurations();
                return byArray;
            }
            catch (Exception e) {
                if (e instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)e);
                }
                throw new ConfigurationException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            cmConnection.closeAllConfigurations();
            throw throwable;
        }
    }

    private byte[] getSecretKey() throws ConfigurationException {
        Object object = this.m_initializeMonitor;
        synchronized (object) {
            if (this.m_initialized) {
                byte[] byArray = this.m_secretKey;
                return byArray;
            }
            this.m_secretKey = this.getSecretKeyFromCM();
            if (!this.m_ListenerInitialized) {
                this.m_configManager.getConfigurationHandler().addConfigurationChangedListener(this, "configmanager_internal", 1);
            }
            this.m_initialized = true;
            this.m_ListenerInitialized = true;
            byte[] byArray = this.m_secretKey;
            return byArray;
        }
    }

    public String encrypt(String str) throws ConfigurationException {
        try {
            return this.m_secStore.encryptString(str, this.getSecretKey());
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public String decrypt(String str) throws ConfigurationException {
        try {
            return this.m_secStore.decryptString(str, this.getSecretKey());
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void reencryptSecureContent() throws ConfigurationException {
        ConfigurationHandler cm_connection = this.m_configManager.getConfigurationHandler();
        try {
            try {
                Configuration internalCfg;
                String[] allRootNames = cm_connection.getAllRootNames();
                Configuration[] allRoots = new Configuration[allRootNames.length];
                int i = 0;
                while (i < allRoots.length) {
                    allRoots[i] = cm_connection.openConfiguration(allRootNames[i], 1);
                    ++i;
                }
                try {
                    internalCfg = cm_connection.openConfiguration("configmanager_internal", 1);
                }
                catch (NameNotFoundException e) {
                    Environment.getInstance().getLogging().log((byte)2, "Internal Configuration does not exist. This means there can not be any encrypted content for reencryption.");
                    Object var9_9 = null;
                    cm_connection.closeAllConfigurations();
                    return;
                }
                if (!internalCfg.existsFile(SEC_KEY_FILE_NAME)) {
                    Environment.getInstance().getLogging().log((byte)2, "SecretKey not found in internal configuration. This means there can not be any encrypted content for reencryption.");
                    Object var9_10 = null;
                    cm_connection.closeAllConfigurations();
                    return;
                }
                byte[] currentKey = this.getSecretKeyFromConfig(internalCfg);
                byte[] newKey = this.m_secStore.generateKey();
                this.processReencryption(currentKey, newKey, allRoots);
                internalCfg.updateFileAsStream(SEC_KEY_FILE_NAME, new ByteArrayInputStream(newKey));
                cm_connection.commit();
            }
            catch (Exception e) {
                if (e instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)e);
                }
                throw new ConfigurationException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            cm_connection.closeAllConfigurations();
            throw throwable;
        }
        Object var9_11 = null;
        cm_connection.closeAllConfigurations();
    }

    private void processReencryption(byte[] currentKey, byte[] newKey, Configuration[] configs) throws Exception {
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getMetaData().getConfigurationType() == 1) {
                PropertySheet sheet = configs[i].getPropertySheetInterface();
                PropertyEntry[] allEntries = sheet.getAllPropertyEntries();
                int ii = 0;
                while (ii < allEntries.length) {
                    PropertyEntryImpl entry = (PropertyEntryImpl)allEntries[ii];
                    if (entry.isSecure()) {
                        String def = (String)entry.getDefault();
                        String cust = (String)entry.getCustom();
                        entry.setReencryptedDefault(this.m_secStore.encryptString(def, newKey));
                        if (cust != null) {
                            entry.setReencryptedCustom(this.m_secStore.encryptString(cust, newKey));
                        }
                    }
                    ++ii;
                }
            } else {
                this.processReencryption(currentKey, newKey, configs[i].getAllSubConfigurations().values().toArray(new Configuration[0]));
            }
            ++i;
        }
    }

    public void configurationChanged(ChangeEvent e) {
        Object object = this.m_initializeMonitor;
        synchronized (object) {
            this.m_initialized = false;
            this.m_secretKey = null;
        }
    }
}

