/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.persistence.rdbms;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.FileEntry;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnection;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnectionPool;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class UpdateProcessor {
    private DBConnectionPool m_connPool;
    private DBConnection m_dbconn = null;
    private String m_transId;
    private Vector m_fileEntriesForStatusUpdate = new Vector();
    private int m_deleteEntries = 0;
    private int m_deleteFiles = 0;
    private int m_deleteConfig = 0;
    private int m_insertConfig = 0;
    private int m_updateConfig = 0;
    private int m_insertEntry = 0;
    private int m_updateEntry = 0;
    private int m_deleteEntry = 0;
    private int m_insertFile = 0;
    private int m_updateFile = 0;
    private int m_deleteFile = 0;

    protected UpdateProcessor(DBConnectionPool connPool, String transactionId) {
        this.m_connPool = connPool;
        this.m_transId = transactionId;
    }

    public void updateConfig(ConfigurationData data) throws ConfigurationException {
        Environment.getInstance().getLogging().trace(3, "updateConfig for " + data.getCID(), " in UpdateProcessor");
        try {
            Object entry;
            Integer otype;
            String name;
            Iterator iter;
            if (this.m_dbconn == null) {
                this.m_dbconn = this.m_connPool.getConnection();
            }
            if (data.isDeleted()) {
                this.m_dbconn.getDBAccess().addDeleteConfig(data.getCID(), data.getPath());
                ++this.m_deleteConfig;
                ++this.m_deleteEntries;
                ++this.m_deleteFiles;
                return;
            }
            if (data.isCreated()) {
                this.m_dbconn.getDBAccess().addInsertConfig(data.getCID(), data.getParentCID(), data.getPath(), data.getCacheMode(), data.getConfigurationType());
                ++this.m_insertConfig;
            }
            if (data.isCacheModeChanged()) {
                this.m_dbconn.getDBAccess().addUpdateConfig(data.getCID(), data.getCacheMode());
                ++this.m_updateConfig;
            }
            HashMap deltaValue = data.getValueDeltas();
            HashMap deltaFile = data.getFileDeltas();
            HashMap deltaSubConfig = data.getSubConfigDeltas();
            if (data.areAllValuesDeleted()) {
                this.m_dbconn.getDBAccess().addDeleteConfigEntries(data.getCID());
                ++this.m_deleteEntries;
            }
            if (data.areAllFilesDeleted()) {
                this.m_dbconn.getDBAccess().addDeleteFiles(data.getCID());
                ++this.m_deleteFiles;
            }
            if (deltaValue != null) {
                iter = deltaValue.keySet().iterator();
                while (iter.hasNext()) {
                    name = (String)iter.next();
                    otype = (Integer)deltaValue.get(name);
                    if (otype == ConfigurationData.ADD || otype == ConfigurationData.MODIFY) {
                        entry = data.getValueEntry(name);
                        int dtype = ((ValueEntry)entry).getType();
                        long discrete_nr = 0L;
                        double floating_nr = 0.0;
                        String string = null;
                        byte[] bytes = null;
                        switch (dtype) {
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 25: {
                                discrete_nr = (Long)((ValueEntry)entry).getDBValue();
                                break;
                            }
                            case 30: {
                                floating_nr = (Double)((ValueEntry)entry).getDBValue();
                                break;
                            }
                            case 40: {
                                string = (String)((ValueEntry)entry).getDBValue();
                                break;
                            }
                            case 50: 
                            case 60: {
                                bytes = (byte[])((ValueEntry)entry).getDBValue();
                                discrete_nr = bytes.length;
                            }
                        }
                        if (otype == ConfigurationData.ADD) {
                            this.m_dbconn.getDBAccess().addInsertConfigEntry(data.getCID(), ((ValueEntry)entry).getName(), dtype, discrete_nr, floating_nr, string, bytes);
                            ++this.m_insertEntry;
                            continue;
                        }
                        this.m_dbconn.getDBAccess().addUpdateConfigEntry(data.getCID(), ((ValueEntry)entry).getName(), dtype, discrete_nr, floating_nr, string, bytes);
                        ++this.m_updateEntry;
                        continue;
                    }
                    this.m_dbconn.getDBAccess().addDeleteConfigEntry(data.getCID(), name);
                    ++this.m_deleteEntry;
                }
            }
            if (deltaFile != null) {
                iter = deltaFile.keySet().iterator();
                while (iter.hasNext()) {
                    name = (String)iter.next();
                    otype = (Integer)deltaFile.get(name);
                    if (otype == ConfigurationData.ADD) {
                        entry = data.getFileEntry(name);
                        File file = ((FileEntry)entry).getFile();
                        if (file != null) {
                            this.m_dbconn.getDBAccess().addInsertFile(data.getCID(), name, file);
                        } else if (((FileEntry)entry).getStreamLength() == -10) {
                            this.m_dbconn.getDBAccess().addInsertFileAsStream(data.getCID(), name, ((FileEntry)entry).getStream(), this.m_transId);
                        } else {
                            this.m_dbconn.getDBAccess().addInsertFileAsStreamWithLength(data.getCID(), name, ((FileEntry)entry).getStream(), ((FileEntry)entry).getStreamLength());
                        }
                        this.m_fileEntriesForStatusUpdate.add(entry);
                        ++this.m_insertFile;
                        continue;
                    }
                    if (otype == ConfigurationData.MODIFY) {
                        entry = data.getFileEntry(name);
                        File file = ((FileEntry)entry).getFile();
                        if (file != null) {
                            this.m_dbconn.getDBAccess().addUpdateFile(data.getCID(), name, file);
                        } else {
                            this.m_dbconn.getDBAccess().addUpdateFileAsStream(data.getCID(), name, ((FileEntry)entry).getStream(), this.m_transId);
                        }
                        this.m_fileEntriesForStatusUpdate.add(entry);
                        ++this.m_updateFile;
                        continue;
                    }
                    this.m_dbconn.getDBAccess().addDeleteFile(data.getCID(), name);
                    ++this.m_deleteFile;
                }
            }
            if (deltaSubConfig != null) {
                iter = deltaSubConfig.keySet().iterator();
                while (iter.hasNext()) {
                    ConfigMetaDataImpl entry2 = (ConfigMetaDataImpl)iter.next();
                    otype = (Integer)deltaSubConfig.get(entry2);
                    if (otype != ConfigurationData.DELETE) continue;
                    this.m_dbconn.getDBAccess().addDeleteConfig(entry2.getCID(), entry2.getPath());
                    ++this.m_deleteConfig;
                    ++this.m_deleteEntries;
                    ++this.m_deleteFiles;
                }
            }
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1501", new Object[]{data.getPath().getPathString(), ""});
        }
    }

    public void commitUpdate() throws ConfigurationException {
        try {
            block9: {
                try {
                    if (this.m_dbconn == null) break block9;
                    this.flush();
                    this.m_dbconn.getDBAccess().commit();
                    int i = 0;
                    while (i < this.m_fileEntriesForStatusUpdate.size()) {
                        ((FileEntry)this.m_fileEntriesForStatusUpdate.get(i)).setStatus(2);
                        ++i;
                    }
                    this.m_fileEntriesForStatusUpdate.clear();
                    Environment.getInstance().getLogging().trace(2, "UpdateProcessor: Database commit", "");
                }
                catch (Exception e) {
                    Environment.getInstance().getLogging().logThrowable("Error during commit. See stacktrace for details.", e);
                    try {
                        this.rollbackUpdate();
                    }
                    catch (Exception ee) {
                        Environment.getInstance().getLogging().logThrowable("Error during rollback. See stacktrace for details.", ee);
                    }
                    throw new ConfigurationException(e, "kernel_1501", new Object[]{"", ""});
                }
            }
            Object var4_3 = null;
            if (this.m_dbconn != null) {
                this.m_connPool.releaseConnection(this.m_dbconn);
                this.m_dbconn = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.m_dbconn != null) {
                this.m_connPool.releaseConnection(this.m_dbconn);
                this.m_dbconn = null;
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flush() throws ConfigurationException {
        block17: {
            try {
                if (this.m_dbconn != null) {
                    if (this.m_deleteEntries > 0) {
                        this.m_dbconn.getDBAccess().execDeleteEntriesBatch();
                        this.m_deleteEntries = 0;
                    }
                    if (this.m_deleteFiles > 0) {
                        this.m_dbconn.getDBAccess().execDeleteFilesBatch();
                        this.m_deleteFiles = 0;
                    }
                    if (this.m_deleteConfig > 0) {
                        this.m_dbconn.getDBAccess().execDeleteConfigBatch();
                        this.m_deleteConfig = 0;
                    }
                    if (this.m_insertConfig > 0) {
                        this.m_dbconn.getDBAccess().execInsertConfigBatch();
                        this.m_insertConfig = 0;
                    }
                    if (this.m_updateConfig > 0) {
                        this.m_dbconn.getDBAccess().execUpdateConfigBatch();
                        this.m_updateConfig = 0;
                    }
                    if (this.m_insertEntry > 0) {
                        this.m_dbconn.getDBAccess().execInsertEntryBatch();
                        this.m_insertEntry = 0;
                    }
                    if (this.m_updateEntry > 0) {
                        this.m_dbconn.getDBAccess().execUpdateEntryBatch();
                        this.m_updateEntry = 0;
                    }
                    if (this.m_deleteEntry > 0) {
                        this.m_dbconn.getDBAccess().execDeleteEntryBatch();
                        this.m_deleteEntry = 0;
                    }
                    if (this.m_insertFile > 0) {
                        this.m_dbconn.getDBAccess().execInsertFileBatch();
                        this.m_insertFile = 0;
                    }
                    if (this.m_updateFile > 0) {
                        this.m_dbconn.getDBAccess().execUpdateFileBatch();
                        this.m_updateFile = 0;
                    }
                    if (this.m_deleteFile > 0) {
                        this.m_dbconn.getDBAccess().execDeleteFileBatch();
                        this.m_deleteFile = 0;
                    }
                    this.m_dbconn.getDBAccess().clearAllBatches();
                }
                break block17;
            }
            catch (SQLException e) {
                Environment.getInstance().getLogging().logThrowable("Error during flush data, trying to rollback. See stacktrace for details.", e);
                nested = e;
                i = 0;
                ** while ((nested = nested.getNextException()) != null)
            }
lbl-1000:
            // 1 sources

            {
                Environment.getInstance().getLogging().logThrowable("Chained Exception " + i++, nested);
                continue;
            }
lbl45:
            // 1 sources

            try {
                this.rollbackUpdate();
            }
            catch (Exception ee) {
                Environment.getInstance().getLogging().logThrowable("Error during rollback. See stacktrace for details.", ee);
            }
            throw new ConfigurationException(e, "kernel_1501", new Object[]{"", ""});
        }
    }

    public void rollbackUpdate() throws ConfigurationException {
        try {
            block7: {
                try {
                    if (this.m_dbconn == null) break block7;
                    this.m_dbconn.getDBAccess().clearAllBatches();
                    this.m_dbconn.getDBAccess().rollback();
                    int i = 0;
                    while (i < this.m_fileEntriesForStatusUpdate.size()) {
                        ((FileEntry)this.m_fileEntriesForStatusUpdate.get(i)).setStatus(3);
                        ++i;
                    }
                    this.m_fileEntriesForStatusUpdate.clear();
                }
                catch (Exception e) {
                    Environment.getInstance().getLogging().logThrowable("Error during rollback. See stacktrace for details.", e);
                    throw new ConfigurationException(e, "kernel_1501", new Object[]{"", ""});
                }
            }
            Object var3_3 = null;
            if (this.m_dbconn != null) {
                this.m_connPool.releaseConnection(this.m_dbconn);
                this.m_dbconn = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this.m_dbconn != null) {
                this.m_connPool.releaseConnection(this.m_dbconn);
                this.m_dbconn = null;
            }
            throw throwable;
        }
    }
}

