/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.persistence.rdbms;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ConfigurationDataCacheAllImpl;
import com.sap.engine.core.configuration.impl.ConfigurationDataCacheEntryImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessDefault;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnection;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnectionPool;
import com.sap.engine.core.configuration.impl.persistence.rdbms.FileLoader;
import com.sap.engine.core.configuration.impl.persistence.rdbms.KeyGenerator;
import com.sap.engine.core.configuration.impl.persistence.rdbms.UpdateProcessor;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.StorageInformation;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class PersistenceHandler {
    DBConnectionPool m_connPool;
    KeyGenerator m_keyGen;

    public PersistenceHandler(Properties connProps) throws ConfigurationException {
        this.m_connPool = new DBConnectionPool(connProps);
        this.m_keyGen = new KeyGenerator(this.m_connPool);
        File tempFolder = new File(DBAccessDefault.TEMP_FOLDER_NAME);
        if (tempFolder.exists() && tempFolder.isDirectory()) {
            try {
                this.doRecursiveDelete(tempFolder);
            }
            catch (IOException e) {
                Environment.getInstance().getLogging().logThrowable("Error while deleting temporary files during startup in folder " + tempFolder.getAbsolutePath() + ". Please see if other processes are locking this folder.", e);
                throw new ConfigurationException(e, "kernel_1533", new Object[]{tempFolder.getAbsolutePath()});
            }
        }
    }

    private void doRecursiveDelete(File dir) throws IOException {
        if (dir != null) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.doRecursiveDelete(files[i]);
                } else if (!files[i].delete()) {
                    throw new IOException("Cannot delete temporary file: " + files[i].getAbsolutePath());
                }
                ++i;
            }
            if (!dir.delete()) {
                throw new IOException("Cannot delete temporary directory: " + dir.getAbsolutePath());
            }
        }
    }

    public ConfigurationData readConfig(long CID) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            ConfigurationData configurationData;
            try {
                ConfigMetaDataImpl entry = dbconn.getDBAccess().getConfiguration(CID);
                configurationData = this.readConfigInternal(dbconn, entry);
                Object var7_7 = null;
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), ""});
            }
            this.m_connPool.releaseConnection(dbconn);
            return configurationData;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public ConfigurationData readConfig(ConfigMetaDataImpl entry) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            ConfigurationData configurationData = this.readConfigInternal(dbconn, entry);
            Object var5_4 = null;
            this.m_connPool.releaseConnection(dbconn);
            return configurationData;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public ConfigurationData readConfig(ConfigurationPath path) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            ConfigurationData configurationData;
            try {
                ConfigMetaDataImpl entry = dbconn.getDBAccess().getConfiguration(path);
                configurationData = this.readConfigInternal(dbconn, entry);
                Object var6_7 = null;
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{path.getPathString(), ""});
            }
            this.m_connPool.releaseConnection(dbconn);
            return configurationData;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public long getCID(ConfigurationPath path) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                ConfigMetaDataImpl entry = dbconn.getDBAccess().getConfiguration(path);
                long l = entry.getCID();
                Object var7_7 = null;
                this.m_connPool.releaseConnection(dbconn);
                return l;
            }
            catch (NameNotFoundException ne) {
                throw ne;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{path.getPathString(), ""});
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public ConfigMetaDataImpl getConfigMetaData(ConfigurationPath path) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                ConfigMetaDataImpl entry;
                ConfigMetaDataImpl configMetaDataImpl = entry = dbconn.getDBAccess().getConfiguration(path);
                Object var6_7 = null;
                this.m_connPool.releaseConnection(dbconn);
                return configMetaDataImpl;
            }
            catch (NameNotFoundException ne) {
                throw ne;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{path.getPathString(), ""});
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public UpdateProcessor getUpdateProcessor(String transactionId) {
        return new UpdateProcessor(this.m_connPool, transactionId);
    }

    public FileLoader getFileLoader(long CID, String name) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            return new FileLoader(dbconn, CID, name);
        }
        catch (Exception e) {
            this.m_connPool.releaseConnection(dbconn);
            Environment.getInstance().getLogging().logThrowable(e);
            throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), name});
        }
    }

    public void close() {
        this.m_connPool.close();
    }

    public ValueEntry readValue(long CID, String name) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                ValueEntry valueEntry = dbconn.getDBAccess().getConfigEntry(CID, name);
                Object var8_6 = null;
                this.m_connPool.releaseConnection(dbconn);
                return valueEntry;
            }
            catch (NameNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), name});
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public String[] getAllValueNames(long CID) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                String[] stringArray = dbconn.getDBAccess().getConfigEntryNames(CID);
                Object var6_5 = null;
                this.m_connPool.releaseConnection(dbconn);
                return stringArray;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), ""});
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public String[] getAllRootNames() throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                HashMap entries = new HashMap(dbconn.getDBAccess().getSubConfigurations(ConfigurationData.ROOT_ID));
                Vector names = new Vector(entries.keySet());
                String[] stringArray = names.toArray(new String[names.size()]);
                Object var6_6 = null;
                this.m_connPool.releaseConnection(dbconn);
                return stringArray;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{"", ""});
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public ConfigMetaData[] getAllRootConfigsMetaData() throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                HashMap entries = new HashMap(dbconn.getDBAccess().getSubConfigurations(ConfigurationData.ROOT_ID));
                ConfigMetaData[] configMetaDataArray = entries.values().toArray(new ConfigMetaData[0]);
                Object var5_5 = null;
                this.m_connPool.releaseConnection(dbconn);
                return configMetaDataArray;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{"", ""});
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public Vector getAllSubConfigNames(long CID, ConfigurationPath parentPath) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                Vector names;
                HashMap entries = new HashMap(dbconn.getDBAccess().getSubConfigurations(CID));
                Vector vector = names = new Vector(entries.keySet());
                Object var9_8 = null;
                this.m_connPool.releaseConnection(dbconn);
                return vector;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), parentPath.getPathString()});
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public HashMap readAllValues(long CID) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                HashMap hashMap = new HashMap(dbconn.getDBAccess().getConfigEntries(CID));
                Object var6_5 = null;
                this.m_connPool.releaseConnection(dbconn);
                return hashMap;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), ""});
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public HashMap readAllSubConfigurations(long CID, ConfigurationPath parentPath) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                HashMap hashMap = new HashMap(dbconn.getDBAccess().getSubConfigurations(CID));
                Object var7_6 = null;
                this.m_connPool.releaseConnection(dbconn);
                return hashMap;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), parentPath.getPathString()});
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public boolean existsEntry(long CID, String name) throws ConfigurationException {
        DBConnection dbconn = this.m_connPool.getConnection();
        try {
            try {
                boolean bl = dbconn.getDBAccess().checkEntry(CID, name);
                Object var7_6 = null;
                this.m_connPool.releaseConnection(dbconn);
                return bl;
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
                throw new ConfigurationException(e, "kernel_1501", new Object[]{new Long(CID), name});
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }

    public KeyGenerator getKeyGenerator() throws ConfigurationException {
        return this.m_keyGen;
    }

    public StorageInformation getStorageInformation() {
        return new StorageInformation("RDBMS", this.m_connPool.getStorageVendorId());
    }

    public int[] getPoolStatistics() {
        return this.m_connPool.getPoolStatistics();
    }

    private ConfigurationData readConfigInternal(DBConnection dbconn, ConfigMetaDataImpl entry) throws ConfigurationException {
        String FUNCT = "PersistenceHandler.readConfigInternal for Configuration: " + entry.getPath().getPathString();
        try {
            Environment.getInstance().getLogging().trace(2, FUNCT, "PersistenceHandler.readConfigInternal");
            ConfigurationData result = null;
            HashMap valueEntries = new HashMap();
            HashMap fileEntries = new HashMap();
            if ((entry.getCacheMode() & 2) == 2) {
                HashMap subConfigs = new HashMap(dbconn.getDBAccess().getSubConfigurations(entry.getCID()));
                dbconn.getDBAccess().getConfigAndFileEntries(entry.getCID(), valueEntries, fileEntries);
                result = new ConfigurationDataCacheAllImpl(entry, valueEntries, fileEntries, subConfigs, this);
            } else {
                HashMap subConfigs = new HashMap();
                fileEntries = new HashMap(dbconn.getDBAccess().getFileEntries(entry.getCID()));
                result = new ConfigurationDataCacheEntryImpl(entry, valueEntries, fileEntries, subConfigs, this);
            }
            return result;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().logThrowable(e);
            throw new ConfigurationException(e, "kernel_1501", new Object[]{"", ""});
        }
    }
}

