/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.persistence.rdbms;

import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnection;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnectionPool;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;

public class KeyGenerator {
    public static long UNDEFINED = Long.MIN_VALUE;
    public static long SEQUENCE_ID = 1L;
    private static long KEY_MULTIPLIER = 100L;
    private static long FIRST_VALUE = UNDEFINED / KEY_MULTIPLIER + 1L;
    private DBConnectionPool m_connPool = null;
    private long m_initKey;
    private long m_currentKey = FIRST_VALUE;

    public KeyGenerator(DBConnectionPool connPool) {
        this.m_connPool = connPool;
    }

    public synchronized long generateKey() throws ConfigurationException {
        if (this.m_currentKey == FIRST_VALUE || this.m_currentKey == this.m_initKey + KEY_MULTIPLIER - 1L) {
            this.init();
        } else {
            ++this.m_currentKey;
        }
        return this.m_currentKey;
    }

    private synchronized void init() throws ConfigurationException {
        DBConnection dbconn = null;
        try {
            try {
                dbconn = this.m_connPool.getConnection();
                int updatedRows = 0;
                while (updatedRows == 0) {
                    long incValue = 0L;
                    try {
                        incValue = dbconn.getDBAccess().getIncValue(SEQUENCE_ID);
                    }
                    catch (NameNotFoundException ne) {
                        incValue = FIRST_VALUE;
                        dbconn.getDBAccess().insertInitialKey(SEQUENCE_ID, incValue);
                        dbconn.getDBAccess().commit();
                    }
                    this.m_currentKey = this.m_initKey = incValue * KEY_MULTIPLIER;
                    updatedRows = dbconn.getDBAccess().updateKey(incValue, SEQUENCE_ID, incValue + 1L);
                    dbconn.getDBAccess().commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ConfigurationException(e, "kernel_1501", new Object[]{"KeyGenerator!"});
            }
            Object var7_6 = null;
            this.m_connPool.releaseConnection(dbconn);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_connPool.releaseConnection(dbconn);
            throw throwable;
        }
    }
}

