/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.persistence.rdbms;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnection;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import java.io.InputStream;
import java.sql.SQLException;

public class FileLoader {
    private InputStream m_filein = null;
    private DBConnection m_dbconn = null;
    private long m_CID = 0L;
    private String m_name = null;

    protected FileLoader(DBConnection dbconn, long CID, String name) {
        this.m_dbconn = dbconn;
        this.m_CID = CID;
        this.m_name = name;
    }

    public InputStream getInputStream() throws SQLException, NameNotFoundException {
        try {
            if (this.m_filein == null) {
                this.m_filein = this.m_dbconn.getDBAccess().getFileEntry(this.m_CID, this.m_name);
            }
            return this.m_filein;
        }
        catch (SQLException e) {
            Environment.getInstance().getLogging().logThrowable(e);
            this.close();
            throw e;
        }
        catch (NameNotFoundException e) {
            Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e));
            this.close();
            throw e;
        }
    }

    public void close() throws SQLException {
        if (this.m_dbconn != null) {
            this.m_dbconn.getDBAccess().releaseOpenStream();
            this.m_dbconn.release();
        }
    }
}

