/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.persistence.rdbms;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessDefault;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnection;
import com.sap.engine.core.configuration.impl.persistence.rdbms.KeyGenerator;
import com.sap.engine.core.configuration.impl.utilities.PropertyUtil;
import com.sap.engine.core.configuration.impl.utilities.Utils;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import com.sap.sql.connect.OpenSQLDataSource;
import com.sap.sql.jdbc.DatabaseVendor;
import com.sap.sql.jdbc.direct.DirectDataSource;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.sql.PooledConnection;

public class DBConnectionPool {
    private static final PropertyUtil UTIL = new PropertyUtil();
    private static final int RECONNECT_WAIT = 2000;
    private static final int MAXIMUM_IDLE_TIME = 60000;
    private static final int CHECK_INTERVAL = 60000;
    private static final int WAIT_BEFORE_TRACE = 30000;
    private static final String DEFAULT_IMPL = "com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessDefault";
    private static final String DB2_OS390_IMPL = "com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessDB2";
    private static final String DB2_AS400_IMPL = "com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessDB4";
    private static final String INFORMIX_IMPL = "com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessInformix";
    private static final String SAPDB_IMPL = "com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessSAPDB";
    private static final String ORACLE_IMPL = "com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessOracle";
    private static final String MSSQL_IMPL = "com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessMSSQL";
    private OpenSQLDataSource m_openSQLDataSource;
    private DirectDataSource m_directDataSource;
    private String[] m_tableNames = new String[3];
    private String m_dbAccessImplName;
    private String m_vendorId;
    private int m_initConnections = 0;
    private int m_maxConnections = 0;
    private int m_peakNrOfConnections = 0;
    private HashSet m_activeConnections;
    private Vector m_idleConnections;
    private IdleConnectionsChecker m_checker;
    private boolean m_secStoreConnect = true;
    private HashMap m_connectionTracesMap = new HashMap();
    private String m_traceLevel;

    protected DBConnectionPool(Properties properties) throws ConfigurationException {
        String sapSystemName = properties.getProperty("system.name");
        String secStoreFile = properties.getProperty("secstorefs.secfile");
        String secStoreKeyFile = properties.getProperty("secstorefs.keyfile");
        String dataSourceName = properties.getProperty("rdbms.connection");
        this.m_traceLevel = properties.getProperty("call.trace.level", "0");
        String url = null;
        String user = null;
        String password = null;
        if (sapSystemName == null || secStoreFile == null || secStoreKeyFile == null || dataSourceName == null) {
            Environment.getInstance().getLogging().log((byte)2, "Properties for connect through secure store not set. Please check your connect properties. Trying to connect via plain user/password.");
            url = UTIL.getStringProperty(properties, "rdbms.url", false);
            user = UTIL.getStringProperty(properties, "rdbms.user", false);
            password = UTIL.getStringProperty(properties, "rdbms.password", false);
            this.m_secStoreConnect = false;
        }
        this.m_initConnections = UTIL.getIntegerProperty(properties, "rdbms.initial_connections", false);
        this.m_maxConnections = UTIL.getIntegerProperty(properties, "rdbms.maximum_connections", false);
        this.m_dbAccessImplName = UTIL.getStringProperty(properties, "rdbms.dbAccessImpl", true);
        this.m_tableNames[0] = UTIL.getStringProperty(properties, "rdbms.config_table", true);
        this.m_tableNames[1] = UTIL.getStringProperty(properties, "rdbms.entry_table", true);
        this.m_tableNames[2] = UTIL.getStringProperty(properties, "rdbms.key_table", true);
        this.m_peakNrOfConnections = this.m_initConnections;
        if (this.m_initConnections < 1) {
            throw new ConfigurationException("kernel_1516");
        }
        if (this.m_maxConnections < this.m_initConnections) {
            throw new ConfigurationException("kernel_1517");
        }
        if (this.m_secStoreConnect) {
            try {
                SecStoreFS.setSID((String)sapSystemName);
                SecStoreFS.setDefaultFilenames((String)secStoreFile, (String)secStoreKeyFile);
                this.m_openSQLDataSource = OpenSQLDataSource.newInstance();
                this.m_openSQLDataSource.setConnectionType(2);
                this.m_openSQLDataSource.setDataSourceName(dataSourceName);
                Environment.getInstance().getLogging().log((byte)2, "OpenSQLDataSource successfully created with secure store.");
            }
            catch (Exception e) {
                throw new ConfigurationException(e, "kernel_1518");
            }
        } else {
            this.m_directDataSource = new DirectDataSource(url, user, password);
        }
        this.m_activeConnections = new HashSet(this.m_initConnections);
        this.m_idleConnections = new Vector(this.m_initConnections);
        int i = 0;
        while (i < this.m_initConnections) {
            this.m_idleConnections.add(this.createConnection());
            ++i;
        }
        this.m_checker = new IdleConnectionsChecker(this, 60000);
        Environment.getInstance().startThread(this.m_checker);
    }

    public synchronized DBConnection getConnection() throws ConfigurationException {
        DBConnection dbconn = null;
        while ((dbconn = this.getConnectionInternal()) == null) {
            this.waitForConnection();
        }
        if (this.m_traceLevel.equals("1")) {
            this.m_connectionTracesMap.put(dbconn, Utils.getStackTraceWithoutFirstLine(new Exception()));
        }
        return dbconn;
    }

    private synchronized void waitForConnection() {
        try {
            long currentTime = System.currentTimeMillis();
            this.wait(30000L);
            if (this.m_idleConnections.size() == 0 && System.currentTimeMillis() - currentTime > 30000L) {
                if (this.m_traceLevel.equals("1")) {
                    StringBuffer buf = new StringBuffer();
                    int i = 1;
                    buf.append("\r\nTimeout occured while waiting of connections in the connection pool.\r\n");
                    Set keySet = this.m_connectionTracesMap.keySet();
                    Iterator iter = keySet.iterator();
                    while (iter.hasNext()) {
                        DBConnection element = (DBConnection)iter.next();
                        buf.append("DBConnection " + i++ + "/" + this.m_maxConnections + " is taken from \r\n" + this.m_connectionTracesMap.get(element));
                    }
                    Environment.getInstance().getLogging().logMessage((byte)4, buf.toString(), "");
                } else {
                    Environment.getInstance().getLogging().logMessage((byte)4, "A thread is waiting for a connection more than 30seconds. Please set the trace level to 1 (call.trace.level = 1) in the ConfigurationManager properties and restart this process to get more informations.", "");
                }
            }
        }
        catch (InterruptedException e) {
            Environment.getInstance().getLogging().logThrowable(e);
        }
    }

    private synchronized DBConnection getConnectionInternal() throws ConfigurationException {
        DBConnection dbconn = null;
        if (!this.m_idleConnections.isEmpty()) {
            dbconn = (DBConnection)this.m_idleConnections.firstElement();
            this.m_idleConnections.remove(0);
        } else if (this.m_activeConnections.size() < this.m_maxConnections) {
            Object dummy = new Object();
            this.m_activeConnections.add(dummy);
            boolean connected = false;
            while (!connected) {
                try {
                    dbconn = this.createConnection();
                    this.m_activeConnections.remove(dummy);
                    connected = true;
                }
                catch (Exception e) {
                    Environment.getInstance().getLogging().traceThrowable(3, "Reconnect failed - retrying after 2000 ms ...", e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        Environment.getInstance().getLogging().logThrowable(ie);
                    }
                    System.out.println("ConfigurationManager: retry to connect to DB ...");
                }
            }
        } else {
            return null;
        }
        this.m_activeConnections.add(dbconn);
        if (this.m_peakNrOfConnections < this.m_activeConnections.size()) {
            ++this.m_peakNrOfConnections;
        }
        dbconn.setLastUseTimeStamp();
        return dbconn;
    }

    public synchronized void releaseConnection(DBConnection dbconn) throws ConfigurationException {
        if (this.m_activeConnections.contains(dbconn)) {
            Environment.getInstance().getLogging().trace(3, "DBConnectionPool.releaseConnection", "before connection is released", " activeConnections: " + this.m_activeConnections.size() + " idleConnections: " + this.m_idleConnections.size());
            this.m_activeConnections.remove(dbconn);
            this.m_idleConnections.add(dbconn);
            this.notify();
            if (this.m_traceLevel.equals("1")) {
                this.m_connectionTracesMap.remove(dbconn);
            }
        }
    }

    public synchronized int[] getPoolStatistics() {
        int[] stats = new int[]{this.m_activeConnections.size() + this.m_idleConnections.size(), this.m_activeConnections.size(), this.m_idleConnections.size(), this.m_peakNrOfConnections};
        return stats;
    }

    protected synchronized void discardConnection(DBConnection dbconn) {
        if (this.m_activeConnections.contains(dbconn)) {
            this.m_activeConnections.remove(dbconn);
            dbconn = null;
        }
    }

    protected synchronized void checkAllConnections() {
        Vector<DBConnection> forDeletion = new Vector<DBConnection>();
        Iterator iter = this.m_activeConnections.iterator();
        while (iter.hasNext()) {
            DBConnection dbconn = (DBConnection)iter.next();
            dbconn.deactivateEventListener();
            DBAccessDefault dbaccess = dbconn.getDBAccess();
            try {
                dbaccess.getIncValue(KeyGenerator.SEQUENCE_ID);
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().traceThrowable(3, "DBConnection is broken/invalid and will be closed.", e);
                try {
                    dbconn.close();
                }
                catch (Exception ee) {
                    Environment.getInstance().getLogging().logThrowable(ee);
                }
                forDeletion.add(dbconn);
            }
        }
        this.m_activeConnections.removeAll(forDeletion);
        forDeletion.clear();
        Iterator iter2 = ((AbstractList)this.m_idleConnections).iterator();
        while (iter2.hasNext()) {
            DBConnection dbconn = (DBConnection)iter2.next();
            dbconn.deactivateEventListener();
            DBAccessDefault dbaccess = dbconn.getDBAccess();
            try {
                dbaccess.getIncValue(KeyGenerator.SEQUENCE_ID);
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().traceThrowable(3, "DBConnection is broken/invalid and will be closed.", e);
                try {
                    dbconn.close();
                }
                catch (Exception ee) {
                    Environment.getInstance().getLogging().logThrowable(ee);
                }
                forDeletion.add(dbconn);
            }
        }
        this.m_idleConnections.removeAll(forDeletion);
    }

    protected String getStorageVendorId() {
        return this.m_vendorId;
    }

    private DBConnection createConnection() throws ConfigurationException {
        try {
            PooledConnection dpconn = null;
            dpconn = this.m_secStoreConnect ? this.m_openSQLDataSource.getPooledConnection() : this.m_directDataSource.getPooledConnection();
            Environment.getInstance().getLogging().trace(3, "DBConnectionPool.createConnection", " new connection created");
            if (this.m_dbAccessImplName == null) {
                Connection conn = dpconn.getConnection();
                int vendorId = DatabaseVendor.getVendorID((Connection)conn);
                this.m_vendorId = DatabaseVendor.getVendorName((int)vendorId);
                switch (vendorId) {
                    case 2: {
                        this.m_dbAccessImplName = DB2_OS390_IMPL;
                        break;
                    }
                    case 1: {
                        this.m_dbAccessImplName = DB2_AS400_IMPL;
                        break;
                    }
                    case 3: {
                        this.m_dbAccessImplName = INFORMIX_IMPL;
                        break;
                    }
                    case 6: {
                        this.m_dbAccessImplName = SAPDB_IMPL;
                        break;
                    }
                    case 5: {
                        this.m_dbAccessImplName = ORACLE_IMPL;
                        break;
                    }
                    case 4: {
                        this.m_dbAccessImplName = MSSQL_IMPL;
                        break;
                    }
                    default: {
                        this.m_dbAccessImplName = DEFAULT_IMPL;
                    }
                }
                DBAccessDefault.buildStatements(this.m_tableNames);
                Method buildPlatformStatements = Class.forName(this.m_dbAccessImplName).getMethod("buildPlatformSpecificStatements", new Class[0]);
                buildPlatformStatements.invoke(null, new Object[0]);
                conn.close();
            }
            return new DBConnection(this, dpconn, this.m_dbAccessImplName);
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1518");
        }
    }

    protected void close() {
        try {
            this.m_checker.stop();
            Iterator iter = this.m_activeConnections.iterator();
            while (iter.hasNext()) {
                DBConnection dbconn = (DBConnection)iter.next();
                dbconn.close();
            }
            Iterator iter2 = ((AbstractList)this.m_idleConnections).iterator();
            while (iter2.hasNext()) {
                DBConnection dbconn = (DBConnection)iter2.next();
                dbconn.close();
            }
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().logThrowable(e);
        }
    }

    public void checkTimeoutForIdleConnections() {
        Vector<DBConnection> closeUs = new Vector<DBConnection>();
        DBConnectionPool dBConnectionPool = this;
        synchronized (dBConnectionPool) {
            DBConnection[] idleConns = this.m_idleConnections.toArray(new DBConnection[this.m_idleConnections.size()]);
            int i = 0;
            while (i < idleConns.length) {
                DBConnection dbconn = idleConns[i];
                int totalConn = this.m_idleConnections.size() + this.m_activeConnections.size();
                long timeSinceLastUse = System.currentTimeMillis() - dbconn.getLastUseTimeStamp();
                if (totalConn > this.m_initConnections && timeSinceLastUse > 60000L) {
                    this.m_idleConnections.remove(dbconn);
                    closeUs.add(dbconn);
                }
                ++i;
            }
        }
        Iterator iter = ((AbstractList)closeUs).iterator();
        while (iter.hasNext()) {
            try {
                DBConnection dbconn = (DBConnection)iter.next();
                dbconn.close();
            }
            catch (Exception e) {
                Environment.getInstance().getLogging().logThrowable(e);
            }
        }
    }

    protected class IdleConnectionsChecker
    implements Runnable {
        private boolean m_stopped = false;
        private int m_interval;
        private DBConnectionPool m_connPool;
        private Thread m_currentThread;

        IdleConnectionsChecker(DBConnectionPool connPool, int interval) {
            this.m_connPool = connPool;
            this.m_interval = interval;
        }

        public void run() {
            this.m_currentThread = Thread.currentThread();
            while (!this.m_stopped) {
                this.m_connPool.checkTimeoutForIdleConnections();
                try {
                    Thread.sleep(this.m_interval);
                }
                catch (InterruptedException ie) {
                    if (this.m_stopped) continue;
                    Environment.getInstance().getLogging().logThrowable(ie);
                }
            }
        }

        public void stop() {
            this.m_stopped = true;
            this.m_currentThread.interrupt();
        }
    }
}

