/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.persistence.rdbms;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBAccessDefault;
import com.sap.engine.core.configuration.impl.persistence.rdbms.DBConnectionPool;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DBConnection
implements ConnectionEventListener {
    private DBConnectionPool m_connPool;
    private Connection m_conn;
    private PooledConnection m_dpconn;
    private DBAccessDefault m_dbAccess;
    private long m_timeStamp;

    protected DBConnection(DBConnectionPool connPool, PooledConnection dpconn, String dbAccessImplName) throws ConfigurationException {
        try {
            this.m_connPool = connPool;
            this.m_dpconn = dpconn;
            this.m_conn = dpconn.getConnection();
            this.m_conn.setAutoCommit(false);
            try {
                this.m_conn.setTransactionIsolation(1);
            }
            catch (SQLException se) {
                Environment.getInstance().getLogging().logThrowable("Could not set transaction level to TRANSACTION_READ_UNCOMMITTED. Using the default isolation level of the underlying database.", se, (byte)4);
            }
            this.m_dpconn.addConnectionEventListener(this);
            this.m_dbAccess = (DBAccessDefault)Class.forName(dbAccessImplName).newInstance();
            this.m_dbAccess.init(this.m_conn);
            this.m_timeStamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1514");
        }
    }

    public DBAccessDefault getDBAccess() {
        return this.m_dbAccess;
    }

    public long getLastUseTimeStamp() {
        return this.m_timeStamp;
    }

    public void setLastUseTimeStamp() {
        this.m_timeStamp = System.currentTimeMillis();
    }

    public void release() {
        try {
            this.m_connPool.releaseConnection(this);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().logThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws ConfigurationException {
        try {
            try {
                this.m_dpconn.removeConnectionEventListener(this);
                this.m_dbAccess.rollback();
                this.m_dbAccess.close();
            }
            catch (SQLException e) {
                throw new ConfigurationException(e);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            try {
                this.m_dpconn.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new ConfigurationException(e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new ConfigurationException(e);
        }
        this.m_dpconn.close();
    }

    protected void deactivateEventListener() {
        this.m_dpconn.removeConnectionEventListener(this);
    }

    public void connectionClosed(ConnectionEvent event) {
        Environment.getInstance().getLogging().trace(2, "Connection closed event: " + this.m_dpconn, " DBConnection.connectionClosed");
        Environment.getInstance().getLogging().logThrowable((Throwable)((Object)new ConfigurationException("kernel_1515", new Object[]{"connectionClosed"})));
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        Environment.getInstance().getLogging().log((byte)6, "Error event: " + event.getSQLException());
        Environment.getInstance().getLogging().logThrowable((Throwable)((Object)new ConfigurationException(event.getSQLException(), "kernel_1515", new Object[]{"connectionErrorOccurred"})));
        this.m_connPool.discardConnection(this);
        try {
            this.close();
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().logThrowable(e);
        }
        this.m_connPool.checkAllConnections();
    }
}

