/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.persistence.rdbms;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.FileEntry;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.Utils;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DBAccessDefault {
    protected static String CONFIG_TABLE = "\"J2EE_CONFIG\"";
    protected static String ENTRY_TABLE = "\"J2EE_CONFIGENTRY\"";
    protected static String KEY_TABLE = "\"J2EE_KEYSEQUENCE\"";
    protected static String PATH = "CPATH";
    protected static String PHASH = "PATHHASH";
    protected static String PACID = "PARENTCID";
    protected static String CACHEMODE = "CACHEMODE";
    protected static String PREFIX = "PATHPREFIX";
    protected static String CTYPE = "CTYPE";
    protected static int PREFIX_LENGTH = 84;
    protected static String KEYCID = "CID";
    protected static String NAME = "NAME";
    protected static String NAMEHASH = "NAMEHASH";
    protected static String TYPE = "DTYPE";
    protected static String VINT = "VBIGINT";
    protected static String VDOUBLE = "VDOUBLE";
    protected static String VSTR = "VSTR";
    protected static String VBYTES = "VBYTES";
    protected static String FBLOB = "FBLOB";
    protected static String FILEFLAG = "ISFILE";
    protected static String SEQUENCE_ID = "SEQUENCE_ID";
    protected static String INC_VALUE = "INC_VALUE";
    protected static String PATH_QUOTE = "\"CPATH\"";
    protected static String PHASH_QUOTE = "\"PATHHASH\"";
    protected static String PACID_QUOTE = "\"PARENTCID\"";
    protected static String CACHEMODE_QUOTE = "\"CACHEMODE\"";
    protected static String PREFIX_QUOTE = "\"PATHPREFIX\"";
    protected static String CTYPE_QUOTE = "\"CTYPE\"";
    protected static String KEYCID_QUOTE = "\"CID\"";
    protected static String NAME_QUOTE = "\"NAME\"";
    protected static String NAMEHASH_QUOTE = "\"NAMEHASH\"";
    protected static String TYPE_QUOTE = "\"DTYPE\"";
    protected static String VINT_QUOTE = "\"VBIGINT\"";
    protected static String VDOUBLE_QUOTE = "\"VDOUBLE\"";
    protected static String VSTR_QUOTE = "\"VSTR\"";
    protected static String VBYTES_QUOTE = "\"VBYTES\"";
    protected static String FBLOB_QUOTE = "\"FBLOB\"";
    protected static String FILEFLAG_QUOTE = "\"ISFILE\"";
    protected static String SEQUENCE_ID_QUOTE = "\"SEQUENCE_ID\"";
    protected static String INC_VALUE_QUOTE = "\"INC_VALUE\"";
    protected static int FLAG_ENTRY_VALUE = 0;
    protected static int FLAG_FILE_VALUE = 1;
    protected static String INSERT_CONFIG;
    protected static String UPDATE_CONFIG;
    protected static String DELETE_CONFIG;
    protected static String SELECT_SUBCONFIGS;
    protected static String SELECT_SUBCONFIG_TREE;
    protected static String SELECT_ALL;
    protected static String SELECT_CONFIGMETADATA_PATH;
    protected static String SELECT_CONFIGMETADATA_CID;
    protected static String INSERT_ENTRY;
    protected static String UPDATE_ENTRY;
    protected static String DELETE_ENTRY;
    protected static String DELETE_ENTRIES;
    protected static String SELECT_ENTRY;
    protected static String SELECT_ENTRIES;
    protected static String SELECT_ENTRIES_FILES;
    protected static String CHECK_ENTRY;
    protected static String INSERT_FILE;
    protected static String UPDATE_FILE;
    protected static String DELETE_FILE;
    protected static String DELETE_FILES;
    protected static String SELECT_FILE;
    protected static String SELECT_NAMES;
    protected static String SELECT_KEYGEN;
    protected static String UPDATE_KEYGEN;
    protected static String INSERT_KEYGEN;
    protected PreparedStatement m_insertConfig = null;
    protected PreparedStatement m_updateConfig = null;
    protected PreparedStatement m_deleteConfig = null;
    protected PreparedStatement m_selectSubConfigs = null;
    protected PreparedStatement m_selectSubConfigTree = null;
    protected PreparedStatement m_selectAllConfigs = null;
    protected PreparedStatement m_selectConfigMetaData_CID = null;
    protected PreparedStatement m_selectConfigMetaData_Path = null;
    protected PreparedStatement m_insertEntry = null;
    protected PreparedStatement m_updateEntry = null;
    protected PreparedStatement m_deleteEntry = null;
    protected PreparedStatement m_deleteEntries = null;
    protected PreparedStatement m_selectEntry = null;
    protected PreparedStatement m_selectEntries = null;
    protected PreparedStatement m_checkEntry = null;
    protected PreparedStatement m_selectNames = null;
    protected PreparedStatement m_selectEntriesFiles = null;
    protected PreparedStatement m_insertFile = null;
    protected PreparedStatement m_updateFile = null;
    protected PreparedStatement m_deleteFile = null;
    protected PreparedStatement m_deleteFiles = null;
    protected PreparedStatement m_selectFile = null;
    protected PreparedStatement m_selectKey = null;
    protected PreparedStatement m_updateKey = null;
    protected Connection m_conn = null;
    protected static final int MAX_BYTEARRAY_SIZE = 10000;
    protected static final String TEMP_FOLDER_NAME;
    protected int m_tempFileCounter = 0;
    protected File m_tempFileFolder = null;
    protected Vector m_fileStreams = new Vector();
    protected ResultSet m_fileResultSet = null;

    public static void buildStatements(String[] tableNames) {
        if (tableNames[0] != null) {
            CONFIG_TABLE = DBAccessDefault.quoteTableName(tableNames[0]);
        }
        if (tableNames[1] != null) {
            ENTRY_TABLE = DBAccessDefault.quoteTableName(tableNames[1]);
        }
        if (tableNames[2] != null) {
            KEY_TABLE = DBAccessDefault.quoteTableName(tableNames[2]);
        }
        INSERT_CONFIG = "INSERT INTO " + CONFIG_TABLE + "(" + KEYCID_QUOTE + "," + PACID_QUOTE + "," + PATH_QUOTE + "," + PHASH_QUOTE + "," + CACHEMODE_QUOTE + "," + PREFIX_QUOTE + "," + CTYPE_QUOTE + ")" + " VALUES (?, ?, ?, ?, ?, ?, ?)";
        UPDATE_CONFIG = "UPDATE " + CONFIG_TABLE + " SET " + CACHEMODE_QUOTE + " = ? WHERE " + KEYCID_QUOTE + " = ?";
        DELETE_CONFIG = "DELETE FROM " + CONFIG_TABLE + " WHERE " + KEYCID_QUOTE + " = ?";
        SELECT_SUBCONFIGS = "SELECT " + PATH_QUOTE + "," + KEYCID_QUOTE + "," + CACHEMODE_QUOTE + "," + CTYPE_QUOTE + " FROM " + CONFIG_TABLE + " WHERE " + PACID_QUOTE + " = ?";
        SELECT_SUBCONFIG_TREE = "SELECT " + KEYCID_QUOTE + " FROM " + CONFIG_TABLE + " WHERE " + PATH_QUOTE + " LIKE ? ESCAPE '#'";
        SELECT_ALL = "SELECT " + PATH_QUOTE + "," + KEYCID_QUOTE + "," + CACHEMODE_QUOTE + "," + CTYPE_QUOTE + " FROM " + CONFIG_TABLE;
        SELECT_CONFIGMETADATA_PATH = "SELECT " + PATH_QUOTE + "," + KEYCID_QUOTE + "," + PACID_QUOTE + "," + CACHEMODE_QUOTE + "," + CTYPE_QUOTE + " FROM " + CONFIG_TABLE + " WHERE " + PHASH_QUOTE + " = ?";
        SELECT_CONFIGMETADATA_CID = "SELECT " + PATH_QUOTE + "," + PACID_QUOTE + "," + CACHEMODE_QUOTE + "," + CTYPE_QUOTE + " FROM " + CONFIG_TABLE + " WHERE " + KEYCID_QUOTE + " = ?";
        INSERT_ENTRY = "INSERT INTO " + ENTRY_TABLE + "(" + KEYCID_QUOTE + "," + NAMEHASH_QUOTE + "," + NAME_QUOTE + "," + TYPE_QUOTE + "," + VINT_QUOTE + "," + VDOUBLE_QUOTE + "," + VSTR_QUOTE + "," + VBYTES_QUOTE + "," + FILEFLAG_QUOTE + ")" + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, 0)";
        UPDATE_ENTRY = "UPDATE " + ENTRY_TABLE + " SET " + TYPE_QUOTE + " = ?, " + VINT_QUOTE + " = ?, " + VDOUBLE_QUOTE + " = ?, " + VSTR_QUOTE + " = ?, " + VBYTES_QUOTE + " = ? " + " WHERE " + KEYCID_QUOTE + " = ? AND " + NAMEHASH_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 0";
        DELETE_ENTRY = "DELETE FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + NAMEHASH_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 0";
        DELETE_ENTRIES = "DELETE FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 0";
        SELECT_ENTRY = "SELECT " + NAME_QUOTE + "," + TYPE_QUOTE + "," + VINT_QUOTE + "," + VDOUBLE_QUOTE + "," + VSTR_QUOTE + "," + VBYTES_QUOTE + " FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + NAMEHASH_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 0";
        SELECT_ENTRIES = "SELECT " + NAME_QUOTE + "," + TYPE_QUOTE + "," + VINT_QUOTE + "," + VDOUBLE_QUOTE + "," + VSTR_QUOTE + "," + VBYTES_QUOTE + " FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 0";
        SELECT_ENTRIES_FILES = "SELECT " + NAME_QUOTE + "," + FILEFLAG_QUOTE + "," + TYPE_QUOTE + "," + VINT_QUOTE + "," + VDOUBLE_QUOTE + "," + VSTR_QUOTE + "," + VBYTES_QUOTE + " FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ?";
        CHECK_ENTRY = "SELECT " + KEYCID_QUOTE + " FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + NAMEHASH_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 0";
        INSERT_FILE = "INSERT INTO " + ENTRY_TABLE + "(" + KEYCID_QUOTE + "," + NAMEHASH_QUOTE + "," + NAME_QUOTE + "," + FBLOB_QUOTE + "," + FILEFLAG_QUOTE + ")" + " VALUES(?, ?, ?, ?, 1)";
        UPDATE_FILE = "UPDATE " + ENTRY_TABLE + " SET " + FBLOB_QUOTE + " = ?" + " WHERE " + KEYCID_QUOTE + " = ? AND " + NAMEHASH_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 1";
        DELETE_FILE = "DELETE FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + NAMEHASH_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 1";
        DELETE_FILES = "DELETE FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 1";
        SELECT_FILE = "SELECT " + FBLOB_QUOTE + " FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + NAMEHASH_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = 1";
        SELECT_NAMES = "SELECT " + NAME_QUOTE + " FROM " + ENTRY_TABLE + " WHERE " + KEYCID_QUOTE + " = ? AND " + FILEFLAG_QUOTE + " = ?";
        SELECT_KEYGEN = "SELECT " + INC_VALUE_QUOTE + " FROM " + KEY_TABLE + " WHERE " + SEQUENCE_ID_QUOTE + " = ?";
        UPDATE_KEYGEN = "UPDATE " + KEY_TABLE + " SET " + INC_VALUE_QUOTE + " = ?" + " WHERE " + SEQUENCE_ID_QUOTE + " = ? AND " + INC_VALUE_QUOTE + " = ?";
        INSERT_KEYGEN = "INSERT INTO " + KEY_TABLE + "(" + SEQUENCE_ID_QUOTE + "," + INC_VALUE_QUOTE + ")" + " VALUES(";
    }

    public static void buildPlatformSpecificStatements() {
    }

    private static String quoteTableName(String tableName) {
        if (!tableName.startsWith("\"")) {
            tableName = "\"" + tableName;
        }
        if (!tableName.endsWith("\"")) {
            tableName = tableName + "\"";
        }
        return tableName;
    }

    public void init(Connection conn) throws SQLException {
        this.m_conn = conn;
        this.m_insertConfig = this.m_conn.prepareStatement(INSERT_CONFIG);
        this.m_updateConfig = this.m_conn.prepareStatement(UPDATE_CONFIG);
        this.m_deleteConfig = this.m_conn.prepareStatement(DELETE_CONFIG);
        this.m_selectSubConfigs = this.m_conn.prepareStatement(SELECT_SUBCONFIGS);
        this.m_selectSubConfigTree = this.m_conn.prepareStatement(SELECT_SUBCONFIG_TREE);
        this.m_selectAllConfigs = this.m_conn.prepareStatement(SELECT_ALL);
        this.m_selectConfigMetaData_CID = this.m_conn.prepareStatement(SELECT_CONFIGMETADATA_CID);
        this.m_selectConfigMetaData_Path = this.m_conn.prepareStatement(SELECT_CONFIGMETADATA_PATH);
        this.m_insertEntry = this.m_conn.prepareStatement(INSERT_ENTRY);
        this.m_updateEntry = this.m_conn.prepareStatement(UPDATE_ENTRY);
        this.m_deleteEntry = this.m_conn.prepareStatement(DELETE_ENTRY);
        this.m_deleteEntries = this.m_conn.prepareStatement(DELETE_ENTRIES);
        this.m_selectEntry = this.m_conn.prepareStatement(SELECT_ENTRY);
        this.m_selectEntries = this.m_conn.prepareStatement(SELECT_ENTRIES);
        this.m_selectEntriesFiles = this.m_conn.prepareStatement(SELECT_ENTRIES_FILES);
        this.m_selectNames = this.m_conn.prepareStatement(SELECT_NAMES);
        this.m_checkEntry = this.m_conn.prepareStatement(CHECK_ENTRY);
        this.m_insertFile = this.m_conn.prepareStatement(INSERT_FILE);
        this.m_updateFile = this.m_conn.prepareStatement(UPDATE_FILE);
        this.m_deleteFile = this.m_conn.prepareStatement(DELETE_FILE);
        this.m_deleteFiles = this.m_conn.prepareStatement(DELETE_FILES);
        this.m_selectFile = this.m_conn.prepareStatement(SELECT_FILE);
        this.m_selectKey = this.m_conn.prepareStatement(SELECT_KEYGEN);
        this.m_updateKey = this.m_conn.prepareStatement(UPDATE_KEYGEN);
    }

    public void addInsertConfig(long CID, long parentCID, ConfigurationPath path, int cacheMode, int type) throws SQLException {
        this.m_insertConfig.setLong(1, CID);
        this.m_insertConfig.setLong(2, parentCID);
        this.m_insertConfig.setString(3, path.getPathString());
        this.m_insertConfig.setLong(4, path.hashCode());
        this.m_insertConfig.setInt(5, cacheMode);
        int prefixLength = Math.min(PREFIX_LENGTH, path.getPathString().length());
        String pathPrefix = Utils.removeTrailingWhitespace(path.getPathString().substring(0, prefixLength));
        this.m_insertConfig.setString(6, pathPrefix);
        this.m_insertConfig.setInt(7, type);
        this.m_insertConfig.addBatch();
    }

    public void addUpdateConfig(long CID, int cacheMode) throws SQLException {
        this.m_updateConfig.setInt(1, cacheMode);
        this.m_updateConfig.setLong(2, CID);
        this.m_updateConfig.addBatch();
    }

    public void addDeleteConfig(long CID, ConfigurationPath path) throws SQLException {
        Vector subCIDs = this.getSubtree(path);
        subCIDs.add(new Long(CID));
        Iterator iter = ((AbstractList)subCIDs).iterator();
        while (iter.hasNext()) {
            long deleteID = (Long)iter.next();
            this.m_deleteConfig.setLong(1, deleteID);
            this.m_deleteConfig.addBatch();
            this.m_deleteEntries.setLong(1, deleteID);
            this.m_deleteEntries.addBatch();
            this.m_deleteFiles.setLong(1, deleteID);
            this.m_deleteFiles.addBatch();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getSubConfigurations(long CID) throws SQLException {
        HashMap<String, ConfigMetaDataImpl> hashMap;
        ResultSet resConfigs = null;
        try {
            HashMap<String, ConfigMetaDataImpl> result = new HashMap<String, ConfigMetaDataImpl>();
            this.m_selectSubConfigs.setLong(1, CID);
            resConfigs = this.m_selectSubConfigs.executeQuery();
            while (resConfigs.next()) {
                ConfigurationPath path = ConfigurationPath.getConfigurationPath(resConfigs.getString(PATH));
                ConfigMetaDataImpl sub = new ConfigMetaDataImpl(path, resConfigs.getLong(KEYCID), CID, resConfigs.getInt(CACHEMODE), resConfigs.getInt(CTYPE));
                result.put(path.getNameFromPath(), sub);
            }
            hashMap = result;
            Object var8_6 = null;
            if (resConfigs == null) return hashMap;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (resConfigs == null) throw throwable;
            resConfigs.close();
            throw throwable;
        }
        resConfigs.close();
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigMetaDataImpl getConfiguration(ConfigurationPath path) throws SQLException, NameNotFoundException {
        ConfigMetaDataImpl configMetaDataImpl;
        ResultSet resConfig = null;
        try {
            String actualPath;
            this.m_selectConfigMetaData_Path.setInt(1, path.getPathString().hashCode());
            resConfig = this.m_selectConfigMetaData_Path.executeQuery();
            do {
                if (resConfig.next()) continue;
                throw new NameNotFoundException("kernel_1600", new Object[]{path.getPathString()});
            } while (!(actualPath = resConfig.getString(PATH)).equals(path.getPathString()));
            configMetaDataImpl = new ConfigMetaDataImpl(path, resConfig.getLong(KEYCID), resConfig.getLong(PACID), resConfig.getInt(CACHEMODE), resConfig.getInt(CTYPE));
            Object var6_5 = null;
            if (resConfig == null) return configMetaDataImpl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (resConfig == null) throw throwable;
            resConfig.close();
            throw throwable;
        }
        resConfig.close();
        return configMetaDataImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConfigMetaDataImpl getConfiguration(long CID) throws SQLException, NameNotFoundException {
        ConfigMetaDataImpl configMetaDataImpl;
        ResultSet resConfig = null;
        try {
            this.m_selectConfigMetaData_CID.setLong(1, CID);
            resConfig = this.m_selectConfigMetaData_CID.executeQuery();
            if (!resConfig.next()) throw new NameNotFoundException("kernel_1604", new Object[]{new Long(CID)});
            configMetaDataImpl = new ConfigMetaDataImpl(ConfigurationPath.getConfigurationPath(resConfig.getString(PATH)), CID, resConfig.getLong(PACID), resConfig.getInt(CACHEMODE), resConfig.getInt(CTYPE));
            Object var6_4 = null;
            if (resConfig == null) return configMetaDataImpl;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (resConfig == null) throw throwable;
            resConfig.close();
            throw throwable;
        }
        resConfig.close();
        return configMetaDataImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getAllConfigurations() throws SQLException {
        HashMap<String, ConfigMetaDataImpl> hashMap;
        ResultSet resConfigs = null;
        try {
            resConfigs = this.m_selectAllConfigs.executeQuery();
            HashMap<String, ConfigMetaDataImpl> result = new HashMap<String, ConfigMetaDataImpl>();
            while (resConfigs.next()) {
                ConfigMetaDataImpl sub = new ConfigMetaDataImpl(ConfigurationPath.getConfigurationPath(resConfigs.getString(PATH)), resConfigs.getLong(KEYCID), resConfigs.getLong(PACID), resConfigs.getInt(CACHEMODE), resConfigs.getInt(CTYPE));
                result.put(sub.getName(), sub);
            }
            hashMap = result;
            Object var5_4 = null;
            if (resConfigs == null) return hashMap;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (resConfigs == null) throw throwable;
            resConfigs.close();
            throw throwable;
        }
        resConfigs.close();
        return hashMap;
    }

    public void addInsertConfigEntry(long CID, String name, int type, long vint, double vdouble, String vstr, byte[] vbytes) throws SQLException {
        this.m_insertEntry.setLong(1, CID);
        this.m_insertEntry.setInt(2, name.hashCode());
        this.m_insertEntry.setString(3, name);
        this.m_insertEntry.setInt(4, type);
        this.m_insertEntry.setLong(5, vint);
        this.m_insertEntry.setDouble(6, vdouble);
        this.m_insertEntry.setString(7, vstr);
        this.m_insertEntry.setBytes(8, vbytes);
        this.m_insertEntry.addBatch();
    }

    public void addUpdateConfigEntry(long CID, String name, int type, long vint, double vdouble, String vstr, byte[] vbytes) throws SQLException {
        this.m_updateEntry.setInt(1, type);
        this.m_updateEntry.setLong(2, vint);
        this.m_updateEntry.setDouble(3, vdouble);
        this.m_updateEntry.setString(4, vstr);
        this.m_updateEntry.setBytes(5, vbytes);
        this.m_updateEntry.setLong(6, CID);
        this.m_updateEntry.setInt(7, name.hashCode());
        this.m_updateEntry.addBatch();
    }

    public void addDeleteConfigEntry(long CID, String name) throws SQLException {
        this.m_deleteEntry.setLong(1, CID);
        this.m_deleteEntry.setInt(2, name.hashCode());
        this.m_deleteEntry.addBatch();
    }

    public void addDeleteConfigEntries(long CID) throws SQLException {
        this.m_deleteEntries.setLong(1, CID);
        this.m_deleteEntries.addBatch();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getConfigEntries(long CID) throws SQLException {
        HashMap<String, ValueEntry> hashMap;
        ResultSet resValues = null;
        try {
            this.m_selectEntries.setLong(1, CID);
            resValues = this.m_selectEntries.executeQuery();
            HashMap<String, ValueEntry> result = new HashMap<String, ValueEntry>();
            while (resValues.next()) {
                int type = resValues.getInt(TYPE);
                String name = resValues.getString(NAME);
                result.put(name, ValueEntry.createValueEntry(name, this.switchType(resValues, type), type));
            }
            hashMap = result;
            Object var8_7 = null;
            if (resValues == null) return hashMap;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (resValues == null) throw throwable;
            resValues.close();
            throw throwable;
        }
        resValues.close();
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValueEntry getConfigEntry(long CID, String name) throws SQLException, NameNotFoundException {
        ValueEntry valueEntry;
        ResultSet resEntry = null;
        try {
            this.m_selectEntry.setLong(1, CID);
            this.m_selectEntry.setInt(2, name.hashCode());
            resEntry = this.m_selectEntry.executeQuery();
            if (!resEntry.next()) throw new NameNotFoundException("kernel_1601", new Object[]{name, new Long(CID)});
            int type = resEntry.getInt(TYPE);
            valueEntry = ValueEntry.createValueEntry(name, this.switchType(resEntry, type), type);
            Object var8_6 = null;
            if (resEntry == null) return valueEntry;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (resEntry == null) throw throwable;
            resEntry.close();
            throw throwable;
        }
        resEntry.close();
        return valueEntry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getConfigEntryNames(long CID) throws SQLException {
        String[] stringArray;
        ResultSet resValues = null;
        try {
            this.m_selectNames.setLong(1, CID);
            this.m_selectNames.setInt(2, FLAG_ENTRY_VALUE);
            resValues = this.m_selectNames.executeQuery();
            Vector<String> names = new Vector<String>();
            while (resValues.next()) {
                names.add(resValues.getString(NAME));
            }
            stringArray = names.toArray(new String[names.size()]);
            Object var7_5 = null;
            if (resValues == null) return stringArray;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (resValues == null) throw throwable;
            resValues.close();
            throw throwable;
        }
        resValues.close();
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkEntry(long CID, String name) throws SQLException {
        boolean bl;
        ResultSet resCheck;
        block4: {
            boolean bl2;
            block3: {
                resCheck = null;
                try {
                    this.m_checkEntry.setLong(1, CID);
                    this.m_checkEntry.setInt(2, name.hashCode());
                    resCheck = this.m_checkEntry.executeQuery();
                    if (resCheck.next()) {
                        bl2 = true;
                        Object var7_6 = null;
                        if (resCheck == null) return bl2;
                        break block3;
                    }
                    bl = false;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (resCheck == null) throw throwable;
                    resCheck.close();
                    throw throwable;
                }
            }
            resCheck.close();
            return bl2;
        }
        Object var7_7 = null;
        if (resCheck == null) return bl;
        resCheck.close();
        return bl;
    }

    public void addInsertFile(long CID, String name, File file) throws SQLException, IOException {
        FileInputStream fileIn = new FileInputStream(file);
        this.m_insertFile.setLong(1, CID);
        this.m_insertFile.setInt(2, name.hashCode());
        this.m_insertFile.setString(3, name);
        this.m_insertFile.setBinaryStream(4, (InputStream)fileIn, (int)file.length());
        this.m_insertFile.addBatch();
        this.m_fileStreams.add(fileIn);
    }

    public void addInsertFileAsStream(long CID, String name, InputStream in, String transactionId) throws SQLException, IOException {
        StreamLengthPair streamLengthPair = this.getInputStreamLength(in, transactionId);
        int streamLength = streamLengthPair.m_length;
        in = streamLengthPair.m_stream;
        this.m_insertFile.setLong(1, CID);
        this.m_insertFile.setInt(2, name.hashCode());
        this.m_insertFile.setString(3, name);
        this.m_insertFile.setBinaryStream(4, in, streamLength);
        this.m_insertFile.addBatch();
    }

    public void addInsertFileAsStreamWithLength(long CID, String name, InputStream in, int streamLength) throws SQLException {
        this.m_insertFile.setLong(1, CID);
        this.m_insertFile.setInt(2, name.hashCode());
        this.m_insertFile.setString(3, name);
        this.m_insertFile.setBinaryStream(4, in, streamLength);
        this.m_insertFile.addBatch();
    }

    public void addUpdateFile(long CID, String name, File file) throws SQLException, IOException {
        FileInputStream fileIn = new FileInputStream(file);
        this.m_updateFile.setBinaryStream(1, (InputStream)fileIn, (int)file.length());
        this.m_updateFile.setLong(2, CID);
        this.m_updateFile.setInt(3, name.hashCode());
        this.m_updateFile.addBatch();
        this.m_fileStreams.add(fileIn);
    }

    public void addUpdateFileAsStream(long CID, String name, InputStream in, String transactionId) throws SQLException, IOException {
        StreamLengthPair streamLengthPair = this.getInputStreamLength(in, transactionId);
        int streamLength = streamLengthPair.m_length;
        in = streamLengthPair.m_stream;
        this.m_updateFile.setBinaryStream(1, in, streamLength);
        this.m_updateFile.setLong(2, CID);
        this.m_updateFile.setInt(3, name.hashCode());
        this.m_updateFile.addBatch();
    }

    public void addDeleteFile(long CID, String name) throws SQLException {
        this.m_deleteFile.setLong(1, CID);
        this.m_deleteFile.setInt(2, name.hashCode());
        this.m_deleteFile.addBatch();
    }

    public void addDeleteFiles(long CID) throws SQLException {
        this.m_deleteFiles.setLong(1, CID);
        this.m_deleteFiles.addBatch();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getFileEntries(long CID) throws SQLException, InvalidValueException {
        HashMap<String, FileEntry> hashMap;
        ResultSet resFiles = null;
        try {
            this.m_selectNames.setLong(1, CID);
            this.m_selectNames.setInt(2, FLAG_FILE_VALUE);
            resFiles = this.m_selectNames.executeQuery();
            HashMap<String, FileEntry> result = new HashMap<String, FileEntry>();
            while (resFiles.next()) {
                String name = resFiles.getString(NAME);
                result.put(name, FileEntry.createFileEntry(name));
            }
            hashMap = result;
            Object var7_5 = null;
            if (resFiles == null) return hashMap;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (resFiles == null) throw throwable;
            resFiles.close();
            throw throwable;
        }
        resFiles.close();
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getFileEntry(long CID, String name) throws SQLException, NameNotFoundException {
        InputStream inputStream;
        ResultSet resStream = null;
        InputStream in = null;
        try {
            this.m_selectFile.setLong(1, CID);
            this.m_selectFile.setInt(2, name.hashCode());
            resStream = this.m_selectFile.executeQuery();
            if (!resStream.next()) throw new NameNotFoundException("kernel_1605", new Object[]{name, new Long(CID)});
            in = resStream.getBinaryStream(FBLOB);
            if (in == null) {
                in = new ByteArrayInputStream(new byte[0]);
            }
            inputStream = in;
            Object var8_6 = null;
            if (resStream == null) return inputStream;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (resStream == null) throw throwable;
            resStream.close();
            throw throwable;
        }
        resStream.close();
        return inputStream;
    }

    public void releaseOpenStream() throws SQLException {
        if (this.m_fileResultSet != null) {
            this.m_fileResultSet.close();
            this.m_fileResultSet = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getConfigAndFileEntries(long CID, HashMap values, HashMap files) throws SQLException, InvalidValueException {
        ResultSet resValues = null;
        try {
            this.m_selectEntriesFiles.setLong(1, CID);
            resValues = this.m_selectEntriesFiles.executeQuery();
            while (resValues.next()) {
                String name = resValues.getString(NAME);
                boolean isFile = resValues.getShort(FILEFLAG) != 0;
                int type = resValues.getInt(TYPE);
                if (isFile) {
                    files.put(name, FileEntry.createFileEntry(name));
                    continue;
                }
                values.put(name, ValueEntry.createValueEntry(name, this.switchType(resValues, type), type));
            }
            Object var10_8 = null;
            if (resValues == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (resValues == null) throw throwable;
            resValues.close();
            throw throwable;
        }
        resValues.close();
    }

    public void insertInitialKey(long sequenceId, long initialValue) throws SQLException {
        String insertKey = INSERT_KEYGEN + sequenceId + "," + initialValue + ")";
        Statement stm = this.m_conn.createStatement();
        stm.executeUpdate(insertKey);
    }

    public int updateKey(long incValue, long sequenceId, long newIncValue) throws SQLException {
        this.m_updateKey.setLong(1, newIncValue);
        this.m_updateKey.setLong(2, sequenceId);
        this.m_updateKey.setLong(3, incValue);
        return this.m_updateKey.executeUpdate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getIncValue(long sequenceId) throws SQLException, NameNotFoundException {
        long l;
        ResultSet resKey = null;
        try {
            this.m_selectKey.setLong(1, sequenceId);
            resKey = this.m_selectKey.executeQuery();
            if (!resKey.next()) throw new NameNotFoundException("Key sequence does not exist.");
            l = resKey.getLong(1);
            Object var7_4 = null;
            if (resKey == null) return l;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (resKey == null) throw throwable;
            resKey.close();
            throw throwable;
        }
        resKey.close();
        return l;
    }

    public void execDeleteEntriesBatch() throws SQLException {
        this.m_deleteEntries.executeBatch();
    }

    public void execDeleteFilesBatch() throws SQLException {
        this.m_deleteFiles.executeBatch();
    }

    public void execDeleteConfigBatch() throws SQLException {
        this.m_deleteConfig.executeBatch();
    }

    public void execInsertConfigBatch() throws SQLException {
        this.m_insertConfig.executeBatch();
    }

    public void execUpdateConfigBatch() throws SQLException {
        this.m_updateConfig.executeBatch();
    }

    public void execInsertEntryBatch() throws SQLException {
        this.m_insertEntry.executeBatch();
    }

    public void execUpdateEntryBatch() throws SQLException {
        this.m_updateEntry.executeBatch();
    }

    public void execDeleteEntryBatch() throws SQLException {
        this.m_deleteEntry.executeBatch();
    }

    public void execInsertFileBatch() throws SQLException {
        this.m_insertFile.executeBatch();
    }

    public void execUpdateFileBatch() throws SQLException {
        this.m_updateFile.executeBatch();
    }

    public void execDeleteFileBatch() throws SQLException {
        this.m_deleteFile.executeBatch();
    }

    public void clearAllBatches() throws SQLException {
        this.m_insertConfig.clearBatch();
        this.m_updateConfig.clearBatch();
        this.m_deleteConfig.clearBatch();
        this.m_insertEntry.clearBatch();
        this.m_updateEntry.clearBatch();
        this.m_deleteEntry.clearBatch();
        this.m_deleteEntries.clearBatch();
        this.m_insertFile.clearBatch();
        this.m_updateFile.clearBatch();
        this.m_deleteFile.clearBatch();
        this.m_deleteFiles.clearBatch();
    }

    public void commit() throws SQLException {
        try {
            this.m_conn.commit();
            Object var2_1 = null;
            this.cleanUpFiles();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cleanUpFiles();
            throw throwable;
        }
    }

    public void rollback() throws SQLException {
        try {
            this.m_conn.rollback();
            Object var2_1 = null;
            this.cleanUpFiles();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cleanUpFiles();
            throw throwable;
        }
    }

    public void close() throws SQLException {
        try {
            this.m_conn.close();
            Object var2_1 = null;
            this.cleanUpFiles();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cleanUpFiles();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Vector getSubtree(ConfigurationPath path) throws SQLException {
        Vector<Long> vector;
        ResultSet CIDs = null;
        try {
            try {
                String searchPath = this.escapeSearchPath(path.getPathString(), "_");
                Vector<Long> result = new Vector<Long>();
                this.m_selectSubConfigTree.setString(1, searchPath + "/%");
                CIDs = this.m_selectSubConfigTree.executeQuery();
                while (true) {
                    if (!CIDs.next()) {
                        vector = result;
                        Object var7_7 = null;
                        if (CIDs == null) return vector;
                        break;
                    }
                    result.add(new Long(CIDs.getLong(1)));
                }
            }
            catch (SQLException e) {
                Environment.getInstance().getLogging().logThrowable(e, (byte)5);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (CIDs == null) throw throwable;
            CIDs.close();
            throw throwable;
        }
        CIDs.close();
        return vector;
    }

    protected String escapeSearchPath(String path, String escape) {
        String subDestStr = "#" + escape;
        int sourceLength = escape.length();
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while ((index = path.indexOf(escape)) != -1) {
            buffer.append(path.substring(0, index));
            buffer.append(subDestStr);
            path = path.substring(index + sourceLength);
        }
        buffer.append(path);
        return buffer.toString();
    }

    protected StreamLengthPair getInputStreamLength(InputStream streamIn, String transId) throws IOException {
        InputStream in = null;
        int length = 0;
        byte[] buf = new byte[1000];
        int received = 0;
        int cumulativeReceived = 0;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        File tempFile = null;
        FileOutputStream fileOut = null;
        while ((received = streamIn.read(buf)) != -1) {
            if ((cumulativeReceived += received) < 10000) {
                byteOut.write(buf, 0, received);
                continue;
            }
            if (tempFile == null) {
                if (this.m_tempFileFolder == null) {
                    this.m_tempFileFolder = new File(TEMP_FOLDER_NAME + transId);
                    if (!this.m_tempFileFolder.mkdirs()) {
                        throw new IOException("Could not create folder: " + TEMP_FOLDER_NAME + transId);
                    }
                }
                tempFile = new File(this.m_tempFileFolder.getPath() + File.separator + this.m_tempFileCounter++);
                fileOut = new FileOutputStream(tempFile);
                byteOut.writeTo(fileOut);
                byteOut.close();
            }
            fileOut.write(buf, 0, received);
        }
        streamIn.close();
        if (tempFile == null) {
            byte[] temp = byteOut.toByteArray();
            byteOut.close();
            in = new ByteArrayInputStream(temp);
            length = temp.length;
        } else {
            fileOut.close();
            in = new FileInputStream(tempFile);
            length = (int)tempFile.length();
        }
        streamIn = in;
        this.m_fileStreams.add(streamIn);
        return new StreamLengthPair(length, streamIn);
    }

    private Object switchType(ResultSet res, int type) throws SQLException {
        Object obj = null;
        switch (type) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                obj = new Long(res.getLong(VINT));
                break;
            }
            case 30: {
                obj = new Double(res.getDouble(VDOUBLE));
                break;
            }
            case 40: {
                obj = res.getString(VSTR);
                break;
            }
            case 50: 
            case 60: {
                byte[] bytes = res.getBytes(VBYTES);
                int length = (int)res.getLong(VINT);
                if (bytes == null) {
                    bytes = new byte[]{};
                    length = 0;
                }
                if (bytes.length != length) {
                    byte[] adjBytes = new byte[length];
                    System.arraycopy(bytes, 0, adjBytes, 0, length);
                    obj = adjBytes;
                    break;
                }
                obj = bytes;
                break;
            }
        }
        return obj;
    }

    private void cleanUpFiles() {
        int i = 0;
        while (i < this.m_fileStreams.size()) {
            InputStream in = (InputStream)this.m_fileStreams.get(i);
            try {
                in.close();
            }
            catch (IOException e) {
                Environment.getInstance().getLogging().logThrowable("Could not close stream on input file. See stacktrace for details.", e, (byte)5);
            }
            ++i;
        }
        this.m_fileStreams.clear();
        if (this.m_tempFileFolder != null) {
            Environment.getInstance().startThread(new TempFileCleaner(this.m_tempFileFolder));
            this.m_tempFileCounter = 0;
            this.m_tempFileFolder = null;
        }
    }

    static {
        TEMP_FOLDER_NAME = "." + File.separator + "temp" + File.separator + "kernel" + File.separator + "configuration" + File.separator;
    }

    class TempFileCleaner
    implements Runnable {
        File m_fileFolder;

        public TempFileCleaner(File fileFolder) {
            this.m_fileFolder = fileFolder;
        }

        public void run() {
            if (this.m_fileFolder != null) {
                File[] filesForDeletion = this.m_fileFolder.listFiles();
                int i = 0;
                while (i < filesForDeletion.length) {
                    File deleteMe = filesForDeletion[i];
                    if (!deleteMe.delete()) {
                        Environment.getInstance().getLogging().log((byte)5, "Could not delete temporary file: " + deleteMe.getAbsolutePath());
                    }
                    ++i;
                }
                if (!this.m_fileFolder.delete()) {
                    Environment.getInstance().getLogging().log((byte)5, "Could not delete temporary folder: " + this.m_fileFolder.getAbsolutePath());
                }
            }
        }
    }

    class StreamLengthPair {
        InputStream m_stream;
        int m_length;

        StreamLengthPair(int length, InputStream stream) {
            this.m_stream = stream;
            this.m_length = length;
        }
    }
}

