/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.event;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.event.EventProcessor;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.lib.util.WaitQueue;

public class QueuedEventProcessor
implements Runnable {
    private WaitQueue m_queue = new WaitQueue();
    EventProcessor m_eventProcessor;
    private boolean m_stopped;
    private Thread m_thread;

    public QueuedEventProcessor(EventProcessor eventProcessor) {
        this.m_eventProcessor = eventProcessor;
    }

    public void enqeueEvents(ChangeEvent[] events) {
        this.m_queue.enqueue((Object)events);
    }

    public void run() {
        this.m_stopped = false;
        this.m_thread = Thread.currentThread();
        while (!this.m_stopped) {
            ChangeEvent[] events = (ChangeEvent[])this.m_queue.dequeue();
            if (this.m_stopped) continue;
            this.m_eventProcessor.processEventListeners(events, 2);
        }
        this.m_thread = null;
    }

    public void start() {
        if (this.m_thread != null) {
            return;
        }
        Environment.getInstance().startThread(this);
    }

    public void stop() {
        if (this.m_thread == null) {
            return;
        }
        this.m_stopped = true;
        try {
            this.m_thread.interrupt();
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, e.getMessage(), e);
        }
    }
}

