/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.event;

import com.sap.engine.core.configuration.impl.ChangeEventImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class PathEventProcessor {
    private ConfigurationChangedListener[] m_listeners;
    private Vector m_sortedEvents;
    private ChangeEventImpl m_changeEvent;
    private int m_pathLength;
    private boolean m_valid = true;

    public PathEventProcessor(ConfigurationPath path, ConfigurationChangedListener[] listeners) {
        this.m_listeners = listeners;
        this.m_sortedEvents = new Vector();
        this.m_changeEvent = new ChangeEventImpl(-1, path);
        this.m_pathLength = path.length();
    }

    private int insertInVector(ChangeEvent obj) {
        int len;
        int t = len = this.m_sortedEvents.size();
        int b = 0;
        int pos = (t + b) / 2;
        int objLength = obj.getPath().length();
        while (b < t) {
            int posLength = ((ChangeEvent)this.m_sortedEvents.elementAt(pos)).getPath().length();
            if (objLength > posLength) {
                b = pos + 1;
                pos = (t + b) / 2;
                continue;
            }
            t = pos;
            pos = (t + b) / 2;
        }
        this.m_sortedEvents.insertElementAt(obj, b);
        return b;
    }

    public void addEvent(ChangeEvent e) {
        this.insertInVector(e);
    }

    private void calculateEvent(ChangeEvent e) {
        int curAction = this.m_changeEvent.getAction();
        int pathlength = e.getPath().length();
        int action = e.getAction();
        if (action == 2 && pathlength <= this.m_pathLength) {
            if (curAction != 1) {
                this.m_changeEvent.setAction(2);
            } else {
                this.m_changeEvent.setAction(0);
            }
            return;
        }
        if (pathlength == this.m_pathLength) {
            switch (curAction) {
                case -1: {
                    this.m_changeEvent.setAction(action);
                    return;
                }
                case 1: {
                    if (action == 2) {
                        this.m_changeEvent.setAction(0);
                    }
                    return;
                }
                case 2: {
                    if (action == 1) {
                        this.m_changeEvent.setAction(0);
                    }
                    return;
                }
                case 0: {
                    return;
                }
            }
        } else if (pathlength > this.m_pathLength && this.m_changeEvent.getAction() != 1) {
            this.m_changeEvent.setAction(0);
        }
    }

    private void prepareForSend() {
        Iterator iterator = ((AbstractList)this.m_sortedEvents).iterator();
        while (iterator.hasNext()) {
            ChangeEvent e = (ChangeEvent)iterator.next();
            this.calculateEvent(e);
        }
    }

    public void sendEvents() {
        if (!this.m_valid) {
            throw new RuntimeException("Internal Config Manager Error, PathEventProcessor is not valid");
        }
        this.prepareForSend();
        if (this.m_changeEvent.getAction() == -1) {
            return;
        }
        this.m_changeEvent.setDetailedChangeEvents(this.m_sortedEvents.toArray(new ChangeEvent[0]));
        int i = 0;
        while (i < this.m_listeners.length) {
            try {
                this.m_listeners[i].configurationChanged(this.m_changeEvent);
            }
            catch (Throwable t) {
                Environment.getInstance().getLogging().logThrowable("Exception in ConfigurationChangedListener", t);
            }
            ++i;
        }
        this.m_valid = false;
    }
}

