/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.event;

import com.sap.engine.core.configuration.impl.event.PathEventProcessor;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import java.util.AbstractCollection;
import java.util.HashSet;

class ListenersForPath {
    private HashSet m_syncListeners = new HashSet();
    private HashSet m_asyncListeners = new HashSet();
    private ConfigurationPath m_path;

    public ListenersForPath(ConfigurationPath path) {
        this.m_path = path;
    }

    public synchronized void addListener(ConfigurationChangedListener l, int mode) {
        if (mode == 1) {
            this.m_asyncListeners.remove(l);
            this.m_syncListeners.add(l);
        } else {
            this.m_syncListeners.remove(l);
            this.m_asyncListeners.add(l);
        }
    }

    public synchronized void removeListener(ConfigurationChangedListener l) {
        this.m_asyncListeners.remove(l);
        this.m_syncListeners.remove(l);
    }

    public synchronized int getListenerCount() {
        return this.m_syncListeners.size() + this.m_asyncListeners.size();
    }

    public synchronized int getListenerCount(int mode) {
        if (mode == 1) {
            return this.m_syncListeners.size();
        }
        if (mode == 2) {
            return this.m_asyncListeners.size();
        }
        return 0;
    }

    public synchronized PathEventProcessor getPathEventProcessor(int mode) {
        if (mode == 1) {
            return new PathEventProcessor(this.m_path, ((AbstractCollection)this.m_syncListeners).toArray(new ConfigurationChangedListener[0]));
        }
        return new PathEventProcessor(this.m_path, ((AbstractCollection)this.m_asyncListeners).toArray(new ConfigurationChangedListener[0]));
    }
}

