/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.event;

import com.sap.engine.core.configuration.impl.ChangeEventImpl;
import com.sap.engine.core.configuration.impl.event.ListenersForPath;
import com.sap.engine.core.configuration.impl.event.PathEventProcessor;
import com.sap.engine.core.configuration.impl.event.QueuedEventProcessor;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import java.util.HashMap;
import java.util.Map;

public class EventProcessor {
    private HashMap m_changeListeners = new HashMap();
    private QueuedEventProcessor m_queuedEventProcessor = new QueuedEventProcessor(this);

    public EventProcessor() {
        this.m_queuedEventProcessor.start();
    }

    public void shutDown() {
        this.m_queuedEventProcessor.stop();
    }

    public synchronized void addConfigurationChangedListener(ConfigurationChangedListener listener, ConfigurationPath pathObj, int mode) {
        ListenersForPath listenersForPath = (ListenersForPath)this.m_changeListeners.get(pathObj);
        if (listenersForPath == null) {
            listenersForPath = new ListenersForPath(pathObj);
            this.m_changeListeners.put(pathObj, listenersForPath);
        }
        listenersForPath.addListener(listener, mode);
    }

    public synchronized void removeConfigurationChangedListener(ConfigurationChangedListener listener, ConfigurationPath pathObj) {
        ListenersForPath listenersForPath = (ListenersForPath)this.m_changeListeners.get(pathObj);
        if (listenersForPath == null) {
            return;
        }
        listenersForPath.removeListener(listener);
        if (listenersForPath.getListenerCount() == 0) {
            this.m_changeListeners.remove(pathObj);
        }
    }

    public void processEvents(ChangeEvent[] events) {
        this.m_queuedEventProcessor.enqeueEvents(events);
        this.processEventListeners(events, 1);
    }

    protected void processEventListeners(ChangeEvent[] events, int mode) {
        Map.Entry[] regPaths = null;
        EventProcessor eventProcessor = this;
        synchronized (eventProcessor) {
            regPaths = this.m_changeListeners.entrySet().toArray(new Map.Entry[0]);
        }
        int i = 0;
        while (i < regPaths.length) {
            ConfigurationPath listenerPath = (ConfigurationPath)regPaths[i].getKey();
            ListenersForPath listenersForPath = (ListenersForPath)regPaths[i].getValue();
            PathEventProcessor pathEventProcessor = null;
            if (listenersForPath.getListenerCount(mode) != 0) {
                int ii = 0;
                while (ii < events.length) {
                    ChangeEventImpl event = (ChangeEventImpl)events[ii];
                    if (event.getAction() != 3) {
                        boolean sendEvent = false;
                        if (listenerPath.isArgumentSubTree(event.getPathWrapper())) {
                            sendEvent = true;
                        } else if (event.getAction() == 2 && event.getPathWrapper().isArgumentSubTree(listenerPath)) {
                            sendEvent = true;
                        }
                        if (sendEvent) {
                            if (pathEventProcessor == null) {
                                pathEventProcessor = listenersForPath.getPathEventProcessor(mode);
                            }
                            pathEventProcessor.addEvent(event);
                        }
                    }
                    ++ii;
                }
            }
            if (pathEventProcessor != null) {
                pathEventProcessor.sendEvents();
            }
            ++i;
        }
    }
}

