/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.cache;

import com.sap.engine.core.configuration.impl.cache.InternalLock;
import java.util.HashMap;
import java.util.Iterator;

class InCommitEntry {
    public boolean exclusive;
    public InternalLock exclusiveLock;
    public HashMap allSharedLocks;

    public InCommitEntry(InternalLock lock, boolean isExclusive) {
        this.exclusive = isExclusive;
        if (this.exclusive) {
            this.exclusiveLock = lock;
        } else {
            this.allSharedLocks = new HashMap();
            this.allSharedLocks.put(lock.m_transactionID, lock);
        }
    }

    public void addWaiter() {
        if (this.exclusive) {
            this.exclusiveLock.addWaiter();
        } else {
            Iterator it = this.allSharedLocks.values().iterator();
            int i = 0;
            while (i < this.allSharedLocks.size()) {
                ((InternalLock)it.next()).addWaiter();
                ++i;
            }
        }
    }

    public InternalLock[] getAllLocks() {
        if (this.exclusive) {
            InternalLock[] result = new InternalLock[]{this.exclusiveLock};
            return result;
        }
        return this.allSharedLocks.values().toArray(new InternalLock[this.allSharedLocks.size()]);
    }

    public InternalLock getLockForTransactionId(String id) {
        if (this.exclusive) {
            if (this.exclusiveLock.m_transactionID.equals(id)) {
                return this.exclusiveLock;
            }
            return null;
        }
        return (InternalLock)this.allSharedLocks.get(id);
    }

    public void addSharedLock(InternalLock lock) {
        this.allSharedLocks.put(lock.m_transactionID, lock);
    }

    public void removeSharedLock(InternalLock lock) {
        this.allSharedLocks.remove(lock.m_transactionID);
    }

    public void removeSharedLock(String id) {
        this.allSharedLocks.remove(id);
    }

    public int getSharedLockCount() {
        return this.allSharedLocks.size();
    }
}

