/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.cache;

import com.sap.engine.core.configuration.impl.ChangeEventImpl;
import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ConfigurationDataCacheAllImpl;
import com.sap.engine.core.configuration.impl.ConfigurationHandlerImpl;
import com.sap.engine.core.configuration.impl.ConfigurationImpl;
import com.sap.engine.core.configuration.impl.ConfigurationMessageAnswer;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.EnvironmentListener;
import com.sap.engine.core.configuration.impl.ReadAccessConfiguration;
import com.sap.engine.core.configuration.impl.TransactionInfo;
import com.sap.engine.core.configuration.impl.WriteAccessConfiguration;
import com.sap.engine.core.configuration.impl.cache.AccessController;
import com.sap.engine.core.configuration.impl.cache.CachedConfiguration;
import com.sap.engine.core.configuration.impl.cache.CachedConfigurationHolder;
import com.sap.engine.core.configuration.impl.event.EventProcessor;
import com.sap.engine.core.configuration.impl.persistence.rdbms.FileLoader;
import com.sap.engine.core.configuration.impl.persistence.rdbms.PersistenceHandler;
import com.sap.engine.core.configuration.impl.persistence.rdbms.UpdateProcessor;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.Semaphore;
import com.sap.engine.core.configuration.impl.utilities.SequenceGenerator;
import com.sap.engine.core.configuration.impl.utilities.Utils;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.StorageInformation;
import com.sap.engine.frame.core.configuration.admin.BlockingLock;
import com.sap.engine.frame.core.configuration.admin.BlockingLockImpl;
import com.sap.engine.frame.core.configuration.admin.OpenConfigInfo;
import com.sap.engine.frame.core.configuration.admin.OpenConfigInfoImpl;
import com.sap.engine.lib.util.cache.CacheGroup;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ConfigurationCache
implements EnvironmentListener {
    private static final String DEFAULT_AREA = "J2EE_CONFIGURATION_MANAGER";
    private static final String INTERNAL_LOCK_AREA = "J2EE_CONFIG_MGR_INTERNAL";
    private static final int AFTER_COMMIT_MSG_TYPE = 1;
    private static final int CACHE_INVALIDATION_MSG_TYPE = 2;
    private static final int REQUEST_OPEN_CONFIG_INFO_MSG_TYPE = 3;
    private static final int REQUEST_BLOCKING_LOCK_INFO_MSG_TYPE = 4;
    private static final int FORCE_RELEASE_ACCESSCONTROLLER_LOCKS = 5;
    private static final int FORCE_CLOSE_CONFIGURATION = 6;
    private static int INTERNAL_ENQEUE_WAIT_TIME = 100;
    protected static int MAX_CACHED_CONFIGURATIONS = 30;
    public static final String INTERNAL_ROOT = "configmanager_internal";
    private static final String[] HIDDEN_CONFIGURATIONS_ARRAY = new String[]{"configmanager_internal", "keystore", "securestorage"};
    private static final HashSet HIDDEN_CONFIGURATIONS_SET = new HashSet<String>(Arrays.asList(HIDDEN_CONFIGURATIONS_ARRAY));
    private long[] m_statistics = new long[8];
    public static final int ACC_COMMIT_TIME = 0;
    public static final int ACC_NR_OF_COMMITS = 1;
    public static final int ACC_NR_ALL_OPEN_REQUESTS = 2;
    public static final int ACC_NR_OPEN_FOR_WRITE = 3;
    public static final int ACC_NR_OPEN_FOR_READ = 4;
    public static final int ACC_NR_LOCKED_OPEN_REQUESTS = 5;
    public static final int ACC_NR_TOTAL_CACHE_REQUESTS = 6;
    public static final int ACC_NR_OF_CACHE_HITS = 7;
    private PersistenceHandler m_persistenceHandler;
    private CachedConfigurationHolder m_cache = new CachedConfigurationHolder();
    private HashMap m_changeListeners = new HashMap();
    private Hashtable m_inCommitTransactions = new Hashtable();
    private Hashtable m_openforWriteConfigsInfo = new Hashtable();
    private Hashtable m_inCommitThreads = new Hashtable();
    private AccessController m_accessController;
    private String m_internalLockOwner;
    private int m_localClusterID;
    private CacheGroup m_cacheGroup;
    private EventProcessor m_eventProcessor;
    private Semaphore m_shutdownSychronizer;
    private boolean m_isShutdown = false;
    private boolean m_isCommitTraceEnabled = false;
    private HashMap m_commitInfos = new HashMap();

    public ConfigurationCache(Properties properties) throws ConfigurationException {
        String traceProp = properties.getProperty("call.trace.level", "0");
        if (traceProp.equals("1")) {
            this.setCommitTrace(true);
        } else if (traceProp.equals("0")) {
            this.setCommitTrace(false);
        }
        this.m_cacheGroup = new CacheGroup();
        ConfigurationPath.init(this.m_cacheGroup);
        this.m_cache.init(this.m_cacheGroup);
        Environment.getInstance().startThread((Runnable)this.m_cacheGroup);
        this.m_internalLockOwner = Environment.getInstance().createUniqueOwner();
        this.m_localClusterID = Environment.getInstance().getLocalClusterID();
        this.m_persistenceHandler = new PersistenceHandler(properties);
        this.m_eventProcessor = new EventProcessor();
        this.m_shutdownSychronizer = new Semaphore();
        try {
            this.getInternalEnqueueLock(new String[]{""}, false, true, true);
            this.m_accessController = new AccessController();
            Environment.getInstance().setEnvironmentListener(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInternalEnqueueLock(new String[]{""}, false, true);
            throw throwable;
        }
        this.releaseInternalEnqueueLock(new String[]{""}, false, true);
    }

    private void synchronizeShutDown(int lockType) {
        try {
            this.m_shutdownSychronizer.getLock(lockType);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void releaseShutDownLock(int lockType) {
        try {
            this.m_shutdownSychronizer.releaseLock(lockType);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    public TransactionInfo checkIfCurrentThreadIsInCommit() {
        return (TransactionInfo)this.m_inCommitThreads.get(Thread.currentThread());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationMessageAnswer receive(int clusterId, int msgtype, byte[] message, int offset, int length) throws ConfigurationException {
        ConfigurationMessageAnswer configurationMessageAnswer;
        block15: {
            ConfigurationMessageAnswer in2;
            block14: {
                ConfigurationMessageAnswer in2;
                block13: {
                    try {
                        try {
                            ObjectInputStream in3;
                            this.synchronizeShutDown(Semaphore.SHARED);
                            if (this.m_isShutdown) {
                                ConfigurationMessageAnswer configurationMessageAnswer2 = new ConfigurationMessageAnswer(new byte[0]);
                                Object var12_8 = null;
                                this.releaseShutDownLock(Semaphore.SHARED);
                                return configurationMessageAnswer2;
                            }
                            ByteArrayInputStream bytes = new ByteArrayInputStream(message, offset, length);
                            if (msgtype == 2) {
                                in3 = new ObjectInputStream(new GZIPInputStream(bytes));
                                TransactionInfo tInfo = TransactionInfo.readFromStream(in3);
                                this.processLocalBeforeCommit(clusterId, tInfo);
                            } else if (msgtype == 1) {
                                in3 = new ObjectInputStream(bytes);
                                String id = in3.readUTF();
                                int commitReturn = in3.readInt();
                                this.processLocalAfterCommit(clusterId, id, commitReturn, false);
                            } else {
                                if (msgtype == 3) {
                                    in2 = this.getLocalOpenConfigInfoAsMessage();
                                    break block13;
                                }
                                if (msgtype == 4) {
                                    in2 = this.getLocalBlockingLockInfoAsMessage();
                                    break block14;
                                }
                                if (msgtype == 5) {
                                    in3 = new ObjectInputStream(new ByteArrayInputStream(message, offset, length));
                                    BlockingLockImpl[] lock = BlockingLockImpl.readAllFromStream(in3);
                                    this.forceReleaseAccessControllerLocksLocal(lock[0]);
                                } else {
                                    if (msgtype != 6) throw new ConfigurationException("kernel_1502");
                                    in3 = new ObjectInputStream(new ByteArrayInputStream(message, offset, length));
                                    OpenConfigInfo[] info = OpenConfigInfoImpl.readAllFromStream(in3);
                                    this.forceCloseConfigurationLocal(info[0]);
                                }
                            }
                            configurationMessageAnswer = new ConfigurationMessageAnswer(new byte[0]);
                            break block15;
                        }
                        catch (Exception e) {
                            throw new ConfigurationException(e, "kernel_1503");
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        this.releaseShutDownLock(Semaphore.SHARED);
                        throw throwable;
                    }
                }
                Object var12_9 = null;
                this.releaseShutDownLock(Semaphore.SHARED);
                return in2;
            }
            Object var12_10 = null;
            this.releaseShutDownLock(Semaphore.SHARED);
            return in2;
        }
        Object var12_11 = null;
        this.releaseShutDownLock(Semaphore.SHARED);
        return configurationMessageAnswer;
    }

    public StorageInformation getStorageInformation() {
        return this.m_persistenceHandler.getStorageInformation();
    }

    public int[] getDBPoolStatistics() {
        return this.m_persistenceHandler.getPoolStatistics();
    }

    private OpenConfigInfoImpl[] getLocalOpenConfigInfo() {
        Hashtable hashtable = this.m_openforWriteConfigsInfo;
        synchronized (hashtable) {
            OpenConfigInfoImpl[] openConfigInfoImplArray = this.m_openforWriteConfigsInfo.values().toArray(new OpenConfigInfoImpl[0]);
            return openConfigInfoImplArray;
        }
    }

    private ConfigurationMessageAnswer getLocalOpenConfigInfoAsMessage() throws ConfigurationException {
        OpenConfigInfoImpl[] openWrites = this.getLocalOpenConfigInfo();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objout = new ObjectOutputStream(out);
            int i = 0;
            while (i < openWrites.length) {
                openWrites[i].writeToStream(objout);
                ++i;
            }
            objout.flush();
            objout.close();
            return new ConfigurationMessageAnswer(out.toByteArray());
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1504", new Object[]{"getLocalOpenConfigInfo()"});
        }
    }

    public OpenConfigInfo[] getOpenConfigurationInfo(int node) throws ConfigurationException {
        if (node == this.m_localClusterID) {
            return this.getLocalOpenConfigInfo();
        }
        Vector<OpenConfigInfo> result = new Vector<OpenConfigInfo>();
        ConfigurationMessageAnswer[] answers = null;
        if (node == -1) {
            OpenConfigInfoImpl[] localInfos = this.getLocalOpenConfigInfo();
            int i = 0;
            while (i < localInfos.length) {
                result.add(localInfos[i]);
                ++i;
            }
            answers = Environment.getInstance().send(3, new byte[0], true);
        } else {
            answers = new ConfigurationMessageAnswer[]{Environment.getInstance().sendToOneNode(node, 3, new byte[0])};
        }
        try {
            int i = 0;
            while (i < answers.length) {
                if (!answers[i].isEmpty()) {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(answers[i].getMessage(), answers[i].getOffset(), answers[i].getLength()));
                    OpenConfigInfo[] infos = OpenConfigInfoImpl.readAllFromStream(in);
                    int ii = 0;
                    while (ii < infos.length) {
                        result.add(infos[ii]);
                        ++ii;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1505", new Object[]{"getOpenConfigurationInfo"});
        }
        return result.toArray(new OpenConfigInfo[0]);
    }

    private void forceCloseConfigurationLocal(OpenConfigInfo openConfigInfo) {
        Hashtable hashtable = this.m_openforWriteConfigsInfo;
        synchronized (hashtable) {
            OpenConfigInfoImpl openConfig = (OpenConfigInfoImpl)this.m_openforWriteConfigsInfo.get(ConfigurationPath.getConfigurationPath(openConfigInfo.getPath()));
            if (openConfig != null) {
                try {
                    openConfig.getConfiguration().close();
                    Environment.getInstance().getLogging().log((byte)3, "Admin forced to close " + openConfig.getConfiguration());
                }
                catch (Exception e) {
                    Environment.getInstance().getLogging().traceThrowable(3, null, e);
                    Environment.getInstance().getLogging().log((byte)3, "Exception " + e + " occured while Admin forced to close " + openConfig.getConfiguration());
                }
            }
        }
    }

    public void forceCloseConfiguration(OpenConfigInfo openConfigInfo) throws ConfigurationException {
        if (openConfigInfo.getClusterNodeID() == this.m_localClusterID) {
            this.forceCloseConfigurationLocal(openConfigInfo);
            return;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objout = new ObjectOutputStream(out);
            ((OpenConfigInfoImpl)openConfigInfo).writeToStream(objout);
            objout.flush();
            Environment.getInstance().sendToOneNode(openConfigInfo.getClusterNodeID(), 6, out.toByteArray());
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1506", new Object[]{"FORCE_CLOSE_CONFIGURATION"});
        }
    }

    private BlockingLock[] getLocalBlockingLockInfo() {
        return this.m_accessController.getBlockedReaders();
    }

    private ConfigurationMessageAnswer getLocalBlockingLockInfoAsMessage() throws ConfigurationException {
        BlockingLock[] openWrites = this.getLocalBlockingLockInfo();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objout = new ObjectOutputStream(out);
            int i = 0;
            while (i < openWrites.length) {
                ((BlockingLockImpl)openWrites[i]).writeToStream(objout);
                ++i;
            }
            objout.flush();
            objout.close();
            return new ConfigurationMessageAnswer(out.toByteArray());
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1504", new Object[]{"getLocalBlockingLockInfo()"});
        }
    }

    public BlockingLock[] getBlockingLockInfo(int node) throws ConfigurationException {
        if (node == this.m_localClusterID) {
            return this.getLocalBlockingLockInfo();
        }
        Vector<BlockingLock> result = new Vector<BlockingLock>();
        ConfigurationMessageAnswer[] answers = null;
        if (node == -1) {
            BlockingLock[] localInfos = this.getLocalBlockingLockInfo();
            int i = 0;
            while (i < localInfos.length) {
                result.add(localInfos[i]);
                ++i;
            }
            answers = Environment.getInstance().send(4, new byte[0], true);
        } else {
            answers = new ConfigurationMessageAnswer[]{Environment.getInstance().sendToOneNode(node, 4, new byte[0])};
        }
        try {
            int i = 0;
            while (i < answers.length) {
                if (!answers[i].isEmpty()) {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(answers[i].getMessage(), answers[i].getOffset(), answers[i].getLength()));
                    BlockingLockImpl[] infos = BlockingLockImpl.readAllFromStream(in);
                    int ii = 0;
                    while (ii < infos.length) {
                        result.add(infos[ii]);
                        ++ii;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1505", new Object[]{"getBlockingLockInfo"});
        }
        return result.toArray(new BlockingLock[0]);
    }

    private void forceReleaseAccessControllerLocksLocal(BlockingLock lock) {
        this.m_accessController.resolveBlockingLock(lock);
    }

    public void forceReleaseAccessControllerLocks(BlockingLock lock) throws ConfigurationException {
        this.m_accessController.resolveBlockingLock(lock);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objout = new ObjectOutputStream(out);
            ((BlockingLockImpl)lock).writeToStream(objout);
            objout.flush();
            Environment.getInstance().send(5, out.toByteArray(), false);
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1506", new Object[]{"FORCE_RELEASE_ACCESSCONTROLLER_LOCKS"});
        }
    }

    public void clusterElementJoined(int clusterId) {
    }

    public void clusterElementLost(int clusterId) {
        Environment.getInstance().getLogging().trace(2, "", "cluster node " + clusterId + " lost");
        this.m_accessController.removeAllInCommitLocksForClusterNode(clusterId);
    }

    public void getInternalEnqueueLock(String[] key, boolean exclusive, boolean hierachy, boolean wait) throws ConfigurationException {
        if (key.length == 0) {
            return;
        }
        boolean[] exclusiveFlags = new boolean[key.length];
        String[] areaArray = new String[key.length];
        int i = 0;
        while (i < key.length) {
            exclusiveFlags[i] = exclusive;
            areaArray[i] = INTERNAL_LOCK_AREA;
            ++i;
        }
        if (wait) {
            boolean success = false;
            while (!success) {
                try {
                    Environment.getInstance().addLock(this.m_internalLockOwner, areaArray, key, exclusiveFlags, hierachy);
                    success = true;
                }
                catch (ConfigurationLockedException le) {
                    Environment.getInstance().getLogging().traceThrowable(3, le.getMessage(), (Throwable)((Object)le));
                    this.waitForLock();
                }
            }
        } else {
            Environment.getInstance().addLock(this.m_internalLockOwner, areaArray, key, exclusiveFlags, hierachy);
        }
    }

    public void releaseInternalEnqueueLock(String[] key, boolean exclusive, boolean hierachy) throws ConfigurationException {
        if (key.length == 0) {
            return;
        }
        boolean[] exclusiveFlags = new boolean[key.length];
        String[] areaArray = new String[key.length];
        int i = 0;
        while (i < key.length) {
            exclusiveFlags[i] = exclusive;
            areaArray[i] = INTERNAL_LOCK_AREA;
            ++i;
        }
        Environment.getInstance().removeLock(this.m_internalLockOwner, areaArray, key, exclusiveFlags, hierachy);
    }

    private synchronized void waitForLock() {
        try {
            this.wait(INTERNAL_ENQEUE_WAIT_TIME);
        }
        catch (InterruptedException e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    public void shutDown(Properties p) {
        Environment.getInstance().unsetEnvironmentListener();
        this.synchronizeShutDown(Semaphore.EXCLUSIVE);
        this.m_cacheGroup.stop();
        this.m_eventProcessor.shutDown();
        this.m_persistenceHandler.close();
        this.m_isShutdown = true;
        this.releaseShutDownLock(Semaphore.EXCLUSIVE);
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener listener, String path, int mode) {
        ConfigurationPath pathObj = ConfigurationPath.getConfigurationPath(path);
        this.m_eventProcessor.addConfigurationChangedListener(listener, pathObj, mode);
    }

    public void removeConfigurationChangedListener(ConfigurationChangedListener listener, String path) {
        ConfigurationPath pathObj = ConfigurationPath.getConfigurationPath(path);
        this.m_eventProcessor.removeConfigurationChangedListener(listener, pathObj);
    }

    private void processEventListeners(ChangeEvent[] events) {
        this.m_eventProcessor.processEvents(events);
    }

    public long getSureConfigId(ConfigurationPath path) throws ConfigurationException {
        try {
            this.m_accessController.getAccessAndWait(path);
            long l = this.getSureConfigIdInternal(path);
            Object var5_3 = null;
            this.m_accessController.releaseAccess(path);
            return l;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.m_accessController.releaseAccess(path);
            throw throwable;
        }
    }

    private long getSureConfigIdInternal(ConfigurationPath path) throws ConfigurationException {
        CachedConfiguration obj = null;
        ConfigurationCache configurationCache = this;
        synchronized (configurationCache) {
            obj = this.m_cache.getFromCache(path);
        }
        if (obj != null) {
            return obj.getId();
        }
        return this.m_persistenceHandler.getCID(path);
    }

    public String[] getAllRootNames() throws ConfigurationException {
        String[] result = this.m_persistenceHandler.getAllRootNames();
        Vector<String> v = new Vector<String>(result.length);
        int i = 0;
        while (i < result.length) {
            if (!HIDDEN_CONFIGURATIONS_SET.contains(result[i])) {
                v.add(result[i]);
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    public ConfigMetaData[] getAllRootConfigsMetaData() throws ConfigurationException {
        ConfigMetaData[] result = this.m_persistenceHandler.getAllRootConfigsMetaData();
        Vector<ConfigMetaData> v = new Vector<ConfigMetaData>(result.length);
        int i = 0;
        while (i < result.length) {
            if (!HIDDEN_CONFIGURATIONS_SET.contains(result[i].getName())) {
                v.add(result[i]);
            }
            ++i;
        }
        return v.toArray(new ConfigMetaData[0]);
    }

    public Configuration createRootConfiguration(ConfigurationPath name, ConfigurationHandler hdl) throws ConfigurationException {
        Environment.getInstance().getLogging().trace(2, "", "create root configuration " + name);
        Environment.getInstance().addLock(hdl.getId(), DEFAULT_AREA, name.getLockKey(), true, true);
        try {
            try {
                this.getSureConfigIdInternal(name);
                throw new NameAlreadyExistsException("kernel_1610", new Object[]{name.getPathString()});
            }
            catch (NameNotFoundException e) {
                long cid = this.m_persistenceHandler.getKeyGenerator().generateKey();
                ConfigurationDataCacheAllImpl emptyData = new ConfigurationDataCacheAllImpl(cid, name, this.m_persistenceHandler);
                WriteAccessConfiguration cfg = new WriteAccessConfiguration(emptyData, hdl, null);
                this.m_openforWriteConfigsInfo.put(name, new OpenConfigInfoImpl(cfg, 1, this.m_localClusterID, 1));
                return cfg;
            }
        }
        catch (ConfigurationException e) {
            Environment.getInstance().removeLock(hdl.getId(), DEFAULT_AREA, name.getLockKey(), true, true);
            throw e;
        }
    }

    public Configuration createSubConfiguration(ConfigurationPath path, ConfigurationHandler hdl) throws ConfigurationException {
        Environment.getInstance().getLogging().trace(2, "", "create sub configuration without locking the parent " + path);
        Environment.getInstance().addLock(hdl.getId(), DEFAULT_AREA, path.getLockKey(), true, true);
        try {
            try {
                this.getSureConfigIdInternal(path);
                throw new NameAlreadyExistsException("kernel_1610", new Object[]{path.getPathString()});
            }
            catch (NameNotFoundException e) {
                ConfigurationPath parPath = path.getParrentPath();
                long parrentcid = ConfigurationData.ROOT_ID;
                if (parPath != ConfigurationPath.ROOT_CONFIG_PATH) {
                    parrentcid = this.getSureConfigIdInternal(parPath);
                }
                long cid = this.m_persistenceHandler.getKeyGenerator().generateKey();
                ConfigurationDataCacheAllImpl emptyData = new ConfigurationDataCacheAllImpl(cid, parrentcid, path, 0, this.m_persistenceHandler);
                WriteAccessConfiguration cfg = new WriteAccessConfiguration(emptyData, hdl, null);
                this.m_openforWriteConfigsInfo.put(path, new OpenConfigInfoImpl(cfg, 1, this.m_localClusterID, 1));
                return cfg;
            }
        }
        catch (ConfigurationException e) {
            Environment.getInstance().removeLock(hdl.getId(), DEFAULT_AREA, path.getLockKey(), true, true);
            throw e;
        }
    }

    public Configuration openConfiguration(ConfigurationPath path, int mode, ConfigurationHandler hdl) throws ConfigurationException {
        this.m_statistics[2] = this.m_statistics[2] + 1L;
        if (mode == 0) {
            Environment.getInstance().getLogging().trace(2, "", "open for READ configuration " + path);
            this.m_statistics[4] = this.m_statistics[4] + 1L;
            return new ReadAccessConfiguration(this.getCachedConfiguration(path), hdl, null);
        }
        if (mode == 1) {
            Environment.getInstance().getLogging().trace(2, "", "open for WRITE configuration " + path);
            try {
                Environment.getInstance().addLock(hdl.getId(), DEFAULT_AREA, path.getLockKey(), true, true);
                WriteAccessConfiguration cfg = new WriteAccessConfiguration(this.getCachedConfiguration(path).getDataCopy(), hdl, null);
                this.m_openforWriteConfigsInfo.put(path, new OpenConfigInfoImpl(cfg, 1, this.m_localClusterID, 1));
                this.m_statistics[3] = this.m_statistics[3] + 1L;
                return cfg;
            }
            catch (ConfigurationException e) {
                if (!(e instanceof ConfigurationLockedException)) {
                    Environment.getInstance().removeLock(hdl.getId(), DEFAULT_AREA, path.getLockKey(), true, true);
                } else {
                    this.m_statistics[5] = this.m_statistics[5] + 1L;
                    this.checkForDeadLock(path, (ConfigurationLockedException)e);
                }
                throw e;
            }
        }
        throw new ConfigurationException("kernel_1507", new Object[]{"openConfiguration()"});
    }

    private void checkForDeadLock(ConfigurationPath pathToOpen, ConfigurationLockedException cle) throws ConfigurationException {
        Thread currentThread = Thread.currentThread();
        TransactionInfo tInfo = null;
        tInfo = (TransactionInfo)this.m_inCommitThreads.get(currentThread);
        if (tInfo != null) {
            ConfigurationPath[] openConfigs = tInfo.getOpenConfigs();
            int i = 0;
            while (i < openConfigs.length) {
                if (pathToOpen.isArgumentSubTree(openConfigs[i]) || openConfigs[i].isArgumentSubTree(pathToOpen)) {
                    throw new ConfigurationException((Exception)((Object)cle), "kernel_1531", new Object[0]);
                }
                ++i;
            }
        }
    }

    public double getHitRate() {
        if (this.m_statistics[6] == 0L) {
            return 0.0;
        }
        double rate = (double)this.m_statistics[7] / (double)this.m_statistics[6];
        return rate * 100.0;
    }

    public String[] getCacheList() {
        return this.m_cache.listCache();
    }

    public void clearCache() throws ConfigurationException {
        this.m_cache.clearCache();
    }

    private void updateCacheHitStatistics(boolean cacheHit) {
        if (cacheHit) {
            this.m_statistics[7] = this.m_statistics[7] + 1L;
        }
        this.m_statistics[6] = this.m_statistics[6] + 1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CachedConfiguration getCachedConfiguration(ConfigurationPath path, Long cid) throws ConfigurationException {
        Object keyObj = path;
        if (cid != null) {
            keyObj = cid;
        }
        CachedConfiguration conf = null;
        boolean success = false;
        boolean gotFromCache = false;
        ConfigurationCache configurationCache = this;
        synchronized (configurationCache) {
            while (!success) {
                conf = this.m_cache.getFromCache(keyObj);
                if (conf != null) {
                    gotFromCache = conf.isDataAvailable();
                    success = true;
                    continue;
                }
                try {
                    conf = new CachedConfiguration(path, cid, this.m_persistenceHandler, this.m_accessController);
                    this.m_cache.putIntoCache(conf);
                    gotFromCache = false;
                    success = true;
                }
                catch (ConfigurationLockedException e) {
                    try {
                        Environment.getInstance().getLogging().traceThrowable(3, null, (Throwable)((Object)e));
                        this.wait(AccessController.waitForAccessTime);
                    }
                    catch (Exception ee) {
                        Environment.getInstance().getLogging().traceThrowable(3, null, ee);
                    }
                }
            }
        }
        this.updateCacheHitStatistics(gotFromCache);
        if (gotFromCache) {
            Environment.getInstance().getLogging().trace(2, "", "got configuration " + path + ", " + cid + " from cache");
            return conf;
        }
        Environment.getInstance().getLogging().trace(2, "", "got configuration " + path + ", " + cid + " from external storage");
        return conf;
    }

    public CachedConfiguration getCachedConfiguration(ConfigurationPath path) throws ConfigurationException {
        return this.getCachedConfiguration(path, null);
    }

    public FileLoader readPersistentFile(long cid, String name) throws ConfigurationException {
        return this.m_persistenceHandler.getFileLoader(cid, name);
    }

    private void processLocalBeforeCommit(int clusterId, TransactionInfo tInfo) {
        this.m_inCommitTransactions.put(tInfo.getTransId(), tInfo);
        this.m_accessController.beforeCommit(clusterId, tInfo.getTransId(), tInfo.getEvents());
    }

    private void processBeforeCommit(TransactionInfo tInfo) throws ConfigurationException {
        this.processLocalBeforeCommit(this.m_localClusterID, tInfo);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream zipout = new GZIPOutputStream(out);
            ObjectOutputStream objout = new ObjectOutputStream(zipout);
            tInfo.writeToStream(objout);
            objout.flush();
            objout.close();
            byte[] msg = out.toByteArray();
            Environment.getInstance().getLogging().trace(2, "", "Cache Invalidation message size is ", new Long(msg.length), " bytes");
            Environment.getInstance().send(2, msg, false);
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1508");
        }
    }

    private void processLocalAfterCommit(int clusterID, String id, int commitReturn, boolean local) {
        TransactionInfo tInfo = (TransactionInfo)this.m_inCommitTransactions.remove(id);
        if (tInfo == null) {
            return;
        }
        if (commitReturn >= 0) {
            ConfigurationCache configurationCache = this;
            synchronized (configurationCache) {
                long timeStamp = SequenceGenerator.getNext();
                ChangeEvent[] events = tInfo.getEvents();
                int i = 0;
                while (i < events.length) {
                    ChangeEventImpl event = (ChangeEventImpl)events[i];
                    Long cid = new Long(event.getConfigID());
                    CachedConfiguration cached = this.m_cache.getFromCache(cid);
                    if (event.getAction() == 0 && cached != null) {
                        cached.invalidateEntry(timeStamp);
                    } else if (event.getAction() == 3 && cached != null) {
                        cached.invalidateEntry(Long.MIN_VALUE);
                    } else if (event.getAction() == 2) {
                        this.m_cache.invalidateAndRemoveAllCachedSubnodes(event.getPathWrapper(), timeStamp);
                    }
                    ++i;
                }
                if (local) {
                    this.reuseLocallyChangedConfigurationData(events);
                }
            }
        }
        this.m_accessController.afterCommit(clusterID, id);
        if (commitReturn >= 0) {
            ChangeEvent[] events = tInfo.getEvents();
            Thread currentThread = Thread.currentThread();
            this.m_inCommitThreads.put(currentThread, tInfo);
            if (events != null) {
                this.processEventListeners(events);
            }
            this.m_inCommitThreads.remove(currentThread);
        }
    }

    private void processAfterCommit(String id, int commitReturn) throws ConfigurationException {
        this.processLocalAfterCommit(this.m_localClusterID, id, commitReturn, true);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objout = new ObjectOutputStream(out);
            objout.writeUTF(id);
            objout.writeInt(commitReturn);
            objout.flush();
            objout.close();
            byte[] msg = out.toByteArray();
            Environment.getInstance().send(1, msg, false);
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1509");
        }
    }

    private synchronized void reuseLocallyChangedConfigurationData(ChangeEvent[] events) {
        long timeStamp = SequenceGenerator.getNext();
        int i = 0;
        while (i < events.length) {
            ChangeEventImpl event = (ChangeEventImpl)events[i];
            Long cid = new Long(event.getConfigID());
            CachedConfiguration cached = this.m_cache.getFromCache(cid);
            if (event.getAction() == 1) {
                this.m_cache.putIntoCache(new CachedConfiguration((ConfigurationData)event.getData().clone(), this.m_persistenceHandler, this.m_accessController));
            } else if (event.getAction() == 0 && cached != null && event.getData() != null) {
                cached.invalidateEntry(Long.MIN_VALUE, (ConfigurationData)event.getData().clone());
            } else if (event.getAction() == 3 && cached != null && event.getData() != null) {
                cached.invalidateEntry(Long.MIN_VALUE, (ConfigurationData)event.getData().clone());
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    public void commitConfigurationHandler(ConfigurationHandlerImpl hdl) throws ConfigurationException {
        long countCfgs;
        long startTime;
        block39: {
            startTime = System.currentTimeMillis();
            countCfgs = 0L;
            UpdateProcessor update = null;
            Vector<ChangeEventImpl> changeEvents = new Vector<ChangeEventImpl>();
            Vector<ConfigurationData> allChangedData = new Vector<ConfigurationData>();
            Configuration[] openConfigs = hdl.getAllOpenForWriteRoots();
            String[] lockKeys = new String[openConfigs.length];
            HashSet<ConfigurationPath> nonExclusiveModify = new HashSet<ConfigurationPath>();
            if (openConfigs.length == 0) {
                return;
            }
            try {
                int i = 0;
                while (i < openConfigs.length) {
                    ConfigurationData[] accessedData = hdl.getAllAccessedSubConfigData(openConfigs[i]);
                    lockKeys[i] = ((ConfigurationImpl)openConfigs[i]).getPathWrapper().getLockKey();
                    int ii = 0;
                    while (ii < accessedData.length) {
                        ++countCfgs;
                        ConfigurationData data = accessedData[ii];
                        if (data.isCreated() || data.isModified() || data.isDeleted() || data.isCacheModeChanged()) {
                            ChangeEventImpl implicitModify;
                            allChangedData.addElement(data);
                            int action = -1;
                            ConfigurationPath path = data.getPath();
                            if (data.isCreated()) {
                                action = 1;
                                changeEvents.addElement(new ChangeEventImpl(data.getCID(), action, path, data));
                                if (data.getPath() == ((ConfigurationImpl)openConfigs[i]).getPathWrapper() && data.getParentCID() != ConfigurationData.ROOT_ID) {
                                    implicitModify = new ChangeEventImpl(data.getParentCID(), 0, path.getParrentPath());
                                    implicitModify.setExclusiveAccessAvailable(false);
                                    if (!nonExclusiveModify.contains(implicitModify.getPathWrapper())) {
                                        changeEvents.addElement(implicitModify);
                                        nonExclusiveModify.add(implicitModify.getPathWrapper());
                                    }
                                }
                            } else if (data.isModified()) {
                                action = 0;
                                changeEvents.addElement(new ChangeEventImpl(data.getCID(), action, path, data));
                                if (data.isCacheModeChanged() && data.getParentCID() != ConfigurationData.ROOT_ID) {
                                    changeEvents.addElement(new ChangeEventImpl(data.getParentCID(), 3, path.getParrentPath()));
                                }
                            } else if (data.isDeleted()) {
                                action = 2;
                                changeEvents.addElement(new ChangeEventImpl(data.getCID(), action, path));
                                if (data.getParentCID() != ConfigurationData.ROOT_ID) {
                                    implicitModify = new ChangeEventImpl(data.getParentCID(), 0, path.getParrentPath());
                                    implicitModify.setExclusiveAccessAvailable(false);
                                    if (!nonExclusiveModify.contains(implicitModify.getPathWrapper())) {
                                        changeEvents.addElement(implicitModify);
                                        nonExclusiveModify.add(implicitModify.getPathWrapper());
                                    }
                                }
                            } else if (data.isCacheModeChanged()) {
                                changeEvents.addElement(new ChangeEventImpl(data.getCID(), 3, path, data));
                                if (data.getParentCID() != ConfigurationData.ROOT_ID) {
                                    changeEvents.addElement(new ChangeEventImpl(data.getParentCID(), 3, path.getParrentPath()));
                                }
                            }
                            if (!data.isDeleted()) {
                                ConfigMetaDataImpl[] allDeletedSubs = data.getAllDeleted().toArray(new ConfigMetaDataImpl[0]);
                                int iii = 0;
                                while (iii < allDeletedSubs.length) {
                                    ConfigMetaDataImpl deletedSub = allDeletedSubs[iii];
                                    changeEvents.addElement(new ChangeEventImpl(deletedSub.getCID(), 2, path.getSubConfigurationPath(deletedSub.getName())));
                                    ++iii;
                                }
                            }
                        }
                        ++ii;
                    }
                    ++i;
                }
            }
            catch (ConfigurationException e) {
                Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e));
                throw e;
            }
            Object[] events = new ChangeEvent[changeEvents.size()];
            changeEvents.copyInto(events);
            int commitReturn = -1;
            this.getInternalEnqueueLock(lockKeys, true, true, true);
            this.processBeforeCommit(new TransactionInfo(hdl.getTransactionId(), (ChangeEvent[])events, openConfigs));
            update = this.m_persistenceHandler.getUpdateProcessor(hdl.getTransactionId());
            Iterator changedDataIterator = ((AbstractList)allChangedData).iterator();
            int i = 0;
            while (i < allChangedData.size()) {
                ConfigurationData data = (ConfigurationData)changedDataIterator.next();
                update.updateConfig(data);
                ++i;
            }
            update.flush();
            update.commitUpdate();
            commitReturn = 0;
            changedDataIterator = ((AbstractList)allChangedData).iterator();
            int i2 = 0;
            while (i2 < allChangedData.size()) {
                ((ConfigurationData)changedDataIterator.next()).resetDeltas();
                ++i2;
            }
            int i3 = 0;
            while (i3 < events.length) {
                Environment.getInstance().getLogging().trace(1, "", events[i3].toString());
                ++i3;
            }
            Object var22_31 = null;
            try {
                this.processAfterCommit(hdl.getTransactionId(), commitReturn);
            }
            catch (ConfigurationException e) {
                Environment.getInstance().getLogging().log((byte)5, "process after commit failed - maybe hanging internal locks must be removed manually");
                Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e));
            }
            try {
                this.releaseInternalEnqueueLock(lockKeys, true, true);
            }
            catch (ConfigurationException e) {
                Environment.getInstance().getLogging().log((byte)6, "unlock failed ! There might be locks hanging which must be removed manually !!!");
                Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e), (byte)6);
            }
            break block39;
            {
                catch (ConfigurationException e) {
                    Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e));
                    if (update != null) {
                        try {
                            update.rollbackUpdate();
                        }
                        catch (Exception ignore) {
                            Environment.getInstance().getLogging().traceThrowable(3, ignore.getMessage(), ignore);
                        }
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var22_32 = null;
                try {
                    this.processAfterCommit(hdl.getTransactionId(), commitReturn);
                }
                catch (ConfigurationException e) {
                    Environment.getInstance().getLogging().log((byte)5, "process after commit failed - maybe hanging internal locks must be removed manually");
                    Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e));
                }
                try {
                    this.releaseInternalEnqueueLock(lockKeys, true, true);
                }
                catch (ConfigurationException e) {
                    Environment.getInstance().getLogging().log((byte)6, "unlock failed ! There might be locks hanging which must be removed manually !!!");
                    Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e), (byte)6);
                }
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        this.m_statistics[0] = this.m_statistics[0] + (endTime - startTime);
        this.m_statistics[1] = this.m_statistics[1] + 1L;
        if (this.m_isCommitTraceEnabled) {
            this.traceCommit(endTime - startTime, countCfgs);
        }
    }

    public void releaseConfiguration(Configuration config, ConfigurationHandler hdl) throws ConfigurationException {
        if (config instanceof WriteAccessConfiguration) {
            Environment.getInstance().getLogging().trace(2, "", "release open for WRITE configuration " + config);
            ConfigurationPath path = ((WriteAccessConfiguration)config).getPathWrapper();
            Environment.getInstance().removeLock(hdl.getId(), DEFAULT_AREA, path.getLockKey(), true, true);
            this.m_openforWriteConfigsInfo.remove(path);
        } else {
            Environment.getInstance().getLogging().trace(2, "", "release open for READ configuration " + config);
        }
    }

    public long[] getMonitoringStatistics() {
        return this.m_statistics;
    }

    public void setCommitTrace(boolean isCommitTraceEnabled) {
        if (!isCommitTraceEnabled) {
            this.m_commitInfos = new HashMap();
        }
        this.m_isCommitTraceEnabled = isCommitTraceEnabled;
    }

    public boolean isCommitTraceEnabled() {
        return this.m_isCommitTraceEnabled;
    }

    public HashMap getCommitInfos() {
        return this.m_commitInfos;
    }

    private void traceCommit(long separateCommitTime, long countCfgs) {
        int numberOfLine = 0;
        String line = "";
        String exceptionString = Utils.getStackTrace(new Exception());
        BufferedReader bf = new BufferedReader(new StringReader(exceptionString));
        try {
            while ((line = bf.readLine()) != null) {
                if (numberOfLine++ != 4) continue;
                line = line.substring(3).trim();
                HashMap hashMap = this.m_commitInfos;
                synchronized (hashMap) {
                    if (!this.m_commitInfos.containsKey(line)) {
                        this.m_commitInfos.put(line, new Object[]{new Long(1L), new Long(separateCommitTime), new Long(countCfgs)});
                    } else {
                        Object[] temp = (Object[])this.m_commitInfos.get(line);
                        temp[0] = new Long((Long)temp[0] + 1L);
                        temp[1] = new Long((Long)temp[1] + separateCommitTime);
                        temp[2] = new Long((Long)temp[2] + countCfgs);
                    }
                }
                return;
            }
        }
        catch (IOException e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
            this.m_commitInfos.put("<IOException while reading line from BufferedReader>", new Object[]{new Long(0L), new Long(0L), new Long(0L)});
        }
    }
}

