/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.cache;

import com.sap.engine.core.configuration.impl.cache.CachedConfiguration;
import com.sap.engine.core.configuration.impl.cache.ConfigurationCache;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.SimpleSortedSet;
import com.sap.engine.lib.util.cache.Cache;
import com.sap.engine.lib.util.cache.CacheGroup;
import com.sap.engine.lib.util.cache.CacheListener;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;

public class CachedConfigurationHolder
implements CacheListener {
    private Cache m_cache;
    private SimpleSortedSet m_pathKeys = new SimpleSortedSet(ConfigurationPath.getComparator());

    public void init(CacheGroup group) {
        this.m_cache = new Cache(0, ConfigurationCache.MAX_CACHED_CONFIGURATIONS, group);
        this.m_cache.registerCacheListener((CacheListener)this);
    }

    public synchronized void removedByGarbageCollector(Object key) {
        if (key instanceof ConfigurationPath) {
            this.m_pathKeys.remove(key);
        }
    }

    public synchronized void putIntoCache(CachedConfiguration value) {
        if ((value.getInitialCacheMode() & 8) == 8) {
            this.m_cache.addCache((Object)new Long(value.getId()), (Object)value);
            this.m_cache.addCache((Object)value.getPath(), (Object)value);
        } else {
            this.m_cache.addToWeakCache((Object)new Long(value.getId()), (Object)value);
            this.m_cache.addToWeakCache((Object)value.getPath(), (Object)value);
        }
        this.m_pathKeys.add(value.getPath());
    }

    public synchronized CachedConfiguration getFromCache(Object key) {
        return (CachedConfiguration)this.m_cache.getByKey(key);
    }

    public synchronized void removeFromCache(CachedConfiguration value) {
        this.m_cache.remove((Object)new Long(value.getId()));
        this.m_cache.remove((Object)value.getPath());
        this.m_pathKeys.remove(value.getPath());
    }

    public synchronized void invalidateAndRemoveAllCachedSubnodes(ConfigurationPath path, long timeStamp) {
        ConfigurationPath nextPath = ConfigurationPath.getConfigurationPath(path.getPathString() + '\u0000');
        SortedSet subNodes = this.m_pathKeys.subSet(path, nextPath);
        Iterator it = subNodes.iterator();
        while (it.hasNext()) {
            CachedConfiguration cached = this.getFromCache(it.next());
            if (cached == null) continue;
            cached.invalidateEntry(timeStamp);
            this.m_cache.remove((Object)new Long(cached.getId()));
            this.m_cache.remove((Object)cached.getPath());
        }
        subNodes.clear();
    }

    public synchronized String[] listCache() {
        Iterator allValues = this.m_cache.valueIterator();
        SimpleSortedSet allKeys = new SimpleSortedSet(ConfigurationPath.getComparator());
        while (allValues.hasNext()) {
            CachedConfiguration value = (CachedConfiguration)allValues.next();
            if (value == null || !value.isDataAvailable()) continue;
            allKeys.add(value.getPath());
        }
        String[] result = new String[allKeys.size()];
        Vector v = new Vector(allKeys);
        int i = 0;
        while (i < allKeys.size()) {
            result[i] = v.elementAt(i).toString();
            ++i;
        }
        return result;
    }

    public void clearCache() {
        CachedConfigurationHolder cachedConfigurationHolder = this;
        synchronized (cachedConfigurationHolder) {
            Iterator allValuesIterator = this.m_cache.valueIterator();
            Vector allValues = new Vector();
            while (allValuesIterator.hasNext()) {
                allValues.add(allValuesIterator.next());
            }
            int i = 0;
            while (i < allValues.size()) {
                CachedConfiguration cached = (CachedConfiguration)allValues.elementAt(i);
                if (cached != null) {
                    cached.invalidateEntry(Long.MIN_VALUE);
                    this.removeFromCache(cached);
                    this.m_cache.addToWeakCache((Object)new Long(cached.getId()), (Object)cached);
                    this.m_cache.addToWeakCache((Object)cached.getPath(), (Object)cached);
                    this.m_pathKeys.add(cached.getPath());
                }
                ++i;
            }
        }
    }
}

