/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.cache;

import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ConfigurationDataCacheEntryImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.cache.AccessController;
import com.sap.engine.core.configuration.impl.persistence.rdbms.PersistenceHandler;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.Semaphore;
import com.sap.engine.core.configuration.impl.utilities.SequenceGenerator;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;

public class CachedConfiguration {
    private long m_timeStamp;
    private ConfigurationPath m_path = null;
    private Semaphore m_semaphore;
    private int m_initialCacheMode;
    private ConfigurationData m_configData;
    private long m_configID;
    private PersistenceHandler m_persistenceHandler;
    private AccessController m_accessController;

    public CachedConfiguration(ConfigurationPath path, Long cid, PersistenceHandler persistenceHandler, AccessController accessController) throws ConfigurationException {
        this.m_persistenceHandler = persistenceHandler;
        this.m_accessController = accessController;
        this.m_path = path;
        this.m_accessController.getAccess(this.m_path);
        try {
            this.m_configData = cid != null ? this.m_persistenceHandler.readConfig(cid) : this.m_persistenceHandler.readConfig(path);
            this.m_initialCacheMode = this.m_configData.getCacheMode();
            this.m_configID = this.m_configData.getCID();
            Object var6_5 = null;
            this.m_accessController.releaseAccess(this.m_path);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.m_accessController.releaseAccess(this.m_path);
            throw throwable;
        }
        this.m_timeStamp = SequenceGenerator.getNext();
        this.m_semaphore = new Semaphore();
    }

    public CachedConfiguration(ConfigurationData data, PersistenceHandler persistenceHandler, AccessController accessController) {
        this.m_persistenceHandler = persistenceHandler;
        this.m_accessController = accessController;
        this.m_configID = data.getCID();
        this.m_configData = data;
        this.m_path = data.getPath();
        this.m_initialCacheMode = this.m_configData.getCacheMode();
        this.m_timeStamp = SequenceGenerator.getNext();
        this.m_semaphore = new Semaphore();
    }

    private void getSemaphoreLock(int type) {
        try {
            this.m_semaphore.getLock(type);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void releaseSemaphoreLock(int type) {
        try {
            this.m_semaphore.releaseLock(type);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void extendSemaphoreLock() {
        try {
            this.m_semaphore.extendToExclusive();
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void reduceSemaphoreLock() {
        try {
            this.m_semaphore.reduceToShared();
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    public long getId() {
        return this.m_configID;
    }

    public ConfigurationPath getPath() {
        return this.m_path;
    }

    public boolean isDataAvailable() {
        return this.m_configData != null;
    }

    private void getDataFromDB() throws ConfigurationException {
        this.m_accessController.getAccess(this.m_path);
        try {
            this.extendSemaphoreLock();
            if (this.m_configData != null) {
                Object var2_1 = null;
                this.reduceSemaphoreLock();
                this.m_accessController.releaseAccess(this.m_path);
                return;
            }
            this.m_configData = this.m_persistenceHandler.readConfig(this.m_configID);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.reduceSemaphoreLock();
            this.m_accessController.releaseAccess(this.m_path);
            throw throwable;
        }
        Object var2_2 = null;
        this.reduceSemaphoreLock();
        this.m_accessController.releaseAccess(this.m_path);
    }

    public void invalidateEntry(long timestamp) {
        this.invalidateEntry(timestamp, null);
    }

    public void invalidateEntry(long timestamp, ConfigurationData newData) {
        try {
            this.getSemaphoreLock(Semaphore.EXCLUSIVE);
            this.m_configData = newData;
            if (timestamp != Long.MIN_VALUE) {
                this.m_timeStamp = timestamp;
            }
            Object var5_3 = null;
            this.releaseSemaphoreLock(Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    private synchronized void sleep(int time) {
        try {
            this.wait(time);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationData prepareRead(long timeStamp) throws ConfigurationException {
        ConfigurationData configurationData;
        boolean success = false;
        try {
            while (true) {
                if (success) {
                    if (timeStamp >= this.m_timeStamp) break;
                    throw new InconsistentReadException("kernel_1650");
                }
                this.getSemaphoreLock(Semaphore.SHARED);
                if (timeStamp < this.m_timeStamp) {
                    throw new InconsistentReadException("kernel_1650", new Object[]{this.getPath().getPathString()});
                }
                if (this.m_configData == null) {
                    try {
                        this.getDataFromDB();
                        success = true;
                    }
                    catch (ConfigurationLockedException e) {
                        Environment.getInstance().getLogging().traceThrowable(3, e.getMessage(), (Throwable)((Object)e));
                        this.releaseSemaphoreLock(Semaphore.SHARED);
                        this.sleep(AccessController.waitForAccessTime);
                    }
                    continue;
                }
                success = true;
            }
            configurationData = this.m_configData;
            Object var6_5 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (!(this.m_configData instanceof ConfigurationDataCacheEntryImpl)) throw throwable;
            this.getAccess();
            throw throwable;
        }
        if (!(this.m_configData instanceof ConfigurationDataCacheEntryImpl)) return configurationData;
        this.getAccess();
        return configurationData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationData getDataCopy() throws ConfigurationException {
        ConfigurationData configurationData;
        boolean success = false;
        try {
            while (true) {
                if (success) {
                    configurationData = (ConfigurationData)this.m_configData.clone();
                    break;
                }
                this.getSemaphoreLock(Semaphore.SHARED);
                if (this.m_configData != null) {
                    ConfigurationData configurationData2 = (ConfigurationData)this.m_configData.clone();
                    Object var4_5 = null;
                    this.releaseSemaphoreLock(Semaphore.SHARED);
                    return configurationData2;
                }
                try {
                    this.getDataFromDB();
                    success = true;
                }
                catch (ConfigurationLockedException e) {
                    Environment.getInstance().getLogging().traceThrowable(3, e.getMessage(), (Throwable)((Object)e));
                    this.releaseSemaphoreLock(Semaphore.SHARED);
                    this.sleep(100);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            throw throwable;
        }
        Object var4_6 = null;
        this.releaseSemaphoreLock(Semaphore.SHARED);
        return configurationData;
    }

    public void releaseData(ConfigurationData data) {
        if (data instanceof ConfigurationDataCacheEntryImpl) {
            this.m_accessController.releaseAccess(this.m_path);
        }
    }

    public void getAccess() {
        this.m_accessController.getAccessAndWait(this.m_path);
    }

    public int getInitialCacheMode() {
        return this.m_initialCacheMode;
    }

    public void consistencyCheck(long timestamp) throws InconsistentReadException {
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            if (timestamp < this.m_timeStamp) {
                throw new InconsistentReadException("kernel_1650");
            }
            Object var4_2 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            throw throwable;
        }
    }
}

