/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.cache;

import com.sap.engine.core.configuration.impl.ChangeEventImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.cache.BlockingLockEntry;
import com.sap.engine.core.configuration.impl.cache.InCommitEntry;
import com.sap.engine.core.configuration.impl.cache.InternalLock;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.Counter;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.admin.BlockingLock;
import com.sap.engine.frame.core.configuration.admin.BlockingLockImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class AccessController {
    public static int waitForAccessTime = 100;
    private HashMap m_inAccessConfigurations = new HashMap();
    private HashMap m_inDeleteConfigurations = new HashMap();
    private HashMap m_inCommitEvents = new HashMap();
    private HashMap m_blockedReaders = new HashMap();

    private synchronized InCommitEntry getAccessInternal(ConfigurationPath path) {
        Object obj = this.m_inAccessConfigurations.get(path);
        InCommitEntry obj2 = null;
        if (obj instanceof InCommitEntry && this.performValidityCheck((InCommitEntry)obj) || (obj2 = this.isInDeleteCommit(path)) != null) {
            if (obj instanceof InCommitEntry) {
                Environment.getInstance().getLogging().trace(1, "getAccess(" + path + ") rejected because of " + obj, "");
                return (InCommitEntry)obj;
            }
            Environment.getInstance().getLogging().trace(1, "getAccess(" + path + ") rejected because of isInDeleteCommit() returns true", "");
            return obj2;
        }
        if (obj == null || obj instanceof InCommitEntry) {
            obj = new Counter();
            this.m_inAccessConfigurations.put(path, obj);
        }
        ((Counter)obj).inc();
        Environment.getInstance().getLogging().trace(2, "getAccess(" + path + ") succeded", "");
        return null;
    }

    protected void getAccess(ConfigurationPath path) throws ConfigurationLockedException {
        BlockingLockEntry blockingEntry = null;
        InCommitEntry lock = this.getAccessInternal(path);
        if (lock != null) {
            long timeStamp = System.currentTimeMillis();
            lock.addWaiter();
            HashMap hashMap = this.m_blockedReaders;
            synchronized (hashMap) {
                blockingEntry = (BlockingLockEntry)this.m_blockedReaders.get(path);
                if (blockingEntry == null) {
                    blockingEntry = new BlockingLockEntry(lock, path);
                    this.m_blockedReaders.put(path, blockingEntry);
                }
                blockingEntry.m_lock = lock;
                blockingEntry.m_timeStamp = timeStamp;
            }
            throw new ConfigurationLockedException("cannot access " + path + " because it's currently modified on the database.");
        }
        HashMap hashMap = this.m_blockedReaders;
        synchronized (hashMap) {
            this.m_blockedReaders.remove(path);
        }
    }

    protected synchronized void getAccessAndWait(ConfigurationPath path) {
        boolean success = false;
        while (!success) {
            try {
                this.getAccess(path);
                success = true;
            }
            catch (ConfigurationLockedException e) {
                Environment.getInstance().getLogging().traceThrowable(3, e.getMessage(), (Throwable)((Object)e));
                try {
                    this.wait(waitForAccessTime);
                }
                catch (Exception ee) {
                    Environment.getInstance().getLogging().traceThrowable(3, null, ee);
                }
            }
        }
    }

    protected synchronized void releaseAccess(ConfigurationPath path) {
        Object cnt = this.m_inAccessConfigurations.get(path);
        if (cnt == null || cnt instanceof InCommitEntry) {
            return;
        }
        ((Counter)cnt).dec();
        Environment.getInstance().getLogging().trace(2, "releaseAccess(" + path + ")", "");
        if (((Counter)cnt).value() <= 0) {
            this.m_inAccessConfigurations.remove(path);
            this.notifyAll();
        }
    }

    protected BlockingLock[] getBlockedReaders() {
        long timeStamp = System.currentTimeMillis();
        int clusterId = Environment.getInstance().getLocalClusterID();
        HashMap hashMap = this.m_blockedReaders;
        synchronized (hashMap) {
            Iterator allBlocked = this.m_blockedReaders.values().iterator();
            Vector<BlockingLockImpl> result = new Vector<BlockingLockImpl>();
            Vector<BlockingLockEntry> invalids = new Vector<BlockingLockEntry>();
            int i = 0;
            while (i < this.m_blockedReaders.size()) {
                BlockingLockEntry entry = (BlockingLockEntry)allBlocked.next();
                if (timeStamp - entry.m_timeStamp < (long)(2 * waitForAccessTime)) {
                    InternalLock[] locks = entry.m_lock.getAllLocks();
                    int ii = 0;
                    while (ii < locks.length) {
                        int time = (int)(timeStamp - locks[ii].m_timestamp) / 1000;
                        BlockingLockImpl blockingLock = new BlockingLockImpl(entry.m_path.getPathString(), 0, clusterId, time, locks[ii].getWaiterCount(), locks[ii].m_transactionID, locks[ii].m_clusterId);
                        result.add(blockingLock);
                        ++ii;
                    }
                } else {
                    invalids.add(entry);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < invalids.size()) {
                this.m_blockedReaders.remove(invalids.elementAt(i2));
                ++i2;
            }
            BlockingLock[] blockingLockArray = result.toArray(new BlockingLock[0]);
            return blockingLockArray;
        }
    }

    protected synchronized void resolveBlockingLock(BlockingLock lock) {
        Environment.getInstance().getLogging().log((byte)3, "Admin removed locks manually for " + lock);
        if (!this.removeInCommitLocks(((BlockingLockImpl)lock).getLockOwnerClusterID(), ((BlockingLockImpl)lock).getLockOwnerTransactionID())) {
            ConfigurationPath blockedPath = ConfigurationPath.getConfigurationPath(((BlockingLockImpl)lock).getBlockedConfigurationPath());
            InternalLock internalLock = null;
            HashMap hashMap = this.m_blockedReaders;
            synchronized (hashMap) {
                BlockingLockEntry blockingEntry = (BlockingLockEntry)this.m_blockedReaders.get(blockedPath);
                if (blockingEntry == null) {
                    Environment.getInstance().getLogging().log((byte)3, "Can not find any internal lock for " + lock);
                    return;
                }
                internalLock = blockingEntry.m_lock.getLockForTransactionId(((BlockingLockImpl)lock).getLockOwnerTransactionID());
                if (internalLock == null) {
                    Environment.getInstance().getLogging().log((byte)3, "Can not find any internal lock for " + lock);
                    return;
                }
                this.removeInvalidCommitLocks(internalLock.m_clusterId, internalLock.m_transactionID, internalLock.m_events);
            }
        }
    }

    protected synchronized void beforeCommit(int clusterID, String id, ChangeEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Environment.getInstance().getLogging().trace(2, "beforeCommit: Tx ID:" + id + ", " + events[i], "");
            ++i;
        }
        HashMap<String, ChangeEvent[]> inCommitEventsForClusterId = (HashMap<String, ChangeEvent[]>)this.m_inCommitEvents.get(new Integer(clusterID));
        if (inCommitEventsForClusterId == null) {
            inCommitEventsForClusterId = new HashMap<String, ChangeEvent[]>();
            this.m_inCommitEvents.put(new Integer(clusterID), inCommitEventsForClusterId);
        }
        InternalLock internalLock = new InternalLock(clusterID, id, events, System.currentTimeMillis());
        InCommitEntry inCommit = new InCommitEntry(internalLock, true);
        inCommitEventsForClusterId.put(id, events);
        int i2 = 0;
        while (i2 < events.length) {
            ChangeEventImpl event = (ChangeEventImpl)events[i2];
            Object existingLock = null;
            if (event.getAction() == 0 || event.getAction() == 1) {
                boolean waitForLock = true;
                while (waitForLock && this.m_inAccessConfigurations.containsKey(event.getPathWrapper())) {
                    existingLock = this.m_inAccessConfigurations.get(event.getPathWrapper());
                    if (existingLock instanceof InCommitEntry && existingLock != inCommit && event.isExclusiveAccessAvailable()) {
                        Environment.getInstance().getLogging().log((byte)3, "beforeCommit(" + clusterID + ", " + id + " ,ChangeEvent[]) detected inconsistent internal lockstate for " + event.getPathWrapper() + "\nlockentry found: " + existingLock + "\nlockentry to set: " + inCommit);
                        this.removeInvalidCommitLocks(existingLock);
                        continue;
                    }
                    if (existingLock == inCommit) {
                        System.out.println("XXX");
                        Environment.getInstance().getLogging().trace(2, "beforeCommit(" + clusterID + ", " + id + " ,ChangeEvent[]) modify/create access already available for " + event.getPathWrapper(), "");
                        waitForLock = false;
                        continue;
                    }
                    if (existingLock instanceof InCommitEntry && !event.isExclusiveAccessAvailable()) {
                        waitForLock = false;
                        continue;
                    }
                    try {
                        Environment.getInstance().getLogging().trace(2, "beforeCommit(" + clusterID + ", " + id + " ,ChangeEvent[]) waiting for modify/create access for " + event.getPathWrapper(), "");
                        this.wait();
                        existingLock = null;
                    }
                    catch (Exception e) {
                        Environment.getInstance().getLogging().traceThrowable(3, null, e);
                    }
                }
            } else if (event.getAction() == 2) {
                while (this.isReaderOnSubNode(event.getPathWrapper())) {
                    try {
                        Environment.getInstance().getLogging().trace(2, "beforeCommit(" + clusterID + ", " + id + " ,ChangeEvent[]) waiting for delete access for " + event.getPathWrapper(), "");
                        this.wait();
                    }
                    catch (Exception e) {
                        Environment.getInstance().getLogging().traceThrowable(3, null, e);
                    }
                }
            }
            if (event.getAction() == 0 || event.getAction() == 1) {
                if (event.isExclusiveAccessAvailable()) {
                    this.m_inAccessConfigurations.put(event.getPathWrapper(), inCommit);
                } else if (existingLock != null) {
                    ((InCommitEntry)existingLock).addSharedLock(internalLock);
                } else {
                    this.m_inAccessConfigurations.put(event.getPathWrapper(), new InCommitEntry(internalLock, false));
                }
                Environment.getInstance().getLogging().trace(2, "beforeCommit(" + clusterID + ", " + id + ", ChangeEvent[]) got modify/create access for " + event.getPathWrapper(), "");
            } else if (event.getAction() == 2) {
                this.addToDeleteInCommit(event.getPathWrapper(), inCommit);
                Environment.getInstance().getLogging().trace(2, "beforeCommit(" + clusterID + ", " + id + ", ChangeEvent[]) got delete access for " + event.getPathWrapper(), "");
            }
            ++i2;
        }
    }

    protected synchronized void afterCommit(int clusterID, String id) {
        this.removeInCommitLocks(clusterID, id);
        Environment.getInstance().getLogging().trace(2, "afterCommit(" + clusterID + ", " + id + ") succeeded", "");
    }

    protected synchronized void removeAllInCommitLocksForClusterNode(int clusterID) {
        HashMap inCommitEventsForClusterId = (HashMap)this.m_inCommitEvents.get(new Integer(clusterID));
        if (inCommitEventsForClusterId == null) {
            return;
        }
        String[] allIdsForClusterNode = inCommitEventsForClusterId.keySet().toArray(new String[0]);
        int i = 0;
        while (i < allIdsForClusterNode.length) {
            this.removeInCommitLocks(clusterID, allIdsForClusterNode[i]);
            ++i;
        }
        Environment.getInstance().getLogging().trace(2, "removeAllInCommitLocksForClusterNode(" + clusterID + ") succeeded", "");
    }

    private boolean performValidityCheck(InCommitEntry lockEntry) {
        InternalLock[] internalLocks = lockEntry.getAllLocks();
        boolean returnVal = false;
        int i = 0;
        while (i < internalLocks.length) {
            Object events = null;
            HashMap inCommitEventsForClusterId = (HashMap)this.m_inCommitEvents.get(new Integer(internalLocks[i].m_clusterId));
            if (inCommitEventsForClusterId != null) {
                events = inCommitEventsForClusterId.get(internalLocks[i].m_transactionID);
            }
            if (events == null) {
                Environment.getInstance().getLogging().log((byte)3, "performValidityCheck detected inconsistent internal lockstate for " + lockEntry);
                this.removeInvalidCommitLocks(internalLocks[i].m_clusterId, internalLocks[i].m_transactionID, internalLocks[i].m_events);
            } else {
                returnVal = true;
            }
            ++i;
        }
        return returnVal;
    }

    private InCommitEntry isInDeleteCommit(ConfigurationPath path) {
        Iterator it = this.m_inDeleteConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ConfigurationPath delPath = (ConfigurationPath)it.next();
            if (delPath.length() > path.length() || !delPath.isArgumentSubTree(path)) continue;
            InCommitEntry obj = (InCommitEntry)this.m_inDeleteConfigurations.get(delPath);
            this.performValidityCheck(obj);
            Environment.getInstance().getLogging().trace(2, "isInDeleteCommit is true. Checked for path:" + path + ", collision with path " + delPath + " with " + obj, "");
            return obj;
        }
        return null;
    }

    private void addToDeleteInCommit(ConfigurationPath path, InCommitEntry entry) {
        InCommitEntry obj = (InCommitEntry)this.m_inDeleteConfigurations.get(path);
        if (obj != null) {
            Environment.getInstance().getLogging().log((byte)3, "AccessController.addToDeleteInCommit: detected inconsistent internal lockstate for " + path + "\nlockentry found: " + obj + "\nlockentry to set: " + entry);
            this.removeInvalidCommitLocks(obj);
        }
        this.m_inDeleteConfigurations.put(path, entry);
    }

    private void removeFromDeleteInCommit(ConfigurationPath path) {
        this.m_inDeleteConfigurations.remove(path);
    }

    private boolean isReaderOnSubNode(ConfigurationPath path) {
        Iterator it = this.m_inAccessConfigurations.keySet().iterator();
        while (it.hasNext()) {
            ConfigurationPath accessedPath = (ConfigurationPath)it.next();
            if (!path.isArgumentSubTree(accessedPath) || this.m_inAccessConfigurations.get(accessedPath) instanceof InCommitEntry) continue;
            return true;
        }
        return false;
    }

    private void removeInvalidCommitLocks(InCommitEntry entry) {
        InternalLock[] locks = entry.getAllLocks();
        int i = 0;
        while (i < locks.length) {
            this.removeInvalidCommitLocks(locks[i].m_clusterId, locks[i].m_transactionID, locks[i].m_events);
            ++i;
        }
    }

    private void removeInvalidCommitLocks(int clusterID, String id, ChangeEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object obj;
            ChangeEventImpl event = (ChangeEventImpl)events[i];
            if (event.getAction() == 0 || event.getAction() == 1) {
                obj = this.m_inAccessConfigurations.get(event.getPathWrapper());
                if (obj instanceof InCommitEntry) {
                    if (((InCommitEntry)obj).exclusive && ((InCommitEntry)obj).exclusiveLock.m_events == events) {
                        this.m_inAccessConfigurations.remove(event.getPathWrapper());
                    } else if (!((InCommitEntry)obj).exclusive) {
                        ((InCommitEntry)obj).removeSharedLock(id);
                        if (((InCommitEntry)obj).getSharedLockCount() == 0) {
                            this.m_inAccessConfigurations.remove(event.getPathWrapper());
                        }
                    }
                }
            } else if (event.getAction() == 2 && (obj = (InCommitEntry)this.m_inDeleteConfigurations.get(event.getPathWrapper())) != null && ((InCommitEntry)obj).exclusiveLock.m_events == events) {
                this.m_inDeleteConfigurations.remove(event.getPathWrapper());
            }
            ++i;
        }
        HashMap inCommitEventsForClusterId = (HashMap)this.m_inCommitEvents.get(new Integer(clusterID));
        if (inCommitEventsForClusterId != null) {
            inCommitEventsForClusterId.remove(id);
        }
        this.notifyAll();
    }

    private boolean removeInCommitLocks(int clusterID, String id) {
        HashMap inCommitEventsForClusterId = (HashMap)this.m_inCommitEvents.get(new Integer(clusterID));
        if (inCommitEventsForClusterId == null) {
            return false;
        }
        ChangeEvent[] events = (ChangeEvent[])inCommitEventsForClusterId.get(id);
        if (events == null) {
            return false;
        }
        Environment.getInstance().getLogging().trace(2, "removeInCommitLocks for clusterID: " + clusterID + ", handlerID: " + id, "");
        int i = 0;
        while (i < events.length) {
            ChangeEventImpl event = (ChangeEventImpl)events[i];
            if (event.getAction() == 0 || event.getAction() == 1) {
                if (event.isExclusiveAccessAvailable()) {
                    this.m_inAccessConfigurations.remove(event.getPathWrapper());
                } else {
                    Object obj = this.m_inAccessConfigurations.get(event.getPathWrapper());
                    if (obj instanceof InCommitEntry) {
                        ((InCommitEntry)obj).removeSharedLock(id);
                        if (((InCommitEntry)obj).getSharedLockCount() == 0) {
                            this.m_inAccessConfigurations.remove(event.getPathWrapper());
                        }
                    }
                }
            } else if (event.getAction() == 2) {
                this.removeFromDeleteInCommit(event.getPathWrapper());
            }
            ++i;
        }
        inCommitEventsForClusterId.remove(id);
        if (inCommitEventsForClusterId.size() == 0) {
            this.m_inCommitEvents.remove(new Integer(clusterID));
        }
        this.notifyAll();
        return true;
    }
}

