/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.admin;

import com.sap.engine.core.configuration.impl.admin.ConfigManagementInterfaceImpl;
import com.sap.engine.core.configuration.impl.cache.ConfigurationCache;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.admin.BlockingLock;
import com.sap.engine.frame.core.configuration.admin.ConfigManagementInterface;
import com.sap.engine.frame.core.configuration.admin.Controller;
import com.sap.engine.frame.core.configuration.admin.OpenConfigInfo;
import java.util.HashMap;

public class ControllerImpl
implements Controller {
    private ConfigurationCache m_cache;
    private ConfigManagementInterface m_mngConfigInterface = null;

    public ControllerImpl(ConfigurationCache cache) {
        this.m_cache = cache;
        this.m_mngConfigInterface = new ConfigManagementInterfaceImpl(this.m_cache);
    }

    public OpenConfigInfo[] getOpenConfigurationInfo() throws ConfigurationException {
        return this.m_cache.getOpenConfigurationInfo(-1);
    }

    public OpenConfigInfo[] getOpenConfigurationInfo(int clusterNode) throws ConfigurationException {
        return this.m_cache.getOpenConfigurationInfo(clusterNode);
    }

    public BlockingLock[] getBlockingLockInfo() throws ConfigurationException {
        return this.m_cache.getBlockingLockInfo(-1);
    }

    public BlockingLock[] getBlockingLockInfo(int clusterNode) throws ConfigurationException {
        return this.m_cache.getBlockingLockInfo(clusterNode);
    }

    public void forceToCloseConfiguration(OpenConfigInfo cfg) throws ConfigurationException {
        this.m_cache.forceCloseConfiguration(cfg);
    }

    public void removeBlockingLock(BlockingLock lock) throws ConfigurationException {
        this.m_cache.forceReleaseAccessControllerLocks(lock);
    }

    public String[] listCache() throws ConfigurationException {
        return this.m_cache.getCacheList();
    }

    public void clearCache() throws ConfigurationException {
        this.m_cache.clearCache();
    }

    public double getCacheHitRate() throws ConfigurationException {
        return this.m_cache.getHitRate();
    }

    public int[] getDBPoolStatistics() throws ConfigurationException {
        return this.m_cache.getDBPoolStatistics();
    }

    public ConfigManagementInterface getConfigManagementInterface() {
        return this.m_mngConfigInterface;
    }

    public void setCommitTrace(boolean isCommitTraceEnabled) {
        this.m_cache.setCommitTrace(isCommitTraceEnabled);
    }

    public HashMap getCommitInfos() {
        return this.m_cache.getCommitInfos();
    }

    public boolean isCommitTraceEnabled() {
        return this.m_cache.isCommitTraceEnabled();
    }
}

