/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.addons.hashindex;

import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.lib.io.hash.InDepthIterator;
import com.sap.engine.lib.io.hash.Index;
import java.io.IOException;

public class ConfigurationInDepthIterator
implements InDepthIterator {
    private Configuration folder = null;
    private ConfigMetaData folderProps = null;

    public ConfigurationInDepthIterator(Configuration c) throws IOException {
        this.folder = c;
        try {
            this.folderProps = c.getMetaData();
            if (!c.isValid()) {
                throw new IOException("Configuration [" + this.folderProps.getName() + "] does not exists.");
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void addEntries(Index targetIndex) throws IOException {
        try {
            this.addFileEntries(targetIndex);
            this.addSubCfgEntries(targetIndex);
        }
        catch (ConfigurationException e) {
            throw new IOException("Error reading Cofiguration [" + this.folderProps.getName() + "]: " + e.getMessage());
        }
    }

    private void addSubCfgEntries(Index targetIndex) throws IOException, ConfigurationException {
        ConfigMetaData[] cfgs = this.folder.getAllSubConfigurationMetaData();
        int i = 0;
        while (i < cfgs.length) {
            String workCfgName = cfgs[i].getName();
            if (cfgs[i].getConfigurationType() == 0) {
                targetIndex.addFolder(new ConfigurationInDepthIterator(this.folder.getSubConfiguration(workCfgName)));
            }
            ++i;
        }
    }

    private void addFileEntries(Index targetIndex) throws ConfigurationException, IOException {
        String[] fileNames = this.folder.getAllFileEntryNames();
        int i = 0;
        while (i < fileNames.length) {
            targetIndex.addFile(fileNames[i], this.folder.getFile(fileNames[i]), true);
            ++i;
        }
    }

    public String getName() {
        return this.folderProps.getName();
    }
}

