/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.addons;

import com.sap.engine.core.configuration.impl.WriteAccessConfiguration;
import com.sap.engine.core.configuration.impl.addons.PropertyEntryImpl;
import com.sap.engine.core.configuration.impl.addons.PropertyName;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.admin.PropertySheetEntry;
import com.sap.engine.frame.core.configuration.admin.PropertySheetExtension;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PropertySheetImpl
implements PropertySheetExtension {
    private Configuration m_config;
    private boolean m_writeMode = false;
    private Hashtable m_entries;

    public PropertySheetImpl(Configuration config) throws ConfigurationException {
        if (config.getMetaData().getConfigurationType() != 1) {
            throw new ConfigurationException("kernel_1519");
        }
        if (config instanceof WriteAccessConfiguration) {
            this.m_writeMode = true;
        } else {
            this.m_entries = new Hashtable();
        }
        Map values = config.getAllConfigEntries();
        Map files = config.getAllFileEntries();
        values.putAll(files);
        Iterator iter = values.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PropertyName pname = new PropertyName(name);
            if (pname.isCustomValue()) {
                if (!values.containsKey(pname.getDefaultName())) {
                    throw new ConfigurationException("kernel_1520");
                }
            } else if (!(pname.isDefaultValue() || pname.isDescriptionValue() || pname.isFlagsValue())) {
                throw new ConfigurationException("kernel_1529");
            }
            if (this.m_writeMode || this.m_entries.containsKey(pname.getName())) continue;
            this.m_entries.put(pname.getName(), PropertyEntryImpl.readPropertyEntry(pname.getName(), config));
        }
        this.m_config = config;
    }

    public PropertyEntry[] getAllPropertyEntries() throws ConfigurationException {
        if (!this.m_writeMode) {
            return this.m_entries.values().toArray(new PropertyEntry[this.m_entries.size()]);
        }
        Vector<PropertyEntry> result = new Vector<PropertyEntry>();
        Map values = this.m_config.getAllConfigEntries();
        Map files = this.m_config.getAllFileEntries();
        values.putAll(files);
        Iterator iter = values.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PropertyName pname = new PropertyName(name);
            if (!pname.isDefaultValue()) continue;
            try {
                result.add(PropertyEntryImpl.readPropertyEntry(pname.getName(), this.m_config));
            }
            catch (NameNotFoundException nn) {
                throw new ConfigurationException("kernel_1520");
            }
        }
        return result.toArray(new PropertyEntry[result.size()]);
    }

    public Properties getProperties() throws ConfigurationException {
        PropertyEntry[] entries = this.getAllPropertyEntries();
        Properties result = new Properties();
        int i = 0;
        while (i < entries.length) {
            result.setProperty(entries[i].getName(), entries[i].getValue().toString());
            ++i;
        }
        return result;
    }

    public Map getPropertyMap() throws ConfigurationException {
        PropertyEntry[] entries = this.getAllPropertyEntries();
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (i < entries.length) {
            result.put(entries[i].getName(), entries[i].getValue());
            ++i;
        }
        return result;
    }

    public PropertyEntry getPropertyEntry(String name) throws ConfigurationException, NameNotFoundException {
        PropertyEntry result = null;
        if (!this.m_writeMode) {
            result = (PropertyEntry)this.m_entries.get(name);
            if (result == null) {
                throw new NameNotFoundException("kernel_1603", new Object[]{name, this.m_config.getPath()});
            }
        } else {
            result = PropertyEntryImpl.readPropertyEntry(name, this.m_config);
        }
        return result;
    }

    public PropertyEntry createPropertyEntry(String name, Object defaultValue, String description) throws ConfigurationException, NameAlreadyExistsException {
        return this.createPropertyEntry(name, defaultValue, description, 0);
    }

    private PropertyEntry createPropertyEntry(String name, Object defaultValue, String description, int flags) throws ConfigurationException, NameAlreadyExistsException {
        PropertyEntry result = PropertyEntryImpl.createPropertyEntry(name, defaultValue, description, flags, this.m_config);
        return result;
    }

    public void createPropertyEntries(Properties properties) throws ConfigurationException, NameAlreadyExistsException {
        Iterator iter = ((Hashtable)properties).keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PropertyEntryImpl.createPropertyEntry(name, properties.getProperty(name), null, 0, this.m_config);
        }
    }

    public void deletePropertyEntry(String name) throws ConfigurationException {
        PropertyName pname = new PropertyName(name);
        if (this.m_config.existsConfigEntry(pname.getDefaultName())) {
            this.m_config.deleteConfigEntry(pname.getDefaultName());
        } else {
            this.m_config.deleteFile(pname.getDefaultName());
        }
        if (this.m_config.existsConfigEntry(pname.getCustomName())) {
            this.m_config.deleteConfigEntry(pname.getCustomName());
        }
        if (this.m_config.existsFile(pname.getCustomName())) {
            this.m_config.deleteFile(pname.getCustomName());
        }
        if (this.m_config.existsConfigEntry(pname.getDescriptionName())) {
            this.m_config.deleteConfigEntry(pname.getDescriptionName());
        }
        if (this.m_config.existsConfigEntry(pname.getFlagsName())) {
            this.m_config.deleteConfigEntry(pname.getFlagsName());
        }
    }

    public void deleteAllPropertyEntries() throws ConfigurationException {
        this.m_config.deleteAllConfigEntries();
        this.m_config.deleteAllFiles();
    }

    public void restoreDefaults() throws ConfigurationException {
        Map values = this.m_config.getAllConfigEntries();
        this.m_config.deleteConfigEntries(this.findCustomsInMap(values));
        Map files = this.m_config.getAllFileEntries();
        this.m_config.deleteFiles(this.findCustomsInMap(files));
    }

    private String[] findCustomsInMap(Map values) throws ConfigurationException {
        Vector<String> forDeletion = new Vector<String>();
        Iterator iter = values.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            PropertyName pname = new PropertyName(name);
            if (!pname.isCustomValue()) continue;
            forDeletion.add(name);
        }
        return forDeletion.toArray(new String[forDeletion.size()]);
    }

    public PropertySheetEntry[] getAllEntries() throws ConfigurationException {
        PropertyEntry[] entry = this.getAllPropertyEntries();
        PropertySheetEntry[] result = PropertySheetEntry.createCopy(entry);
        return result;
    }

    public void createPropertyEntries(byte[] propertyFile) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        this.writeWithDescriptions(propertyFile, false);
    }

    public String[] updatePropertyEntries(byte[] propertyFile) throws ConfigurationException, NoWriteAccessException {
        return this.writeWithDescriptions(propertyFile, true);
    }

    private String[] writeWithDescriptions(byte[] propertyFile, boolean updateMode) throws ConfigurationException {
        String whiteSpaceChars = " \t\r\n\f";
        String separatorChars = "=: \t\r\n\f";
        String PREFIX = "#!";
        String FLAGS_PREFIX = "#?";
        Vector<String> result = new Vector<String>();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(propertyFile);
            Properties props = new Properties();
            props.load(stream);
            stream.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(propertyFile)));
            String line = null;
            String flags = null;
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith(FLAGS_PREFIX)) {
                    flags = line.substring(FLAGS_PREFIX.length()).trim();
                    continue;
                }
                if (line.startsWith(PREFIX)) {
                    if (buffer.length() > 0) {
                        buffer.append('\n');
                    }
                    buffer.append(line.substring(PREFIX.length()));
                    continue;
                }
                if (buffer.length() <= 0 && flags == null || line.startsWith("#")) continue;
                int length = line.length();
                int keyIndex = 0;
                while (keyIndex < length) {
                    if (whiteSpaceChars.indexOf(line.charAt(keyIndex)) == -1) break;
                    ++keyIndex;
                }
                if (keyIndex >= length) continue;
                int keyEnd = keyIndex;
                while (keyEnd < length) {
                    char current = line.charAt(keyEnd);
                    if (current == '\\') {
                        ++keyEnd;
                    } else if (separatorChars.indexOf(current) != -1) break;
                    ++keyEnd;
                }
                String key = this.convertSpecialChars(line.substring(keyIndex, keyEnd));
                String value = props.getProperty(key);
                String descr = buffer.toString();
                if (this.writeEntry(key, value, descr, flags, updateMode)) {
                    result.add(key);
                }
                buffer = new StringBuffer();
                flags = null;
                ((Hashtable)props).remove(key);
            }
            Iterator iter = ((Hashtable)props).entrySet().iterator();
            while (iter.hasNext()) {
                String value;
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                if (!this.writeEntry(key, value = (String)entry.getValue(), "", null, updateMode)) continue;
                result.add(key);
            }
            reader.close();
            return result.toArray(new String[result.size()]);
        }
        catch (IOException e) {
            throw new ConfigurationException(e, "kernel_1520");
        }
    }

    private String convertSpecialChars(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = theString.charAt(x++)) == '\\') {
                if ((aChar = theString.charAt(x++)) == 'u') {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private boolean writeEntry(String key, String value, String descr, String flags, boolean updateMode) throws ConfigurationException {
        int i;
        boolean isCustomSet = false;
        boolean secure = false;
        if (flags != null && (i = (flags = flags.toLowerCase()).indexOf(61)) != -1) {
            String flagKey = flags.substring(0, i).trim();
            String flagValue = flags.substring(i + 1).trim();
            secure = flagKey.equals("secure") && flagValue.equals("true");
        }
        int entryFlags = 0;
        if (secure) {
            entryFlags = 1;
        }
        try {
            PropertyEntryImpl.createPropertyEntry(key, value, descr, entryFlags, this.m_config);
        }
        catch (NameAlreadyExistsException n) {
            if (updateMode) {
                PropertyEntry entry = this.getPropertyEntry(key);
                entry.setSecure(secure);
                if (!entry.getDefault().equals(value)) {
                    entry.setDefault(value);
                    isCustomSet = entry.getCustom() != null;
                }
                entry.setDescription(descr);
            }
            throw n;
        }
        return isCustomSet;
    }

    public PropertyEntry createSecurePropertyEntry(String name, Object defaultValue, String description) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException {
        return this.createPropertyEntry(name, defaultValue, description, 1);
    }
}

