/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.addons;

public class PropertyName {
    private static String CUSTOM_CHARS = "@";
    private static String DEFAULT_CHARS = "~";
    private static String DESCR_CHARS = "#";
    private static String FLAG_CHARS = "&";
    private String m_name = null;
    private String m_defName = null;
    private String m_custName = null;
    private String m_descrName = null;
    private String m_flagName = null;
    private boolean m_defaultValue = false;
    private boolean m_customValue = false;
    private boolean m_descrValue = false;
    private boolean m_flagValue = false;

    public PropertyName(String name) {
        if (name.startsWith(DEFAULT_CHARS)) {
            this.m_defName = name;
            this.m_name = name.substring(DEFAULT_CHARS.length());
            this.m_defaultValue = true;
        } else if (name.startsWith(CUSTOM_CHARS)) {
            this.m_custName = name;
            this.m_name = name.substring(CUSTOM_CHARS.length());
            this.m_customValue = true;
        } else if (name.startsWith(DESCR_CHARS)) {
            this.m_descrName = name;
            this.m_name = name.substring(DESCR_CHARS.length());
            this.m_descrValue = true;
        } else if (name.startsWith(FLAG_CHARS)) {
            this.m_flagName = name;
            this.m_name = name.substring(FLAG_CHARS.length());
            this.m_flagValue = true;
        } else {
            this.m_name = name;
        }
    }

    public String getDefaultName() {
        if (this.m_defName == null) {
            this.m_defName = DEFAULT_CHARS + this.m_name;
        }
        return this.m_defName;
    }

    public String getCustomName() {
        if (this.m_custName == null) {
            this.m_custName = CUSTOM_CHARS + this.m_name;
        }
        return this.m_custName;
    }

    public String getDescriptionName() {
        if (this.m_descrName == null) {
            this.m_descrName = DESCR_CHARS + this.m_name;
        }
        return this.m_descrName;
    }

    public String getFlagsName() {
        if (this.m_flagName == null) {
            this.m_flagName = FLAG_CHARS + this.m_name;
        }
        return this.m_flagName;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean isCustomValue() {
        return this.m_customValue;
    }

    public boolean isDescriptionValue() {
        return this.m_descrValue;
    }

    public boolean isFlagsValue() {
        return this.m_flagValue;
    }
}

