/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl.addons;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.addons.PropertyName;
import com.sap.engine.core.configuration.impl.security.Crypter;
import com.sap.engine.core.configuration.impl.utilities.CloneableByteArrayInputStream;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PropertyEntryImpl
implements PropertyEntry {
    protected static int UNDEFINED = -1;
    protected static int NUMBER = 1;
    protected static int STRING = 2;
    private static int LARGE_STRING_LIMIT = 1300;
    private String m_name;
    private Object m_def;
    private Object m_cust;
    private String m_defDecr;
    private String m_custDecr;
    private String m_desc;
    private int m_type;
    private Configuration m_config;
    private PropertyName m_pname;
    private int m_flags;
    private Crypter m_crypter;

    public static PropertyEntry createPropertyEntry(String name, Object def, String desc, int flags, Configuration config) throws ConfigurationException {
        return new PropertyEntryImpl(name, def, desc, flags, config);
    }

    public static PropertyEntry readPropertyEntry(String name, Configuration config) throws ConfigurationException {
        return new PropertyEntryImpl(name, config);
    }

    private PropertyEntryImpl(String name, Configuration config) throws ConfigurationException {
        int flags = 0;
        if (name == null) {
            throw new InvalidValueException("kernel_1625");
        }
        PropertyName pname = new PropertyName(name);
        if (pname.isDefaultValue() || pname.isCustomValue() || pname.isDescriptionValue() || pname.isFlagsValue()) {
            throw new InvalidValueException("kernel_1628", new Object[]{name, "@, ~, #, &"});
        }
        Object def = null;
        String defDecr = null;
        Object cust = null;
        String custDecr = null;
        String desc = null;
        int type = 0;
        try {
            if (config.existsConfigEntry(pname.getDefaultName())) {
                def = config.getConfigEntry(pname.getDefaultName());
                cust = this.readCustomValue(pname.getCustomName(), config);
            } else if (config.existsFile(pname.getDefaultName())) {
                def = this.readStringFromFileEntry(pname.getDefaultName(), config);
                cust = this.readCustomValue(pname.getCustomName(), config);
            } else {
                throw new NameNotFoundException("kernel_1603", new Object[]{name, config.getPath()});
            }
            if (config.existsConfigEntry(pname.getDescriptionName())) {
                desc = (String)config.getConfigEntry(pname.getDescriptionName());
            }
            if (config.existsConfigEntry(pname.getFlagsName())) {
                flags = (Integer)config.getConfigEntry(pname.getFlagsName());
            }
            if (flags & true) {
                if (def != null) {
                    defDecr = Environment.getInstance().getCryptoUtility().decrypt((String)def);
                }
                if (cust != null) {
                    custDecr = Environment.getInstance().getCryptoUtility().decrypt((String)cust);
                }
            }
            type = def instanceof String ? STRING : NUMBER;
            this.setGlobalVariables(pname, def, defDecr, cust, custDecr, desc, type, flags, config);
        }
        catch (NameNotFoundException nn) {
            throw nn;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private PropertyEntryImpl(String name, Object def, String desc, int flags, Configuration config) throws ConfigurationException {
        String defDecr = null;
        if (name == null) {
            throw new InvalidValueException("kernel_1625", new Object[]{name});
        }
        if (def == null) {
            throw new InvalidValueException("kernel_1626", new Object[]{name});
        }
        if ((flags & 1) != 0) {
            if (!(def instanceof String)) {
                throw new InvalidValueException("kernel_1637");
            }
            defDecr = (String)def;
            def = Environment.getInstance().getCryptoUtility().encrypt((String)def);
        }
        int type = 0;
        if (def instanceof String) {
            type = STRING;
        } else if (def instanceof Number) {
            type = NUMBER;
        } else {
            throw new InvalidValueException("kernel_1627", new Object[]{name, config.toString()});
        }
        try {
            PropertyName pname = new PropertyName(name);
            if (pname.isDefaultValue() || pname.isCustomValue() || pname.isDescriptionValue() || pname.isFlagsValue()) {
                throw new InvalidValueException("kernel_1628", new Object[]{name, "@, ~, #, &"});
            }
            if (!config.existsConfigEntry(pname.getDefaultName()) && !config.existsFile(pname.getDefaultName())) {
                String defString = (String)def;
                if (type == STRING && defString.length() > LARGE_STRING_LIMIT) {
                    config.addFileAsStream(pname.getDefaultName(), new CloneableByteArrayInputStream(this.serializeString(defString)));
                } else {
                    config.addConfigEntry(pname.getDefaultName(), def);
                }
                if (desc != null) {
                    String descName = pname.getDescriptionName();
                    this.writeObjectToConfigEntry(descName, desc, config);
                }
            } else {
                throw new NameAlreadyExistsException("kernel_1613", new Object[]{name, config.getPath()});
            }
            this.writeObjectToConfigEntry(pname.getFlagsName(), new Integer(flags), config);
            this.setGlobalVariables(pname, def, defDecr, null, null, desc, type, flags, config);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private void setGlobalVariables(PropertyName pname, Object def, String defDecr, Object cust, String custDecr, String desc, int type, int flags, Configuration config) {
        this.m_config = config;
        this.m_pname = pname;
        this.m_name = pname.getName();
        this.m_def = def;
        this.m_defDecr = defDecr;
        this.m_cust = cust;
        this.m_custDecr = custDecr;
        this.m_desc = desc;
        this.m_type = type;
        this.m_flags = flags;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public void setDescription(String description) throws ConfigurationException {
        if (description.equals(this.m_desc)) {
            return;
        }
        String descName = this.m_pname.getDescriptionName();
        this.writeObjectToConfigEntry(descName, description, this.m_config);
        this.m_desc = description;
    }

    public void setDefault(Object value) throws ConfigurationException, InvalidValueException {
        try {
            Object valDecr = value;
            if ((this.m_flags & 1) != 0) {
                if (!(value instanceof String)) {
                    throw new InvalidValueException("kernel_1637");
                }
                value = Environment.getInstance().getCryptoUtility().encrypt((String)value);
            }
            if (value instanceof String) {
                if (this.m_cust != null && this.m_type != STRING) {
                    throw new InvalidValueException("kernel_1629", new Object[]{this.m_name, this.m_config.toString()});
                }
                String valueString = (String)value;
                String defName = this.m_pname.getDefaultName();
                if (valueString.length() > LARGE_STRING_LIMIT) {
                    this.writeStringToFileEntry(defName, valueString, this.m_config);
                } else {
                    this.writeObjectToConfigEntry(defName, value, this.m_config);
                }
                this.m_type = STRING;
            } else if (value instanceof Number) {
                if (this.m_cust != null && this.m_type != NUMBER) {
                    throw new InvalidValueException("kernel_1629", new Object[]{this.m_name, this.m_config.toString()});
                }
                this.writeObjectToConfigEntry(this.m_pname.getDefaultName(), value, this.m_config);
                this.m_type = NUMBER;
            } else {
                throw new InvalidValueException("kernel_1627", new Object[]{this.m_name, this.m_config.toString()});
            }
            this.m_def = value;
            this.m_defDecr = (this.m_flags & 1) != 0 ? (String)valDecr : null;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void setValue(Object value) throws ConfigurationException, InvalidValueException {
        try {
            Object valDecr = value;
            if ((this.m_flags & 1) != 0) {
                if (!(value instanceof String)) {
                    throw new InvalidValueException("kernel_1637");
                }
                value = Environment.getInstance().getCryptoUtility().encrypt((String)value);
            }
            if (value instanceof String) {
                if (this.m_type != STRING) {
                    throw new InvalidValueException("kernel_1629", new Object[]{this.m_name, this.m_config.toString()});
                }
                String valueString = (String)value;
                String custName = this.m_pname.getCustomName();
                if (valueString.length() > LARGE_STRING_LIMIT) {
                    this.writeStringToFileEntry(custName, valueString, this.m_config);
                } else {
                    this.writeObjectToConfigEntry(custName, value, this.m_config);
                }
            } else if (value instanceof Number) {
                if (this.m_type != NUMBER) {
                    throw new InvalidValueException("kernel_1629", new Object[]{this.m_name, this.m_config.toString()});
                }
                this.writeObjectToConfigEntry(this.m_pname.getCustomName(), value, this.m_config);
            } else {
                throw new InvalidValueException("kernel_1627", new Object[]{this.m_name, this.m_config.toString()});
            }
            this.m_cust = value;
            this.m_custDecr = (this.m_flags & 1) != 0 ? (String)valDecr : null;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public Object getValue() {
        boolean secure;
        boolean bl = secure = (this.m_flags & 1) != 0;
        if (this.m_cust != null) {
            if (secure) {
                return this.m_custDecr;
            }
            return this.m_cust;
        }
        if (secure) {
            return this.m_defDecr;
        }
        return this.m_def;
    }

    public Object getDefault() {
        if ((this.m_flags & 1) != 0) {
            return this.m_defDecr;
        }
        return this.m_def;
    }

    public Object getCustom() {
        if ((this.m_flags & 1) != 0) {
            return this.m_custDecr;
        }
        return this.m_cust;
    }

    public void restoreDefault() throws ConfigurationException {
        String cName = this.m_pname.getCustomName();
        if (this.m_config.existsConfigEntry(cName)) {
            this.m_config.deleteConfigEntry(cName);
        } else if (this.m_config.existsFile(cName)) {
            this.m_config.deleteFile(cName);
        }
        this.m_cust = null;
        this.m_custDecr = null;
    }

    private byte[] serializeString(String s) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(s.length());
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        objOut.writeObject(s);
        objOut.flush();
        byte[] result = byteOut.toByteArray();
        objOut.close();
        byteOut.close();
        return result;
    }

    private String readStringFromFileEntry(String entryName, Configuration config) throws ConfigurationException {
        try {
            InputStream in = config.getFile(entryName);
            ObjectInputStream objIn = new ObjectInputStream(in);
            String result = (String)objIn.readObject();
            objIn.close();
            return result;
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private Object readCustomValue(String entryName, Configuration config) throws ConfigurationException {
        Object result = null;
        if (config.existsConfigEntry(entryName)) {
            result = config.getConfigEntry(entryName);
        } else if (config.existsFile(entryName)) {
            result = this.readStringFromFileEntry(entryName, config);
        }
        return result;
    }

    private void writeObjectToConfigEntry(String entryName, Object value, Configuration config) throws ConfigurationException {
        if (config.existsConfigEntry(entryName)) {
            config.modifyConfigEntry(entryName, value);
        } else {
            config.addConfigEntry(entryName, value);
        }
        try {
            config.deleteFile(entryName);
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
    }

    private void writeStringToFileEntry(String entryName, String value, Configuration config) throws ConfigurationException {
        try {
            CloneableByteArrayInputStream defBytes = new CloneableByteArrayInputStream(this.serializeString(value));
            if (config.existsFile(entryName)) {
                config.updateFileAsStream(entryName, defBytes);
            } else {
                config.addFileAsStream(entryName, defBytes);
            }
            try {
                config.deleteConfigEntry(entryName);
            }
            catch (NameNotFoundException nn) {}
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public boolean isSecure() {
        return (this.m_flags & 1) != 0;
    }

    public void setSecure(boolean secure) throws ConfigurationException {
        boolean current;
        boolean bl = current = (this.m_flags & 1) != 0;
        if (secure == current) {
            return;
        }
        Object def = this.m_def;
        Object cust = this.m_cust;
        if (secure) {
            if (this.m_type != STRING) {
                throw new InvalidValueException("kernel_1637");
            }
            ++this.m_flags;
        } else {
            --this.m_flags;
            def = Environment.getInstance().getCryptoUtility().decrypt((String)def);
            if (cust != null) {
                cust = Environment.getInstance().getCryptoUtility().decrypt((String)cust);
            }
        }
        this.setDefault(def);
        if (this.m_cust != null) {
            this.setValue(cust);
        }
        this.writeObjectToConfigEntry(this.m_pname.getFlagsName(), new Integer(this.m_flags), this.m_config);
    }

    public void setReencryptedDefault(String valueString) throws ConfigurationException {
        if (valueString.length() > LARGE_STRING_LIMIT) {
            this.writeStringToFileEntry(this.m_pname.getDefaultName(), valueString, this.m_config);
        } else {
            this.writeObjectToConfigEntry(this.m_pname.getDefaultName(), valueString, this.m_config);
        }
        this.m_def = valueString;
    }

    public void setReencryptedCustom(String valueString) throws ConfigurationException {
        if (valueString.length() > LARGE_STRING_LIMIT) {
            this.writeStringToFileEntry(this.m_pname.getCustomName(), valueString, this.m_config);
        } else {
            this.writeObjectToConfigEntry(this.m_pname.getCustomName(), valueString, this.m_config);
        }
        this.m_cust = valueString;
    }

    public String getEncryptedCustom() {
        if (!this.isSecure()) {
            return null;
        }
        return (String)this.m_cust;
    }

    public String getEncryptedDefault() {
        if (!this.isSecure()) {
            return null;
        }
        return (String)this.m_def;
    }
}

