/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ConfigurationHandlerImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.FileEntry;
import com.sap.engine.core.configuration.impl.ReadAccessConfiguration;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.RestrictionChecker;
import com.sap.engine.core.configuration.impl.utilities.Semaphore;
import com.sap.engine.core.configuration.impl.utilities.transfer.ConfigImporter;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class WriteAccessConfiguration
extends ReadAccessConfiguration {
    private ConfigurationData m_datacopy;
    private int m_pathLength = -1;
    private Semaphore m_semaphore2;

    public WriteAccessConfiguration(ConfigurationData datacopy, ConfigurationHandler handler, Configuration openRoot) {
        this.m_datacopy = datacopy;
        this.m_path = datacopy.getPath();
        this.m_cid = datacopy.getCID();
        this.m_handler = (ConfigurationHandlerImpl)handler;
        if (openRoot == null) {
            openRoot = this;
        }
        this.m_openRoot = (WriteAccessConfiguration)openRoot;
        this.m_semaphore = new Semaphore();
        this.m_semaphore2 = new Semaphore();
    }

    public WriteAccessConfiguration(ConfigurationPath path, long cid, ConfigurationHandler handler, Configuration openRoot) {
        this.m_cid = cid;
        this.m_path = path;
        this.m_handler = (ConfigurationHandlerImpl)handler;
        if (openRoot == null) {
            openRoot = this;
        }
        this.m_openRoot = (WriteAccessConfiguration)openRoot;
        this.m_semaphore = new Semaphore();
        this.m_semaphore2 = new Semaphore();
    }

    private void getSemaphoreLock(Semaphore s, int type) {
        try {
            s.getLock(type);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void releaseSemaphoreLock(Semaphore s, int type) {
        try {
            s.releaseLock(type);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void extendSemaphoreLock(Semaphore s) {
        try {
            s.extendToExclusive();
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void reduceSemaphoreLock(Semaphore s) {
        try {
            s.reduceToShared();
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    public long getId() {
        return this.m_cid;
    }

    protected boolean isNewCreated() {
        boolean bl;
        try {
            this.getSemaphoreLock(this.m_semaphore2, Semaphore.SHARED);
            if (this.m_datacopy == null) {
                boolean bl2 = false;
                Object var3_3 = null;
                this.releaseSemaphoreLock(this.m_semaphore2, Semaphore.SHARED);
                return bl2;
            }
            bl = this.m_datacopy.isCreated();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.releaseSemaphoreLock(this.m_semaphore2, Semaphore.SHARED);
            throw throwable;
        }
        Object var3_4 = null;
        this.releaseSemaphoreLock(this.m_semaphore2, Semaphore.SHARED);
        return bl;
    }

    private void retrieveData() throws ConfigurationException {
        try {
            try {
                this.extendSemaphoreLock(this.m_semaphore2);
                if (this.m_datacopy != null) {
                    Object var3_1 = null;
                    this.reduceSemaphoreLock(this.m_semaphore2);
                    return;
                }
                this.m_datacopy = this.m_handler.getDataForWrite(this.m_path, this.m_cid);
            }
            catch (ConfigurationException e) {
                Environment.getInstance().getLogging().log((byte)5, this + ": Error while trying to load configuration data");
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.reduceSemaphoreLock(this.m_semaphore2);
            throw throwable;
        }
        Object var3_2 = null;
        this.reduceSemaphoreLock(this.m_semaphore2);
    }

    protected ConfigurationData getData() throws ConfigurationException {
        boolean gotAccess = false;
        gotAccess = this.m_handler.getTransactionAccess();
        try {
            try {
                this.getSemaphoreLock(this.m_semaphore2, Semaphore.SHARED);
                if (this.m_datacopy == null) {
                    this.retrieveData();
                }
                ConfigurationData configurationData = this.m_datacopy;
                Object var4_4 = null;
                this.releaseSemaphoreLock(this.m_semaphore2, Semaphore.SHARED);
                return configurationData;
            }
            catch (ConfigurationException e) {
                if (gotAccess) {
                    this.m_handler.releaseTransactionAccess();
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.releaseSemaphoreLock(this.m_semaphore2, Semaphore.SHARED);
            throw throwable;
        }
    }

    protected void releaseData(ConfigurationData data) {
        this.m_handler.releaseTransactionAccess();
    }

    protected void resetDataCopy() throws ConfigurationException {
        this.getSemaphoreLock(this.m_semaphore2, Semaphore.EXCLUSIVE);
        if (this.m_datacopy != null) {
            this.m_datacopy.cleanAll();
        }
        this.m_datacopy = null;
        this.releaseSemaphoreLock(this.m_semaphore2, Semaphore.EXCLUSIVE);
    }

    protected void checkNames(String[] names) throws ConfigurationException {
        int i = 0;
        while (i < names.length) {
            RestrictionChecker.checkSubConfigurationPath(this.m_path, names[i]);
            ++i;
        }
    }

    protected void validityCheck() throws ConfigurationException {
        if (this.m_openRoot.getValidityFlag() == 1) {
            throw new ConfigurationException("kernel_1521", new Object[]{this.getPath(), "closed"});
        }
        if (this.m_validFlag == 3) {
            throw new ConfigurationException("kernel_1521", new Object[]{this.getPath(), "deleted"});
        }
        if (this.m_validFlag == 4) {
            throw new ConfigurationException("kernel_1521", new Object[]{this.getPath(), "not existing"});
        }
    }

    protected void consistencyCheck() throws InconsistentReadException {
    }

    protected ConfigurationData getDataCopy() {
        return this.m_datacopy;
    }

    public void setCacheMode(int mode) throws ConfigurationException, NoWriteAccessException {
        if (mode != 10 && mode != 12 && mode != 20 && mode != 18) {
            throw new ConfigurationException("kernel_1507", new Object[]{"cacheMode"});
        }
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            data = this.getData();
            this.validityCheck();
            data.setCacheMode(mode);
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public Configuration createSubConfiguration(String name) throws ConfigurationException, NoWriteAccessException {
        return this.createSubConfiguration(name, 0);
    }

    public Map createSubConfigurations(String[] names) throws ConfigurationException, NoWriteAccessException {
        return this.createSubConfigurations(names, 0);
    }

    public Configuration createSubConfiguration(String name, int type) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            Configuration config;
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            RestrictionChecker.checkSubConfigurationPath(this.m_path, name);
            data = this.getData();
            this.validityCheck();
            Configuration configuration = config = this.m_handler.registerNewSubConfiguration(this.m_openRoot, data.createSubConfiguration(name, type));
            Object var7_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            return configuration;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public Map createSubConfigurations(String[] names, int type) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            data = this.getData();
            this.validityCheck();
            this.checkNames(names);
            ConfigurationData[] datalist = new ConfigurationData[names.length];
            datalist = data.createSubConfigurations(names, type);
            Map map = this.m_handler.registerNewSubConfigurations(this.m_openRoot, datalist);
            Object var7_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            return map;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public Configuration createSubConfigurationHierachy(String relPath) throws ConfigurationException, NoWriteAccessException {
        ConfigurationPath absPath = this.m_path.getSubTreeConfigurationPath(relPath);
        RestrictionChecker.checkConfigurationPath(absPath);
        String[] allLevels = absPath.getLevelArray();
        Configuration config = this;
        int i = this.m_path.getLevels();
        while (i < allLevels.length) {
            config = config.existsSubConfiguration(allLevels[i]) ? config.getSubConfiguration(allLevels[i]) : config.createSubConfiguration(allLevels[i]);
            ++i;
        }
        return config;
    }

    public void deleteConfiguration(String name) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteSubConfiguration(name);
            this.m_handler.registerDeleteSubConfiguration(this, name);
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteConfiguration() throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        this.validityCheck();
        if (this.equals(this.getOpenRoot())) {
            try {
                this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
                this.validityCheck();
                data = this.getData();
                data.deleteAll();
                this.m_handler.handleDeleteOpenRootConfiguration(this);
                Object var3_2 = null;
                if (data != null) {
                    this.releaseData(data);
                }
                this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (data != null) {
                    this.releaseData(data);
                }
                this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
                throw throwable;
            }
        } else {
            ConfigurationPath parentPath = this.m_path.getParrentPath();
            Configuration parentConfig = this.m_openRoot;
            if (parentPath != this.m_openRoot.m_path) {
                parentConfig = this.m_handler.getSubConfiguration((Configuration)this.m_openRoot, this.m_openRoot.getPathWrapper().getRelPathForSubPath(parentPath));
            }
            parentConfig.deleteConfiguration(this.m_path.getNameFromPath());
        }
    }

    public void deleteSubConfigurations(String[] names) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            this.m_handler.registerDeleteSubConfigurations(this, data.deleteSubConfigurations(names));
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteAllSubConfigurations() throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteAllSubConfigurations();
            this.m_handler.registerDeleteSubConfiguration(this, "/");
            Object var3_2 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addConfigEntry(String name, Object value) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            RestrictionChecker.checkConfigEntryName(name);
            this.validityCheck();
            data = this.getData();
            data.createValueEntry(new ValueEntry(name, value));
            Object var5_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addConfigEntries(Map list) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            Vector<ValueEntry> v = new Vector<ValueEntry>();
            Iterator it = list.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                RestrictionChecker.checkConfigEntryName(name);
                ValueEntry val = new ValueEntry(name, list.get(name));
                v.addElement(val);
            }
            data.createValueEntries(v);
            Object var8_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void modifyConfigEntry(String name, Object value) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        this.modifyConfigEntry(name, value, false);
    }

    public void modifyConfigEntry(String name, Object value, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            if (createIfNotExist && !data.existsValue(name)) {
                data.createValueEntry(new ValueEntry(name, value));
            } else {
                data.modifyValueEntry(new ValueEntry(name, value));
            }
            Object var6_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void modifyConfigEntries(Map list) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            Vector<ValueEntry> v = new Vector<ValueEntry>();
            Iterator it = list.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                RestrictionChecker.checkConfigEntryName(name);
                ValueEntry val = new ValueEntry(name, list.get(name));
                v.addElement(val);
            }
            data.modifyValueEntries(v);
            Object var8_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteConfigEntry(String name) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteValueEntry(name);
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteConfigEntries(String[] names) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteValueEntries(names);
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteAllConfigEntries() throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteAllValueEntries();
            Object var3_2 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addFileEntry(File file) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            RestrictionChecker.checkConfigEntryName(file.getName());
            this.validityCheck();
            data = this.getData();
            data.createFileEntry(new FileEntry(file));
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addFileEntryByKey(String key, File file) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            RestrictionChecker.checkConfigEntryName(key);
            this.validityCheck();
            data = this.getData();
            data.createFileEntry(new FileEntry(key, file));
            Object var5_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addFileAsStreamWithLength(String name, InputStream stream, int streamLength) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            RestrictionChecker.checkConfigEntryName(name);
            this.validityCheck();
            data = this.getData();
            data.createFileEntry(new FileEntry(name, stream, streamLength));
            Object var6_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addFileAsStream(String name, InputStream stream) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            RestrictionChecker.checkConfigEntryName(name);
            this.validityCheck();
            data = this.getData();
            data.createFileEntry(new FileEntry(name, stream));
            Object var5_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addFileEntries(File[] list) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            Vector<FileEntry> v = new Vector<FileEntry>();
            int i = 0;
            while (i < list.length) {
                RestrictionChecker.checkConfigEntryName(list[i].getName());
                FileEntry val = new FileEntry(list[i]);
                v.addElement(val);
                ++i;
            }
            data.createFileEntries(v);
            Object var7_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addFileEntriesByKey(Map list) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            Vector<FileEntry> v = new Vector<FileEntry>();
            Iterator it = list.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                RestrictionChecker.checkConfigEntryName(name);
                FileEntry val = new FileEntry(name, (File)list.get(name));
                v.addElement(val);
            }
            data.createFileEntries(v);
            Object var8_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void updateFile(File file) throws ConfigurationException, NoWriteAccessException {
        this.updateFile(file, false);
    }

    public void updateFile(File file, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            if (createIfNotExist && !data.existsFileEntry(file.getName())) {
                data.createFileEntry(new FileEntry(file));
            } else {
                data.modifyFileEntry(new FileEntry(file));
            }
            Object var5_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void updateFileByKey(String key, File file) throws ConfigurationException, NoWriteAccessException {
        this.updateFileByKey(key, file, false);
    }

    public void updateFileByKey(String key, File file, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            if (createIfNotExist && !data.existsFileEntry(key)) {
                data.createFileEntry(new FileEntry(key, file));
            } else {
                data.modifyFileEntry(new FileEntry(key, file));
            }
            Object var6_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void updateFileAsStream(String name, InputStream stream) throws ConfigurationException, NoWriteAccessException {
        this.updateFileAsStream(name, stream, false);
    }

    public void updateFileAsStream(String name, InputStream stream, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            if (createIfNotExist && !data.existsFileEntry(name)) {
                data.createFileEntry(new FileEntry(name, stream));
            } else {
                data.modifyFileEntry(new FileEntry(name, stream));
            }
            Object var6_5 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void updateFiles(File[] files) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            Vector<FileEntry> v = new Vector<FileEntry>();
            int i = 0;
            while (i < files.length) {
                FileEntry val = new FileEntry(files[i]);
                RestrictionChecker.checkConfigEntryName(val.getName());
                v.addElement(val);
                ++i;
            }
            data.modifyFileEntries(v);
            Object var7_6 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void updateFilesByKey(Map list) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            Vector<FileEntry> v = new Vector<FileEntry>();
            Iterator it = list.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                RestrictionChecker.checkConfigEntryName(name);
                FileEntry val = new FileEntry(name, (File)list.get(name));
                v.addElement(val);
            }
            data.modifyFileEntries(v);
            Object var8_7 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteFile(String file) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteFileEntry(file);
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteFiles(String[] files) throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteFileEntries(files);
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void deleteAllFiles() throws ConfigurationException, NoWriteAccessException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            data.deleteAllFileEntries();
            Object var3_2 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void addValueEntry(ValueEntry entry) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            this.validityCheck();
            data = this.getData();
            RestrictionChecker.checkConfigEntryName(entry.getName());
            data.createValueEntry(entry);
            Object var4_3 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (data != null) {
                this.releaseData(data);
            }
            this.releaseSemaphoreLock(this.m_semaphore, Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void importAsSubConfiguration(String sourcePath) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException {
        ConfigImporter importer = new ConfigImporter();
        importer.importConfig(this, sourcePath, 0);
    }

    public void importContent(String sourcePath) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException {
        ConfigImporter importer = new ConfigImporter();
        importer.importConfig(this, sourcePath, 1);
    }
}

