/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.ConfigInputStream;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.DeserializationFailedException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class ValueEntry
implements Serializable {
    String m_name = null;
    Object m_value = null;
    Object m_dbValue = null;
    int m_type = 0;
    public static final int SHORT = 20;
    public static final int INTEGER = 21;
    public static final int LONG = 22;
    public static final int BYTE = 23;
    public static final int BOOLEAN = 25;
    public static final int DOUBLE = 30;
    public static final int STRING = 40;
    public static final int BYTES = 50;
    public static final int BYTESOBJECT = 60;
    private static final HashMap TYPE_MAPPING_STRING_TO_INT = new HashMap();
    private static final HashMap TYPE_MAPPING_INT_TO_STRING = new HashMap();

    public static ValueEntry createValueEntry(String name, Object dbValue, int type) {
        return new ValueEntry(name, dbValue, type);
    }

    protected ValueEntry(String name, Object value) throws InvalidValueException, ConfigurationException {
        if (value == null) {
            throw new InvalidValueException("kernel_1620", new Object[]{name});
        }
        this.m_name = name;
        if (value instanceof Short) {
            this.m_dbValue = new Long(((Short)value).longValue());
            this.m_type = 20;
        } else if (value instanceof Integer) {
            this.m_dbValue = new Long(((Integer)value).longValue());
            this.m_type = 21;
        } else if (value instanceof Long) {
            this.m_dbValue = value;
            this.m_type = 22;
        } else if (value instanceof Byte) {
            byte temp = (Byte)value;
            this.m_dbValue = new Long(temp);
            this.m_type = 23;
        } else if (value instanceof Boolean) {
            boolean temp = (Boolean)value;
            this.m_dbValue = temp ? new Long(1L) : new Long(0L);
            this.m_type = 25;
        } else if (value instanceof Double) {
            this.m_dbValue = value;
            this.m_type = 30;
        } else if (value instanceof String) {
            String temp = (String)value;
            if (temp.length() > 1300) {
                throw new InvalidValueException("kernel_1621", new Object[]{name, new Integer(1300)});
            }
            temp = this.cutTrailingSpaces(temp);
            value = temp;
            if (temp.equals("")) {
                temp = " ";
            }
            this.m_dbValue = temp;
            this.m_type = 40;
        } else if (value instanceof byte[]) {
            byte[] temp = (byte[])value;
            if (temp.length > 2000) {
                throw new InvalidValueException("kernel_1622", new Object[]{name, new Integer(2000)});
            }
            this.m_dbValue = temp;
            this.m_type = 50;
        } else if (value instanceof Serializable) {
            byte[] temp = this.serialize(value);
            if (temp.length > 2000) {
                throw new InvalidValueException("kernel_1623", new Object[]{name, new Integer(2000)});
            }
            this.m_dbValue = temp;
            this.m_type = 60;
        } else {
            throw new InvalidValueException("kernel_1624", new Object[]{name});
        }
        this.m_value = value;
    }

    private ValueEntry(String name, Object dbValue, int type) {
        this.m_name = name;
        this.m_dbValue = dbValue;
        this.m_type = type;
    }

    public Object getValue() throws ConfigurationException {
        if (this.m_value == null) {
            switch (this.m_type) {
                case 20: {
                    this.m_value = new Short(((Long)this.m_dbValue).shortValue());
                    break;
                }
                case 21: {
                    this.m_value = new Integer(((Long)this.m_dbValue).intValue());
                    break;
                }
                case 25: {
                    boolean bool = (Long)this.m_dbValue != 0L;
                    this.m_value = new Boolean(bool);
                    break;
                }
                case 23: {
                    this.m_value = new Byte(((Long)this.m_dbValue).byteValue());
                    break;
                }
                case 60: {
                    this.m_value = this.deserialize((byte[])this.m_dbValue);
                    break;
                }
                case 40: {
                    if (this.m_dbValue == null || this.m_dbValue.equals(" ")) {
                        this.m_value = "";
                        break;
                    }
                    this.m_value = this.m_dbValue;
                    break;
                }
                default: {
                    this.m_value = this.m_dbValue;
                }
            }
        }
        return this.m_value;
    }

    public Object getDBValue() {
        return this.m_dbValue;
    }

    public int getType() {
        return this.m_type;
    }

    public String getName() {
        return this.m_name;
    }

    public static int getTypeForTypeString(String typeString) {
        return (Integer)TYPE_MAPPING_STRING_TO_INT.get(typeString);
    }

    public static String getTypeStringForType(int type) {
        return (String)TYPE_MAPPING_INT_TO_STRING.get(new Integer(type));
    }

    private byte[] serialize(Object object) throws ConfigurationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            out.close();
            return bos.toByteArray();
        }
        catch (NotSerializableException nse) {
            throw new InvalidValueException("kernel_1624", new Object[]{this.m_name});
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1525", new Object[]{this.m_name});
        }
    }

    private Object deserialize(byte[] bytes) throws ConfigurationException {
        ConfigInputStream in = null;
        try {
            in = new ConfigInputStream(new ByteArrayInputStream(bytes));
            Object obj = in.readObject();
            in.close();
            return obj;
        }
        catch (Exception e) {
            throw new DeserializationFailedException(e, "kernel_1526", new Object[]{this.m_name}, in.getLastClassName());
        }
    }

    private String cutTrailingSpaces(String s) {
        int length = s.length();
        int i = length - 1;
        while (i >= 0) {
            if (s.charAt(i) != ' ') break;
            --length;
            --i;
        }
        if (length == s.length()) {
            return s;
        }
        Environment.getInstance().getLogging().log((byte)4, "ValueEntry: trim performed on ConfigEntry: " + this.m_name);
        return s.substring(0, length);
    }

    static {
        TYPE_MAPPING_STRING_TO_INT.put("SHORT", new Integer(20));
        TYPE_MAPPING_STRING_TO_INT.put("INTEGER", new Integer(21));
        TYPE_MAPPING_STRING_TO_INT.put("LONG", new Integer(22));
        TYPE_MAPPING_STRING_TO_INT.put("BOOLEAN", new Integer(25));
        TYPE_MAPPING_STRING_TO_INT.put("BYTE", new Integer(23));
        TYPE_MAPPING_STRING_TO_INT.put("DOUBLE", new Integer(30));
        TYPE_MAPPING_STRING_TO_INT.put("STRING", new Integer(40));
        TYPE_MAPPING_STRING_TO_INT.put("BYTES", new Integer(50));
        TYPE_MAPPING_STRING_TO_INT.put("BYTESOBJECT", new Integer(60));
        Iterator iter = TYPE_MAPPING_STRING_TO_INT.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            TYPE_MAPPING_INT_TO_STRING.put(TYPE_MAPPING_STRING_TO_INT.get(key), key);
        }
    }
}

