/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ChangeEventImpl;
import com.sap.engine.core.configuration.impl.ConfigurationImpl;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.Configuration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TransactionInfo {
    private String m_transId;
    private ChangeEvent[] m_events;
    private ConfigurationPath[] m_openConfigs;

    public TransactionInfo(String transId, ChangeEvent[] events, Configuration[] openConfigs) {
        this.m_transId = transId;
        this.m_events = events;
        this.m_openConfigs = new ConfigurationPath[openConfigs.length];
        int i = 0;
        while (i < openConfigs.length) {
            this.m_openConfigs[i] = ((ConfigurationImpl)openConfigs[i]).getPathWrapper();
            ++i;
        }
    }

    private TransactionInfo(String transId, ChangeEvent[] events, ConfigurationPath[] openConfigs) {
        this.m_transId = transId;
        this.m_events = events;
        this.m_openConfigs = openConfigs;
    }

    public ChangeEvent[] getEvents() {
        return this.m_events;
    }

    public ConfigurationPath[] getOpenConfigs() {
        return this.m_openConfigs;
    }

    public String getTransId() {
        return this.m_transId;
    }

    public void writeToStream(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_transId);
        out.writeInt(this.m_events.length);
        int i = 0;
        while (i < this.m_events.length) {
            ((ChangeEventImpl)this.m_events[i]).writeToStream(out);
            ++i;
        }
        out.writeInt(this.m_openConfigs.length);
        int i2 = 0;
        while (i2 < this.m_openConfigs.length) {
            out.writeObject(this.m_openConfigs[i2].getPathString());
            ++i2;
        }
    }

    public static TransactionInfo readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String transId = (String)in.readObject();
        int eventsLength = in.readInt();
        ChangeEvent[] events = new ChangeEventImpl[eventsLength];
        int i = 0;
        while (i < events.length) {
            events[i] = ChangeEventImpl.readFromStream(in);
            ++i;
        }
        int openConfigsLength = in.readInt();
        ConfigurationPath[] openConfigs = new ConfigurationPath[openConfigsLength];
        int i2 = 0;
        while (i2 < openConfigs.length) {
            String path = (String)in.readObject();
            openConfigs[i2] = ConfigurationPath.getConfigurationPath(path);
            ++i2;
        }
        return new TransactionInfo(transId, events, openConfigs);
    }
}

