/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigurationMessageAnswer;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.EnvironmentListener;
import com.sap.engine.core.configuration.impl.Logging;
import com.sap.engine.core.configuration.impl.security.Crypter;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import java.util.AbstractCollection;
import java.util.HashSet;

public class StandaloneEnvironment
extends Environment {
    private Logging m_logging;
    private HashSet m_locks;
    private Object m_localMonitor = new Object();
    private long m_lockOwnerId;
    private ConfigurationHandlerFactory m_configManager;
    private Crypter m_crypter;

    public StandaloneEnvironment(Logging logging, ConfigurationHandlerFactory configFactory) {
        this.m_logging = logging;
        this.m_locks = new HashSet();
        this.m_lockOwnerId = 0L;
        this.m_configManager = configFactory;
    }

    public void setEnvironmentListener(EnvironmentListener listener) {
    }

    public void unsetEnvironmentListener() {
    }

    public EnvironmentListener getEnvironmentListener() {
        return null;
    }

    public ConfigurationMessageAnswer[] send(int messageType, byte[] message, boolean acceptPartialResponse) throws ConfigurationException {
        return new ConfigurationMessageAnswer[0];
    }

    public ConfigurationMessageAnswer sendToOneNode(int node, int messageType, byte[] message) throws ConfigurationException {
        return new ConfigurationMessageAnswer(new byte[0]);
    }

    public Logging getLogging() {
        return this.m_logging;
    }

    public void startThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.start();
    }

    public void startThread(Runnable runnable, int priority) {
        Thread t = new Thread(runnable);
        t.setPriority(priority);
        t.start();
    }

    public void addLock(String owner, String area, String key, boolean exclusive) throws ConfigurationLockedException, ConfigurationException {
        this.addLock(owner, area, key, exclusive, false);
    }

    public void addLock(String owner, String area, String key, boolean exclusive, boolean fillWithWildcards) throws ConfigurationLockedException, ConfigurationException {
        if (!exclusive || !fillWithWildcards) {
            throw new UnsupportedOperationException("This locking method is not supported in StandaloneEnvironment");
        }
        HashSet hashSet = this.m_locks;
        synchronized (hashSet) {
            int keyLength = key.length();
            String[] allLocks = ((AbstractCollection)this.m_locks).toArray(new String[0]);
            int i = 0;
            while (i < allLocks.length) {
                int lockLength = allLocks[i].length();
                if (keyLength > lockLength ? key.startsWith(allLocks[i]) : keyLength <= lockLength && allLocks[i].startsWith(key)) {
                    throw new ConfigurationLockedException(new Exception(key + " is already locked via " + allLocks[i]), "kernel_1670");
                }
                ++i;
            }
            this.m_locks.add(key);
        }
    }

    public void addLock(String owner, String[] area, String[] key, boolean[] exclusive) throws ConfigurationLockedException, ConfigurationException {
        this.addLock(owner, area, key, exclusive, false);
    }

    public void addLock(String owner, String[] area, String[] key, boolean[] exclusive, boolean fillWithWildcards) throws ConfigurationLockedException, ConfigurationException {
    }

    public void removeLock(String owner, String area, String key, boolean exclusive) throws ConfigurationException {
        this.removeLock(owner, area, key, exclusive, false);
    }

    public void removeLock(String owner, String area, String key, boolean exclusive, boolean fillWithWildcards) throws ConfigurationException {
        if (!exclusive || !fillWithWildcards) {
            throw new UnsupportedOperationException("This locking method is not supported in StandaloneEnvironment");
        }
        HashSet hashSet = this.m_locks;
        synchronized (hashSet) {
            this.m_locks.remove(key);
        }
    }

    public void removeLock(String owner, String[] area, String[] key, boolean[] exclusive) throws ConfigurationException {
        this.removeLock(owner, area, key, exclusive, false);
    }

    public void removeLock(String owner, String[] area, String[] key, boolean[] exclusive, boolean fillWithWildcards) throws ConfigurationException {
    }

    public void removeAllLocks(String owner) throws ConfigurationException {
    }

    public String createUniqueOwner() throws ConfigurationException {
        Object object = this.m_localMonitor;
        synchronized (object) {
            ++this.m_lockOwnerId;
            String string = "" + this.m_lockOwnerId;
            return string;
        }
    }

    public void releaseUniqueOwner(String uniqueOwner) {
    }

    public ConfigurationHandlerFactory getConfigurationHandlerFactory() {
        return this.m_configManager;
    }

    public Crypter getCryptoUtility() throws ConfigurationException {
        if (this.m_crypter == null) {
            throw new ConfigurationException("kernel_1500", new Object[]{"Cryto Utility still not initialitzed in this Environment"});
        }
        return this.m_crypter;
    }

    public void registerCryptoUtility(Crypter cryptoUtil) {
        this.m_crypter = cryptoUtil;
    }

    public int getLocalClusterID() {
        return 0;
    }

    public void deinitialize() {
    }
}

