/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.cluster.ClusterManager;
import com.sap.engine.core.configuration.impl.ConfigurationMessageAnswer;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.EnvironmentListener;
import com.sap.engine.core.configuration.impl.Logging;
import com.sap.engine.core.configuration.impl.security.Crypter;
import com.sap.engine.core.thread.ThreadManager;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.message.DestinationLostException;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.cluster.message.NoListenerOnDestinationException;
import com.sap.engine.frame.cluster.message.PartialResponseException;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.frame.core.pool.PoolContext;
import java.util.ArrayList;
import java.util.Hashtable;

public class ServerEnvironment
extends Environment
implements MessageListener,
ClusterEventListener {
    private static final String LOCKING_NAMESPACE = "!";
    private static final String LOCKING_NAMESPACE_DESCRIPTION = "configuration manager";
    private static final Util UTIL = new Util();
    private static final MessageAnswer[] EMPTY_MESSAGEANSWERARRAY = new MessageAnswer[0];
    private static final long MESSAGE_TIMEOUT = 180000L;
    private Hashtable _lockingInterfaces;
    private ClusterManager _clusterManager;
    private MessageContext _messageContext;
    private PoolContext _poolContext;
    private LockingContext _lockingContext;
    private ThreadManager _threadSystem;
    private Logging _logging;
    private EnvironmentListener _environmentListener;
    private ConfigurationHandlerFactory _configManager;
    private Crypter _crypter;

    public ServerEnvironment(ClusterManager clusterManager, PoolContext poolContext, LockingContext lockingContext, ThreadManager threadSystem, Logging logging, ConfigurationHandlerFactory cm) throws ConfigurationException {
        this._clusterManager = clusterManager;
        this._poolContext = poolContext;
        this._lockingContext = lockingContext;
        this._threadSystem = threadSystem;
        this._logging = logging;
        this._lockingInterfaces = new Hashtable();
        this._configManager = cm;
        if (this._clusterManager != null) {
            this._messageContext = this._clusterManager.getMessageContext("ConfigurationManager");
        }
        try {
            if (this._messageContext != null) {
                this._messageContext.registerListener(this);
            }
        }
        catch (ListenerAlreadyRegisteredException e) {
            throw new ConfigurationException((Exception)((Object)e), "kernel_1523");
        }
        if (this._clusterManager != null) {
            try {
                this._clusterManager.registerClusterListener((ClusterEventListener)this, "ConfigurationManager");
            }
            catch (ListenerAlreadyRegisteredException e) {
                Environment.getInstance().getLogging().logThrowable((Throwable)((Object)e));
            }
        }
    }

    public void receive(int clusterId, int messageType, byte[] body, int offset, int length) {
        throw new RuntimeException("Asynchronous messages are not allowed in " + this.getClass().getName());
    }

    public MessageAnswer receiveWait(int clusterId, int messageType, byte[] body, int offset, int length) throws Exception {
        EnvironmentListener environmentListener = this._environmentListener;
        if (environmentListener == null) {
            return new MessageAnswer(new byte[0]);
        }
        try {
            try {
                ConfigurationMessageAnswer cAnswer = environmentListener.receive(clusterId, messageType, body, offset, length);
                MessageAnswer messageAnswer = new MessageAnswer(cAnswer.getMessage());
                Object var10_10 = null;
                if (this._poolContext != null) {
                    this._poolContext.release(body);
                }
                return messageAnswer;
            }
            catch (ConfigurationException e) {
                this.getLogging().logThrowable("Message could not received! See stacktrace for details.", (Throwable)((Object)e));
                throw e;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_11 = null;
                if (this._poolContext == null) break block6;
                this._poolContext.release(body);
            }
            throw throwable;
        }
    }

    public void setEnvironmentListener(EnvironmentListener listener) {
        if (this._environmentListener != null) {
            throw new RuntimeException("The EnvironmentListener is already set. You must unset the old listener before setting a new one.");
        }
        this._environmentListener = listener;
    }

    public void unsetEnvironmentListener() {
        this._environmentListener = null;
    }

    public EnvironmentListener getEnvironmentListener() {
        return this._environmentListener;
    }

    public ConfigurationMessageAnswer[] send(int messageType, byte[] message, boolean acceptPartialResponse) throws ConfigurationException {
        try {
            MultipleAnswer answer = null;
            try {
                answer = this._messageContext.sendAndWaitForAnswer(-1, (byte)-1, messageType, message, 0, message.length, 180000L);
            }
            catch (PartialResponseException e) {
                this.getLogging().traceThrowable(3, null, (Throwable)((Object)e));
                answer = e.getPartialResponse();
            }
            int[] ids = answer.participants();
            ArrayList<ConfigurationMessageAnswer> resultList = new ArrayList<ConfigurationMessageAnswer>(ids.length);
            int i = 0;
            while (i < ids.length) {
                block9: {
                    try {
                        MessageAnswer cAnswer = answer.getAnswer(ids[i]);
                        resultList.add(new ConfigurationMessageAnswer(cAnswer.getMessage(), cAnswer.getOffset(), cAnswer.getLength()));
                    }
                    catch (NoListenerOnDestinationException noListener) {
                        this.getLogging().traceThrowable(3, null, (Throwable)((Object)noListener));
                        this.getLogging().log((byte)2, "synchronous message could not be delivered to Configuration Manager on Cluster Node " + ids[i] + "! Node is processing shutdown, no listener is registered anymore! ");
                    }
                    catch (DestinationLostException destLost) {
                        this.getLogging().traceThrowable(3, null, (Throwable)((Object)destLost));
                        this.getLogging().log((byte)2, "synchronous message could not be delivered to Configuration Manager on Cluster Node " + ids[i] + "! Node was shutdown, destination lost ! ");
                    }
                    catch (ClusterException e) {
                        this.getLogging().logThrowable((Throwable)((Object)e));
                        if (acceptPartialResponse) break block9;
                        throw e;
                    }
                }
                ++i;
            }
            ConfigurationMessageAnswer[] result = new ConfigurationMessageAnswer[resultList.size()];
            resultList.toArray(result);
            return result;
        }
        catch (ClusterException e) {
            throw new ConfigurationException((Exception)((Object)e), "kernel_1524", new Object[]{e.getMessage()});
        }
    }

    public ConfigurationMessageAnswer sendToOneNode(int node, int messageType, byte[] message) throws ConfigurationException {
        try {
            MessageAnswer answer = this._messageContext.sendAndWaitForAnswer(node, messageType, message, 0, message.length, 180000L);
            return new ConfigurationMessageAnswer(answer.getMessage(), answer.getOffset(), answer.getLength());
        }
        catch (ClusterException e) {
            throw new ConfigurationException((Exception)((Object)e), "kernel_1506", new Object[]{e.getMessage()});
        }
    }

    public Logging getLogging() {
        return this._logging;
    }

    public void startThread(Runnable runnable) {
        this._threadSystem.startThread(runnable, true);
    }

    public void startThread(Runnable runnable, int priority) {
        this._threadSystem.startThread(runnable, true);
    }

    public void addLock(String owner, String area, String key, boolean exclusive) throws ConfigurationLockedException, ConfigurationException {
        if (this._lockingContext == null) {
            return;
        }
        ServerInternalLocking locking = (ServerInternalLocking)this._lockingInterfaces.get(owner);
        if (locking == null) {
            throw new ConfigurationException("kernel_1522", new Object[]{owner});
        }
        try {
            char type = exclusive ? (char)'X' : 'S';
            locking.lock(this.addNamespace(area), key, type);
        }
        catch (LockException e) {
            throw new ConfigurationLockedException((Exception)((Object)e), "kernel_1670");
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1530", new Object[]{e.getMessage()});
        }
    }

    public void addLock(String owner, String area, String key, boolean exclusive, boolean fillWithWildcards) throws ConfigurationLockedException, ConfigurationException {
        if (fillWithWildcards) {
            key = this.fillKeyWithWildcards(key);
        }
        this.addLock(owner, area, key, exclusive);
    }

    public void addLock(String owner, String[] area, String[] key, boolean[] exclusive) throws ConfigurationLockedException, ConfigurationException {
        if (this._lockingContext == null) {
            return;
        }
        ServerInternalLocking locking = (ServerInternalLocking)this._lockingInterfaces.get(owner);
        if (locking == null) {
            throw new ConfigurationException("kernel_1522", new Object[]{owner});
        }
        char[] type = new char[exclusive.length];
        int i = 0;
        while (i < exclusive.length) {
            type[i] = exclusive[i] ? 88 : 83;
            ++i;
        }
        String[] areaNS = new String[area.length];
        int i2 = 0;
        while (i2 < area.length) {
            areaNS[i2] = this.addNamespace(area[i2]);
            ++i2;
        }
        try {
            locking.lock(areaNS, key, type);
        }
        catch (LockException e) {
            throw new ConfigurationLockedException((Exception)((Object)e), e.getMessage());
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1530", new Object[]{e.getMessage()});
        }
    }

    public void addLock(String owner, String[] area, String[] key, boolean[] exclusive, boolean fillWithWildcards) throws ConfigurationLockedException, ConfigurationException {
        String[] filled = key;
        if (fillWithWildcards) {
            filled = new String[key.length];
            int i = 0;
            while (i < key.length) {
                filled[i] = this.fillKeyWithWildcards(key[i]);
                ++i;
            }
        }
        this.addLock(owner, area, filled, exclusive);
    }

    public void removeLock(String owner, String area, String key, boolean exclusive) throws ConfigurationException {
        if (this._lockingContext == null) {
            return;
        }
        ServerInternalLocking locking = (ServerInternalLocking)this._lockingInterfaces.get(owner);
        if (locking == null) {
            throw new ConfigurationException("kernel_1522", new Object[]{owner});
        }
        try {
            char type = exclusive ? (char)'X' : 'S';
            locking.unlock(this.addNamespace(area), key, type, true);
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1530", new Object[]{e.getMessage()});
        }
    }

    public void removeLock(String owner, String area, String key, boolean exclusive, boolean fillWithWildcards) throws ConfigurationException {
        if (fillWithWildcards) {
            key = this.fillKeyWithWildcards(key);
        }
        this.removeLock(owner, area, key, exclusive);
    }

    public void removeLock(String owner, String[] area, String[] key, boolean[] exclusive) throws ConfigurationException {
        if (this._lockingContext == null) {
            return;
        }
        ServerInternalLocking locking = (ServerInternalLocking)this._lockingInterfaces.get(owner);
        if (locking == null) {
            throw new ConfigurationException("kernel_1522", new Object[]{owner});
        }
        char[] type = new char[exclusive.length];
        int i = 0;
        while (i < exclusive.length) {
            type[i] = exclusive[i] ? 88 : 83;
            ++i;
        }
        String[] areaNS = new String[area.length];
        int i2 = 0;
        while (i2 < area.length) {
            areaNS[i2] = this.addNamespace(area[i2]);
            ++i2;
        }
        try {
            locking.unlock(areaNS, key, type, true);
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1530", new Object[]{e.getMessage()});
        }
    }

    public void removeLock(String owner, String[] area, String[] key, boolean[] exclusive, boolean fillWithWildcards) throws ConfigurationException {
        String[] filled = key;
        if (fillWithWildcards) {
            filled = new String[key.length];
            int i = 0;
            while (i < key.length) {
                filled[i] = this.fillKeyWithWildcards(key[i]);
                ++i;
            }
        }
        this.removeLock(owner, area, filled, exclusive);
    }

    public void removeAllLocks(String owner) throws ConfigurationException {
        if (this._lockingContext == null) {
            return;
        }
        ServerInternalLocking locking = (ServerInternalLocking)this._lockingInterfaces.get(owner);
        if (locking == null) {
            throw new ConfigurationException("kernel_1522", new Object[]{owner});
        }
        try {
            locking.unlockAll(true);
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1530", new Object[]{e.getMessage()});
        }
    }

    public String createUniqueOwner() throws ConfigurationException {
        if (this._lockingContext == null) {
            return null;
        }
        try {
            ServerInternalLocking locking = this._lockingContext.createServerInternalLocking(LOCKING_NAMESPACE, LOCKING_NAMESPACE_DESCRIPTION);
            this._lockingInterfaces.put(locking.getUniqueOwner(), locking);
            return locking.getUniqueOwner();
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "kernel_1530", new Object[]{e.getMessage()});
        }
    }

    public void releaseUniqueOwner(String uniqueOwner) {
        if (this._lockingContext == null) {
            return;
        }
        this._lockingInterfaces.remove(uniqueOwner);
    }

    public String fillKeyWithWildcards(String key) {
        return UTIL.adjustStringLengthRight(key, 150, '@');
    }

    public ConfigurationHandlerFactory getConfigurationHandlerFactory() {
        return this._configManager;
    }

    public Crypter getCryptoUtility() throws ConfigurationException {
        if (this._crypter == null) {
            throw new ConfigurationException("kernel_1500", new Object[]{"Cryto Utility still not initialitzed in this Environment"});
        }
        return this._crypter;
    }

    public void registerCryptoUtility(Crypter cryptoUtil) {
        this._crypter = cryptoUtil;
    }

    public void elementJoin(ClusterElement element) {
        if (this._environmentListener == null) {
            return;
        }
        this._environmentListener.clusterElementJoined(element.getClusterId());
    }

    public void elementLoss(ClusterElement element) {
        if (this._environmentListener == null) {
            return;
        }
        this._environmentListener.clusterElementLost(element.getClusterId());
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
    }

    public int getLocalClusterID() {
        if (this._clusterManager != null) {
            return this._clusterManager.getClusterMonitor().getCurrentParticipant().getClusterId();
        }
        return 0;
    }

    public void deinitialize() {
        if (this._clusterManager != null) {
            this._clusterManager.unregisterClusterListener("ConfigurationManager");
        }
        if (this._messageContext != null) {
            this._messageContext.unregisterListener();
        }
    }

    private String addNamespace(String area) {
        if (area == null) {
            return null;
        }
        return LOCKING_NAMESPACE + area;
    }
}

