/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ConfigurationHandlerImpl;
import com.sap.engine.core.configuration.impl.ConfigurationImpl;
import com.sap.engine.core.configuration.impl.FileEntry;
import com.sap.engine.core.configuration.impl.PersistentDataInputStream;
import com.sap.engine.core.configuration.impl.cache.CachedConfiguration;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.Semaphore;
import com.sap.engine.core.configuration.impl.utilities.SequenceGenerator;
import com.sap.engine.core.configuration.impl.utilities.transfer.ConfigExporter;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReadAccessConfiguration
extends ConfigurationImpl {
    private long m_timeStamp;
    private CachedConfiguration m_cached;

    protected ReadAccessConfiguration() {
    }

    public ReadAccessConfiguration(CachedConfiguration cached, ConfigurationHandler handler, Configuration openRoot) {
        this.m_cached = cached;
        this.m_path = cached.getPath();
        this.m_cid = cached.getId();
        this.m_handler = (ConfigurationHandlerImpl)handler;
        this.m_timeStamp = SequenceGenerator.getNext();
        if (openRoot == null) {
            openRoot = this;
        }
        this.m_openRoot = (ReadAccessConfiguration)openRoot;
    }

    public ReadAccessConfiguration(ConfigurationPath path, long cid, ConfigurationHandler handler, Configuration openRoot) {
        this.m_cid = cid;
        this.m_path = path;
        this.m_timeStamp = Long.MAX_VALUE;
        this.m_handler = (ConfigurationHandlerImpl)handler;
        if (openRoot == null) {
            openRoot = this;
        }
        this.m_openRoot = (ReadAccessConfiguration)openRoot;
    }

    protected ConfigurationData getData() throws ConfigurationException {
        try {
            try {
                ReadAccessConfiguration readAccessConfiguration = this;
                synchronized (readAccessConfiguration) {
                    if (this.m_cached == null) {
                        this.m_cached = this.m_handler.getCachedConfiguration(this.m_path, this.m_cid);
                        this.m_timeStamp = SequenceGenerator.getNext();
                    }
                }
            }
            catch (NameNotFoundException e0) {
                throw new InconsistentReadException((Exception)((Object)e0));
            }
            ConfigurationData data = this.m_cached.prepareRead(this.m_timeStamp);
            return data;
        }
        catch (InconsistentReadException e) {
            this.m_openRoot.setValidityFlag(2);
            throw e;
        }
    }

    protected void releaseData(ConfigurationData data) {
        if (this.m_cached == null) {
            return;
        }
        this.m_cached.releaseData(data);
    }

    private void getSemaphoreLock(int type) throws ConfigurationException {
    }

    private void releaseSemaphoreLock(int type) throws ConfigurationException {
    }

    protected long getOpenTimeStamp() {
        return this.m_timeStamp;
    }

    public long getId() {
        return this.m_cid;
    }

    protected void validityCheck() throws ConfigurationException {
        if (this.m_openRoot.getValidityFlag() == 1) {
            throw new ConfigurationException("kernel_1521", new Object[]{this.getPath(), "closed"});
        }
        if (this.m_openRoot.getValidityFlag() == 2) {
            throw new InconsistentReadException("kernel_1521");
        }
    }

    protected void consistencyCheck() throws InconsistentReadException {
        try {
            this.m_cached.consistencyCheck(this.m_timeStamp);
        }
        catch (InconsistentReadException e) {
            this.m_openRoot.setValidityFlag(2);
            throw e;
        }
    }

    public void setCacheMode(int mode) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public int getCacheMode() throws ConfigurationException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            int n = data.getCacheMode();
            Object var4_3 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return n;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public ConfigMetaData getMetaData() throws ConfigurationException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            ConfigMetaDataImpl configMetaDataImpl = data.getConfigParams();
            Object var4_3 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return configMetaDataImpl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Configuration createSubConfiguration(String name) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public Map createSubConfigurations(String[] names) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public Configuration createSubConfiguration(String name, int type) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public Map createSubConfigurations(String[] names, int type) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public Configuration createSubConfigurationHierachy(String relPath) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteConfiguration(String name) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteConfiguration() throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteSubConfigurations(String[] names) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteAllSubConfigurations() throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void addConfigEntry(String name, Object value) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void addConfigEntries(Map list) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void modifyConfigEntry(String name, Object value) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void modifyConfigEntries(Map list) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteConfigEntry(String name) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteConfigEntries(String[] names) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteAllConfigEntries() throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void addFileEntry(File file) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void addFileEntryByKey(String key, File file) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void addFileAsStream(String name, InputStream stream) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void addFileEntries(File[] list) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void addFileEntriesByKey(Map list) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFile(File file) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFileByKey(String key, File file) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFileAsStream(String name, InputStream stream) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFiles(File[] files) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFilesByKey(Map list) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteFile(String file) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteFiles(String[] files) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void deleteAllFiles() throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void modifyConfigEntry(String name, Object value, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException, InvalidValueException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFile(File file, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFileAsStream(String name, InputStream stream, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void updateFileByKey(String key, File file, boolean createIfNotExist) throws ConfigurationException, NoWriteAccessException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void importAsSubConfiguration(String sourcePath) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public void importContent(String sourcePath) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException {
        throw new NoWriteAccessException("kernel_1660", new Object[]{this.getPath()});
    }

    public Configuration getSubConfiguration(String relativePath) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        if (relativePath.indexOf("/") != -1) {
            this.validityCheck();
            Configuration config = this.m_handler.getSubConfiguration((Configuration)this, relativePath);
            return config;
        }
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            ConfigMetaDataImpl subentry = data.getSubConfiguration(relativePath);
            this.consistencyCheck();
            Configuration configuration = this.m_handler.getSubConfiguration((Configuration)this, subentry);
            Object var6_6 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return configuration;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_7 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block4;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Map getSubConfigurations(String[] names) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            Collection collection = data.getSubConfigurations(names);
            this.consistencyCheck();
            ConfigMetaDataImpl[] entries = new ConfigMetaDataImpl[collection.size()];
            entries = collection.toArray(entries);
            Map map = this.m_handler.getSubConfigurations(this, entries);
            Object var7_6 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return map;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_7 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Map getAllSubConfigurations() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            Collection collection = data.getAllSubConfigurations();
            this.consistencyCheck();
            ConfigMetaDataImpl[] entries = new ConfigMetaDataImpl[collection.size()];
            entries = collection.toArray(entries);
            Map map = this.m_handler.getSubConfigurations(this, entries);
            Object var6_5 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return map;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public String[] getAllSubConfigurationNames() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            String[] names = data.getAllSubConfigurationNames();
            this.consistencyCheck();
            String[] stringArray = names;
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public ConfigMetaData[] getAllSubConfigurationMetaData() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            Collection coll = data.getAllSubConfigurations();
            this.consistencyCheck();
            ConfigMetaData[] configMetaDataArray = coll.toArray(new ConfigMetaData[0]);
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return configMetaDataArray;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Object getConfigEntry(String name) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            Object val = data.getValue(name);
            this.consistencyCheck();
            Object object = val;
            Object var6_5 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return object;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Map getConfigEntries(String[] names) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            Map vals = data.getValues(names);
            this.consistencyCheck();
            Map map = vals;
            Object var6_5 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return map;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Map getAllConfigEntries() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            Map vals = data.getAllValues();
            this.consistencyCheck();
            Map map = vals;
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return map;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public String[] getAllConfigEntryNames() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            String[] names = data.getAllValueNames();
            this.consistencyCheck();
            String[] stringArray = names;
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public InputStream getFile(String name) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            FileEntry f = data.getFileEntry(name);
            this.consistencyCheck();
            PersistentDataInputStream persistentDataInputStream = new PersistentDataInputStream(f, this, this.m_handler.getConfigurationCache());
            Object var6_5 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return persistentDataInputStream;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Map getFileEntries(String[] names) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            HashMap<String, PersistentDataInputStream> result = new HashMap<String, PersistentDataInputStream>();
            Iterator it = data.getFileEntries(names).iterator();
            this.consistencyCheck();
            while (it.hasNext()) {
                FileEntry entry = (FileEntry)it.next();
                result.put(entry.getName(), new PersistentDataInputStream(entry, this, this.m_handler.getConfigurationCache()));
            }
            HashMap<String, PersistentDataInputStream> hashMap = result;
            Object var7_6 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            block4: {
                Object var7_7 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block4;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Map getAllFileEntries() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            HashMap<String, PersistentDataInputStream> result = new HashMap<String, PersistentDataInputStream>();
            Iterator it = data.getAllFileEntries().iterator();
            this.consistencyCheck();
            while (it.hasNext()) {
                FileEntry entry = (FileEntry)it.next();
                result.put(entry.getName(), new PersistentDataInputStream(entry, this, this.m_handler.getConfigurationCache()));
            }
            HashMap<String, PersistentDataInputStream> hashMap = result;
            Object var6_5 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_6 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block4;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public String[] getAllFileEntryNames() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            String[] names = data.getAllFileNames();
            this.consistencyCheck();
            String[] stringArray = names;
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return stringArray;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public boolean existsSubConfiguration(String name) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            boolean bl = data.existsSubConfiguration(name);
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public boolean existsConfigEntry(String name) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            boolean bl = data.existsValue(name);
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public boolean existsFile(String name) throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            boolean bl = data.existsFileEntry(name);
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public Map getAllValueEntries() throws ConfigurationException, InconsistentReadException {
        ConfigurationData data = null;
        try {
            this.getSemaphoreLock(Semaphore.SHARED);
            this.validityCheck();
            data = this.getData();
            Map vals = data.getAllValueEntries();
            this.consistencyCheck();
            Map map = vals;
            Object var5_4 = null;
            this.releaseSemaphoreLock(Semaphore.SHARED);
            if (data != null) {
                this.releaseData(data);
            }
            return map;
        }
        catch (Throwable throwable) {
            block3: {
                Object var5_5 = null;
                this.releaseSemaphoreLock(Semaphore.SHARED);
                if (data == null) break block3;
                this.releaseData(data);
            }
            throw throwable;
        }
    }

    public void export(String destinationPath) throws ConfigurationException {
        ConfigExporter exporter = new ConfigExporter();
        exporter.export(this, destinationPath);
    }
}

