/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigurationImpl;
import com.sap.engine.core.configuration.impl.FileEntry;
import com.sap.engine.core.configuration.impl.ReadAccessConfiguration;
import com.sap.engine.core.configuration.impl.WriteAccessConfiguration;
import com.sap.engine.core.configuration.impl.cache.ConfigurationCache;
import com.sap.engine.core.configuration.impl.persistence.rdbms.FileLoader;
import com.sap.engine.core.configuration.impl.utilities.CloneableByteArrayInputStream;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.InvalidPersistentDataStreamException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PersistentDataInputStream
extends InputStream {
    private FileEntry m_fileentry;
    private ConfigurationImpl m_configuration;
    private InputStream m_inStream;
    private ConfigurationCache m_cache;
    private FileLoader m_loader;
    private boolean m_closed = false;

    public PersistentDataInputStream(FileEntry fileentry, Configuration config, ConfigurationCache cache) {
        this.m_fileentry = fileentry;
        this.m_configuration = (ConfigurationImpl)config;
        this.m_cache = cache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getStream() throws InvalidPersistentDataStreamException {
        if (this.m_closed) {
            throw new InvalidPersistentDataStreamException("Stream is already closed");
        }
        if (this.m_inStream != null) {
            return this.m_inStream;
        }
        try {
            this.m_configuration.validityCheck();
            if (!(this.m_configuration instanceof WriteAccessConfiguration)) {
                ((ReadAccessConfiguration)this.m_configuration).consistencyCheck();
            }
        }
        catch (Exception e) {
            this.m_closed = true;
            throw new InvalidPersistentDataStreamException("PersistentDataInputStream is invalid", e);
        }
        if (this.m_fileentry.getStatus() == 1) {
            InputStream input = this.m_fileentry.getStream();
            if (input != null) {
                if (!(input instanceof CloneableByteArrayInputStream)) {
                    this.m_closed = true;
                    throw new InvalidPersistentDataStreamException("You need to commit before reading again from the stream used to create this file entry.");
                }
                try {
                    CloneableByteArrayInputStream clByteStream = (CloneableByteArrayInputStream)input;
                    this.m_inStream = (CloneableByteArrayInputStream)clByteStream.clone();
                    return this.m_inStream;
                }
                catch (CloneNotSupportedException e) {
                    this.m_closed = true;
                    throw new InvalidPersistentDataStreamException("The CloneableByteArrayInputStream was already closed before the commit.", e);
                }
            }
            try {
                this.m_inStream = new FileInputStream(this.m_fileentry.getFile());
                return this.m_inStream;
            }
            catch (IOException e) {
                this.m_closed = true;
                throw new InvalidPersistentDataStreamException("Could not open stream on file " + this.m_fileentry.getFile().getPath(), e);
            }
        }
        if (this.m_fileentry.getStatus() != 4 && this.m_fileentry.getStatus() != 2) {
            this.m_closed = true;
            throw new InvalidPersistentDataStreamException("Status of file entry is invalid.");
        }
        try {
            this.m_loader = this.m_cache.readPersistentFile(this.m_configuration.getId(), this.m_fileentry.getName());
            this.m_inStream = this.m_loader.getInputStream();
            return this.m_inStream;
        }
        catch (Exception e) {
            this.m_closed = true;
            throw new InvalidPersistentDataStreamException("Could not get file from DB.", e);
        }
    }

    public int available() throws IOException {
        return this.getStream().available();
    }

    public void close() throws IOException {
        try {
            if (!this.m_closed) {
                if (this.m_inStream != null) {
                    this.getStream().close();
                }
                if (this.m_loader != null) {
                    this.m_loader.close();
                }
                this.m_closed = true;
            }
        }
        catch (Exception e) {
            throw new InvalidPersistentDataStreamException("Error closing input stream on file.", e);
        }
    }

    public int read() throws IOException {
        if (this.m_closed) {
            return -1;
        }
        int received = this.getStream().read();
        if (received == -1) {
            this.close();
        }
        return received;
    }

    public int read(byte[] b) throws IOException {
        if (this.m_closed) {
            return -1;
        }
        int received = this.getStream().read(b);
        if (received == -1) {
            this.close();
        }
        return received;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.m_closed) {
            return -1;
        }
        int received = this.getStream().read(b, off, len);
        if (received == -1) {
            this.close();
        }
        return received;
    }

    public long skip(long n) throws IOException {
        return this.getStream().skip(n);
    }
}

