/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.utilities.PropertyUtil;
import com.sap.engine.core.configuration.impl.utilities.Utils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class Logging {
    public static final byte DEBUG = 0;
    public static final byte TRACE = 1;
    public static final byte INFO = 2;
    public static final byte NOTICE = 3;
    public static final byte WARNING = 4;
    public static final byte ERROR = 5;
    public static final byte CRITICAL = 6;
    public static final byte ALERT = 7;
    public static final byte EMERGENCY = 8;
    private static final int[] SEVERITY_NEW = new int[]{100, 701, 300, 300, 400, 500, 600, 500, 700};
    private static final int[] TRACELEVEL_NEW = new int[]{701, 300, 200, 100};
    private static final PropertyUtil UTIL = new PropertyUtil();
    public static final String LOGGING_LOCATION_NAME = "com.sap.engine.core.configuration";
    private static final Category STD_CATEGORY = Category.getCategory((String)"/System/Server");
    private static final Location STD_LOCATION = Location.getLocation((String)"com.sap.engine.core.configuration");
    private int _tracelevel;
    private PrintStream _printStream;

    public Logging() {
    }

    public Logging(Properties loggingProps) {
        PropertiesConfigurator pc = new PropertiesConfigurator(loggingProps);
        pc.configure();
    }

    public Logging(PrintStream s) {
        this._printStream = s;
    }

    public final int transformSeverity(int oldSeverity) {
        if (oldSeverity < 0 || oldSeverity >= SEVERITY_NEW.length) {
            return 701;
        }
        return SEVERITY_NEW[oldSeverity];
    }

    public final int transformTracelevel(int tracelevel) {
        if (tracelevel < 0) {
            return 701;
        }
        if (tracelevel >= TRACELEVEL_NEW.length) {
            return 100;
        }
        return TRACELEVEL_NEW[tracelevel];
    }

    public void log(byte mode, String message) {
        if (this._printStream == null) {
            STD_CATEGORY.logT(this.transformSeverity(mode), STD_LOCATION, message);
        } else {
            this._printStream.println(message);
        }
    }

    public void logThrowable(String text, Throwable t, byte mode) {
        StringWriter stringWriter = new StringWriter(1000);
        PrintWriter writer = new PrintWriter(stringWriter);
        if (text != null) {
            writer.print(text);
            writer.println(":");
        }
        writer.println(t.getMessage());
        writer.println("=======================================================");
        t.printStackTrace(writer);
        writer.flush();
        stringWriter.flush();
        String message = stringWriter.toString();
        this.log(mode, message);
    }

    public void logThrowable(Throwable t) {
        this.logThrowable(null, t, (byte)5);
    }

    public void logThrowable(Throwable t, byte mode) {
        this.logThrowable(null, t, (byte)5);
    }

    public void logThrowable(String text, Throwable t) {
        this.logThrowable(text, t, (byte)5);
    }

    public final void trace(int tracelevel, String location, Object[] messageparts) {
        if (!STD_LOCATION.beLogged(this.transformTracelevel(tracelevel))) {
            return;
        }
        StringBuffer s = new StringBuffer(256);
        s.append(location);
        int i = 0;
        while (i < messageparts.length) {
            this.appendWithArrayHandling(s, messageparts[i]);
            ++i;
        }
        if (this._printStream == null) {
            STD_LOCATION.logT(this.transformTracelevel(tracelevel), s.toString());
        } else {
            this._printStream.println(s.toString());
        }
    }

    public final void trace(int tracelevel, String location, Object message) {
        if (!STD_LOCATION.beLogged(this.transformTracelevel(tracelevel))) {
            return;
        }
        this.trace(tracelevel, location, new Object[]{message});
    }

    public final void trace(int tracelevel, String location, Object m1, Object m2) {
        if (!STD_LOCATION.beLogged(this.transformTracelevel(tracelevel))) {
            return;
        }
        this.trace(tracelevel, location, new Object[]{m1, m2});
    }

    public final void trace(int tracelevel, String location, Object m1, Object m2, Object m3) {
        if (!STD_LOCATION.beLogged(this.transformTracelevel(tracelevel))) {
            return;
        }
        this.trace(tracelevel, location, new Object[]{m1, m2, m3});
    }

    public final void trace(int tracelevel, String location, Object m1, Object m2, Object m3, Object m4) {
        if (!STD_LOCATION.beLogged(this.transformTracelevel(tracelevel))) {
            return;
        }
        this.trace(tracelevel, location, new Object[]{m1, m2, m3, m4});
    }

    public void logMessage(byte mode, String message, String parameter) {
        STD_CATEGORY.logT(this.transformSeverity(mode), STD_LOCATION, message, new Object[]{parameter});
    }

    public void traceThrowable(int traceLevel, String message, Throwable t) {
        if (!STD_LOCATION.beLogged(this.transformTracelevel(traceLevel))) {
            return;
        }
        if (message != null || message.equals("")) {
            if (this._printStream == null) {
                STD_CATEGORY.log(2, STD_LOCATION, (Object)(message + " See trace file for details."));
            } else {
                this._printStream.println(message + " See trace file for details.");
            }
        }
        String stackTraceString = Utils.getStackTrace(t);
        if (this._printStream == null) {
            STD_LOCATION.logT(this.transformTracelevel(traceLevel), stackTraceString);
        } else {
            this._printStream.println(stackTraceString);
        }
    }

    public void appendWithArrayHandling(StringBuffer s, Object o) {
        if (o == null) {
            s.append(o);
        } else if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof char[]) {
            char[] array = (char[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof int[]) {
            int[] array = (int[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof long[]) {
            long[] array = (long[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else if (o instanceof boolean[]) {
            boolean[] array = (boolean[])o;
            s.append("[");
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    s.append(", ");
                }
                s.append(array[i]);
                ++i;
            }
            s.append("]");
        } else {
            s.append(o);
        }
    }
}

