/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.frame.core.configuration.InvalidValueException;
import java.io.File;
import java.io.InputStream;

public class FileEntry {
    public static final int UNDEFINED_STREAM_LENGTH = -10;
    public static final int STATUS_UNCOMMITED = 1;
    public static final int STATUS_COMMITED = 2;
    public static final int STATUS_ROLLED_BACK = 3;
    public static final int STATUS_READ_FROM_DB = 4;
    private String name = null;
    private File file = null;
    private InputStream in = null;
    private int streamLength = -10;
    private int status;

    public static FileEntry createFileEntry(String name) throws InvalidValueException {
        return new FileEntry(name);
    }

    private FileEntry(String name) throws InvalidValueException {
        if (name == null || name.equals("")) {
            throw new InvalidValueException("kernel_1620", new Object[]{name});
        }
        this.name = name;
        this.status = 4;
    }

    protected FileEntry(File file) throws InvalidValueException {
        if (file == null) {
            throw new InvalidValueException("kernel_1620", new Object[]{this.name});
        }
        this.file = file;
        this.name = file.getName();
        this.status = 1;
    }

    protected FileEntry(String name, InputStream in) throws InvalidValueException {
        if (in == null) {
            throw new InvalidValueException("kernel_1620", new Object[]{name});
        }
        this.name = name;
        this.in = in;
        this.status = 1;
    }

    protected FileEntry(String name, InputStream in, int streamLength) throws InvalidValueException {
        if (in == null) {
            throw new InvalidValueException("kernel_1620", new Object[]{name});
        }
        this.name = name;
        this.in = in;
        this.streamLength = streamLength;
        this.status = 1;
    }

    protected FileEntry(String name, File file) throws InvalidValueException {
        if (file == null) {
            throw new InvalidValueException("kernel_1620", new Object[]{name});
        }
        this.name = name;
        this.file = file;
        this.status = 1;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getStream() {
        return this.in;
    }

    public int getStreamLength() {
        return this.streamLength;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        if (status == 2) {
            this.file = null;
            this.in = null;
        }
    }
}

