/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigurationMessageAnswer;
import com.sap.engine.core.configuration.impl.EnvironmentListener;
import com.sap.engine.core.configuration.impl.Logging;
import com.sap.engine.core.configuration.impl.security.Crypter;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;

public abstract class Environment {
    private static Environment m_environment;

    public static void init(Environment environment) {
        m_environment = environment;
    }

    public static void shutdown() {
        if (m_environment == null) {
            throw new RuntimeException("Environment must be initialized before usage");
        }
        m_environment.deinitialize();
    }

    public static Environment getInstance() {
        if (m_environment == null) {
            throw new RuntimeException("Environment must be initialized before usage");
        }
        return m_environment;
    }

    public abstract void deinitialize();

    public abstract void setEnvironmentListener(EnvironmentListener var1);

    public abstract void unsetEnvironmentListener();

    public abstract EnvironmentListener getEnvironmentListener();

    public abstract ConfigurationMessageAnswer[] send(int var1, byte[] var2, boolean var3) throws ConfigurationException;

    public abstract ConfigurationMessageAnswer sendToOneNode(int var1, int var2, byte[] var3) throws ConfigurationException;

    public abstract Logging getLogging();

    public abstract void startThread(Runnable var1);

    public abstract void startThread(Runnable var1, int var2);

    public abstract void addLock(String var1, String var2, String var3, boolean var4) throws ConfigurationLockedException, ConfigurationException;

    public abstract void addLock(String var1, String var2, String var3, boolean var4, boolean var5) throws ConfigurationLockedException, ConfigurationException;

    public abstract void addLock(String var1, String[] var2, String[] var3, boolean[] var4) throws ConfigurationLockedException, ConfigurationException;

    public abstract void addLock(String var1, String[] var2, String[] var3, boolean[] var4, boolean var5) throws ConfigurationLockedException, ConfigurationException;

    public abstract void removeLock(String var1, String var2, String var3, boolean var4) throws ConfigurationException;

    public abstract void removeLock(String var1, String var2, String var3, boolean var4, boolean var5) throws ConfigurationException;

    public abstract void removeLock(String var1, String[] var2, String[] var3, boolean[] var4) throws ConfigurationException;

    public abstract void removeLock(String var1, String[] var2, String[] var3, boolean[] var4, boolean var5) throws ConfigurationException;

    public abstract void removeAllLocks(String var1) throws ConfigurationException;

    public abstract String createUniqueOwner() throws ConfigurationException;

    public abstract void releaseUniqueOwner(String var1);

    public abstract ConfigurationHandlerFactory getConfigurationHandlerFactory();

    public abstract void registerCryptoUtility(Crypter var1);

    public abstract Crypter getCryptoUtility() throws ConfigurationException;

    public abstract int getLocalClusterID();
}

