/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigurationHandlerImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.addons.PropertySheetImpl;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.Semaphore;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.DeserializationFailedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.configuration.admin.ConfigEntryWrapper;
import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationInfo;
import com.sap.engine.frame.core.configuration.admin.PropertySheetExtension;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public abstract class ConfigurationImpl
implements ConfigurationExtension {
    protected ConfigurationImpl m_openRoot;
    protected ConfigurationHandlerImpl m_handler;
    protected int m_validFlag = 0;
    protected long m_cid;
    protected ConfigurationPath m_path;
    protected Semaphore m_semaphore;
    protected static final int MAX_PATH_LENGHT = 250;

    public abstract long getId();

    public String getPath() {
        return this.m_path.getPathString();
    }

    public ConfigurationPath getPathWrapper() {
        return this.m_path;
    }

    public ConfigurationHandlerImpl getConfigurationHandler() {
        return this.m_handler;
    }

    protected abstract void validityCheck() throws ConfigurationException;

    public Configuration getOpenRoot() {
        return this.m_openRoot;
    }

    protected void setValidityFlag(int flag) {
        this.m_validFlag = flag;
    }

    protected int getValidityFlag() {
        return this.m_validFlag;
    }

    public boolean isValid() {
        return this.m_validFlag == 0 && this.m_openRoot.m_validFlag == 0;
    }

    public void close() throws ConfigurationException {
        this.m_handler.closeConfiguration(this);
    }

    public String toString() {
        return this.m_path.toString();
    }

    public PropertySheet getPropertySheetInterface() throws ConfigurationException {
        return this.getPropertySheetExtensionInterface();
    }

    public int getConfigurationType() throws ConfigurationException {
        return this.getMetaData().getConfigurationType();
    }

    public byte[] getFileAsBytes(String name) throws ConfigurationException, InconsistentReadException, IOException {
        byte[] result = ConfigurationImpl.getBytes(this.getFile(name));
        return result;
    }

    public void addFileAsBytes(String name, byte[] content) throws ConfigurationException, NoWriteAccessException {
        this.addFileAsStream(name, new ByteArrayInputStream(content));
    }

    public void updateFileAsBytes(String name, byte[] content) throws ConfigurationException, NoWriteAccessException {
        this.updateFileAsStream(name, new ByteArrayInputStream(content));
    }

    public Object getConfigEntryWrapper(String name) throws ConfigurationException, InconsistentReadException {
        Object result = null;
        try {
            result = this.getConfigEntry(name);
            if (!ConfigEntryWrapper.isSupportedDatatype(result)) {
                result = new ConfigEntryWrapper(result);
            }
        }
        catch (DeserializationFailedException e) {
            Environment.getInstance().getLogging().traceThrowable(3, e.getMessage(), (Throwable)((Object)e));
            result = new ConfigEntryWrapper("Object could not be deserialized!: " + e.getCause().toString(), e.getLackingClassName());
        }
        return result;
    }

    public ConfigurationInfo[] getAllSubConfigurationInfo() throws ConfigurationException, InconsistentReadException {
        ConfigMetaData[] source = this.getAllSubConfigurationMetaData();
        ConfigurationInfo[] result = ConfigurationInfo.createCopy(source);
        return result;
    }

    public PropertySheetExtension getPropertySheetExtensionInterface() throws ConfigurationException {
        return new PropertySheetImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(InputStream in) throws IOException {
        int next;
        BufferedInputStream stream = new BufferedInputStream(in);
        ByteArrayOutputStream result = new ByteArrayOutputStream(256);
        while ((next = stream.read()) != -1) {
            void var3_3;
            result.write((int)var3_3);
        }
        return result.toByteArray();
    }

    public abstract void importContent(String var1) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException;

    public abstract void importAsSubConfiguration(String var1) throws NoWriteAccessException, NameAlreadyExistsException, ConfigurationException;

    public abstract void export(String var1) throws InconsistentReadException, ConfigurationException;

    public abstract void deleteAllFiles() throws ConfigurationException, NoWriteAccessException;

    public abstract void deleteFiles(String[] var1) throws ConfigurationException, NoWriteAccessException;

    public abstract void deleteFile(String var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract Map getAllFileEntries() throws ConfigurationException, InconsistentReadException;

    public abstract String[] getAllFileEntryNames() throws ConfigurationException, InconsistentReadException;

    public abstract Map getFileEntries(String[] var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public abstract InputStream getFile(String var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public abstract void updateFilesByKey(Map var1) throws ConfigurationException, NoWriteAccessException;

    public abstract void updateFiles(File[] var1) throws ConfigurationException, NoWriteAccessException;

    public abstract void updateFileAsStream(String var1, InputStream var2, boolean var3) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract void updateFileAsStream(String var1, InputStream var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract boolean existsFile(String var1) throws ConfigurationException, InconsistentReadException;

    public abstract void updateFileByKey(String var1, File var2, boolean var3) throws ConfigurationException, NoWriteAccessException;

    public abstract void updateFileByKey(String var1, File var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract void updateFile(File var1, boolean var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract void updateFile(File var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract void addFileEntriesByKey(Map var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract void addFileEntries(File[] var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract void addFileEntry(File var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract void addFileEntryByKey(String var1, File var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract void addFileAsStream(String var1, InputStream var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract void deleteAllConfigEntries() throws ConfigurationException, NoWriteAccessException;

    public abstract void deleteConfigEntries(String[] var1) throws ConfigurationException, NoWriteAccessException;

    public abstract void deleteConfigEntry(String var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract String[] getAllConfigEntryNames() throws ConfigurationException, InconsistentReadException;

    public abstract Map getAllConfigEntries() throws ConfigurationException, InconsistentReadException;

    public abstract Map getConfigEntries(String[] var1) throws ConfigurationException, InconsistentReadException;

    public abstract Object getConfigEntry(String var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public abstract void modifyConfigEntries(Map var1) throws ConfigurationException, NoWriteAccessException, InvalidValueException;

    public abstract void modifyConfigEntry(String var1, Object var2, boolean var3) throws ConfigurationException, NameNotFoundException, NoWriteAccessException, InvalidValueException;

    public abstract void modifyConfigEntry(String var1, Object var2) throws ConfigurationException, NameNotFoundException, NoWriteAccessException, InvalidValueException;

    public abstract boolean existsConfigEntry(String var1) throws ConfigurationException, InconsistentReadException;

    public abstract void addConfigEntries(Map var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException, InvalidValueException;

    public abstract void addConfigEntry(String var1, Object var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException, InvalidValueException;

    public abstract void deleteAllSubConfigurations() throws ConfigurationException, NoWriteAccessException;

    public abstract void deleteSubConfigurations(String[] var1) throws ConfigurationException, NoWriteAccessException;

    public abstract void deleteConfiguration() throws ConfigurationException, NoWriteAccessException;

    public abstract void deleteConfiguration(String var1) throws ConfigurationException, NameNotFoundException, NoWriteAccessException;

    public abstract ConfigMetaData[] getAllSubConfigurationMetaData() throws ConfigurationException, InconsistentReadException;

    public abstract String[] getAllSubConfigurationNames() throws ConfigurationException, InconsistentReadException;

    public abstract Map getAllSubConfigurations() throws ConfigurationException, InconsistentReadException;

    public abstract Map getSubConfigurations(String[] var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public abstract Configuration getSubConfiguration(String var1) throws ConfigurationException, NameNotFoundException, InconsistentReadException;

    public abstract boolean existsSubConfiguration(String var1) throws ConfigurationException, InconsistentReadException;

    public abstract Configuration createSubConfigurationHierachy(String var1) throws ConfigurationException, NoWriteAccessException;

    public abstract Map createSubConfigurations(String[] var1, int var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract Configuration createSubConfiguration(String var1, int var2) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract Map createSubConfigurations(String[] var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract Configuration createSubConfiguration(String var1) throws ConfigurationException, NameAlreadyExistsException, NoWriteAccessException;

    public abstract ConfigMetaData getMetaData() throws ConfigurationException;

    public abstract int getCacheMode() throws ConfigurationException;

    public abstract void setCacheMode(int var1) throws ConfigurationException, NoWriteAccessException;
}

