/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ConfigurationImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.ReadAccessConfiguration;
import com.sap.engine.core.configuration.impl.TransactionInfo;
import com.sap.engine.core.configuration.impl.TransactionListener;
import com.sap.engine.core.configuration.impl.WriteAccessConfiguration;
import com.sap.engine.core.configuration.impl.cache.CachedConfiguration;
import com.sap.engine.core.configuration.impl.cache.ConfigurationCache;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.core.configuration.impl.utilities.RestrictionChecker;
import com.sap.engine.core.configuration.impl.utilities.Semaphore;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationInfo;
import java.sql.Connection;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ConfigurationHandlerImpl
implements ConfigurationHandlerExtension {
    private ConfigurationCache m_cache;
    private Map m_openForWriteConfigs;
    private Map m_openForReadConfigs;
    private String m_id;
    private String m_lockOwner;
    private volatile int m_txID = 0;
    private Properties m_props;
    private HashSet m_transactionListeners;
    private Semaphore m_semaphore;
    private static volatile long INSTANCE_COUNTER = 0L;
    private static Object GLOBAL_MONITOR = new Object();
    private Object LOCAL_MONITOR = new Object();

    public ConfigurationHandlerImpl(ConfigurationCache cache, Properties properties) {
        this.m_cache = cache;
        this.m_props = properties;
        this.m_semaphore = new Semaphore();
        this.m_openForWriteConfigs = new Hashtable();
        this.m_openForReadConfigs = new Hashtable();
        this.m_transactionListeners = new HashSet();
        int clusterId = Environment.getInstance().getLocalClusterID();
        Object object = GLOBAL_MONITOR;
        synchronized (object) {
            this.m_id = clusterId + "_" + ++INSTANCE_COUNTER;
        }
    }

    private void getTransactionAccessSemaphore(int type) {
        try {
            this.m_semaphore.getLock(type);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    private void releaseTransactionAccessSemaphore(int type) {
        try {
            this.m_semaphore.releaseLock(type);
        }
        catch (Exception e) {
            Environment.getInstance().getLogging().traceThrowable(3, null, e);
        }
    }

    public void registerTransactionListener(TransactionListener l) {
        HashSet hashSet = this.m_transactionListeners;
        synchronized (hashSet) {
            this.m_transactionListeners.add(l);
        }
    }

    public void unregisterTransactionListener(TransactionListener l) {
        HashSet hashSet = this.m_transactionListeners;
        synchronized (hashSet) {
            this.m_transactionListeners.remove(l);
        }
    }

    private void nextTransaction() {
        HashSet clone = (HashSet)this.m_transactionListeners.clone();
        String transId = this.getTransactionId();
        ++this.m_txID;
        TransactionListener[] listeners = null;
        HashSet hashSet = this.m_transactionListeners;
        synchronized (hashSet) {
            listeners = ((AbstractCollection)this.m_transactionListeners).toArray(new TransactionListener[0]);
        }
        int i = 0;
        while (i < listeners.length) {
            try {
                listeners[i].transactionFinished(transId);
            }
            catch (Throwable t) {
                Environment.getInstance().getLogging().logThrowable("An exception was thrown in listener method transactionFinished of class: " + listeners[i].getClass() + ". Please check the log files of the corresponding component.", t);
            }
            ++i;
        }
    }

    public String getId() throws ConfigurationException {
        Object object = this.LOCAL_MONITOR;
        synchronized (object) {
            if (this.m_lockOwner == null) {
                this.m_lockOwner = Environment.getInstance().createUniqueOwner();
            }
        }
        return this.m_lockOwner;
    }

    public String getTransactionId() {
        return this.m_id + "_" + this.m_txID;
    }

    protected ConfigurationCache getConfigurationCache() {
        return this.m_cache;
    }

    public boolean getTransactionAccess() throws ConfigurationException {
        TransactionInfo tinfo = this.m_cache.checkIfCurrentThreadIsInCommit();
        if (tinfo == null || !tinfo.getTransId().equals(this.getTransactionId())) {
            this.getTransactionAccessSemaphore(Semaphore.SHARED);
            return true;
        }
        throw new ConfigurationException("kernel_1510");
    }

    public void releaseTransactionAccess() {
        this.releaseTransactionAccessSemaphore(Semaphore.SHARED);
    }

    private void checkOpen(ConfigurationPath path, int mode) throws ConfigurationException {
        if (mode == 1) {
            if (!this.openPathCheck(this.m_openForWriteConfigs.keySet(), path)) {
                throw new ConfigurationException("kernel_1512", new Object[]{path.getPathString(), "write"});
            }
        } else if (mode == 0 && !this.openPathCheck(this.m_openForReadConfigs.keySet(), path)) {
            throw new ConfigurationException("kernel_1512", new Object[]{path.getPathString(), "read"});
        }
    }

    private boolean openPathCheck(Collection allopen, ConfigurationPath pathToOpen) {
        Iterator iterator = allopen.iterator();
        while (iterator.hasNext()) {
            ConfigurationPath openPath = (ConfigurationPath)iterator.next();
            if (!openPath.isArgumentSubTree(pathToOpen) && !pathToOpen.isArgumentSubTree(openPath)) continue;
            return false;
        }
        return true;
    }

    private void checkClose(Configuration config) throws ConfigurationException {
        Object regWrite;
        if (config instanceof WriteAccessConfiguration ? (regWrite = this.m_openForWriteConfigs.get(((ConfigurationImpl)config).getPathWrapper())) == null || ((Object[])regWrite)[0] != config : config instanceof ReadAccessConfiguration && !this.m_openForReadConfigs.containsValue(config)) {
            throw new ConfigurationException("kernel_1511", new Object[]{config.getPath()});
        }
    }

    private void registerOpenConfiguration(ConfigurationPath path, Configuration config, int mode) throws ConfigurationException {
        if (mode == 1) {
            HashMap<ConfigurationPath, Configuration> accessedConfigs = new HashMap<ConfigurationPath, Configuration>();
            accessedConfigs.put(path, config);
            Object[] regWrite = new Object[]{config, accessedConfigs, null, null};
            this.m_openForWriteConfigs.put(((ConfigurationImpl)config).getPathWrapper(), regWrite);
        } else if (mode == 0) {
            this.m_openForReadConfigs.put(path, config);
        }
    }

    private void cleanUpAndRemoveOpenWrite(Configuration config) throws ConfigurationException {
        Object[] mgmStruct;
        Object[] objectArray = mgmStruct = (Object[])this.m_openForWriteConfigs.get(((ConfigurationImpl)config).getPathWrapper());
        synchronized (objectArray) {
            mgmStruct[0] = null;
            HashMap accessedConfigs = (HashMap)mgmStruct[1];
            Iterator iterator = accessedConfigs.values().iterator();
            while (iterator.hasNext()) {
                WriteAccessConfiguration cfg = (WriteAccessConfiguration)iterator.next();
                ConfigurationData data = cfg.getDataCopy();
                if (data == null) continue;
                data.cleanAll();
            }
            Vector v = (Vector)mgmStruct[2];
            if (v != null) {
                v.clear();
            }
            if ((v = (Vector)mgmStruct[3]) != null) {
                v.clear();
            }
        }
        this.m_openForWriteConfigs.remove(((ConfigurationImpl)config).getPathWrapper());
    }

    private void unregisterOpenConfiguration(Configuration config) throws ConfigurationException {
        ((ConfigurationImpl)config).setValidityFlag(1);
        if (config instanceof WriteAccessConfiguration) {
            this.cleanUpAndRemoveOpenWrite(config);
        } else if (config instanceof ReadAccessConfiguration) {
            this.m_openForReadConfigs.remove(((ConfigurationImpl)config).getPathWrapper());
        }
    }

    private synchronized Object[] getConfigManagmentStruct(ConfigurationPath path) throws ConfigurationException {
        Object[] configMgmStruct = (Object[])this.m_openForWriteConfigs.get(path);
        if (configMgmStruct == null) {
            throw new ConfigurationException("kernel_1511", new Object[]{path.getPathString()});
        }
        return configMgmStruct;
    }

    private Configuration retrieveWriteAccessSubConfig(Configuration rootConfig, Object[] configMgmStruct, ConfigurationPath absPath, long cid, boolean doDeleteCheck) throws ConfigurationException {
        Map accessedSubConfigs;
        Configuration configToGet;
        if (configMgmStruct[1] == null) {
            configMgmStruct[1] = new HashMap();
        }
        if ((configToGet = (Configuration)(accessedSubConfigs = (Map)configMgmStruct[1]).get(absPath)) != null) {
            return configToGet;
        }
        if (doDeleteCheck && configMgmStruct[2] != null) {
            Vector deletedPath = (Vector)configMgmStruct[2];
            boolean found = false;
            Enumeration enumeration = deletedPath.elements();
            while (!found && enumeration.hasMoreElements()) {
                ConfigurationPath entry = (ConfigurationPath)enumeration.nextElement();
                found = entry.isArgumentSubTree(absPath);
            }
            if (found) {
                throw new NameNotFoundException("kernel_1521", new Object[]{absPath, "deleted"});
            }
        }
        if (cid == Long.MIN_VALUE) {
            cid = this.m_cache.getSureConfigId(absPath);
        }
        configToGet = new WriteAccessConfiguration(absPath, cid, this, rootConfig);
        accessedSubConfigs.put(absPath, configToGet);
        return configToGet;
    }

    protected ConfigurationData getDataForWrite(ConfigurationPath path, long cid) throws ConfigurationException {
        return this.m_cache.getCachedConfiguration(path, new Long(cid)).getDataCopy();
    }

    protected CachedConfiguration getCachedConfiguration(ConfigurationPath path, long cid) throws ConfigurationException {
        return this.m_cache.getCachedConfiguration(path, new Long(cid));
    }

    protected Configuration getSubConfiguration(Configuration config, String relPath) throws ConfigurationException {
        String absPathStr = config.getPath();
        if (!relPath.equals("")) {
            absPathStr = config.getPath() + "/" + relPath;
        }
        ConfigurationPath absPath = ConfigurationPath.getConfigurationPath(absPathStr);
        ConfigurationImpl rootConfig = (ConfigurationImpl)config.getOpenRoot();
        if (rootConfig instanceof WriteAccessConfiguration) {
            Object[] configMgmStruct;
            Object[] objectArray = configMgmStruct = this.getConfigManagmentStruct(rootConfig.getPathWrapper());
            synchronized (objectArray) {
                Configuration configuration = this.retrieveWriteAccessSubConfig(rootConfig, configMgmStruct, absPath, Long.MIN_VALUE, true);
                return configuration;
            }
        }
        long cid = this.m_cache.getSureConfigId(absPath);
        return new ReadAccessConfiguration(absPath, cid, this, rootConfig);
    }

    protected Configuration getSubConfiguration(Configuration config, ConfigMetaDataImpl entry) throws ConfigurationException {
        ConfigurationPath absPath = ((ConfigurationImpl)config).getPathWrapper().getSubConfigurationPath(entry.getName());
        ConfigurationImpl rootConfig = (ConfigurationImpl)config.getOpenRoot();
        if (rootConfig instanceof WriteAccessConfiguration) {
            Object[] configMgmStruct;
            Object[] objectArray = configMgmStruct = this.getConfigManagmentStruct(rootConfig.getPathWrapper());
            synchronized (objectArray) {
                Configuration configuration = this.retrieveWriteAccessSubConfig(rootConfig, configMgmStruct, absPath, entry.getCID(), false);
                return configuration;
            }
        }
        return new ReadAccessConfiguration(absPath, entry.getCID(), this, rootConfig);
    }

    protected Map getSubConfigurations(Configuration config, ConfigMetaDataImpl[] entries) throws ConfigurationException {
        HashMap<String, Configuration> result = new HashMap<String, Configuration>();
        ConfigurationImpl rootConfig = (ConfigurationImpl)config.getOpenRoot();
        ConfigurationPath path = ((ConfigurationImpl)config).getPathWrapper();
        if (rootConfig instanceof WriteAccessConfiguration) {
            Object[] configMgmStruct;
            Object[] objectArray = configMgmStruct = this.getConfigManagmentStruct(rootConfig.getPathWrapper());
            synchronized (objectArray) {
                int i = 0;
                while (i < entries.length) {
                    String name = entries[i].getName();
                    ConfigurationPath subpath = path.getSubConfigurationPath(name);
                    Configuration subconfig = this.retrieveWriteAccessSubConfig(rootConfig, configMgmStruct, subpath, entries[i].getCID(), false);
                    result.put(name, subconfig);
                    ++i;
                }
                HashMap<String, Configuration> hashMap = result;
                return hashMap;
            }
        }
        int i = 0;
        while (i < entries.length) {
            ConfigMetaDataImpl entry = entries[i];
            ConfigurationPath subpath = ConfigurationPath.getConfigurationPath(path + "/" + entry.getName());
            result.put(entry.getName(), new ReadAccessConfiguration(subpath, entry.getCID(), this, rootConfig));
            ++i;
        }
        return result;
    }

    public Configuration registerNewSubConfiguration(Configuration openRoot, ConfigurationData data) throws ConfigurationException {
        Object[] configMgmStruct;
        Object[] objectArray = configMgmStruct = this.getConfigManagmentStruct(((ConfigurationImpl)openRoot).getPathWrapper());
        synchronized (objectArray) {
            Map accessedSubConfigs = (Map)configMgmStruct[1];
            WriteAccessConfiguration config = new WriteAccessConfiguration(data, (ConfigurationHandler)this, openRoot);
            accessedSubConfigs.put(data.getPath(), config);
            WriteAccessConfiguration writeAccessConfiguration = config;
            return writeAccessConfiguration;
        }
    }

    public Map registerNewSubConfigurations(Configuration openRoot, ConfigurationData[] data) throws ConfigurationException {
        Object[] configMgmStruct;
        Object[] objectArray = configMgmStruct = this.getConfigManagmentStruct(((ConfigurationImpl)openRoot).getPathWrapper());
        synchronized (objectArray) {
            Map accessedSubConfigs = (Map)configMgmStruct[1];
            HashMap<String, WriteAccessConfiguration> configs = new HashMap<String, WriteAccessConfiguration>();
            int i = 0;
            while (i < data.length) {
                WriteAccessConfiguration config = new WriteAccessConfiguration(data[i], (ConfigurationHandler)this, openRoot);
                accessedSubConfigs.put(data[i].getPath(), config);
                configs.put(data[i].getName(), config);
                ++i;
            }
            HashMap<String, WriteAccessConfiguration> hashMap = configs;
            return hashMap;
        }
    }

    private void handleRegisterDelete(Configuration openRoot, ConfigurationPath path, Object[] configMgmStruct, boolean deleteOnlySubNodes) throws ConfigurationException {
        if (configMgmStruct[2] == null) {
            configMgmStruct[2] = new Vector();
        }
        ((Vector)configMgmStruct[2]).addElement(path);
        if (configMgmStruct[3] == null) {
            configMgmStruct[3] = new Vector();
        }
        Vector<ConfigurationPath> toRemove = new Vector<ConfigurationPath>();
        if (configMgmStruct[1] != null) {
            Map accessedSubconfigs = (Map)configMgmStruct[1];
            Iterator allSubs = accessedSubconfigs.keySet().iterator();
            while (allSubs.hasNext()) {
                ConfigurationPath sub = (ConfigurationPath)allSubs.next();
                if (!path.isArgumentSubTree(sub) || deleteOnlySubNodes && path.length() == sub.length()) continue;
                ConfigurationImpl subconfig = (ConfigurationImpl)accessedSubconfigs.get(sub);
                subconfig.setValidityFlag(3);
                if (subconfig != openRoot) {
                    toRemove.add(sub);
                }
                if (((WriteAccessConfiguration)subconfig).isNewCreated()) continue;
                ((Vector)configMgmStruct[3]).addElement(subconfig);
            }
            Iterator it = ((AbstractList)toRemove).iterator();
            while (it.hasNext()) {
                accessedSubconfigs.remove((ConfigurationPath)it.next());
            }
        }
    }

    protected void registerDeleteSubConfiguration(Configuration config, String relpath) throws ConfigurationException {
        Object[] configMgmStruct;
        boolean deleteOnlySubNodes = false;
        ConfigurationImpl openRoot = (ConfigurationImpl)config.getOpenRoot();
        String path = config.getPath();
        if (!relpath.equals("") && !relpath.equals("/")) {
            path = path + "/" + relpath;
        }
        if (relpath.equals("/")) {
            deleteOnlySubNodes = true;
        }
        Object[] objectArray = configMgmStruct = this.getConfigManagmentStruct(openRoot.getPathWrapper());
        synchronized (objectArray) {
            this.handleRegisterDelete(openRoot, ConfigurationPath.getConfigurationPath(path), configMgmStruct, deleteOnlySubNodes);
        }
    }

    protected void registerDeleteSubConfigurations(Configuration config, String[] relpathList) throws ConfigurationException {
        ConfigurationImpl openRoot = (ConfigurationImpl)config.getOpenRoot();
        Object[] configMgmStruct = this.getConfigManagmentStruct(openRoot.getPathWrapper());
        String path = config.getPath();
        Object[] objectArray = configMgmStruct;
        synchronized (objectArray) {
            int i = 0;
            while (i < relpathList.length) {
                this.handleRegisterDelete(openRoot, ConfigurationPath.getConfigurationPath(path + "/" + relpathList[i]), configMgmStruct, false);
                ++i;
            }
        }
    }

    protected void handleDeleteOpenRootConfiguration(Configuration openRoot) throws ConfigurationException {
        this.registerDeleteSubConfiguration(openRoot, "");
    }

    public String[] getAllRootNames() throws ConfigurationException {
        return this.m_cache.getAllRootNames();
    }

    public ConfigMetaData[] getAllRootConfigsMetaData() throws ConfigurationException {
        return this.m_cache.getAllRootConfigsMetaData();
    }

    public synchronized Configuration createRootConfiguration(String name) throws ConfigurationException, ConfigurationLockedException {
        try {
            this.getTransactionAccess();
            RestrictionChecker.checkConfigurationName(name);
            ConfigurationPath nameObj = ConfigurationPath.getConfigurationPath(name);
            this.checkOpen(nameObj, 1);
            Configuration config = this.m_cache.createRootConfiguration(nameObj, this);
            this.registerOpenConfiguration(nameObj, config, 1);
            Configuration configuration = config;
            Object var6_5 = null;
            this.releaseTransactionAccess();
            return configuration;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseTransactionAccess();
            throw throwable;
        }
    }

    public synchronized Configuration createSubConfiguration(String path) throws ConfigurationException, NameAlreadyExistsException, NameNotFoundException, ConfigurationLockedException {
        try {
            this.getTransactionAccess();
            ConfigurationPath pathObj = ConfigurationPath.getConfigurationPath(path);
            RestrictionChecker.checkConfigurationPath(pathObj);
            this.checkOpen(pathObj, 1);
            Configuration config = this.m_cache.createSubConfiguration(pathObj, this);
            this.registerOpenConfiguration(pathObj, config, 1);
            Configuration configuration = config;
            Object var6_5 = null;
            this.releaseTransactionAccess();
            return configuration;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseTransactionAccess();
            throw throwable;
        }
    }

    public synchronized Configuration openConfiguration(String path, int accessmode) throws ConfigurationException, ConfigurationLockedException {
        try {
            this.getTransactionAccess();
            ConfigurationPath pathObj = ConfigurationPath.getConfigurationPath(path);
            this.checkOpen(pathObj, accessmode);
            Configuration config = this.m_cache.openConfiguration(pathObj, accessmode, this);
            this.registerOpenConfiguration(pathObj, config, accessmode);
            Configuration configuration = config;
            Object var7_6 = null;
            this.releaseTransactionAccess();
            return configuration;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseTransactionAccess();
            throw throwable;
        }
    }

    public synchronized void closeConfiguration(Configuration config) throws ConfigurationException {
        try {
            this.getTransactionAccess();
            this.checkClose(config);
            ((ConfigurationImpl)config).setValidityFlag(1);
            this.m_cache.releaseConfiguration(config, this);
            this.unregisterOpenConfiguration(config);
            Object var3_2 = null;
            this.releaseTransactionAccess();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseTransactionAccess();
            throw throwable;
        }
    }

    public synchronized void closeAllConfigurations() throws ConfigurationException {
        try {
            this.getTransactionAccess();
            Configuration[] allRead = this.m_openForReadConfigs.values().toArray(new Configuration[0]);
            int i = 0;
            while (i < allRead.length) {
                Configuration config = allRead[i];
                ((ConfigurationImpl)config).setValidityFlag(1);
                this.m_cache.releaseConfiguration(config, this);
                this.unregisterOpenConfiguration(config);
                ++i;
            }
            Object[] allWrite = this.m_openForWriteConfigs.values().toArray();
            int i2 = 0;
            while (i2 < allWrite.length) {
                Object[] regWrite = (Object[])allWrite[i2];
                ((ConfigurationImpl)regWrite[0]).setValidityFlag(1);
                this.m_cache.releaseConfiguration((Configuration)regWrite[0], this);
                this.unregisterOpenConfiguration((Configuration)regWrite[0]);
                ++i2;
            }
            Object var7_6 = null;
            this.releaseTransactionAccess();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseTransactionAccess();
            throw throwable;
        }
    }

    public void removeConfigurationChangedListener(ConfigurationChangedListener listener, String path) {
        this.m_cache.removeConfigurationChangedListener(listener, path);
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener listener, String path) {
        this.m_cache.addConfigurationChangedListener(listener, path, 2);
    }

    public void addConfigurationChangedListener(ConfigurationChangedListener listener, String path, int mode) {
        this.m_cache.addConfigurationChangedListener(listener, path, mode);
    }

    private void cleanUpStructuresAfterCommit() {
        Object[] allWrite = this.m_openForWriteConfigs.values().toArray();
        int i = 0;
        while (i < allWrite.length) {
            Object[] regWrite;
            Object[] objectArray = regWrite = (Object[])allWrite[i];
            synchronized (objectArray) {
                Vector v = (Vector)regWrite[2];
                if (v != null) {
                    v.clear();
                }
                if ((v = (Vector)regWrite[3]) != null) {
                    v.clear();
                }
            }
            ++i;
        }
    }

    public void commit() throws ConfigurationException {
        try {
            this.getTransactionAccessSemaphore(Semaphore.EXCLUSIVE);
            this.m_cache.commitConfigurationHandler(this);
            this.nextTransaction();
            this.cleanUpStructuresAfterCommit();
            Object var3_1 = null;
            this.releaseTransactionAccessSemaphore(Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.releaseTransactionAccessSemaphore(Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public void rollback() throws ConfigurationException {
        this.getTransactionAccessSemaphore(Semaphore.EXCLUSIVE);
        Object[] allWrite = this.m_openForWriteConfigs.values().toArray();
        try {
            try {
                int i = 0;
                while (i < allWrite.length) {
                    Object[] regWrite;
                    Object[] objectArray = regWrite = (Object[])allWrite[i];
                    synchronized (objectArray) {
                        Map accessedSubconfigs = (Map)regWrite[1];
                        Iterator allSubs = accessedSubconfigs.values().iterator();
                        Vector<WriteAccessConfiguration> temp = new Vector<WriteAccessConfiguration>();
                        while (allSubs.hasNext()) {
                            WriteAccessConfiguration accessedConfig = (WriteAccessConfiguration)allSubs.next();
                            if (!accessedConfig.isNewCreated()) continue;
                            temp.addElement(accessedConfig);
                            accessedConfig.setValidityFlag(4);
                        }
                        Iterator removeSubs = ((AbstractList)temp).iterator();
                        while (removeSubs.hasNext()) {
                            WriteAccessConfiguration removecfg = (WriteAccessConfiguration)removeSubs.next();
                            Object obj = accessedSubconfigs.remove(removecfg.getPathWrapper());
                        }
                        Vector deletedConfigs = (Vector)regWrite[3];
                        if (deletedConfigs != null) {
                            Enumeration enumeration = deletedConfigs.elements();
                            while (enumeration.hasMoreElements()) {
                                WriteAccessConfiguration c = (WriteAccessConfiguration)enumeration.nextElement();
                                accessedSubconfigs.put(c.getPathWrapper(), c);
                            }
                        }
                        allSubs = accessedSubconfigs.values().iterator();
                        while (allSubs.hasNext()) {
                            WriteAccessConfiguration accessedConfig = (WriteAccessConfiguration)allSubs.next();
                            accessedConfig.resetDataCopy();
                            accessedConfig.setValidityFlag(0);
                        }
                        Vector v = (Vector)regWrite[2];
                        if (v != null) {
                            v.clear();
                        }
                        if ((v = (Vector)regWrite[3]) != null) {
                            v.clear();
                        }
                    }
                    ++i;
                }
            }
            catch (ConfigurationException e) {
                throw new ConfigurationException((Exception)((Object)e), "kernel_1513");
            }
            Object var14_14 = null;
            this.nextTransaction();
            this.releaseTransactionAccessSemaphore(Semaphore.EXCLUSIVE);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.nextTransaction();
            this.releaseTransactionAccessSemaphore(Semaphore.EXCLUSIVE);
            throw throwable;
        }
    }

    public Configuration[] getAllOpenForWriteRoots() {
        Collection collection = this.m_openForWriteConfigs.values();
        int size = collection.size();
        Configuration[] result = new Configuration[size];
        Iterator iterator = collection.iterator();
        int i = 0;
        while (i < size) {
            result[i] = (Configuration)((Object[])iterator.next())[0];
            ++i;
        }
        return result;
    }

    public ConfigurationData[] getAllAccessedSubConfigData(Configuration config) throws ConfigurationException {
        Object[] configMgmStruct = (Object[])this.m_openForWriteConfigs.get(((WriteAccessConfiguration)config).getPathWrapper());
        Map accessedSubConfigs = (Map)configMgmStruct[1];
        Collection collection = accessedSubConfigs.values();
        Iterator iterator = collection.iterator();
        Vector<ConfigurationData> resultvector = new Vector<ConfigurationData>();
        while (iterator.hasNext()) {
            ConfigurationData data = ((WriteAccessConfiguration)iterator.next()).getDataCopy();
            if (data == null) continue;
            resultvector.addElement(data);
        }
        Object[] result = new ConfigurationData[resultvector.size()];
        resultvector.copyInto(result);
        return result;
    }

    public Connection getDBConnection() throws ConfigurationException {
        return null;
    }

    public Properties getCurrentProperties() {
        return this.m_props;
    }

    public ConfigurationInfo[] getAllRootConfigsInfos() throws ConfigurationException {
        ConfigMetaData[] source = this.getAllRootConfigsMetaData();
        ConfigurationInfo[] result = ConfigurationInfo.createCopy(source);
        return result;
    }

    public ConfigurationExtension openConfigurationExtension(String path, int accessmode) throws ConfigurationException, ConfigurationLockedException {
        return (ConfigurationExtension)this.openConfiguration(path, accessmode);
    }

    protected void finalize() throws Throwable {
        if (this.m_lockOwner != null) {
            Environment.getInstance().releaseUniqueOwner(this.m_lockOwner);
        }
        super.finalize();
    }
}

