/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigurationHandlerImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.admin.ConfigManagementInterfaceImpl;
import com.sap.engine.core.configuration.impl.admin.ControllerImpl;
import com.sap.engine.core.configuration.impl.cache.ConfigurationCache;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.StorageInformation;
import com.sap.engine.frame.core.configuration.admin.ConfigManagementInterface;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerFactoryExtension;
import com.sap.engine.frame.core.configuration.admin.Controller;
import java.util.Properties;

public class ConfigurationHandlerFactoryImpl
implements ConfigurationHandlerFactoryExtension {
    private ConfigurationCache _configurationCache;
    private Properties _props;
    private ConfigManagementInterface _mngInterface;

    public ConfigurationHandlerFactoryImpl(Properties properties) throws ConfigurationException {
        this._configurationCache = new ConfigurationCache(properties);
        this._props = properties;
        this._mngInterface = new ConfigManagementInterfaceImpl(this._configurationCache);
    }

    public void setProperty(String key, String value) throws Exception {
    }

    public void shutDown(Properties properties) {
        this._configurationCache.shutDown(properties);
    }

    public ConfigurationHandler getConfigurationHandler() throws ConfigurationException {
        return this.getConfigurationHandlerExtension();
    }

    public ConfigurationHandlerExtension getConfigurationHandlerExtension() throws ConfigurationException {
        return new ConfigurationHandlerImpl(this._configurationCache, this._props);
    }

    public Controller getConfigurationController() throws ConfigurationException {
        return new ControllerImpl(this._configurationCache);
    }

    public Properties getCurrentProperties() {
        return this._props;
    }

    public StorageInformation getStorageInformation() {
        return this._configurationCache.getStorageInformation();
    }

    public ConfigManagementInterface getConfigManagementInterface() {
        return this._mngInterface;
    }

    public void reencryptSecureContent() throws ConfigurationException {
        Environment.getInstance().getCryptoUtility().reencryptSecureContent();
    }
}

