/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.persistence.rdbms.PersistenceHandler;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ConfigMetaData;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ConfigurationDataCacheEntryImpl
extends ConfigurationData {
    public ConfigurationDataCacheEntryImpl(ConfigMetaDataImpl configData, HashMap valueEntries, HashMap fileEntries, HashMap subConfigs, PersistenceHandler persist) throws ConfigurationException {
        super(configData, valueEntries, fileEntries, subConfigs, persist);
    }

    protected ConfigurationDataCacheEntryImpl(ConfigurationData cd) {
        super(cd);
    }

    public String[] getAllValueNames() throws ConfigurationException {
        String[] names = this.m_persist.getAllValueNames(this.m_CID);
        int i = 0;
        while (i < names.length) {
            if (!this.m_valueEntries.containsKey(names[i]) && !this.isValueEntryDeleted(names[i])) {
                this.m_valueEntries.put(names[i], null);
            }
            ++i;
        }
        return this.m_valueEntries.keySet().toArray(new String[this.m_valueEntries.size()]);
    }

    public String[] getAllSubConfigurationNames() throws ConfigurationException {
        Vector names = this.m_persist.getAllSubConfigNames(this.m_CID, this.m_path);
        Iterator iter = ((AbstractList)names).iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.m_subConfigs.containsKey(name) || this.isSubConfigDeleted(name)) continue;
            this.m_subConfigs.put(name, null);
        }
        return this.m_subConfigs.keySet().toArray(new String[this.m_subConfigs.size()]);
    }

    public Collection getAllSubConfigurations() throws ConfigurationException {
        HashMap subs = this.m_persist.readAllSubConfigurations(this.m_CID, this.m_path);
        Iterator iter = subs.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.isSubConfigDeleted(name)) continue;
            this.m_subConfigs.put(name, subs.get(name));
        }
        return this.m_subConfigs.values();
    }

    public Map getAllValues() throws ConfigurationException {
        this.getAllValueEntries();
        HashMap<String, Object> entries = new HashMap<String, Object>();
        Iterator iter = this.m_valueEntries.values().iterator();
        while (iter.hasNext()) {
            ValueEntry v = (ValueEntry)iter.next();
            entries.put(v.getName(), v.getValue());
        }
        return entries;
    }

    public Map getAllValueEntries() throws ConfigurationException {
        HashMap entries = this.m_persist.readAllValues(this.m_CID);
        Iterator iter = entries.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.isValueEntryDeleted(name)) continue;
            this.m_valueEntries.put(name, entries.get(name));
        }
        return this.m_valueEntries;
    }

    public ValueEntry getValueEntry(String name) throws ConfigurationException {
        ValueEntry result = null;
        if (this.m_valueEntries.containsKey(name) && (result = (ValueEntry)this.m_valueEntries.get(name)) != null) {
            return result;
        }
        if (this.isValueEntryDeleted(name)) {
            throw new NameNotFoundException("kernel_1601", new Object[]{name, this.m_path.getPathString()});
        }
        result = this.m_persist.readValue(this.m_CID, name);
        this.m_valueEntries.put(name, result);
        return result;
    }

    public Object getValue(String name) throws ConfigurationException {
        return this.getValueEntry(name).getValue();
    }

    public Map getValues(String[] names) throws ConfigurationException {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        int i = 0;
        while (i < names.length) {
            entries.put(names[i], this.getValue(names[i]));
            ++i;
        }
        return entries;
    }

    public ConfigMetaDataImpl getSubConfiguration(String name) throws ConfigurationException {
        ConfigMetaDataImpl result = null;
        if (this.m_subConfigs.containsKey(name) && (result = (ConfigMetaDataImpl)this.m_subConfigs.get(name)) != null) {
            return result;
        }
        if (this.isSubConfigDeleted(name)) {
            throw new NameNotFoundException("kernel_1600", new Object[]{this.m_path + "/ " + name});
        }
        ConfigurationPath subConfigPath = this.m_path.getSubConfigurationPath(name);
        result = this.m_persist.getConfigMetaData(subConfigPath);
        this.m_subConfigs.put(name, result);
        return result;
    }

    public Collection getSubConfigurations(String[] names) throws ConfigurationException {
        Vector<ConfigMetaDataImpl> entries = new Vector<ConfigMetaDataImpl>();
        int i = 0;
        while (i < names.length) {
            entries.add(this.getSubConfiguration(names[i]));
            ++i;
        }
        return entries;
    }

    public boolean existsValue(String name) throws ConfigurationException {
        boolean result = false;
        if (this.m_valueEntries.containsKey(name)) {
            result = true;
        } else {
            boolean exists = this.m_persist.existsEntry(this.m_CID, name);
            if (exists && !this.isValueEntryDeleted(name)) {
                this.m_valueEntries.put(name, null);
                result = true;
            }
        }
        return result;
    }

    public boolean existsSubConfiguration(String name) throws ConfigurationException {
        boolean result = false;
        if (this.m_subConfigs.containsKey(name)) {
            result = true;
        } else {
            boolean exists = false;
            try {
                ConfigurationPath subConfigPath = this.m_path.getSubConfigurationPath(name);
                this.m_persist.getCID(subConfigPath);
                exists = true;
            }
            catch (NameNotFoundException ne) {
                // empty catch block
            }
            if (exists && !this.isSubConfigDeleted(name)) {
                this.m_subConfigs.put(name, null);
                result = true;
            }
        }
        return result;
    }

    public Object clone() {
        return new ConfigurationDataCacheEntryImpl(this);
    }

    private boolean isSubConfigDeleted(String name) {
        boolean result = false;
        if (this.m_deltaSubConfig != null) {
            Iterator iter = this.m_deltaSubConfig.keySet().iterator();
            while (iter.hasNext()) {
                ConfigMetaData data = (ConfigMetaData)iter.next();
                Integer op = (Integer)this.m_deltaSubConfig.get(data);
                if (op != ConfigurationData.DELETE || !data.getName().equals(name)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isValueEntryDeleted(String name) {
        boolean result = false;
        if (this.m_deltaValue != null && this.m_deltaValue.containsKey(name)) {
            Integer op = (Integer)this.m_deltaValue.get(name);
            result = op == ConfigurationData.DELETE;
        }
        return result;
    }
}

