/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.persistence.rdbms.PersistenceHandler;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ConfigurationDataCacheAllImpl
extends ConfigurationData {
    public ConfigurationDataCacheAllImpl(ConfigMetaDataImpl configData, HashMap valueEntries, HashMap fileEntries, HashMap subConfigs, PersistenceHandler persist) throws ConfigurationException {
        super(configData, valueEntries, fileEntries, subConfigs, persist);
    }

    public ConfigurationDataCacheAllImpl(long CID, ConfigurationPath path, PersistenceHandler persist) throws ConfigurationException {
        this.m_CID = CID;
        this.m_path = path;
        this.m_valueEntries = new HashMap();
        this.m_fileEntries = new HashMap();
        this.m_subConfigs = new HashMap();
        this.m_created = true;
        this.initializeDeltaObjects();
        this.m_cacheMode = 10;
        this.m_persist = persist;
    }

    public ConfigurationDataCacheAllImpl(long CID, long parentCID, ConfigurationPath path, int type, PersistenceHandler persist) throws ConfigurationException {
        this(CID, path, persist);
        this.m_type = type;
        this.m_parentCID = parentCID;
    }

    protected ConfigurationDataCacheAllImpl(ConfigurationData cd) {
        super(cd);
    }

    public String[] getAllValueNames() throws ConfigurationException {
        return this.m_valueEntries.keySet().toArray(new String[this.m_valueEntries.size()]);
    }

    public String[] getAllSubConfigurationNames() throws ConfigurationException {
        return this.m_subConfigs.keySet().toArray(new String[this.m_subConfigs.size()]);
    }

    public Collection getAllSubConfigurations() throws ConfigurationException {
        return this.m_subConfigs.values();
    }

    public Map getAllValues() throws ConfigurationException {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        Iterator iter = this.m_valueEntries.values().iterator();
        while (iter.hasNext()) {
            ValueEntry v = (ValueEntry)iter.next();
            entries.put(v.getName(), v.getValue());
        }
        return entries;
    }

    public Object getValue(String name) throws ConfigurationException {
        ValueEntry entry = null;
        entry = (ValueEntry)this.m_valueEntries.get(name);
        if (entry != null) {
            return entry.getValue();
        }
        throw new NameNotFoundException("kernel_1601", new Object[]{name, this.m_path.getPathString()});
    }

    public ConfigMetaDataImpl getSubConfiguration(String name) throws ConfigurationException {
        ConfigMetaDataImpl subConfig = null;
        subConfig = (ConfigMetaDataImpl)this.m_subConfigs.get(name);
        if (subConfig != null) {
            return subConfig;
        }
        throw new NameNotFoundException("kernel_1600", new Object[]{this.m_path + "/" + name});
    }

    public Map getValues(String[] names) throws ConfigurationException {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        int i = 0;
        while (i < names.length) {
            ValueEntry entry = null;
            entry = (ValueEntry)this.m_valueEntries.get(names[i]);
            if (entry == null) {
                throw new NameNotFoundException("kernel_1601", new Object[]{names[i], this.m_path.getPathString()});
            }
            entries.put(names[i], entry.getValue());
            ++i;
        }
        return entries;
    }

    public Collection getSubConfigurations(String[] names) throws ConfigurationException {
        Vector<ConfigMetaDataImpl> entries = new Vector<ConfigMetaDataImpl>();
        int i = 0;
        while (i < names.length) {
            ConfigMetaDataImpl subConfig = null;
            subConfig = (ConfigMetaDataImpl)this.m_subConfigs.get(names[i]);
            if (subConfig == null) {
                throw new NameNotFoundException("kernel_1600", new Object[]{this.m_path + "/" + names[i]});
            }
            entries.add(subConfig);
            ++i;
        }
        return entries;
    }

    public boolean existsValue(String name) throws ConfigurationException {
        return this.m_valueEntries.containsKey(name);
    }

    public boolean existsSubConfiguration(String name) throws ConfigurationException {
        return this.m_subConfigs.containsKey(name);
    }

    public ValueEntry getValueEntry(String name) throws ConfigurationException {
        return (ValueEntry)this.m_valueEntries.get(name);
    }

    public Object clone() {
        return new ConfigurationDataCacheAllImpl(this);
    }

    public Map getAllValueEntries() throws ConfigurationException {
        return this.m_valueEntries;
    }
}

