/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigMetaDataImpl;
import com.sap.engine.core.configuration.impl.ConfigurationDataCacheAllImpl;
import com.sap.engine.core.configuration.impl.FileEntry;
import com.sap.engine.core.configuration.impl.ValueEntry;
import com.sap.engine.core.configuration.impl.persistence.rdbms.PersistenceHandler;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public abstract class ConfigurationData {
    public static final Integer ADD = new Integer(10);
    public static final Integer MODIFY = new Integer(20);
    public static final Integer DELETE = new Integer(30);
    public static final Integer DELETE_ALL = new Integer(40);
    public static final int VALUE = 50;
    public static final int FILE = 60;
    public static final int SUBCONFIG = 70;
    public static long ROOT_ID = Long.MIN_VALUE;
    protected long m_CID;
    protected ConfigurationPath m_path = null;
    protected PersistenceHandler m_persist;
    protected String m_name = null;
    protected long m_parentCID = ROOT_ID;
    protected int m_cacheMode = 0;
    protected int m_type = 0;
    protected HashMap m_valueEntries;
    protected HashMap m_fileEntries;
    protected HashMap m_subConfigs;
    protected boolean m_deleted = false;
    protected boolean m_modified = false;
    protected boolean m_created = false;
    protected boolean m_deleteAllValues = false;
    protected boolean m_deleteAllFiles = false;
    protected boolean m_cacheModeChanged = false;
    protected Vector m_deletedSubConfigs;
    protected HashMap m_deltaValue;
    protected HashMap m_deltaFile;
    protected HashMap m_deltaSubConfig;

    public ConfigurationData() {
    }

    public ConfigurationData(ConfigMetaDataImpl configData, HashMap valueEntries, HashMap fileEntries, HashMap subConfigs, PersistenceHandler persist) throws ConfigurationException {
        this.m_CID = configData.getCID();
        this.m_path = configData.getPath();
        this.m_parentCID = configData.getParentCID();
        this.m_valueEntries = valueEntries;
        this.m_fileEntries = fileEntries;
        this.m_subConfigs = subConfigs;
        this.m_cacheMode = configData.getCacheMode();
        this.m_type = configData.getConfigurationType();
        this.m_persist = persist;
    }

    protected ConfigurationData(ConfigurationData cd) {
        this.m_CID = cd.m_CID;
        this.m_parentCID = cd.m_parentCID;
        this.m_path = cd.m_path;
        this.m_cacheMode = cd.m_cacheMode;
        this.m_type = cd.m_type;
        this.m_persist = cd.m_persist;
        this.m_valueEntries = new HashMap(cd.m_valueEntries);
        this.m_fileEntries = new HashMap(cd.m_fileEntries);
        this.m_subConfigs = new HashMap(cd.m_subConfigs);
    }

    public abstract Object clone();

    public long getCID() {
        return this.m_CID;
    }

    public ConfigMetaDataImpl getConfigParams() throws ConfigurationException {
        return new ConfigMetaDataImpl(this.m_path, this.m_CID, this.m_parentCID, this.m_cacheMode, this.m_type);
    }

    public ConfigurationPath getPath() {
        return this.m_path;
    }

    public long getParentCID() {
        return this.m_parentCID;
    }

    public String getName() {
        if (this.m_name == null) {
            this.m_name = this.m_path.getNameFromPath();
        }
        return this.m_name;
    }

    public HashMap getValueDeltas() {
        return this.m_deltaValue;
    }

    public HashMap getFileDeltas() {
        return this.m_deltaFile;
    }

    public HashMap getSubConfigDeltas() {
        return this.m_deltaSubConfig;
    }

    public boolean areAllFilesDeleted() {
        return this.m_deleteAllFiles;
    }

    public boolean areAllValuesDeleted() {
        return this.m_deleteAllValues;
    }

    public boolean isCacheModeChanged() {
        return this.m_cacheModeChanged;
    }

    public int getCacheMode() {
        return this.m_cacheMode;
    }

    public int getConfigurationType() {
        return this.m_type;
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public boolean isCreated() {
        return this.m_created;
    }

    public void setCacheMode(int cacheMode) throws ConfigurationException {
        this.m_cacheMode = cacheMode;
        if (!this.m_created) {
            this.m_cacheModeChanged = true;
        }
    }

    public Collection getAllDeleted() throws ConfigurationException {
        if (this.m_deletedSubConfigs == null) {
            this.m_deletedSubConfigs = new Vector();
        }
        return this.m_deletedSubConfigs;
    }

    public abstract String[] getAllSubConfigurationNames() throws ConfigurationException;

    public String[] getAllFileNames() throws ConfigurationException {
        return this.m_fileEntries.keySet().toArray(new String[this.m_fileEntries.size()]);
    }

    public abstract String[] getAllValueNames() throws ConfigurationException;

    public void deleteAll() {
        this.m_modified = false;
        this.m_deleted = true;
    }

    public void deleteAllSubConfigurations() throws ConfigurationException {
        this.prepareForModify();
        ConfigMetaDataImpl[] subs = this.getAllSubConfigurations().toArray(new ConfigMetaDataImpl[0]);
        int i = 0;
        while (i < subs.length) {
            this.m_deletedSubConfigs.add(subs[i]);
            this.m_subConfigs.remove(subs[i].getPath().getNameFromPath());
            this.addOperation(subs[i], DELETE, 70);
            ++i;
        }
    }

    public void deleteAllFileEntries() throws ConfigurationException {
        this.prepareForModify();
        this.m_fileEntries.clear();
        this.m_deltaFile.clear();
        this.m_deleteAllFiles = true;
    }

    public void deleteAllValueEntries() throws ConfigurationException {
        this.prepareForModify();
        this.m_valueEntries.clear();
        this.m_deltaValue.clear();
        this.m_deleteAllValues = true;
    }

    public abstract Collection getAllSubConfigurations() throws ConfigurationException;

    public Collection getAllFileEntries() throws ConfigurationException {
        return this.m_fileEntries.values();
    }

    public abstract Map getAllValues() throws ConfigurationException;

    public abstract ConfigMetaDataImpl getSubConfiguration(String var1) throws ConfigurationException;

    public FileEntry getFileEntry(String name) throws ConfigurationException {
        FileEntry file = null;
        file = (FileEntry)this.m_fileEntries.get(name);
        if (file != null) {
            return file;
        }
        throw new NameNotFoundException("kernel_1602", new Object[]{name, this.m_path.getPathString()});
    }

    public abstract Object getValue(String var1) throws ConfigurationException;

    public abstract Collection getSubConfigurations(String[] var1) throws ConfigurationException;

    public Collection getFileEntries(String[] names) throws ConfigurationException {
        Vector<FileEntry> entries = new Vector<FileEntry>();
        int i = 0;
        while (i < names.length) {
            FileEntry file = null;
            file = (FileEntry)this.m_fileEntries.get(names[i]);
            if (file == null) {
                throw new NameNotFoundException("kernel_1602", new Object[]{names[i], this.m_path.getPathString()});
            }
            entries.add(file);
            ++i;
        }
        return entries;
    }

    public abstract Map getValues(String[] var1) throws ConfigurationException;

    public void modifyFileEntry(FileEntry f) throws ConfigurationException {
        this.prepareForModify();
        if (!this.existsFileEntry(f.getName())) {
            throw new NameNotFoundException("kernel_1602", new Object[]{f.getName(), this.m_path.getPathString()});
        }
        this.addOperation(f.getName(), MODIFY, 60);
        this.m_fileEntries.put(f.getName(), f);
    }

    public void modifyValueEntry(ValueEntry v) throws ConfigurationException {
        this.prepareForModify();
        if (!this.existsValue(v.getName())) {
            throw new NameNotFoundException("kernel_1601", new Object[]{v.getName(), this.m_path.getPathString()});
        }
        this.addOperation(v.getName(), MODIFY, 50);
        this.m_valueEntries.put(v.getName(), v);
    }

    public void modifyFileEntries(Vector list) throws ConfigurationException {
        this.prepareForModify();
        Iterator iter = ((AbstractList)list).iterator();
        while (iter.hasNext()) {
            FileEntry f = (FileEntry)iter.next();
            if (this.existsFileEntry(f.getName())) {
                this.addOperation(f.getName(), MODIFY, 60);
            } else {
                this.addOperation(f.getName(), ADD, 60);
            }
            this.m_fileEntries.put(f.getName(), f);
        }
    }

    public void modifyValueEntries(Vector list) throws ConfigurationException {
        this.prepareForModify();
        Iterator iter = ((AbstractList)list).iterator();
        while (iter.hasNext()) {
            ValueEntry v = (ValueEntry)iter.next();
            if (this.existsValue(v.getName())) {
                this.addOperation(v.getName(), MODIFY, 50);
            } else {
                this.addOperation(v.getName(), ADD, 50);
            }
            this.m_valueEntries.put(v.getName(), v);
        }
    }

    public void createFileEntry(FileEntry f) throws ConfigurationException {
        this.prepareForModify();
        if (this.existsFileEntry(f.getName())) {
            throw new NameAlreadyExistsException("kernel_1612", new Object[]{f.getName(), this.m_path.getPathString()});
        }
        this.addOperation(f.getName(), ADD, 60);
        this.m_fileEntries.put(f.getName(), f);
    }

    public void createValueEntry(ValueEntry v) throws ConfigurationException {
        this.prepareForModify();
        if (this.existsValue(v.getName())) {
            throw new NameAlreadyExistsException("kernel_1611", new Object[]{v.getName(), this.m_path.getPathString()});
        }
        this.addOperation(v.getName(), ADD, 50);
        this.m_valueEntries.put(v.getName(), v);
    }

    public ConfigurationData createSubConfiguration(String name) throws ConfigurationException {
        return this.createSubConfiguration(name, 0);
    }

    public ConfigurationData createSubConfiguration(String name, int type) throws ConfigurationException {
        this.prepareForModify();
        if (!this.existsSubConfiguration(name)) {
            ConfigMetaDataImpl sub = new ConfigMetaDataImpl(this.m_path, name, this.m_persist.getKeyGenerator().generateKey(), this.m_parentCID, 10, type);
            this.m_subConfigs.put(name, sub);
            this.addOperation(sub, ADD, 70);
            return new ConfigurationDataCacheAllImpl(sub.getCID(), this.m_CID, sub.getPath(), type, this.m_persist);
        }
        throw new NameAlreadyExistsException("kernel_1610", new Object[]{this.m_path + "/" + name});
    }

    public void createFileEntries(Vector list) throws ConfigurationException {
        this.prepareForModify();
        Iterator iter = ((AbstractList)list).iterator();
        while (iter.hasNext()) {
            FileEntry f = (FileEntry)iter.next();
            if (!this.existsFileEntry(f.getName())) continue;
            throw new NameAlreadyExistsException("kernel_1612", new Object[]{f.getName(), this.m_path.getPathString()});
        }
        Iterator iter2 = ((AbstractList)list).iterator();
        while (iter2.hasNext()) {
            FileEntry f = (FileEntry)iter2.next();
            this.addOperation(f.getName(), ADD, 60);
            this.m_fileEntries.put(f.getName(), f);
        }
    }

    public void createValueEntries(Vector list) throws ConfigurationException {
        this.prepareForModify();
        Iterator iter = ((AbstractList)list).iterator();
        while (iter.hasNext()) {
            ValueEntry v = (ValueEntry)iter.next();
            if (!this.existsValue(v.getName())) continue;
            throw new NameAlreadyExistsException("kernel_1611", new Object[]{v.getName(), this.m_path.getPathString()});
        }
        Iterator iter2 = ((AbstractList)list).iterator();
        while (iter2.hasNext()) {
            ValueEntry v = (ValueEntry)iter2.next();
            this.addOperation(v.getName(), ADD, 50);
            this.m_valueEntries.put(v.getName(), v);
        }
    }

    public ConfigurationData[] createSubConfigurations(String[] names) throws ConfigurationException {
        return this.createSubConfigurations(names, 0);
    }

    public ConfigurationData[] createSubConfigurations(String[] names, int type) throws ConfigurationException {
        this.prepareForModify();
        int i = 0;
        while (i < names.length) {
            if (this.existsSubConfiguration(names[i])) {
                throw new NameAlreadyExistsException("kernel_1610", new Object[]{this.m_path + "/" + names[i]});
            }
            ++i;
        }
        ConfigurationData[] result = new ConfigurationDataCacheAllImpl[names.length];
        int i2 = 0;
        while (i2 < names.length) {
            ConfigMetaDataImpl entry = new ConfigMetaDataImpl(this.m_path, names[i2], this.m_persist.getKeyGenerator().generateKey(), this.m_parentCID, 10, type);
            this.m_subConfigs.put(entry.getName(), entry);
            this.addOperation(entry, ADD, 70);
            result[i2] = new ConfigurationDataCacheAllImpl(entry.getCID(), this.m_CID, entry.getPath(), type, this.m_persist);
            ++i2;
        }
        return result;
    }

    public void deleteSubConfiguration(String name) throws ConfigurationException {
        this.prepareForModify();
        if (!this.existsSubConfiguration(name)) {
            throw new NameNotFoundException("kernel_1600", new Object[]{this.m_path + "/" + name});
        }
        ConfigMetaDataImpl entry = this.getSubConfiguration(name);
        this.m_deletedSubConfigs.add(entry);
        this.m_subConfigs.remove(name);
        this.addOperation(entry, DELETE, 70);
    }

    public void deleteFileEntry(String name) throws ConfigurationException {
        this.prepareForModify();
        if (!this.existsFileEntry(name)) {
            throw new NameNotFoundException("kernel_1602", new Object[]{name, this.m_path.getPathString()});
        }
        this.m_fileEntries.remove(name);
        this.addOperation(name, DELETE, 60);
    }

    public void deleteValueEntry(String name) throws ConfigurationException {
        this.prepareForModify();
        if (!this.existsValue(name)) {
            throw new NameNotFoundException("kernel_1601", new Object[]{name, this.m_path.getPathString()});
        }
        this.m_valueEntries.remove(name);
        this.addOperation(name, DELETE, 50);
    }

    public String[] deleteSubConfigurations(String[] names) throws ConfigurationException {
        this.prepareForModify();
        Vector<String> deletedNames = new Vector<String>();
        int i = 0;
        while (i < names.length) {
            if (this.existsSubConfiguration(names[i])) {
                ConfigMetaDataImpl entry = this.getSubConfiguration(names[i]);
                this.m_deletedSubConfigs.add(entry);
                this.m_subConfigs.remove(names[i]);
                deletedNames.add(names[i]);
                this.addOperation(entry, DELETE, 70);
            }
            ++i;
        }
        return deletedNames.toArray(new String[deletedNames.size()]);
    }

    public void deleteFileEntries(String[] names) throws ConfigurationException {
        this.prepareForModify();
        int i = 0;
        while (i < names.length) {
            if (this.existsFileEntry(names[i])) {
                this.m_fileEntries.remove(names[i]);
                this.addOperation(names[i], DELETE, 60);
            }
            ++i;
        }
    }

    public void deleteValueEntries(String[] names) throws ConfigurationException {
        this.prepareForModify();
        int i = 0;
        while (i < names.length) {
            if (this.existsValue(names[i])) {
                this.m_valueEntries.remove(names[i]);
                this.addOperation(names[i], DELETE, 50);
            }
            ++i;
        }
    }

    public abstract boolean existsSubConfiguration(String var1) throws ConfigurationException;

    public boolean existsFileEntry(String name) throws ConfigurationException {
        return this.m_fileEntries.containsKey(name);
    }

    public abstract boolean existsValue(String var1) throws ConfigurationException;

    public void resetDeltas() throws ConfigurationException {
        this.m_cacheModeChanged = false;
        if (this.m_modified || this.m_created) {
            this.m_modified = false;
            this.m_created = false;
            this.m_deleteAllValues = false;
            this.m_deleteAllFiles = false;
            this.m_deletedSubConfigs.clear();
            this.m_deltaValue.clear();
            this.m_deltaFile.clear();
            this.m_deltaSubConfig.clear();
        }
    }

    public void cleanAll() {
        this.m_valueEntries.clear();
        this.m_fileEntries.clear();
        this.m_subConfigs.clear();
        if (this.m_created || this.m_modified) {
            this.m_deletedSubConfigs.clear();
            this.m_deltaValue.clear();
            this.m_deltaFile.clear();
            this.m_deltaSubConfig.clear();
        }
    }

    public abstract ValueEntry getValueEntry(String var1) throws ConfigurationException;

    public abstract Map getAllValueEntries() throws ConfigurationException;

    protected void prepareForModify() {
        if (!this.m_created && !this.m_modified) {
            this.m_modified = true;
            this.initializeDeltaObjects();
        }
    }

    protected void initializeDeltaObjects() {
        this.m_deltaValue = new HashMap();
        this.m_deltaFile = new HashMap();
        this.m_deltaSubConfig = new HashMap();
        this.m_deletedSubConfigs = new Vector();
    }

    protected void addOperation(Object name, Integer otype, int etype) {
        if (etype == 50) {
            if (this.m_deltaValue.containsKey(name)) {
                Integer currentOpType = (Integer)this.m_deltaValue.get(name);
                if (otype == ADD && currentOpType == DELETE) {
                    this.m_deltaValue.put(name, MODIFY);
                } else if (otype == DELETE) {
                    if (currentOpType == ADD) {
                        this.m_deltaValue.remove(name);
                    } else if (currentOpType == MODIFY) {
                        this.m_deltaValue.put(name, DELETE);
                    }
                }
            } else {
                this.m_deltaValue.put(name, otype);
            }
        } else if (etype == 60) {
            if (this.m_deltaFile.containsKey(name)) {
                Integer currentOpType = (Integer)this.m_deltaFile.get(name);
                if (otype == ADD && currentOpType == DELETE) {
                    this.m_deltaFile.put(name, MODIFY);
                } else if (otype == DELETE) {
                    if (currentOpType == ADD) {
                        this.m_deltaFile.remove(name);
                    } else if (currentOpType == MODIFY) {
                        this.m_deltaFile.put(name, DELETE);
                    }
                }
            } else {
                this.m_deltaFile.put(name, otype);
            }
        } else if (this.m_deltaSubConfig.containsKey(name)) {
            Integer currentOpType = (Integer)this.m_deltaSubConfig.get(name);
            if (otype == DELETE && currentOpType == ADD) {
                this.m_deltaSubConfig.remove(name);
                this.m_deletedSubConfigs.remove(name);
            }
        } else {
            this.m_deltaSubConfig.put(name, otype);
        }
    }
}

