/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.impl;

import com.sap.engine.core.configuration.impl.ConfigurationData;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.utilities.ConfigurationPath;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ChangeEventImpl
implements ChangeEvent {
    private long m_cid;
    private int m_action;
    private ConfigurationPath m_path;
    private boolean m_exclusiveAccessAvailable = true;
    private transient ConfigurationData m_data;
    private transient ChangeEvent[] m_details;

    public ChangeEventImpl(long cid, int action, ConfigurationPath path) {
        this.m_cid = cid;
        this.m_action = action;
        this.m_path = path;
    }

    public ChangeEventImpl(long cid, int action, ConfigurationPath path, ConfigurationData data) {
        this(cid, action, path);
        this.m_data = data;
    }

    public ChangeEventImpl(int action, ConfigurationPath path) {
        this.m_action = action;
        this.m_path = path;
    }

    public void setExclusiveAccessAvailable(boolean flag) {
        this.m_exclusiveAccessAvailable = flag;
    }

    public boolean isExclusiveAccessAvailable() {
        return this.m_exclusiveAccessAvailable;
    }

    public int getAction() {
        return this.m_action;
    }

    public ChangeEvent[] getDetailedChangeEvents() {
        if (this.m_details == null) {
            return new ChangeEventImpl[0];
        }
        return this.m_details;
    }

    public void setDetailedChangeEvents(ChangeEvent[] events) {
        this.m_details = events;
    }

    public void setAction(int action) {
        this.m_action = action;
    }

    public long getConfigID() {
        return this.m_cid;
    }

    public String getPath() {
        return this.m_path.getPathString();
    }

    public ConfigurationPath getPathWrapper() {
        return this.m_path;
    }

    public ConfigurationData getData() {
        return this.m_data;
    }

    public void writeToStream(ObjectOutputStream out) throws IOException {
        out.writeLong(this.m_cid);
        out.writeInt(this.m_action);
        out.writeBoolean(this.m_exclusiveAccessAvailable);
        out.writeObject(this.m_path.getPathString());
    }

    public static ChangeEventImpl[] readAllFromStream(ObjectInputStream in) throws Exception {
        boolean eof = false;
        Vector<ChangeEventImpl> v = new Vector<ChangeEventImpl>();
        while (!eof) {
            try {
                ChangeEventImpl e = ChangeEventImpl.readFromStream(in);
                v.addElement(e);
            }
            catch (EOFException e) {
                Environment.getInstance().getLogging().traceThrowable(3, null, e);
                eof = true;
            }
        }
        return v.toArray(new ChangeEventImpl[0]);
    }

    public static ChangeEventImpl readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long cid = in.readLong();
        int action = in.readInt();
        boolean exclusiveAccessAvailable = in.readBoolean();
        ConfigurationPath path = ConfigurationPath.getConfigurationPath((String)in.readObject());
        ChangeEventImpl e = new ChangeEventImpl(cid, action, path);
        e.setExclusiveAccessAvailable(exclusiveAccessAvailable);
        return e;
    }

    public String toString() {
        String actionStr = "undefined action occurred";
        if (this.m_action == 1) {
            actionStr = "created";
        } else if (this.m_action == 2) {
            actionStr = "deleted";
        } else if (this.m_action == 0) {
            actionStr = "modified";
        }
        return "Configuration " + this.m_path + " was " + actionStr;
    }
}

