/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.core.configuration.bootstrap;

import com.sap.engine.core.configuration.impl.ConfigurationHandlerImpl;
import com.sap.engine.core.configuration.impl.Environment;
import com.sap.engine.core.configuration.impl.Logging;
import com.sap.engine.core.configuration.impl.StandaloneEnvironment;
import com.sap.engine.core.configuration.impl.admin.ControllerImpl;
import com.sap.engine.core.configuration.impl.cache.ConfigurationCache;
import com.sap.engine.core.configuration.impl.security.Crypter;
import com.sap.engine.core.configuration.impl.utilities.PropertyUtil;
import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.StorageInformation;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.frame.core.configuration.admin.Controller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigurationManagerBootstrapImpl
implements ConfigurationContext,
FilenameFilter {
    private static final PropertyUtil UTIL = new PropertyUtil();
    ConfigurationCache m_cache = null;
    Properties m_props;
    static /* synthetic */ Class array$Ljava$lang$String;

    public ConfigurationManagerBootstrapImpl(Properties connProps) throws ConfigurationException {
        this.m_props = connProps;
        this.init(this.m_props);
    }

    public ConfigurationManagerBootstrapImpl(String fileName) throws ConfigurationException {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            this.m_props = new Properties();
            this.m_props.load(fis);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        this.init(this.m_props);
    }

    public ConfigurationHandler getConfigurationHandler() {
        return new ConfigurationHandlerImpl(this.m_cache, this.m_props);
    }

    public Controller getConfigurationController() throws ConfigurationException {
        return new ControllerImpl(this.m_cache);
    }

    public StorageInformation getStorageInformation() {
        return this.m_cache.getStorageInformation();
    }

    public void shutdown() {
        this.m_cache.shutDown(new Properties());
    }

    private String[] getValidPathsFromLocation(String location) {
        String[] names = null;
        StringTokenizer tokenizer = new StringTokenizer(location, File.pathSeparator);
        names = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken().trim();
            File f = new File(nextToken);
            if (!f.exists()) continue;
            names[index++] = nextToken;
        }
        if (index > 0) {
            return names;
        }
        return null;
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".list");
    }

    private File[] getAllLibDirFiles(File libDir) {
        File[] files = libDir.listFiles();
        Vector<File> v = new Vector<File>(files.length);
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                v.add(files[i]);
            }
            ++i;
        }
        return v.toArray(new File[v.size()]);
    }

    private File[] getAllFilesToAdd(File libDir) throws Exception {
        String libPath = libDir.getAbsolutePath();
        File infoDir = new File(libPath + System.getProperty("file.separator") + "info");
        if (!infoDir.exists() || !infoDir.isDirectory()) {
            return this.getAllLibDirFiles(libDir);
        }
        File[] infoFiles = infoDir.listFiles(this);
        if (infoFiles.length == 0) {
            return this.getAllLibDirFiles(libDir);
        }
        HashSet<File> filesToAdd = new HashSet<File>();
        int i = 0;
        while (i < infoFiles.length) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(infoFiles[i])));
            String ln = null;
            while ((ln = reader.readLine()) != null) {
                if ((ln = ln.trim()).equals("")) continue;
                File fileToAdd = new File(libPath + System.getProperty("file.separator") + ln);
                if (fileToAdd.exists()) {
                    filesToAdd.add(fileToAdd);
                    continue;
                }
                Environment.getInstance().getLogging().log((byte)4, infoFiles[i].getName() + " contains entry " + ln + " which does not exist in " + libPath);
            }
            reader.close();
            ++i;
        }
        return ((AbstractCollection)filesToAdd).toArray(new File[0]);
    }

    private void init(Properties connProps) throws ConfigurationException {
        try {
            String secstoreLibsDir;
            block19: {
                String tracelevel = UTIL.getStringProperty(connProps, "trace.severity", true);
                Boolean sqlTrace = UTIL.getBooleanProperty(connProps, "SQLTrace", true);
                Boolean consoleOutput = UTIL.getBooleanProperty(connProps, "trace.console", true);
                if (tracelevel == null) {
                    tracelevel = "NONE";
                }
                if (sqlTrace == null) {
                    sqlTrace = new Boolean(false);
                }
                if (consoleOutput == null) {
                    consoleOutput = new Boolean(false);
                }
                Logging logging = new Logging(this.makeLoggingProperties(tracelevel, sqlTrace, consoleOutput));
                StandaloneEnvironment env = new StandaloneEnvironment(logging, this);
                Environment.init(env);
                String driverLocation = connProps.getProperty("rdbms.driverLocation");
                if (driverLocation != null) {
                    String[] driverJarPaths = this.getValidPathsFromLocation(driverLocation);
                    if (driverJarPaths != null) {
                        try {
                            Class<?> fileClassLoaderClass = Class.forName("com.sap.engine.offline.FileClassLoader");
                            ClassLoader currentLoader = this.getClass().getClassLoader();
                            if (fileClassLoaderClass.isInstance(currentLoader)) {
                                Method addJarsMethod = fileClassLoaderClass.getMethod("addJars", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ConfigurationManagerBootstrapImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                                addJarsMethod.invoke((Object)currentLoader, new Object[]{driverJarPaths});
                                break block19;
                            }
                            Environment.getInstance().getLogging().log((byte)2, "Current class loader is not of type FileClassLoader - DB Driver locations can not be dynamically added. Assume drivers are already available");
                        }
                        catch (ClassNotFoundException e) {
                            Environment.getInstance().getLogging().logThrowable("FileClassLoader not available - DB Driver locations can not be dynamically added. Assume drivers are already available", e, (byte)2);
                        }
                    } else {
                        Environment.getInstance().getLogging().log((byte)4, "No db driver found for rdbms.driverLocation = " + driverLocation + ". Assume drivers are already available");
                    }
                }
            }
            if ((secstoreLibsDir = connProps.getProperty("secstorefs.lib")) != null) {
                File libdir = new File(secstoreLibsDir = secstoreLibsDir + System.getProperty("file.separator") + "tools");
                if (!libdir.exists() || !libdir.isDirectory()) {
                    throw new ConfigurationException("kernel_1500", new String[]{"Secure Store lib Dir does not exist " + secstoreLibsDir});
                }
                File[] allLibs = this.getAllFilesToAdd(libdir);
                String[] allLibPaths = new String[allLibs.length];
                int i = 0;
                while (i < allLibs.length) {
                    allLibPaths[i] = allLibs[i].getAbsolutePath();
                    Environment.getInstance().getLogging().log((byte)2, "ConfigurationManager: found jar for secure store " + allLibPaths[i]);
                    ++i;
                }
                try {
                    Class<?> fileClassLoaderClass = Class.forName("com.sap.engine.offline.FileClassLoader");
                    ClassLoader currentLoader = this.getClass().getClassLoader();
                    if (fileClassLoaderClass.isInstance(currentLoader)) {
                        Method addJarsMethod = fileClassLoaderClass.getMethod("addJars", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ConfigurationManagerBootstrapImpl.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                        addJarsMethod.invoke((Object)currentLoader, new Object[]{allLibPaths});
                    } else {
                        Environment.getInstance().getLogging().log((byte)2, "Current class loader is not of type FileClassLoader - Secure Store libraries can not be dynamically added. Assume libraries are already available");
                    }
                }
                catch (ClassNotFoundException e) {
                    Environment.getInstance().getLogging().logThrowable("FileClassLoader not available - Secure Store libraries can not be dynamically added. Assume libraries are already available", e, (byte)2);
                }
            }
            this.m_cache = new ConfigurationCache(connProps);
            Environment.getInstance().registerCryptoUtility(new Crypter(this));
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private Properties makeLoggingProperties(String severity, boolean sqlTraceOn, boolean consoleOutput) throws ConfigurationException {
        try {
            Properties defaultProps = new Properties();
            String pathToLogFile = this.m_props.getProperty("offlineconfig.log.location");
            if (pathToLogFile == null) {
                pathToLogFile = ".";
            }
            if (consoleOutput) {
                defaultProps.setProperty("log[defaultTrace]", "ConsoleLog");
                defaultProps.setProperty("log[defaultTrace].formatter", "formatter[ConsoleFormatter]");
                defaultProps.setProperty("formatter[ConsoleFormatter]", "TraceFormatter");
                defaultProps.setProperty("formatter[ConsoleFormatter].pattern", "[%d] %m");
            } else {
                defaultProps.setProperty("log[defaultTrace]", "FileLog");
                defaultProps.setProperty("log[defaultTrace].pattern", "default.trc");
                defaultProps.setProperty("log[defaultTrace].formatter", "ListFormatter");
            }
            defaultProps.setProperty("com.sap.engine.core.configuration.logs", "log[defaultTrace]");
            defaultProps.setProperty("com.sap.engine.core.configuration.severity", severity);
            defaultProps.setProperty("log[SQLTrace]", "FileLog");
            defaultProps.setProperty("log[SQLTrace].pattern", "sqltrace.xml");
            defaultProps.setProperty("log[SQLTrace].formatter", "com.sap.sql.trace.SQLTraceXMLFormatter");
            defaultProps.setProperty("SQLTraceLogger.logs", "log[SQLTrace]");
            String sqlTraceSeverity = sqlTraceOn ? "DEBUG" : "NONE";
            defaultProps.setProperty("SQLTraceLogger.severity", sqlTraceSeverity);
            defaultProps.setProperty("/System.logs", "log[systemLog]");
            defaultProps.setProperty("log[systemLog].pattern", pathToLogFile + File.separator + "system.log");
            defaultProps.setProperty("log[systemLog].formatter", "ListFormatter");
            defaultProps.setProperty("log[systemLog]", "FileLog");
            defaultProps.setProperty("/System.severity", "INFO");
            return defaultProps;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public Properties getCurrentProperties() {
        return this.m_props;
    }

    public String getJDBCDriver() throws RemoteException {
        return null;
    }

    public ConfigurationHandlerExtension getConfigurationHandlerExtension() throws ConfigurationException {
        return new ConfigurationHandlerImpl(this.m_cache, this.m_props);
    }

    public void reencryptSecureContent() throws ConfigurationException {
        Environment.getInstance().getCryptoUtility().reencryptSecureContent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

