/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtSimpleTypeChecker;
import com.sap.dictionary.designtime.DtSimpleTypeExpanded;
import com.sap.dictionary.tools.simpletype.SimpletypeCheckCaller;
import com.sap.dictionary.tools.simpletype.SimpletypeConstants;
import com.sap.dictionary.tools.simpletype.SimpletypeDefinitionForm;
import com.sap.dictionary.tools.simpletype.SimpletypeResetCaller;
import com.sap.dictionary.tools.simpletype.SimpletypeTextElement;
import com.tssap.util.ui.glpc.section.AbstractSection;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SimpletypeValueConstraintsSection
extends AbstractSection {
    private SimpletypeDefinitionForm mForm = null;
    public Label labelMinInclusive;
    public Text textMinInclusive;
    public String yyMinInclusive;
    public Button buttonMinInclusive;
    public Label labelMaxInclusive;
    public Text textMaxInclusive;
    public String yyMaxInclusive;
    public Button buttonMaxInclusive;
    public Label labelMinExclusive;
    public Text textMinExclusive;
    public String yyMinExclusive;
    public Button buttonMinExclusive;
    public Label labelMaxExclusive;
    public Text textMaxExclusive;
    public String yyMaxExclusive;
    public Button buttonMaxExclusive;
    public Label labelPattern;
    public Text textPattern;
    public String yyPattern;
    public Button buttonPattern;
    public Button buttonChange;
    public FocusEvent focusEvent = null;
    public Label markerMinInclusive;
    public Label markerMaxInclusive;
    public Label markerMinExclusive;
    public Label markerMaxExclusive;

    public SimpletypeValueConstraintsSection(IWidgetFactory widgetFactory, int columns, String title, String description, SimpletypeDefinitionForm form) {
        super(widgetFactory, columns, title, description);
        this.mForm = form;
    }

    public SimpletypeValueConstraintsSection(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description, SimpletypeDefinitionForm form) {
        super(widgetFactory, columns, equalColumns, title, description);
        this.mForm = form;
    }

    protected void preInitSection(IGridLayoutPane glp) {
    }

    protected void postInitSection(IGridLayoutPane glp) {
    }

    public void initSection(IGridLayoutPane glp) {
        SectionModifyListener modListener = new SectionModifyListener();
        SimpletypeTextElement tMinInclusive = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Minimum Inclusive:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    return new DtSimpleTypeExpanded(((SimpletypeValueConstraintsSection)SimpletypeValueConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getMinInclusive();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeValueConstraintsSection.this.checkStringFieldContent(SimpletypeValueConstraintsSection.this.labelMinInclusive, SimpletypeValueConstraintsSection.this.textMinInclusive, SimpletypeValueConstraintsSection.this.markerMinInclusive);
            }

            public void setTooltip(Text text) {
                SimpletypeValueConstraintsSection.this.setToolTip(text);
            }
        });
        this.labelMinInclusive = tMinInclusive.wlabel;
        this.textMinInclusive = tMinInclusive.wtext;
        this.buttonMinInclusive = tMinInclusive.wbutton;
        this.markerMinInclusive = tMinInclusive.wmarker;
        this.textMinInclusive.addModifyListener((ModifyListener)modListener);
        SimpletypeTextElement tMaxInclusive = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Maximum Inclusive:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    return new DtSimpleTypeExpanded(((SimpletypeValueConstraintsSection)SimpletypeValueConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getMaxInclusive();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeValueConstraintsSection.this.checkStringFieldContent(SimpletypeValueConstraintsSection.this.labelMaxInclusive, SimpletypeValueConstraintsSection.this.textMaxInclusive, SimpletypeValueConstraintsSection.this.markerMaxInclusive);
            }

            public void setTooltip(Text text) {
                SimpletypeValueConstraintsSection.this.setToolTip(text);
            }
        });
        this.labelMaxInclusive = tMaxInclusive.wlabel;
        this.textMaxInclusive = tMaxInclusive.wtext;
        this.buttonMaxInclusive = tMaxInclusive.wbutton;
        this.markerMaxInclusive = tMaxInclusive.wmarker;
        this.textMaxInclusive.addModifyListener((ModifyListener)modListener);
        SimpletypeTextElement tMinExclusive = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Minimum Exclusive:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    return new DtSimpleTypeExpanded(((SimpletypeValueConstraintsSection)SimpletypeValueConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getMinExclusive();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeValueConstraintsSection.this.checkStringFieldContent(SimpletypeValueConstraintsSection.this.labelMinExclusive, SimpletypeValueConstraintsSection.this.textMinExclusive, SimpletypeValueConstraintsSection.this.markerMinExclusive);
            }

            public void setTooltip(Text text) {
                SimpletypeValueConstraintsSection.this.setToolTip(text);
            }
        });
        this.labelMinExclusive = tMinExclusive.wlabel;
        this.textMinExclusive = tMinExclusive.wtext;
        this.buttonMinExclusive = tMinExclusive.wbutton;
        this.markerMinExclusive = tMinExclusive.wmarker;
        this.textMinExclusive.addModifyListener((ModifyListener)modListener);
        SimpletypeTextElement tMaxExclusive = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Maximum Exclusive:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    return new DtSimpleTypeExpanded(((SimpletypeValueConstraintsSection)SimpletypeValueConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getMaxExclusive();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeValueConstraintsSection.this.checkStringFieldContent(SimpletypeValueConstraintsSection.this.labelMaxExclusive, SimpletypeValueConstraintsSection.this.textMaxExclusive, SimpletypeValueConstraintsSection.this.markerMaxExclusive);
            }

            public void setTooltip(Text text) {
                SimpletypeValueConstraintsSection.this.setToolTip(text);
            }
        });
        this.labelMaxExclusive = tMaxExclusive.wlabel;
        this.textMaxExclusive = tMaxExclusive.wtext;
        this.buttonMaxExclusive = tMaxExclusive.wbutton;
        this.markerMaxExclusive = tMaxExclusive.wmarker;
        this.textMaxExclusive.addModifyListener((ModifyListener)modListener);
        SimpletypeTextElement tPattern = new SimpletypeTextElement(this.mForm.getEditor(), glp, "", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    return new DtSimpleTypeExpanded(((SimpletypeValueConstraintsSection)SimpletypeValueConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getPattern();
                }
                catch (Exception e) {
                    return "";
                }
            }
        });
        this.labelPattern = tPattern.wlabel;
        this.textPattern = tPattern.wtext;
        this.buttonPattern = tPattern.wbutton;
        this.textPattern.addModifyListener((ModifyListener)modListener);
    }

    public void setBoundaryConstraintsEditable(boolean editable) {
        this.textMinInclusive.setEditable(editable);
        this.textMaxInclusive.setEditable(editable);
        this.textMinExclusive.setEditable(editable);
        this.textMaxExclusive.setEditable(editable);
    }

    public void setPatternConstraintsEditable(boolean editable) {
        this.textPattern.setEditable(editable);
    }

    public void setAllEditable(boolean editable) {
        this.setBoundaryConstraintsEditable(editable);
        this.setPatternConstraintsEditable(editable);
    }

    public void setBoundaryConstraintsVisible(boolean visible) {
        this.textMinInclusive.setVisible(visible);
        this.textMaxInclusive.setVisible(visible);
        this.textMinExclusive.setVisible(visible);
        this.textMaxExclusive.setVisible(visible);
        this.labelMinInclusive.setEnabled(visible);
        this.labelMaxInclusive.setEnabled(visible);
        this.labelMinExclusive.setEnabled(visible);
        this.labelMaxExclusive.setEnabled(visible);
    }

    public void setPatternConstraintsVisible(boolean visible) {
        this.textPattern.setVisible(visible);
        this.labelPattern.setEnabled(visible);
    }

    public void clearAll() {
        this.textMinInclusive.setText("");
        this.textMaxInclusive.setText("");
        this.textMinExclusive.setText("");
        this.textMaxExclusive.setText("");
        this.textPattern.setText("");
    }

    public void adaptModifyButtons() {
        this.setButtonProperties(this.buttonMinInclusive, this.textMinInclusive);
        this.setButtonProperties(this.buttonMaxInclusive, this.textMaxInclusive);
        this.setButtonProperties(this.buttonMinExclusive, this.textMinExclusive);
        this.setButtonProperties(this.buttonMaxExclusive, this.textMaxExclusive);
        this.setButtonProperties(this.buttonPattern, this.textPattern);
    }

    public void setButtonProperties(Button pbutton, Text ptext) {
        if (!ptext.getEditable()) {
            pbutton.setImage(this.mForm.getEditor().modifyImage);
            pbutton.setToolTipText("Overwrite Base Type");
        } else {
            pbutton.setImage(this.mForm.getEditor().resetImage);
            pbutton.setToolTipText("Reset to Base Type");
        }
        pbutton.setVisible(ptext.getVisible());
    }

    public void setModifyButtonsVisible(boolean visible) {
        this.buttonMinInclusive.setVisible(visible);
        this.buttonMaxInclusive.setVisible(visible);
        this.buttonMinExclusive.setVisible(visible);
        this.buttonMaxExclusive.setVisible(visible);
        this.buttonPattern.setVisible(visible);
    }

    public void setModifyButtonsEnabled(boolean enabled) {
        this.buttonMinInclusive.setEnabled(enabled);
        this.buttonMaxInclusive.setEnabled(enabled);
        this.buttonMinExclusive.setEnabled(enabled);
        this.buttonMaxExclusive.setEnabled(enabled);
        this.buttonPattern.setEnabled(enabled);
    }

    public String checkValue(Text text) {
        String message = DtSimpleTypeChecker.checkStringFieldContent((String)"", (String)this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), (String)text.getText(), (String)"");
        if (message.equals("")) {
            message = DtSimpleTypeChecker.checkStringValueLength((String)this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), (String)text.getText(), (int)this.getIntFromText(this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textLength), (int)this.getIntFromText(this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textMinLength), (int)this.getIntFromText(this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textMaxLength), (String)"");
        }
        if (message.equals("")) {
            message = DtSimpleTypeChecker.checkDecimalFormat((String)text.getText(), (int)this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.iTotalDigits, (int)this.mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.iFractionDigits, (String)this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), (String)"");
        }
        return message;
    }

    private void checkStringFieldContent(Label label, Text text, Label marker) {
        String message = this.checkValue(text);
        SimpletypeConstants.setErrorMarker(message, label, text, marker);
    }

    public void setToolTip(Text text) {
        String typeName = this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText();
        if (typeName.equals("date")) {
            text.setToolTipText(DtHelper.getDateTemplate());
        } else if (typeName.equals("time")) {
            text.setToolTipText(DtHelper.getTimeTemplate());
        } else if (typeName.equals("timestamp")) {
            text.setToolTipText(DtHelper.getTimestampTemplate());
        } else {
            text.setToolTipText(null);
        }
    }

    public int getIntFromText(Text text) {
        int ival = 0;
        if (text.getText().equals("")) {
            return ival;
        }
        try {
            Integer val = new Integer(text.getText());
            ival = val;
        }
        catch (Exception e) {
            return ival;
        }
        return ival;
    }

    public void updateBuffer() {
        this.yyMinInclusive = this.mForm.getEditor().calculateStringProperty(this.textMinInclusive);
        this.yyMaxInclusive = this.mForm.getEditor().calculateStringProperty(this.textMaxInclusive);
        this.yyMinExclusive = this.mForm.getEditor().calculateStringProperty(this.textMinExclusive);
        this.yyMaxExclusive = this.mForm.getEditor().calculateStringProperty(this.textMaxExclusive);
        this.yyPattern = this.mForm.getEditor().calculateStringProperty(this.textPattern);
    }

    private class SectionModifyListener
    implements ModifyListener {
        private SectionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SimpletypeValueConstraintsSection.this.updateBuffer();
        }
    }
}

