/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.tools.simpletype.SimpletypeCheckCaller;
import com.sap.dictionary.tools.simpletype.SimpletypeConstants;
import com.sap.dictionary.tools.simpletype.SimpletypeMultiEditorPart;
import com.sap.dictionary.tools.simpletype.SimpletypeResetCaller;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SimpletypeTextElement {
    public Label wlabel;
    public Text wtext;
    public Button wbutton;
    public Label wmarker;
    public FocusEvent focusEvent = null;
    private final SimpletypeMultiEditorPart mEditor;
    private final SimpletypeResetCaller mResetCaller;
    private final SimpletypeCheckCaller mCheckCaller;

    public SimpletypeTextElement(SimpletypeMultiEditorPart editor, IGridLayoutPane glp, String slabel, SimpletypeResetCaller resetCaller) {
        this.mEditor = editor;
        this.mResetCaller = resetCaller;
        this.mCheckCaller = null;
        this.addUIElements(glp, slabel, resetCaller);
    }

    public SimpletypeTextElement(SimpletypeMultiEditorPart editor, IGridLayoutPane glp, String slabel, SimpletypeResetCaller resetCaller, SimpletypeCheckCaller checkCaller) {
        this.mEditor = editor;
        this.mResetCaller = resetCaller;
        this.mCheckCaller = checkCaller;
        this.addUIElements(glp, slabel, resetCaller);
    }

    private void addUIElements(IGridLayoutPane glp, String slabel, SimpletypeResetCaller resetCaller) {
        this.wlabel = glp.addTextLabel(slabel, glp.createGridLayoutData(4, 2, 1, 1));
        this.wtext = glp.addTextField("", false, glp.createGridLayoutData(4, 2, true, false, 1, 1));
        this.wtext.addModifyListener((ModifyListener)new TextModifyListener());
        this.wtext.addFocusListener((FocusListener)new TextFocusListener());
        this.wtext.addMouseMoveListener((MouseMoveListener)new TextMouseMoveListener());
        this.wbutton = glp.addPushButton("", glp.createGridLayoutData(3, 2, false, false, 1, 1));
        this.wbutton.setImage(this.mEditor.modifyImage);
        this.wbutton.setToolTipText("Overwrite Base Type");
        this.wbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpletypeTextElement.this.mEditor.makeDirty(e.widget);
                if (!SimpletypeTextElement.this.wtext.getEditable()) {
                    SimpletypeTextElement.this.wtext.setEditable(true);
                    SimpletypeTextElement.this.wtext.setFocus();
                    SimpletypeTextElement.this.wtext.setText(SimpletypeTextElement.this.wtext.getText());
                    SimpletypeTextElement.this.wbutton.setImage(((SimpletypeTextElement)SimpletypeTextElement.this).mEditor.resetImage);
                    SimpletypeTextElement.this.wbutton.setToolTipText("Reset to Base Type");
                } else if (SimpletypeConstants.confirmMsg("Reset Property", "Reset property to value of base type?")) {
                    SimpletypeTextElement.this.wtext.setEditable(false);
                    SimpletypeTextElement.this.wtext.setText(SimpletypeTextElement.this.mResetCaller.getBaseValue());
                    SimpletypeTextElement.this.wtext.setFocus();
                    SimpletypeTextElement.this.wbutton.setImage(((SimpletypeTextElement)SimpletypeTextElement.this).mEditor.modifyImage);
                    SimpletypeTextElement.this.wbutton.setToolTipText("Overwrite Base Type");
                }
            }
        });
        this.wmarker = glp.addImage(SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_ERROR_TSK"), false, glp.createGridLayoutData(3, 2, false, false, 1, 1));
        this.wmarker.setVisible(false);
    }

    private class TextFocusListener
    extends FocusAdapter {
        private TextFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            SimpletypeTextElement.this.mEditor.clearAllFocusEvents();
            SimpletypeTextElement.this.focusEvent = e;
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SimpletypeTextElement.this.mEditor.makeDirty(e.widget);
            if (SimpletypeTextElement.this.mCheckCaller != null) {
                SimpletypeTextElement.this.mCheckCaller.check();
            }
        }
    }

    private class TextMouseMoveListener
    implements MouseMoveListener {
        private TextMouseMoveListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (SimpletypeTextElement.this.mCheckCaller != null) {
                SimpletypeTextElement.this.mCheckCaller.setTooltip(SimpletypeTextElement.this.wtext);
            }
        }
    }
}

