/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.tools.simpletype.SimpletypeContentProvider;
import com.sap.dictionary.tools.simpletype.SimpletypeLabelProvider;
import com.sap.dictionary.tools.simpletype.SimpletypeMultiEditorPart;
import com.sap.dictionary.tools.simpletype.TextPool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SimpletypeSelectionDialog
extends TitleAreaDialog {
    private TreeViewer mViewer;
    private DtSimpleType mSelection;
    private DtDictionaryRoot mDictionaryRoot;
    private String mTitle;
    private String mDescription;
    private SimpletypeMultiEditorPart mEditor;

    public SimpletypeSelectionDialog(String title, String description, DtDictionaryRoot dictionaryRoot, SimpletypeMultiEditorPart editor) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.mTitle = title;
        this.mEditor = editor;
        this.mDescription = description;
        this.mDictionaryRoot = dictionaryRoot;
    }

    public DtSimpleType getSimpleType() {
        return this.mSelection;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle(this.mTitle);
        this.setMessage(this.mDescription);
        this.mViewer = new TreeViewer(contents);
        this.mViewer.setContentProvider((IContentProvider)new SimpletypeContentProvider());
        this.mViewer.setLabelProvider((IBaseLabelProvider)new SimpletypeLabelProvider(this.mEditor));
        this.mViewer.setInput((Object)new SimpletypeContentProvider.DictionaryRoot(this.mDictionaryRoot));
        GridData data = new GridData(1040);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.mViewer.getControl().setLayoutData((Object)data);
        this.mViewer.expandToLevel(2);
        this.mViewer.setSelection(null);
        this.mViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SimpletypeSelectionDialog.super.getButton(0) != null) {
                    if (!event.getSelection().isEmpty()) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        if (selection != null && selection.size() > 0) {
                            Object data = selection.getFirstElement();
                            if (data instanceof DtSimpleType) {
                                SimpletypeSelectionDialog.this.mSelection = (DtSimpleType)data;
                                if (SimpletypeSelectionDialog.this.mEditor.checkForCycle(SimpletypeSelectionDialog.this.mSelection)) {
                                    SimpletypeSelectionDialog.super.getButton(0).setEnabled(false);
                                    SimpletypeSelectionDialog.this.setErrorMessage(TextPool.getMessage("Cyclic dependency: Base Type & depends on current simple type. Selection is not possible.", SimpletypeSelectionDialog.this.mSelection.getName()));
                                } else {
                                    SimpletypeSelectionDialog.super.getButton(0).setEnabled(true);
                                    SimpletypeSelectionDialog.this.setErrorMessage(null);
                                }
                            } else {
                                SimpletypeSelectionDialog.super.getButton(0).setEnabled(false);
                            }
                        }
                    } else {
                        SimpletypeSelectionDialog.super.getButton(0).setEnabled(false);
                    }
                }
            }
        });
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object data = selection.getFirstElement();
                if (data != null && data instanceof DtSimpleType) {
                    SimpletypeSelectionDialog.this.mSelection = (DtSimpleType)data;
                    SimpletypeSelectionDialog.this.close();
                }
            }
        });
        return contents;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 100;
        return size;
    }
}

