/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.designtime.DtSimpleTypeExpanded;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.generation.eclipse.deletion.DeletionService;
import com.sap.dictionary.tools.simpletype.SimpletypeConstants;
import com.sap.dictionary.tools.simpletype.SimpletypeDatabaseForm;
import com.sap.dictionary.tools.simpletype.SimpletypeDefinitionForm;
import com.sap.dictionary.tools.simpletype.SimpletypeEditorInput;
import com.sap.dictionary.tools.simpletype.SimpletypeEnumerationForm;
import com.sap.dictionary.tools.simpletype.SimpletypePlugin;
import com.sap.dictionary.tools.simpletype.SimpletypeRepresentationForm;
import com.sap.dictionary.tools.simpletype.SimpletypeStatusItem;
import com.sap.dictionary.tools.simpletype.TextPool;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditSimpleTypeInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbProperty;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTypeInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtEnumerationValue;
import com.sap.ide.metamodel.dictionary.datatype.DtExternalRepresentation;
import com.sap.ide.metamodel.dictionary.datatype.DtHint;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSchemaType;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtTechnicalInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtTextObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.MultiPageEditorPart;

public class SimpletypeMultiEditorPart
extends MultiPageEditorPart
implements IMetamodelSaveParticipant,
IDevelopmentObjectEditor {
    public SimpletypeDefinitionForm simpletypeDefinitionForm = null;
    public SimpletypeEnumerationForm simpletypeEnumerationForm = null;
    public SimpletypeRepresentationForm simpletypeRepresentationForm = null;
    public SimpletypeDatabaseForm simpletypeDatabaseForm = null;
    public Metamodel metamodel;
    private int readOnlyState = -1;
    private boolean isDirty = false;
    public boolean isLoading = false;
    public boolean suppressReload = false;
    public boolean textfileIsReadOnly = false;
    public String textfileName = "";
    public static SimpletypeStatusItem mStatusItem = null;
    public static IStatusLineManager mManager = null;
    public Image simpletypeImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)SimpletypePlugin.getDefault().getDescriptor(), (String)"ddSimpleType.gif");
    public Image packageImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)SimpletypePlugin.getDefault().getDescriptor(), (String)"package.gif");
    public Image dictionaryImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)SimpletypePlugin.getDefault().getDescriptor(), (String)"dictionary.gif");
    public Image modifyImage = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_CHANGE);
    public Image resetImage = SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_OO_INHERITANCE);
    public DatabaseEnum[] dictDatabases;
    public ArrayList jdbcTypeInfos;
    public DtDictionaryRoot dictRoot;
    public DtSimpleType dictSimpleType;
    private DtSchemaType dictSchemaType;
    private DtTextObject dictTextObject;
    private DtExternalRepresentation dictExternalRepresentation;
    private DtDbProperty dictDbProperty;
    private DtEnumerationValue dictEnumValue;
    private DtEnumerationValue[] dictEnumValues;
    private DtTechnicalInfo dictTechInfo;
    private DtDbTypeInfo dictTypeInfo;
    private DtDbTypeInfo[] dictTypeInfos;
    private Cut cutAction = new Cut(this);
    private Copy copyAction = new Copy(this);
    private Paste pasteAction = new Paste(this);

    protected void createPages() {
        ScrolledComposite sc1 = new ScrolledComposite(this.getContainer(), 768);
        sc1.setLayout((Layout)new FillLayout());
        sc1.setAlwaysShowScrollBars(false);
        sc1.getVerticalBar().setIncrement(10);
        sc1.getVerticalBar().setPageIncrement(100);
        sc1.getHorizontalBar().setIncrement(10);
        sc1.getHorizontalBar().setPageIncrement(100);
        Composite rootPage1 = new Composite((Composite)sc1, 0);
        sc1.setContent((Control)rootPage1);
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 1;
        rootPage1.setLayout((Layout)gridLayout1);
        this.simpletypeDefinitionForm = new SimpletypeDefinitionForm((IWidgetFactory)new LiteWidgetFactory(), 2, true, "Simple Type Definition", this);
        PaneFactory.establishGridLayoutPaneContainer((Composite)rootPage1, (IGridLayoutPaneContainer)this.simpletypeDefinitionForm);
        rootPage1.setSize(800, 600);
        int index1 = this.addPage((Control)sc1);
        this.setPageText(index1, "Definition");
        Composite rootPage11 = new Composite(this.getContainer(), 0);
        GridLayout gridLayout11 = new GridLayout();
        gridLayout11.numColumns = 1;
        rootPage11.setLayout((Layout)new FillLayout());
        this.simpletypeEnumerationForm = new SimpletypeEnumerationForm((IWidgetFactory)new LiteWidgetFactory(), 2, "Simple Type Enumeration", this);
        PaneFactory.establishGridLayoutPaneContainer((Composite)rootPage11, (IGridLayoutPaneContainer)this.simpletypeEnumerationForm);
        int index11 = this.addPage((Control)rootPage11);
        this.setPageText(index11, "Enumeration");
        ScrolledComposite sc2 = new ScrolledComposite(this.getContainer(), 768);
        sc2.setLayout((Layout)new FillLayout());
        sc2.setAlwaysShowScrollBars(false);
        sc2.getVerticalBar().setIncrement(10);
        sc2.getVerticalBar().setPageIncrement(100);
        sc2.getHorizontalBar().setIncrement(10);
        sc2.getHorizontalBar().setPageIncrement(100);
        Composite rootPage2 = new Composite((Composite)sc2, 0);
        sc2.setContent((Control)rootPage2);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        rootPage2.setLayout((Layout)gridLayout2);
        this.simpletypeRepresentationForm = new SimpletypeRepresentationForm((IWidgetFactory)new LiteWidgetFactory(), 2, true, "Simple Type Representation", this);
        PaneFactory.establishGridLayoutPaneContainer((Composite)rootPage2, (IGridLayoutPaneContainer)this.simpletypeRepresentationForm);
        rootPage2.setSize(800, 600);
        int index2 = this.addPage((Control)sc2);
        this.setPageText(index2, "Representation");
        ScrolledComposite sc3 = new ScrolledComposite(this.getContainer(), 768);
        sc3.setLayout((Layout)new FillLayout());
        sc3.setAlwaysShowScrollBars(false);
        sc3.getVerticalBar().setIncrement(10);
        sc3.getVerticalBar().setPageIncrement(100);
        sc3.getHorizontalBar().setIncrement(10);
        sc3.getHorizontalBar().setPageIncrement(100);
        Composite rootPage3 = new Composite((Composite)sc3, 0);
        sc3.setContent((Control)rootPage3);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 1;
        rootPage3.setLayout((Layout)gridLayout3);
        this.simpletypeDatabaseForm = new SimpletypeDatabaseForm((IWidgetFactory)new LiteWidgetFactory(), 2, "Simple Type Database Properties", this);
        PaneFactory.establishGridLayoutPaneContainer((Composite)rootPage3, (IGridLayoutPaneContainer)this.simpletypeDatabaseForm);
        rootPage3.setSize(800, 600);
        int index3 = this.addPage((Control)sc3);
        this.setPageText(index3, "Database");
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.cutAction);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.copyAction);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.pasteAction);
        if (this.getEditorInput() instanceof SimpletypeEditorInput) {
            this.dictRoot = ((SimpletypeEditorInput)this.getEditorInput()).dictRoot;
            this.dictSimpleType = ((SimpletypeEditorInput)this.getEditorInput()).dictSimpleType;
        } else if (this.getEditorInput() instanceof EditSimpleTypeInput) {
            this.metamodel = ((EditSimpleTypeInput)this.getEditorInput()).metamodel;
            this.dictRoot = ((EditSimpleTypeInput)this.getEditorInput()).dictRoot;
            this.dictSimpleType = ((EditSimpleTypeInput)this.getEditorInput()).dictSimpleType;
            if (((EditSimpleTypeInput)this.getEditorInput()).isCreated) {
                this.makeDirty();
            }
        } else if (this.getEditorInput() instanceof IFileEditorInput) {
            // empty if block
        }
        this.dictSchemaType = this.dictSimpleType.getSchemaType();
        this.dictTextObject = this.dictSimpleType.getTexts();
        this.dictExternalRepresentation = this.dictSimpleType.getExternalRepresentation();
        this.dictDbProperty = this.dictSimpleType.getDbProperty();
        if (this.dictSchemaType != null) {
            this.dictEnumValues = this.dictSchemaType.getEnumerationValues();
        }
        if (this.dictSchemaType == null | this.dictTextObject == null | this.dictExternalRepresentation == null | this.dictTextObject == null) {
            SimpletypeConstants.errMsg("Simple Type could not be loaded");
        }
        this.dictTechInfo = this.dictSimpleType.getTechnicalInfo();
        this.isLoading = true;
        this.loadRecursivelySimpleType(this.dictSimpleType);
        this.isLoading = false;
        this.simpletypeDefinitionForm.basicInfoSection.setEditableAndVisible();
        this.setTitle(this.dictSimpleType.getTypeName());
        if (this.isReadOnly()) {
            this.readOnlyState = 0;
            this.setEditorReadOnly();
        } else {
            this.readOnlyState = 1;
        }
        this.suppressReload = true;
        SimpletypePlugin.getDefault().activatePartListener();
    }

    public void setFocus() {
        super.setFocus();
        boolean temp = false;
        switch (this.readOnlyState) {
            case 0: {
                temp = true;
                break;
            }
            case 1: {
                temp = false;
                break;
            }
            default: {
                return;
            }
        }
        if (this.isReadOnly() != temp) {
            this.setActivePage(0);
            this.removePage(3);
            this.removePage(2);
            this.removePage(1);
            this.removePage(0);
            this.readOnlyState = -1;
            try {
                this.createPages();
                SimpletypeConstants.informationMsg("Information", "Read/write permission of simple type has been changed");
                this.setActivePage(0);
            }
            catch (Exception e) {
                SimpletypePlugin.tracer.error("reopen editor pages", (Throwable)e);
            }
            this.readOnlyState = this.isReadOnly() ? 0 : 1;
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IWorkbenchWindow wW;
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = dwindow.getPages();
        Object page = null;
        Object editorReferences = null;
        Object editor = null;
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            String lFileName = file.getFullPath().removeFileExtension().lastSegment();
            IProject project = file.getProject();
            String lProjectName = project.getName();
            IJavaProject javaProject = null;
            IProjectNature nature = null;
            try {
                nature = project.getNature("org.eclipse.jdt.core.javanature");
                if (nature instanceof IJavaProject) {
                    javaProject = (IJavaProject)nature;
                }
            }
            catch (CoreException e) {
                SimpletypePlugin.tracer.error("get project nature", (Throwable)e);
            }
            String lPackageName = null;
            try {
                lPackageName = javaProject.findPackageFragment(file.getParent().getFullPath()).getElementName();
            }
            catch (JavaModelException e) {
                SimpletypePlugin.tracer.error("get package name", (Throwable)e);
            }
            this.metamodel = MetamodelServices.getMetamodel((String)lProjectName);
            this.dictRoot = MetamodelServices.getDictionaryRoot((String)lProjectName);
            try {
                this.dictSimpleType = this.dictRoot.getSimpleType(lPackageName, lFileName);
            }
            catch (Exception e) {
                SimpletypeConstants.errMsg(TextPool.getMessage("Simple Type & does not exist in package &", lFileName, lPackageName));
            }
        }
        DatabaseEnum[] databases = new DatabaseEnum[30];
        int k = 0;
        Enumeration e = DatabaseEnum.enumerate();
        while (e.hasMoreElements()) {
            databases[k] = (DatabaseEnum)e.nextElement();
            ++k;
        }
        this.dictDatabases = new DatabaseEnum[k];
        int kk = 0;
        while (kk < k) {
            this.dictDatabases[kk] = databases[kk];
            ++kk;
        }
        if (mStatusItem == null && (wW = site.getWorkbenchWindow()) instanceof WorkbenchWindow) {
            WorkbenchWindow w = (WorkbenchWindow)wW;
            IActionBars bars = w.getActionBars();
            mManager = bars.getStatusLineManager();
            mStatusItem = new SimpletypeStatusItem();
            mManager.add((IContributionItem)mStatusItem);
        }
        super.init(site, input);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public void makeDirty() {
        if (!this.isDirty && !this.isLoading) {
            this.isDirty = true;
            if (!this.isReadOnly()) {
                SimpletypePlugin.getDefault().deactivatePartListener();
                try {
                    DtHint dummyHint = this.dictSimpleType.createHint("xrsztefgb");
                    try {
                        dummyHint.delete();
                    }
                    catch (DeleteException e) {
                        SimpletypePlugin.tracer.error("delete dummy hint", (Throwable)e);
                    }
                }
                catch (CreateException e) {
                    SimpletypePlugin.tracer.error("create dummy hint", (Throwable)e);
                }
                SimpletypePlugin.getDefault().activatePartListener();
            }
        }
    }

    public void makeDirty(Widget widget) {
        Text ltext = null;
        int lpos = 0;
        if (widget instanceof Text) {
            ltext = (Text)widget;
            lpos = ltext.getCaretPosition();
        }
        this.makeDirty();
        if (widget instanceof Text) {
            ltext.setFocus();
            ltext.setSelection(lpos, lpos);
        }
    }

    public void updateMetamodel() {
        block44: {
            boolean enumCountOld = false;
            int enumCountNew = 0;
            if (this.isReadOnly()) {
                return;
            }
            if (!this.isDirty) {
                return;
            }
            String ls = null;
            if (this.dictSchemaType == null) break block44;
            String lBaseTypeFullName = this.simpletypeDefinitionForm.basicInfoSection.textBaseTypeFullName.getText();
            String lBaseTypeName = this.simpletypeDefinitionForm.basicInfoSection.getBaseTypeName(lBaseTypeFullName);
            String lBaseTypePrefix = this.simpletypeDefinitionForm.basicInfoSection.getBaseTypePrefix(lBaseTypeFullName);
            if (lBaseTypeFullName.equals("")) {
                this.dictSimpleType.setBaseType(null);
                this.dictSimpleType.setBaseTypeName(null);
                this.dictSimpleType.setBaseTypePrefix(null);
            } else {
                DtSimpleType dictBaseType = null;
                if (this.dictRoot.hasSimpleType(lBaseTypePrefix, lBaseTypeName)) {
                    try {
                        dictBaseType = this.dictRoot.getSimpleType(lBaseTypePrefix, lBaseTypeName);
                    }
                    catch (LoadException e) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Base Type & does not exist. Update of simple type is not possible.", lBaseTypeFullName));
                        lBaseTypeName = "";
                        return;
                    }
                    if (this.checkForCycle(dictBaseType)) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Cyclic dependency: Base Type & depends on current simple type. Update of simple type is not possible.", lBaseTypeFullName));
                        return;
                    }
                    if (dictBaseType.hasLogicalDictionary()) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Simple Type & is imported from an external dictionary. It cannot be used as a base type. Update of simple type is not possible.", lBaseTypeFullName));
                        return;
                    }
                    this.dictSimpleType.setBaseType(dictBaseType);
                    this.dictSimpleType.setBaseTypeName(lBaseTypeName);
                    this.dictSimpleType.setBaseTypePrefix(lBaseTypePrefix);
                } else {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Base Type & does not exist. Update of simple type is not possible.", lBaseTypeFullName));
                    lBaseTypeName = "";
                    return;
                }
            }
            this.dictSimpleType.setBuiltInType(this.calculateStringPropertyFromCombo(this.simpletypeDefinitionForm.basicInfoSection.comboBuiltInType));
            ls = this.calculateStringProperty(this.simpletypeDefinitionForm.basicInfoSection.textDescription);
            if (ls == null) {
                if (this.dictTextObject.getDescriptionAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getDescriptionAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setDescription(ls);
            }
            this.dictSchemaType.setLength(this.calculateIntProperty(this.simpletypeDefinitionForm.lengthConstraintsSection.textLength, this.simpletypeDefinitionForm.lengthConstraintsSection.iLength));
            this.dictSchemaType.setMinLength(this.calculateIntProperty(this.simpletypeDefinitionForm.lengthConstraintsSection.textMinLength, this.simpletypeDefinitionForm.lengthConstraintsSection.iMinLength));
            this.dictSchemaType.setMaxLength(this.calculateIntProperty(this.simpletypeDefinitionForm.lengthConstraintsSection.textMaxLength, this.simpletypeDefinitionForm.lengthConstraintsSection.iMaxLength));
            this.dictSchemaType.setTotalDigits(this.calculateIntProperty(this.simpletypeDefinitionForm.lengthConstraintsSection.textTotalDigits, this.simpletypeDefinitionForm.lengthConstraintsSection.iTotalDigits));
            this.dictSchemaType.setFractionDigits(this.calculateIntProperty(this.simpletypeDefinitionForm.lengthConstraintsSection.textFractionDigits, this.simpletypeDefinitionForm.lengthConstraintsSection.iFractionDigits));
            this.dictSchemaType.setMinInclusive(this.calculateStringProperty(this.simpletypeDefinitionForm.valueConstraintsSection.textMinInclusive));
            this.dictSchemaType.setMaxInclusive(this.calculateStringProperty(this.simpletypeDefinitionForm.valueConstraintsSection.textMaxInclusive));
            this.dictSchemaType.setMinExclusive(this.calculateStringProperty(this.simpletypeDefinitionForm.valueConstraintsSection.textMinExclusive));
            this.dictSchemaType.setMaxExclusive(this.calculateStringProperty(this.simpletypeDefinitionForm.valueConstraintsSection.textMaxExclusive));
            String sPattern = null;
            if (this.simpletypeDefinitionForm.valueConstraintsSection.textPattern.getEditable()) {
                sPattern = this.simpletypeDefinitionForm.valueConstraintsSection.textPattern.getText();
            }
            this.dictSchemaType.setPattern(sPattern);
            ls = this.calculateStringProperty(this.simpletypeRepresentationForm.textObjectSection.textFieldLabel);
            if (ls == null) {
                this.dictTextObject.setFieldLabelInherited(true);
                if (this.dictTextObject.getFieldLabelAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getFieldLabelAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setFieldLabelInherited(false);
                this.dictTextObject.setFieldLabel(ls);
            }
            if ((ls = this.calculateStringProperty(this.simpletypeRepresentationForm.textObjectSection.textColumnLabel)) == null) {
                this.dictTextObject.setColumnLabelInherited(true);
                if (this.dictTextObject.getColumnLabelAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getColumnLabelAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setColumnLabelInherited(false);
                this.dictTextObject.setColumnLabel(ls);
            }
            if ((ls = this.calculateStringProperty(this.simpletypeRepresentationForm.textObjectSection.textQuickInfo)) == null) {
                this.dictTextObject.setQuickInfoInherited(true);
                if (this.dictTextObject.getQuickInfoAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getQuickInfoAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setQuickInfoInherited(false);
                this.dictTextObject.setQuickInfo(ls);
            }
            boolean b = false;
            this.dictExternalRepresentation.setFormat(this.calculateStringProperty(this.simpletypeRepresentationForm.externalRepresentationSection.textFormat));
            this.dictExternalRepresentation.setMaxExternalLength(this.calculateIntProperty(this.simpletypeRepresentationForm.externalRepresentationSection.textExternalLength, this.simpletypeRepresentationForm.externalRepresentationSection.iExternalLength));
            this.dictExternalRepresentation.setUppercase(this.calculateBooleanProperty(this.simpletypeRepresentationForm.externalRepresentationSection.buttonUppercase));
            this.dictExternalRepresentation.setTranslateFlag(this.calculateBooleanProperty(this.simpletypeRepresentationForm.externalRepresentationSection.buttonTranslate));
            this.dictExternalRepresentation.setReadOnly(this.calculateBooleanProperty(this.simpletypeRepresentationForm.externalRepresentationSection.buttonReadOnly));
            String jdbcType = this.simpletypeDatabaseForm.dbPropertySection.textlabelJdbcTypeName.getText();
            if (jdbcType.equals("")) {
                jdbcType = null;
            }
            if (!lBaseTypeName.equals("")) {
                jdbcType = null;
            }
            this.dictDbProperty.setJdbcTypeName(jdbcType);
            this.dictDbProperty.setDbDefault(this.calculateStringProperty(this.simpletypeDatabaseForm.dbPropertySection.textDbDefault));
            this.simpletypeDatabaseForm.dbPropertySection.adaptNotNull(false);
            this.dictDbProperty.setNotNull(this.calculateBooleanProperty(this.simpletypeDatabaseForm.dbPropertySection.buttonNotNull));
            this.updateTypeInfoMetadata();
            if (this.dictTechInfo == null) {
                try {
                    this.dictTechInfo = this.dictSimpleType.createTechnicalInfo();
                }
                catch (CreateException e) {
                    SimpletypeConstants.errMsg("Technical info could not be created");
                }
            }
            boolean withClassRep = this.simpletypeEnumerationForm.enumerationSection.buttonWithClassRepresentation.getSelection();
            enumCountNew = this.simpletypeEnumerationForm.enumTableModel.getRowCount();
            this.dictTechInfo.setWithClass(withClassRep);
            String hintKey = null;
            String hintValue = null;
            DtHint hint = null;
            if (withClassRep && enumCountNew > 0) {
                HashMap hintInfo = DtSimpleTypeExpanded.getHintInfo((DtSimpleType)this.dictSimpleType);
                Iterator it = hintInfo.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    hintKey = (String)entry.getKey();
                    hintValue = (String)entry.getValue();
                    if (this.dictSimpleType.hasHint(hintKey)) continue;
                    try {
                        hint = this.dictSimpleType.createHint(hintKey);
                        hint.setSoftwareLanguage(hintKey);
                        hint.setLanguageDataType(hintValue);
                    }
                    catch (CreateException e) {
                        SimpletypeConstants.errMsg("Hint could not be created");
                    }
                }
            } else {
                String projectName = this.dictSimpleType.getDictionary().getMetamodel().getName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                DeletionService delService = new DeletionService(project);
                delService.deleteSimpleTypeEnumClass(this.dictSimpleType, true);
                DtHint[] existingHints = this.dictSimpleType.getHints();
                int k = 0;
                while (k < existingHints.length) {
                    hint = existingHints[k];
                    try {
                        hint.delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Hint could not be deleted");
                    }
                    ++k;
                }
            }
        }
    }

    public void updateMetamodelOnClose() {
        block44: {
            boolean enumCountOld = false;
            int enumCountNew = 0;
            if (!this.dictSimpleType.isValid()) {
                return;
            }
            if (this.isReadOnly()) {
                return;
            }
            if (!this.isDirty) {
                return;
            }
            String ls = null;
            if (this.dictSchemaType == null) break block44;
            String lBaseTypeFullName = this.simpletypeDefinitionForm.basicInfoSection.yyBaseTypeFullName;
            String lBaseTypeName = this.simpletypeDefinitionForm.basicInfoSection.getBaseTypeName(lBaseTypeFullName);
            String lBaseTypePrefix = this.simpletypeDefinitionForm.basicInfoSection.getBaseTypePrefix(lBaseTypeFullName);
            if (lBaseTypeFullName.equals("")) {
                this.dictSimpleType.setBaseType(null);
                this.dictSimpleType.setBaseTypeName(null);
                this.dictSimpleType.setBaseTypePrefix(null);
            } else {
                DtSimpleType dictBaseType = null;
                if (this.dictRoot.hasSimpleType(lBaseTypePrefix, lBaseTypeName)) {
                    try {
                        dictBaseType = this.dictRoot.getSimpleType(lBaseTypePrefix, lBaseTypeName);
                    }
                    catch (LoadException e) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Base Type & does not exist. Update of simple type is not possible.", lBaseTypeFullName));
                        lBaseTypeName = "";
                        return;
                    }
                    if (this.checkForCycle(dictBaseType)) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Cyclic dependency: Base Type & depends on current simple type. Update of simple type is not possible.", lBaseTypeFullName));
                        return;
                    }
                    if (dictBaseType.hasLogicalDictionary()) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Simple Type & is imported from an external dictionary. It cannot be used as a base type. Update of simple type is not possible.", lBaseTypeFullName));
                        return;
                    }
                    this.dictSimpleType.setBaseType(dictBaseType);
                    this.dictSimpleType.setBaseTypeName(lBaseTypeName);
                    this.dictSimpleType.setBaseTypePrefix(lBaseTypePrefix);
                } else {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)TextPool.getMessage("Update Error for Simple Type & ", this.dictSimpleType.getName()), (String)TextPool.getMessage("Base Type & does not exist. Update of simple type is not possible.", lBaseTypeFullName));
                    lBaseTypeName = "";
                    return;
                }
            }
            this.dictSimpleType.setBuiltInType(this.simpletypeDefinitionForm.basicInfoSection.yyBuiltInType);
            ls = this.simpletypeDefinitionForm.basicInfoSection.yyDescription;
            if (ls == null) {
                if (this.dictTextObject.getDescriptionAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getDescriptionAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setDescription(ls);
            }
            this.dictSchemaType.setLength(this.simpletypeDefinitionForm.lengthConstraintsSection.yyLength);
            this.dictSchemaType.setMinLength(this.simpletypeDefinitionForm.lengthConstraintsSection.yyMinLength);
            this.dictSchemaType.setMaxLength(this.simpletypeDefinitionForm.lengthConstraintsSection.yyMaxLength);
            this.dictSchemaType.setTotalDigits(this.simpletypeDefinitionForm.lengthConstraintsSection.yyTotalDigits);
            this.dictSchemaType.setFractionDigits(this.simpletypeDefinitionForm.lengthConstraintsSection.yyFractionDigits);
            this.dictSchemaType.setMinInclusive(this.simpletypeDefinitionForm.valueConstraintsSection.yyMinInclusive);
            this.dictSchemaType.setMaxInclusive(this.simpletypeDefinitionForm.valueConstraintsSection.yyMaxInclusive);
            this.dictSchemaType.setMinExclusive(this.simpletypeDefinitionForm.valueConstraintsSection.yyMinExclusive);
            this.dictSchemaType.setMaxExclusive(this.simpletypeDefinitionForm.valueConstraintsSection.yyMaxExclusive);
            this.dictSchemaType.setPattern(this.simpletypeDefinitionForm.valueConstraintsSection.yyPattern);
            ls = this.simpletypeRepresentationForm.textObjectSection.yyFieldLabel;
            if (ls == null) {
                this.dictTextObject.setFieldLabelInherited(true);
                if (this.dictTextObject.getFieldLabelAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getFieldLabelAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setFieldLabelInherited(false);
                this.dictTextObject.setFieldLabel(ls);
            }
            if ((ls = this.simpletypeRepresentationForm.textObjectSection.yyColumnLabel) == null) {
                this.dictTextObject.setColumnLabelInherited(true);
                if (this.dictTextObject.getColumnLabelAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getColumnLabelAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setColumnLabelInherited(false);
                this.dictTextObject.setColumnLabel(ls);
            }
            if ((ls = this.simpletypeRepresentationForm.textObjectSection.yyQuickInfo) == null) {
                this.dictTextObject.setQuickInfoInherited(true);
                if (this.dictTextObject.getQuickInfoAsTranslatableText() != null) {
                    try {
                        this.dictTextObject.getQuickInfoAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
            } else {
                this.dictTextObject.setQuickInfoInherited(false);
                this.dictTextObject.setQuickInfo(ls);
            }
            boolean b = false;
            this.dictExternalRepresentation.setFormat(this.simpletypeRepresentationForm.externalRepresentationSection.yyFormat);
            this.dictExternalRepresentation.setMaxExternalLength(this.simpletypeRepresentationForm.externalRepresentationSection.yyExternalLength);
            this.dictExternalRepresentation.setUppercase(this.simpletypeRepresentationForm.externalRepresentationSection.yyUppercase);
            this.dictExternalRepresentation.setTranslateFlag(this.simpletypeRepresentationForm.externalRepresentationSection.yyTranslate);
            this.dictExternalRepresentation.setReadOnly(this.simpletypeRepresentationForm.externalRepresentationSection.yyReadOnly);
            String jdbcType = this.simpletypeDatabaseForm.dbPropertySection.yyJdbcTypeName;
            if (jdbcType.equals("")) {
                jdbcType = null;
            }
            if (!lBaseTypeName.equals("")) {
                jdbcType = null;
            }
            this.dictDbProperty.setJdbcTypeName(jdbcType);
            this.dictDbProperty.setDbDefault(this.simpletypeDatabaseForm.dbPropertySection.yyDbDefault);
            this.simpletypeDatabaseForm.dbPropertySection.adaptNotNullOnClose(false);
            this.dictDbProperty.setNotNull(this.simpletypeDatabaseForm.dbPropertySection.yyNotNull);
            this.updateTypeInfoMetadata();
            if (this.dictTechInfo == null) {
                try {
                    this.dictTechInfo = this.dictSimpleType.createTechnicalInfo();
                }
                catch (CreateException e) {
                    SimpletypeConstants.errMsg("Technical info could not be created");
                }
            }
            boolean withClassRep = this.simpletypeEnumerationForm.enumerationSection.yyWithClassRepresentation;
            enumCountNew = this.simpletypeEnumerationForm.enumTableModel.getRowCount();
            this.dictTechInfo.setWithClass(withClassRep);
            String hintKey = null;
            String hintValue = null;
            DtHint hint = null;
            if (withClassRep && enumCountNew > 0) {
                HashMap hintInfo = DtSimpleTypeExpanded.getHintInfo((DtSimpleType)this.dictSimpleType);
                Iterator it = hintInfo.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    hintKey = (String)entry.getKey();
                    hintValue = (String)entry.getValue();
                    if (this.dictSimpleType.hasHint(hintKey)) continue;
                    try {
                        hint = this.dictSimpleType.createHint(hintKey);
                        hint.setSoftwareLanguage(hintKey);
                        hint.setLanguageDataType(hintValue);
                    }
                    catch (CreateException e) {
                        SimpletypeConstants.errMsg("Hint could not be created");
                    }
                }
            } else {
                String projectName = this.dictSimpleType.getDictionary().getMetamodel().getName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                DeletionService delService = new DeletionService(project);
                delService.deleteSimpleTypeEnumClass(this.dictSimpleType, true);
                DtHint[] existingHints = this.dictSimpleType.getHints();
                int k = 0;
                while (k < existingHints.length) {
                    hint = existingHints[k];
                    try {
                        hint.delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Hint could not be deleted");
                    }
                    ++k;
                }
            }
        }
    }

    public void loadSimpleType(DtSimpleType dictSimpleType) {
        this.isLoading = true;
        DtSchemaType dictSchemaType = dictSimpleType.getSchemaType();
        DtTextObject dictTextObject = dictSimpleType.getTexts();
        DtExternalRepresentation dictExternalRepresentation = dictSimpleType.getExternalRepresentation();
        DtDbProperty dictDbProperty = dictSimpleType.getDbProperty();
        DtEnumerationValue[] dictEnumValues = dictSchemaType.getEnumerationValues();
        DtEnumerationValue dictEnumValue = null;
        DtTechnicalInfo dictTechInfo = dictSimpleType.getTechnicalInfo();
        this.loadStringProperty(dictSimpleType.getTypeName(), this.simpletypeDefinitionForm.basicInfoSection.textName);
        this.simpletypeDefinitionForm.basicInfoSection.textName.setEditable(false);
        this.loadStringProperty(dictSimpleType.getPackage(), this.simpletypeDefinitionForm.basicInfoSection.textPackage);
        this.simpletypeDefinitionForm.basicInfoSection.textPackage.setEditable(false);
        if (dictSimpleType.hasLogicalDictionary()) {
            DtLogicalDictionary logDict = dictSimpleType.getLogicalDictionary();
            this.simpletypeDefinitionForm.basicInfoSection.textDictionary.setText(logDict.getName());
        } else {
            this.simpletypeDefinitionForm.basicInfoSection.textDictionary.setText("Local Dictionary");
        }
        String lBaseTypeName = dictSimpleType.getBaseTypeName();
        String lBaseTypePrefix = dictSimpleType.getBaseTypePrefix();
        String lBaseTypeFullName = "";
        if (lBaseTypeName != null & lBaseTypePrefix != null) {
            lBaseTypeFullName = lBaseTypePrefix + "." + lBaseTypeName;
        }
        this.simpletypeDefinitionForm.basicInfoSection.textBaseTypeFullName.setText(lBaseTypeFullName);
        this.simpletypeDefinitionForm.basicInfoSection.yyBaseTypeFullName = lBaseTypeFullName;
        this.simpletypeDefinitionForm.basicInfoSection.currentBaseType = dictSimpleType.getBaseType();
        this.loadStringPropertyToCombo(dictSimpleType.getBuiltInType(), this.simpletypeDefinitionForm.basicInfoSection.comboBuiltInType);
        this.simpletypeDefinitionForm.basicInfoSection.yyBuiltInType = dictSimpleType.getBuiltInType();
        this.loadStringProperty(dictTextObject.getDescription(), this.simpletypeDefinitionForm.basicInfoSection.textDescription);
        this.simpletypeDefinitionForm.basicInfoSection.yyDescription = dictTextObject.getDescription();
        if (dictSchemaType != null) {
            this.loadIntProperty(dictSchemaType.getLength(), this.simpletypeDefinitionForm.lengthConstraintsSection.textLength);
            this.simpletypeDefinitionForm.lengthConstraintsSection.yyLength = dictSchemaType.getLength();
            this.loadIntProperty(dictSchemaType.getMinLength(), this.simpletypeDefinitionForm.lengthConstraintsSection.textMinLength);
            this.simpletypeDefinitionForm.lengthConstraintsSection.yyMinLength = dictSchemaType.getMinLength();
            this.loadIntProperty(dictSchemaType.getMaxLength(), this.simpletypeDefinitionForm.lengthConstraintsSection.textMaxLength);
            this.simpletypeDefinitionForm.lengthConstraintsSection.yyMaxLength = dictSchemaType.getMaxLength();
            if (this.simpletypeDefinitionForm.basicInfoSection.currentBaseType == null) {
                this.loadIntPropertyWithDefault(dictSchemaType.getTotalDigits(), this.simpletypeDefinitionForm.lengthConstraintsSection.textTotalDigits);
                this.loadIntPropertyWithDefault(dictSchemaType.getFractionDigits(), this.simpletypeDefinitionForm.lengthConstraintsSection.textFractionDigits);
            } else {
                this.loadIntProperty(dictSchemaType.getTotalDigits(), this.simpletypeDefinitionForm.lengthConstraintsSection.textTotalDigits);
                this.loadIntProperty(dictSchemaType.getFractionDigits(), this.simpletypeDefinitionForm.lengthConstraintsSection.textFractionDigits);
            }
            this.simpletypeDefinitionForm.lengthConstraintsSection.yyTotalDigits = dictSchemaType.getTotalDigits();
            this.simpletypeDefinitionForm.lengthConstraintsSection.yyFractionDigits = dictSchemaType.getFractionDigits();
        }
        if (dictSchemaType != null) {
            this.loadStringProperty(dictSchemaType.getMinInclusive(), this.simpletypeDefinitionForm.valueConstraintsSection.textMinInclusive);
            this.simpletypeDefinitionForm.valueConstraintsSection.yyMinInclusive = dictSchemaType.getMinInclusive();
            this.loadStringProperty(dictSchemaType.getMaxInclusive(), this.simpletypeDefinitionForm.valueConstraintsSection.textMaxInclusive);
            this.simpletypeDefinitionForm.valueConstraintsSection.yyMaxInclusive = dictSchemaType.getMaxInclusive();
            this.loadStringProperty(dictSchemaType.getMinExclusive(), this.simpletypeDefinitionForm.valueConstraintsSection.textMinExclusive);
            this.simpletypeDefinitionForm.valueConstraintsSection.yyMinExclusive = dictSchemaType.getMinExclusive();
            this.loadStringProperty(dictSchemaType.getMaxExclusive(), this.simpletypeDefinitionForm.valueConstraintsSection.textMaxExclusive);
            this.simpletypeDefinitionForm.valueConstraintsSection.yyMaxExclusive = dictSchemaType.getMaxExclusive();
            this.loadStringProperty(dictSchemaType.getPattern(), this.simpletypeDefinitionForm.valueConstraintsSection.textPattern);
            this.simpletypeDefinitionForm.valueConstraintsSection.yyPattern = dictSchemaType.getPattern();
        }
        if (dictTextObject != null) {
            this.loadTextProperty(dictTextObject.getFieldLabel(), this.simpletypeRepresentationForm.textObjectSection.textFieldLabel, dictTextObject.getFieldLabelInherited());
            this.simpletypeRepresentationForm.textObjectSection.yyFieldLabel = dictTextObject.getFieldLabelInherited() ? null : dictTextObject.getFieldLabel();
            this.loadTextProperty(dictTextObject.getColumnLabel(), this.simpletypeRepresentationForm.textObjectSection.textColumnLabel, dictTextObject.getColumnLabelInherited());
            this.simpletypeRepresentationForm.textObjectSection.yyColumnLabel = dictTextObject.getColumnLabelInherited() ? null : dictTextObject.getColumnLabel();
            this.loadTextProperty(dictTextObject.getQuickInfo(), this.simpletypeRepresentationForm.textObjectSection.textQuickInfo, dictTextObject.getQuickInfoInherited());
            this.simpletypeRepresentationForm.textObjectSection.yyQuickInfo = dictTextObject.getQuickInfoInherited() ? null : dictTextObject.getQuickInfo();
        }
        if (dictExternalRepresentation != null) {
            this.loadStringProperty(dictExternalRepresentation.getFormat(), this.simpletypeRepresentationForm.externalRepresentationSection.textFormat);
            this.simpletypeRepresentationForm.externalRepresentationSection.yyFormat = dictExternalRepresentation.getFormat();
            this.loadIntProperty(dictExternalRepresentation.getMaxExternalLength(), this.simpletypeRepresentationForm.externalRepresentationSection.textExternalLength);
            this.simpletypeRepresentationForm.externalRepresentationSection.yyExternalLength = dictExternalRepresentation.getMaxExternalLength();
            this.loadBooleanProperty(dictExternalRepresentation.getUppercase(), this.simpletypeRepresentationForm.externalRepresentationSection.buttonUppercase);
            this.simpletypeRepresentationForm.externalRepresentationSection.yyUppercase = dictExternalRepresentation.getUppercase();
            this.loadBooleanProperty(dictExternalRepresentation.getTranslateFlag(), this.simpletypeRepresentationForm.externalRepresentationSection.buttonTranslate);
            this.simpletypeRepresentationForm.externalRepresentationSection.yyTranslate = dictExternalRepresentation.getTranslateFlag();
            this.loadBooleanProperty(dictExternalRepresentation.getReadOnly(), this.simpletypeRepresentationForm.externalRepresentationSection.buttonReadOnly);
            this.simpletypeRepresentationForm.externalRepresentationSection.yyReadOnly = dictExternalRepresentation.getReadOnly();
        }
        if (dictDbProperty != null) {
            this.loadStringProperty(dictDbProperty.getDbDefault(), this.simpletypeDatabaseForm.dbPropertySection.textDbDefault);
            this.simpletypeDatabaseForm.dbPropertySection.yyDbDefault = dictDbProperty.getDbDefault();
            this.loadBooleanProperty(dictDbProperty.getNotNull(), this.simpletypeDatabaseForm.dbPropertySection.buttonNotNull);
            this.simpletypeDatabaseForm.dbPropertySection.yyNotNull = dictDbProperty.getNotNull();
            this.simpletypeDatabaseForm.dbPropertySection.checkNotNull();
        }
        if (dictTechInfo != null) {
            this.simpletypeEnumerationForm.enumerationSection.buttonWithClassRepresentation.setSelection(dictTechInfo.getWithClass());
            this.simpletypeEnumerationForm.enumerationSection.yyWithClassRepresentation = dictTechInfo.getWithClass();
        }
        if (dictSchemaType != null) {
            ArrayList<DtEnumerationValue> enumList = new ArrayList<DtEnumerationValue>();
            int i = 0;
            while (i < dictSchemaType.getEnumerationValueCount()) {
                dictEnumValue = dictEnumValues[i];
                enumList.add(dictEnumValue);
                ++i;
            }
            Collections.sort(enumList, new NameComparator());
            Iterator elements = enumList.iterator();
            if (dictSchemaType.getEnumerationValueCount() > 0) {
                this.simpletypeEnumerationForm.clearAll();
                while (elements.hasNext()) {
                    dictEnumValue = (DtEnumerationValue)elements.next();
                    String sval = dictEnumValue.getValue();
                    String sdescr = dictEnumValue.getDescription();
                    this.simpletypeEnumerationForm.addTableRow(sval, sdescr);
                }
            }
        }
        this.adaptModifyButtons();
        this.simpletypeEnumerationForm.enumerationSection.tableDirty = false;
        this.simpletypeDefinitionForm.basicInfoSection.previousBuiltInTypeName = this.simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText();
        this.isLoading = false;
    }

    public void loadRecursivelySimpleType(DtSimpleType dictSimpleType) {
        if (dictSimpleType.getBaseTypePrefix() != null & dictSimpleType.getBaseTypeName() != null) {
            if (dictSimpleType.getDictionary().hasSimpleType(dictSimpleType.getBaseTypePrefix(), dictSimpleType.getBaseTypeName())) {
                DtSimpleType dictBaseType = dictSimpleType.getBaseType();
                if (dictBaseType != null) {
                    this.loadRecursivelySimpleType(dictBaseType);
                }
            } else {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Inconsistent Simple Type", (String)TextPool.getMessage("This simple type derives directly or indirectly from base type &.&. The base type does not exist. Replace it with an existing base type.", dictSimpleType.getBaseTypePrefix(), dictSimpleType.getBaseTypeName()));
            }
        }
        this.loadSimpleType(dictSimpleType);
    }

    public void reloadAll() {
        if (this.simpletypeDefinitionForm == null) {
            return;
        }
        if (this.suppressReload) {
            this.suppressReload = false;
        } else {
            this.clearAllForReload();
            this.isLoading = true;
            this.loadRecursivelySimpleType(this.dictSimpleType);
            this.isLoading = false;
            this.simpletypeDefinitionForm.basicInfoSection.setEditableAndVisible();
            String jdbcType = this.getJdbcTypeName(this.simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), this.simpletypeDefinitionForm.lengthConstraintsSection.jdbcLength);
            Label labelJdbcType = this.simpletypeDatabaseForm.dbPropertySection.textlabelJdbcTypeName;
            if (labelJdbcType != null) {
                labelJdbcType.setText(jdbcType);
            }
            if (this.isReadOnly()) {
                this.readOnlyState = 0;
                this.setEditorReadOnly();
            } else {
                this.readOnlyState = 1;
            }
            SimpletypePlugin.getDefault().activatePartListener();
        }
    }

    public void reloadNotNull() {
        this.loadBooleanProperty(this.dictDbProperty.getNotNull(), this.simpletypeDatabaseForm.dbPropertySection.buttonNotNull);
    }

    public boolean checkForCycle(DtSimpleType simpleType) {
        while (simpleType != null) {
            if (simpleType == this.dictSimpleType) {
                return true;
            }
            if (simpleType.getBaseTypeName() != null) {
                if (simpleType.getDictionary().hasSimpleType(simpleType.getBaseTypePrefix(), simpleType.getBaseTypeName())) {
                    simpleType = simpleType.getBaseType();
                    continue;
                }
                simpleType = null;
                continue;
            }
            simpleType = null;
        }
        return false;
    }

    private void loadStringProperty(String ls, Text ltext) {
        if (ls == null) {
            ltext.setEditable(false);
        } else if (ls.trim().equals("")) {
            ls = "";
            ltext.setText(ls);
            ltext.setEditable(true);
        } else {
            ltext.setText(ls);
            ltext.setEditable(true);
        }
    }

    private void loadTextProperty(String ls, Text ltext, boolean linh) {
        if (linh) {
            ltext.setEditable(false);
        } else if (ls == null) {
            ltext.setText("");
            ltext.setEditable(true);
        } else {
            ltext.setText(ls);
            ltext.setEditable(true);
        }
    }

    private void loadStringPropertyToCombo(String ls, Combo lcombo) {
        if (ls == null) {
            lcombo.setEnabled(false);
        } else if (ls.trim().equals("")) {
            ls = "";
            lcombo.setText(ls);
            lcombo.setEnabled(true);
        } else {
            lcombo.setText(ls);
            lcombo.setEnabled(true);
        }
    }

    private void loadIntProperty(int li, Text ltext) {
        String ls = "";
        if (li > 0) {
            ls = String.valueOf(li);
            ltext.setText(ls);
            ltext.setEditable(true);
        } else if (li == 0) {
            ltext.setEditable(false);
        } else {
            ls = "";
            ltext.setText(ls);
            ltext.setEditable(true);
        }
    }

    private void loadIntPropertyWithDefault(int li, Text ltext) {
        String ls = "";
        if (li > 0) {
            ls = String.valueOf(li);
            ltext.setText(ls);
            ltext.setEditable(true);
        } else if (li == 0) {
            ls = "0";
            ltext.setText(ls);
            ltext.setEditable(false);
        } else {
            ls = "";
            ltext.setText(ls);
            ltext.setEditable(true);
        }
    }

    private void loadBooleanProperty(BooleanEnum lb, Button lbutton) {
        if (lb == null) {
            lbutton.setEnabled(false);
        } else if (lb == BooleanEnum.NOT_SET) {
            lbutton.setEnabled(false);
        } else if (lb == BooleanEnum.TRUE) {
            lbutton.setSelection(true);
            lbutton.setEnabled(true);
        } else {
            lbutton.setSelection(false);
            lbutton.setEnabled(true);
        }
    }

    protected String calculateStringProperty(Text ltext) {
        String ls = null;
        if (ltext.getEditable() & ltext.getVisible()) {
            ls = ltext.getText();
        }
        return ls;
    }

    protected String calculateStringPropertyFromCombo(Combo lcombo) {
        String ls = null;
        if (lcombo.getEnabled()) {
            ls = lcombo.getText();
        }
        return ls;
    }

    protected int calculateIntProperty(Text ltext, Integer lint) {
        int li = 0;
        if (ltext.getEditable() & ltext.getVisible()) {
            li = ltext.getText().equals("") ? -1 : lint;
        }
        return li;
    }

    protected BooleanEnum calculateBooleanProperty(Button lbutton) {
        BooleanEnum lbe = BooleanEnum.NOT_SET;
        if (lbutton.getEnabled()) {
            lbe = lbutton.getSelection() ? BooleanEnum.TRUE : BooleanEnum.FALSE;
        }
        return lbe;
    }

    public void setAllEditable(boolean editable) {
        this.simpletypeDefinitionForm.lengthConstraintsSection.setAllEditable(editable);
        this.simpletypeDefinitionForm.valueConstraintsSection.setAllEditable(editable);
        this.simpletypeRepresentationForm.textObjectSection.setAllEditable(editable);
        this.simpletypeRepresentationForm.externalRepresentationSection.setAllEditable(editable);
        this.simpletypeDatabaseForm.dbPropertySection.setAllEditable(editable);
    }

    public void clearAll() {
        if (!this.isLoading) {
            this.simpletypeDefinitionForm.lengthConstraintsSection.clearAll();
            this.simpletypeDefinitionForm.valueConstraintsSection.clearAll();
            this.simpletypeRepresentationForm.textObjectSection.clearAll();
            this.simpletypeRepresentationForm.externalRepresentationSection.clearAll();
            this.simpletypeDatabaseForm.dbPropertySection.clearAll();
            this.simpletypeEnumerationForm.clearAll();
            this.simpletypeEnumerationForm.enumerationSection.buttonWithClassRepresentation.setSelection(false);
        }
    }

    public void clearAllForReload() {
        boolean loadingState = this.isLoading;
        this.isLoading = true;
        this.simpletypeDefinitionForm.lengthConstraintsSection.clearAll();
        this.simpletypeDefinitionForm.valueConstraintsSection.clearAll();
        this.simpletypeRepresentationForm.textObjectSection.clearAll();
        this.simpletypeRepresentationForm.externalRepresentationSection.clearAll();
        this.simpletypeDatabaseForm.dbPropertySection.clearAll();
        this.simpletypeEnumerationForm.clearAll();
        this.simpletypeEnumerationForm.enumerationSection.buttonWithClassRepresentation.setSelection(false);
        this.isLoading = loadingState;
    }

    public void clearAllFocusEvents() {
        this.simpletypeDefinitionForm.lengthConstraintsSection.focusEvent = null;
        this.simpletypeDefinitionForm.valueConstraintsSection.focusEvent = null;
        this.simpletypeRepresentationForm.textObjectSection.focusEvent = null;
        this.simpletypeRepresentationForm.externalRepresentationSection.focusEvent = null;
        this.simpletypeDatabaseForm.dbPropertySection.focusEvent = null;
    }

    public void setChangeButtonsVisible(boolean visible) {
    }

    public void adaptModifyButtons() {
        this.simpletypeDefinitionForm.lengthConstraintsSection.adaptModifyButtons();
        this.simpletypeDefinitionForm.valueConstraintsSection.adaptModifyButtons();
        this.simpletypeRepresentationForm.textObjectSection.adaptModifyButtons();
        this.simpletypeRepresentationForm.externalRepresentationSection.adaptModifyButtons();
        this.simpletypeDatabaseForm.dbPropertySection.adaptModifyButtons();
    }

    public void setModifyButtonsVisible(boolean visible) {
        this.simpletypeDefinitionForm.lengthConstraintsSection.setModifyButtonsVisible(visible);
        this.simpletypeDefinitionForm.valueConstraintsSection.setModifyButtonsVisible(visible);
        this.simpletypeRepresentationForm.textObjectSection.setModifyButtonsVisible(visible);
        this.simpletypeRepresentationForm.externalRepresentationSection.setModifyButtonsVisible(visible);
        this.simpletypeDatabaseForm.dbPropertySection.setModifyButtonsVisible(visible);
    }

    public void setModifyButtonsEnabled(boolean enabled) {
        this.simpletypeDefinitionForm.lengthConstraintsSection.setModifyButtonsEnabled(enabled);
        this.simpletypeDefinitionForm.valueConstraintsSection.setModifyButtonsEnabled(enabled);
        this.simpletypeRepresentationForm.textObjectSection.setModifyButtonsEnabled(enabled);
        this.simpletypeRepresentationForm.externalRepresentationSection.setModifyButtonsEnabled(enabled);
        this.simpletypeDatabaseForm.dbPropertySection.setModifyButtonsEnabled(enabled);
    }

    public void setEditorReadOnly() {
        this.setAllEditable(false);
        this.simpletypeDefinitionForm.basicInfoSection.setAllEditable(false);
        this.simpletypeEnumerationForm.enumerationSection.setButtonEnabled(0, false);
        this.simpletypeEnumerationForm.enumerationSection.setButtonEnabled(1, false);
        this.simpletypeEnumerationForm.enumerationSection.buttonWithClassRepresentation.setEnabled(false);
        this.setModifyButtonsEnabled(false);
    }

    public boolean isReadOnly() {
        IFile textfile;
        if (this.dictSimpleType == null) {
            return true;
        }
        if (this.dictSimpleType.hasLogicalDictionary()) {
            return true;
        }
        if (this.dictSimpleType.isDeleted()) {
            return true;
        }
        if (this.dictSimpleType.isReadOnly()) {
            this.textfileIsReadOnly = false;
            return true;
        }
        com.sap.ide.metamodel.general.i18n.TextPool textPool = this.dictSimpleType.getTextPool();
        if (textPool != null && (textfile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(textPool.getAbsolutePath(this.dictSimpleType.getMasterLanguage())))) != null && textfile.exists()) {
            if (textfile.isReadOnly()) {
                this.textfileIsReadOnly = true;
                this.textfileName = textfile.getName();
                return true;
            }
            this.textfileIsReadOnly = false;
            return false;
        }
        this.textfileIsReadOnly = false;
        return false;
    }

    public String getJdbcTypeName(String type, int length) {
        this.jdbcTypeInfos = DdMapping.getJdbcTypeInfo((String)type, (int)length, (DatabaseEnum[])this.dictDatabases);
        Iterator typeInfoElements = ((AbstractList)this.jdbcTypeInfos).iterator();
        String jdbcType = "";
        while (typeInfoElements.hasNext()) {
            DtTypeInfoForDatabase typeInfo = (DtTypeInfoForDatabase)typeInfoElements.next();
            if (!typeInfo.getDatabaseName().equals("DEFAULT")) continue;
            jdbcType = typeInfo.getJavaSqlTypeName();
        }
        return jdbcType;
    }

    private void updateTypeInfoMetadata() {
        this.dictTypeInfos = this.dictDbProperty.getTypeInfos();
        int numberOfValues = this.dictDbProperty.getTypeInfoCount();
        int j = 0;
        while (j < numberOfValues) {
            try {
                this.dictTypeInfo = this.dictTypeInfos[j];
                this.dictTypeInfo.delete();
            }
            catch (DeleteException e) {
                SimpletypeConstants.errMsg("JdbcTypeInfo could not be deleted");
            }
            ++j;
        }
        DatabaseEnum database = null;
        Iterator typeInfoElements = ((AbstractList)this.jdbcTypeInfos).iterator();
        int typeInfoId = 0;
        while (typeInfoElements.hasNext()) {
            DtTypeInfoForDatabase typeInfo = (DtTypeInfoForDatabase)typeInfoElements.next();
            if (typeInfo.getDatabaseName().equals("DEFAULT")) continue;
            String databaseName = typeInfo.getDatabaseName();
            int kk = 0;
            while (kk < this.dictDatabases.length) {
                if (this.dictDatabases[kk].toString().toUpperCase().equals(databaseName.toUpperCase())) {
                    database = this.dictDatabases[kk];
                }
                ++kk;
            }
            if (database == null) continue;
            try {
                this.dictTypeInfo = this.dictDbProperty.createTypeInfo(String.valueOf(typeInfoId));
            }
            catch (CreateException e) {
                SimpletypeConstants.errMsg("JdbcTypeInfo could not be created");
            }
            this.dictTypeInfo.setDatabase(database);
            this.dictTypeInfo.setJdbcTypeName(typeInfo.getJavaSqlTypeName());
            ++typeInfoId;
        }
    }

    public Metamodel getMetamodel() {
        return this.metamodel;
    }

    public void preSave() {
        this.updateMetamodel();
    }

    public void postSave() {
        this.isDirty = false;
    }

    public void dispose() {
        super.dispose();
        this.simpletypeImage.dispose();
        this.packageImage.dispose();
        this.dictionaryImage.dispose();
    }

    public void postRollback() {
        if (this.dictSimpleType.isDeleted() || this.dictSimpleType == null) {
            SimpletypePlugin.getDefault().deactivatePartListener();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
            SimpletypePlugin.getDefault().activatePartListener();
            return;
        }
        this.reloadAll();
        this.isDirty = false;
    }

    public void updateBuffer() {
        this.simpletypeDefinitionForm.basicInfoSection.updateBuffer();
        this.simpletypeDefinitionForm.lengthConstraintsSection.updateBuffer();
        this.simpletypeDefinitionForm.valueConstraintsSection.updateBuffer();
        this.simpletypeRepresentationForm.textObjectSection.updateBuffer();
        this.simpletypeRepresentationForm.externalRepresentationSection.updateBuffer();
        this.simpletypeDatabaseForm.dbPropertySection.updateBuffer();
    }

    public Control getEditorContainer() {
        return this.getContainer();
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.dictSimpleType;
    }

    public void updateUI() {
    }

    public class Paste
    extends AbstractPageAction {
        public Paste(SimpletypeMultiEditorPart editor) {
            super(editor, "paste", "org.eclipse.ui.edit.paste");
        }

        public void runOnControl(Control focusControl) {
            if (focusControl instanceof Text) {
                Text textControl = (Text)focusControl;
                textControl.paste();
            } else if (focusControl instanceof Combo) {
                Combo comboControl = (Combo)focusControl;
                comboControl.paste();
            }
        }
    }

    public class Copy
    extends AbstractPageAction {
        public Copy(SimpletypeMultiEditorPart editor) {
            super(editor, "copy", "org.eclipse.ui.edit.copy");
        }

        public void runOnControl(Control focusControl) {
            if (focusControl instanceof Text) {
                Text textControl = (Text)focusControl;
                textControl.copy();
            } else if (focusControl instanceof Combo) {
                Combo comboControl = (Combo)focusControl;
                comboControl.copy();
            }
        }
    }

    public class Cut
    extends AbstractPageAction {
        public Cut(SimpletypeMultiEditorPart editor) {
            super(editor, "cut", "org.eclipse.ui.edit.cut");
        }

        public void runOnControl(Control focusControl) {
            if (focusControl instanceof Text) {
                Text textControl = (Text)focusControl;
                textControl.cut();
            } else if (focusControl instanceof Combo) {
                Combo comboControl = (Combo)focusControl;
                comboControl.cut();
            }
        }
    }

    public abstract class AbstractPageAction
    extends Action {
        private SimpletypeMultiEditorPart myEditor;

        public AbstractPageAction(SimpletypeMultiEditorPart editor, String actionId, String actionDefinitionId) {
            this.setEditor(editor);
            this.setId(actionId);
            this.setActionDefinitionId(actionDefinitionId);
        }

        public final void run() {
            Control editorContainer = this.getEditor().getEditorContainer();
            Control focusControl = this.recursiveFocusControlSearch(editorContainer);
            if (focusControl != null) {
                this.runOnControl(focusControl);
            }
        }

        public abstract void runOnControl(Control var1);

        private Control recursiveFocusControlSearch(Control parent) {
            Control focusControl = null;
            if (parent instanceof Composite) {
                Composite parentCompo = (Composite)parent;
                Control[] childs = parentCompo.getChildren();
                int c = 0;
                while (c < childs.length && focusControl == null) {
                    Control control = childs[c];
                    if (control.isFocusControl()) {
                        focusControl = control;
                    } else if (control instanceof Composite) {
                        focusControl = this.recursiveFocusControlSearch(control);
                    }
                    ++c;
                }
            } else if (parent.isFocusControl()) {
                focusControl = parent;
            }
            return focusControl;
        }

        public SimpletypeMultiEditorPart getEditor() {
            return this.myEditor;
        }

        public void setEditor(SimpletypeMultiEditorPart editor) {
            this.myEditor = editor;
        }

        public boolean isToBeContributed() {
            return true;
        }
    }

    private static class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object e1, Object e2) {
            Integer i1 = new Integer(((DtEnumerationValue)e1).getName());
            Integer i2 = new Integer(((DtEnumerationValue)e2).getName());
            return i1.compareTo(i2);
        }
    }
}

