/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.designtime.DtSimpleTypeChecker;
import com.sap.dictionary.designtime.DtSimpleTypeExpanded;
import com.sap.dictionary.tools.simpletype.SimpletypeCheckCaller;
import com.sap.dictionary.tools.simpletype.SimpletypeConstants;
import com.sap.dictionary.tools.simpletype.SimpletypeDefinitionForm;
import com.sap.dictionary.tools.simpletype.SimpletypeResetCaller;
import com.sap.dictionary.tools.simpletype.SimpletypeTextElement;
import com.tssap.util.ui.glpc.section.AbstractSection;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimpletypeLengthConstraintsSection
extends AbstractSection {
    private SimpletypeDefinitionForm mForm = null;
    public Label labelLength;
    public Text textLength;
    public Button buttonLength;
    public Integer iLength = new Integer(0);
    public int yyLength;
    public Label labelMinLength;
    public Text textMinLength;
    public Button buttonMinLength;
    public Integer iMinLength = new Integer(0);
    public int yyMinLength;
    public Label labelMaxLength;
    public Text textMaxLength;
    public Button buttonMaxLength;
    public Integer iMaxLength = new Integer(0);
    public int yyMaxLength;
    public Label labelTotalDigits;
    public Text textTotalDigits;
    public Button buttonTotalDigits;
    public Integer iTotalDigits = new Integer(0);
    public int yyTotalDigits;
    public Label labelFractionDigits;
    public Text textFractionDigits;
    public Button buttonFractionDigits;
    public Integer iFractionDigits = new Integer(0);
    public int yyFractionDigits;
    public Button buttonChange;
    public FocusEvent focusEvent = null;
    public Label markerLength;
    public Label markerMinLength;
    public Label markerMaxLength;
    public Label markerTotalDigits;
    public Label markerFractionDigits;
    public int jdbcLength = 0;
    private static final int TEXT_LIMIT = 5;
    private SectionModifyListener modListener;

    public SimpletypeLengthConstraintsSection(IWidgetFactory widgetFactory, int columns, String title, String description, SimpletypeDefinitionForm form) {
        super(widgetFactory, columns, title, description);
        this.mForm = form;
    }

    public SimpletypeLengthConstraintsSection(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, String description, SimpletypeDefinitionForm form) {
        super(widgetFactory, columns, equalColumns, title, description);
        this.mForm = form;
    }

    protected void preInitSection(IGridLayoutPane glp) {
    }

    protected void postInitSection(IGridLayoutPane glp) {
    }

    public void initSection(IGridLayoutPane glp) {
        this.modListener = new SectionModifyListener();
        LengthModifyListener lengthModListener = new LengthModifyListener();
        SimpletypeTextElement tMaxLength = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Maximum Length:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    int li = new DtSimpleTypeExpanded(((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getMaxLength();
                    return new Integer(li).toString();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeLengthConstraintsSection.this.checkLengthAttributes();
            }
        });
        this.labelMaxLength = tMaxLength.wlabel;
        this.textMaxLength = tMaxLength.wtext;
        this.buttonMaxLength = tMaxLength.wbutton;
        this.markerMaxLength = tMaxLength.wmarker;
        this.textMaxLength.addModifyListener((ModifyListener)this.modListener);
        this.textMaxLength.addModifyListener((ModifyListener)lengthModListener);
        SimpletypeTextElement tMinLength = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Minimum Length:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    int li = new DtSimpleTypeExpanded(((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getMinLength();
                    return new Integer(li).toString();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeLengthConstraintsSection.this.checkLengthAttributes();
            }
        });
        this.labelMinLength = tMinLength.wlabel;
        this.textMinLength = tMinLength.wtext;
        this.buttonMinLength = tMinLength.wbutton;
        this.markerMinLength = tMinLength.wmarker;
        this.textMinLength.addModifyListener((ModifyListener)this.modListener);
        this.textMinLength.addModifyListener((ModifyListener)lengthModListener);
        SimpletypeTextElement tLength = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Fixed Length:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    int li = new DtSimpleTypeExpanded(((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getLength();
                    return new Integer(li).toString();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeLengthConstraintsSection.this.checkLengthAttributes();
            }
        });
        this.labelLength = tLength.wlabel;
        this.textLength = tLength.wtext;
        this.buttonLength = tLength.wbutton;
        this.markerLength = tLength.wmarker;
        this.textLength.addModifyListener((ModifyListener)this.modListener);
        this.textLength.addModifyListener((ModifyListener)lengthModListener);
        SimpletypeTextElement tTotalDigits = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Total Digits:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    int li = new DtSimpleTypeExpanded(((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getTotalDigits();
                    return new Integer(li).toString();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeLengthConstraintsSection.this.checkDecimalAttributes();
            }
        });
        this.labelTotalDigits = tTotalDigits.wlabel;
        this.textTotalDigits = tTotalDigits.wtext;
        this.buttonTotalDigits = tTotalDigits.wbutton;
        this.markerTotalDigits = tTotalDigits.wmarker;
        this.textTotalDigits.addModifyListener((ModifyListener)this.modListener);
        SimpletypeTextElement tFractionDigits = new SimpletypeTextElement(this.mForm.getEditor(), glp, "Fraction Digits:", new SimpletypeResetCaller(){

            public String getBaseValue() {
                try {
                    int li = new DtSimpleTypeExpanded(((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.currentBaseType, false).getFractionDigits();
                    return new Integer(li).toString();
                }
                catch (Exception e) {
                    return "";
                }
            }
        }, new SimpletypeCheckCaller(){

            public void check() {
                SimpletypeLengthConstraintsSection.this.checkDecimalAttributes();
            }
        });
        this.labelFractionDigits = tFractionDigits.wlabel;
        this.textFractionDigits = tFractionDigits.wtext;
        this.buttonFractionDigits = tFractionDigits.wbutton;
        this.markerFractionDigits = tFractionDigits.wmarker;
        this.textFractionDigits.addModifyListener((ModifyListener)this.modListener);
    }

    public void setLengthConstraintsEditable(boolean editable) {
        this.textLength.setEditable(editable);
        this.textMaxLength.setEditable(editable);
        this.textMinLength.setEditable(editable);
    }

    public void setDigitsConstraintsEditable(boolean editable) {
        this.textTotalDigits.setEditable(editable);
        this.textFractionDigits.setEditable(editable);
    }

    public void setAllEditable(boolean editable) {
        this.setLengthConstraintsEditable(editable);
        this.setDigitsConstraintsEditable(editable);
    }

    public void setLengthConstraintsVisible(boolean visible) {
        this.textLength.setVisible(visible);
        this.textMaxLength.setVisible(visible);
        this.textMinLength.setVisible(visible);
        this.labelLength.setEnabled(visible);
        this.labelMaxLength.setEnabled(visible);
        this.labelMinLength.setEnabled(visible);
    }

    public void setDigitsConstraintsVisible(boolean visible) {
        this.textTotalDigits.setVisible(visible);
        this.textFractionDigits.setVisible(visible);
        this.labelTotalDigits.setEnabled(visible);
        this.labelFractionDigits.setEnabled(visible);
    }

    public void clearAll() {
        this.textLength.setText("");
        this.textMaxLength.setText("");
        this.textMinLength.setText("");
        this.textTotalDigits.setText("");
        this.textFractionDigits.setText("");
    }

    public void adaptModifyButtons() {
        this.setButtonProperties(this.buttonLength, this.textLength);
        this.setButtonProperties(this.buttonMinLength, this.textMinLength);
        this.setButtonProperties(this.buttonMaxLength, this.textMaxLength);
        this.setButtonProperties(this.buttonTotalDigits, this.textTotalDigits);
        this.setButtonProperties(this.buttonFractionDigits, this.textFractionDigits);
    }

    public void setButtonProperties(Button pbutton, Text ptext) {
        if (!ptext.getEditable()) {
            pbutton.setImage(this.mForm.getEditor().modifyImage);
            pbutton.setToolTipText("Overwrite Base Type");
        } else {
            pbutton.setImage(this.mForm.getEditor().resetImage);
            pbutton.setToolTipText("Reset to Base Type");
        }
        pbutton.setVisible(ptext.getVisible());
        this.adaptButtonsToSchemaRestrictions();
    }

    public void setModifyButtonsVisible(boolean visible) {
        this.buttonLength.setVisible(visible);
        this.buttonMaxLength.setVisible(visible);
        this.buttonMinLength.setVisible(visible);
        this.adaptButtonsToSchemaRestrictions();
    }

    public void setModifyButtonsEnabled(boolean enabled) {
        this.buttonLength.setEnabled(enabled);
        this.buttonMaxLength.setEnabled(enabled);
        this.buttonMinLength.setEnabled(enabled);
        this.buttonTotalDigits.setEnabled(enabled);
        this.buttonFractionDigits.setEnabled(enabled);
    }

    private void checkLengthAttributes() {
        String message = "";
        if (this.textLength.getEditable() & this.textLength.getVisible()) {
            message = DtSimpleTypeChecker.checkLengthAttributes((int)SimpletypeConstants.getIntFromText(this.textLength), (int)SimpletypeConstants.getIntFromText(this.textMinLength), (int)SimpletypeConstants.getIntFromText(this.textMaxLength), (String)this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), (String)"");
        }
        SimpletypeConstants.setErrorMarker(message, this.labelLength, this.textLength, this.markerLength);
        SimpletypeConstants.setErrorMarker(message, this.labelMinLength, this.textMinLength, this.markerMinLength);
        SimpletypeConstants.setErrorMarker(message, this.labelMaxLength, this.textMaxLength, this.markerMaxLength);
    }

    private void checkDecimalAttributes() {
        String message = "";
        if (this.textTotalDigits.getVisible() && (message = DtSimpleTypeChecker.checkTotalDigitsAreZero((int)SimpletypeConstants.getIntFromText(this.textTotalDigits), (String)this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), (String)"")).equals("")) {
            message = DtSimpleTypeChecker.checkDecimalAttributes((int)SimpletypeConstants.getIntFromText(this.textTotalDigits), (int)SimpletypeConstants.getIntFromText(this.textFractionDigits), (String)this.mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), (String)"");
        }
        SimpletypeConstants.setErrorMarker(message, this.labelTotalDigits, this.textTotalDigits, this.markerTotalDigits);
        SimpletypeConstants.setErrorMarker(message, this.labelFractionDigits, this.textFractionDigits, this.markerFractionDigits);
    }

    private void adaptButtonsToSchemaRestrictions() {
        this.buttonTotalDigits.setVisible(false);
        this.buttonFractionDigits.setVisible(false);
        if (this.textLength.getText().equals("")) {
            if (!(this.textMinLength.getText().equals("") && this.textMaxLength.getText().equals("") || this.textLength.getEditable())) {
                this.buttonLength.setVisible(false);
            }
        } else {
            if (!this.textLength.getEditable()) {
                this.buttonLength.setVisible(false);
            }
            if (!this.textMaxLength.getEditable()) {
                this.buttonMaxLength.setVisible(false);
            }
            if (!this.textMinLength.getEditable()) {
                this.buttonMinLength.setVisible(false);
            }
        }
    }

    public void updateBuffer() {
        this.yyLength = this.mForm.getEditor().calculateIntProperty(this.textLength, this.iLength);
        this.yyMinLength = this.mForm.getEditor().calculateIntProperty(this.textMinLength, this.iMinLength);
        this.yyMaxLength = this.mForm.getEditor().calculateIntProperty(this.textMaxLength, this.iMaxLength);
        this.yyTotalDigits = this.mForm.getEditor().calculateIntProperty(this.textTotalDigits, this.iTotalDigits);
        this.yyFractionDigits = this.mForm.getEditor().calculateIntProperty(this.textFractionDigits, this.iFractionDigits);
    }

    private class LengthModifyListener
    implements ModifyListener {
        private LengthModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SimpletypeLengthConstraintsSection.this.jdbcLength = !((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textLength.getText().equals("") ? ((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.iLength : (!((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textMaxLength.getText().equals("") ? ((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.iMaxLength : (!((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.lengthConstraintsSection.textMinLength.getText().equals("") ? 0 : 0));
            String jdbcType = SimpletypeLengthConstraintsSection.this.mForm.getEditor().getJdbcTypeName(((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDefinitionForm.basicInfoSection.comboBuiltInType.getText(), SimpletypeLengthConstraintsSection.this.jdbcLength);
            Label labelJdbcType = ((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDatabaseForm.dbPropertySection.textlabelJdbcTypeName;
            if (labelJdbcType != null) {
                labelJdbcType.setText(jdbcType);
                ((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDatabaseForm.dbPropertySection.yyJdbcTypeName = jdbcType;
                ((SimpletypeLengthConstraintsSection)SimpletypeLengthConstraintsSection.this).mForm.getEditor().simpletypeDatabaseForm.dbPropertySection.checkNotNull();
            }
        }
    }

    private class SectionModifyListener
    implements ModifyListener {
        private SectionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            SimpletypeLengthConstraintsSection.this.mForm.getEditor().makeDirty(e.widget);
            SimpletypeLengthConstraintsSection.this.iLength = this.getIntegerFromText(SimpletypeLengthConstraintsSection.this.textLength);
            SimpletypeLengthConstraintsSection.this.iMinLength = this.getIntegerFromText(SimpletypeLengthConstraintsSection.this.textMinLength);
            SimpletypeLengthConstraintsSection.this.iMaxLength = this.getIntegerFromText(SimpletypeLengthConstraintsSection.this.textMaxLength);
            SimpletypeLengthConstraintsSection.this.iTotalDigits = this.getIntegerFromText(SimpletypeLengthConstraintsSection.this.textTotalDigits);
            SimpletypeLengthConstraintsSection.this.iFractionDigits = this.getIntegerFromText(SimpletypeLengthConstraintsSection.this.textFractionDigits);
            SimpletypeLengthConstraintsSection.this.updateBuffer();
        }

        private Integer getIntegerFromText(Text ltext) {
            Integer lval = new Integer(-1);
            if (ltext.getText().equals("")) {
                return lval;
            }
            try {
                lval = new Integer(ltext.getText());
            }
            catch (NumberFormatException e) {
                this.correctText(ltext);
            }
            return lval;
        }

        private void correctText(Text ltext) {
            MessageDialog.openError((Shell)SimpletypeLengthConstraintsSection.this.mForm.getEditor().getSite().getShell(), (String)"Input Error", (String)"Enter a non-negative integer");
            ltext.removeModifyListener((ModifyListener)SimpletypeLengthConstraintsSection.this.modListener);
            this.deleteCharacters(ltext);
            ltext.addModifyListener((ModifyListener)SimpletypeLengthConstraintsSection.this.modListener);
        }

        private void deleteCharacters(Text ltext) {
            int cpos = ltext.getCaretPosition();
            if (cpos > 0) {
                --cpos;
            }
            if (ltext.getText().equals("")) {
                ltext.setText("0");
            } else {
                StringBuffer mystring = new StringBuffer(ltext.getText());
                mystring.deleteCharAt(cpos);
                ltext.setText(mystring.toString());
                ltext.setSelection(cpos, cpos);
                if (ltext.getText().equals("")) {
                    return;
                }
                try {
                    Integer lint = new Integer(ltext.getText());
                }
                catch (NumberFormatException e) {
                    this.deleteCharacters(ltext);
                }
            }
        }
    }
}

