/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.simpletype;

import com.sap.dictionary.tools.simpletype.SimpletypeConstants;
import com.sap.dictionary.tools.simpletype.SimpletypeMultiEditorPart;
import com.sap.dictionary.tools.simpletype.SimpletypePlugin;
import com.sap.ide.metamodel.dictionary.datatype.DtEnumerationValue;
import com.sap.ide.metamodel.dictionary.datatype.DtSchemaType;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.RefactoringException;
import com.sap.ide.metamodel.general.refactoring.RefactoringRequest;
import com.sap.ide.metamodel.general.refactoring.RefactoringTask;
import javax.swing.table.DefaultTableModel;
import org.eclipse.swt.widgets.Table;

public class SimpletypeEnumerationTableModel
extends DefaultTableModel {
    private SimpletypeMultiEditorPart mEditor;

    public SimpletypeEnumerationTableModel(SimpletypeMultiEditorPart editor) {
        this.mEditor = editor;
    }

    private DtSchemaType getSchemaType() {
        DtSchemaType schemaType = this.mEditor.dictSimpleType.getSchemaType();
        if (schemaType == null) {
            try {
                schemaType = this.mEditor.dictSimpleType.createSchemaType();
            }
            catch (CreateException e) {
                SimpletypePlugin.tracer.error("create schema type", (Throwable)e);
            }
        }
        return schemaType;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void doNew(String[] s) {
        SimpletypeEnumerationTableModel.createEnumerationValue(this.mEditor.dictSimpleType, s[0], s[1], true);
        this.addRow(s);
    }

    public void doEdit(String[] s, int row) {
        if (!SimpletypeEnumerationTableModel.canModifyOrDeleteEnumerationValue(this.mEditor.dictSimpleType, row)) {
            SimpletypeConstants.errMsg("Enumeration value does not exist");
            return;
        }
        SimpletypeEnumerationTableModel.modifyEnumerationValue(this.mEditor.dictSimpleType, row, s[0], s[1]);
        this.setValueAt(s[0], row, 0);
        this.setValueAt(s[1], row, 1);
    }

    public void doDelete(Table table) {
        if (!this.mEditor.simpletypeDefinitionForm.basicInfoSection.textBaseTypeFullName.getText().equals("") && this.getSchemaType().getEnumerationValueCount() == 0) {
            this.createAllEnumerationValues();
        }
        if (this.getSchemaType().getEnumerationValueCount() > 0) {
            int selCount = table.getSelectionCount();
            int i = 0;
            while (i < selCount) {
                int[] selIndices = table.getSelectionIndices();
                this.doDeleteInternal(selIndices[0]);
                ++i;
            }
        }
        SimpletypeEnumerationTableModel.renameEnumerationValues(this.mEditor.dictSimpleType);
    }

    private void doDeleteInternal(int row) {
        if (!SimpletypeEnumerationTableModel.canModifyOrDeleteEnumerationValue(this.mEditor.dictSimpleType, row)) {
            SimpletypeConstants.errMsg("Enumeration value could not be deleted");
            return;
        }
        SimpletypeEnumerationTableModel.deleteEnumerationValue(this.mEditor.dictSimpleType, row, false);
        this.removeRow(row);
    }

    private void createAllEnumerationValues() {
        Object enumValue = null;
        String val = null;
        String desc = null;
        int k = 0;
        while (k < this.getRowCount()) {
            val = (String)this.getValueAt(k, 0);
            desc = (String)this.getValueAt(k, 1);
            SimpletypeEnumerationTableModel.createEnumerationValue(this.mEditor.dictSimpleType, val, desc, false);
            ++k;
        }
    }

    private static String createEnumerationValueName(DtSimpleType simpleType) {
        String name = null;
        String prefix = "enumVal";
        int numberOfValues = simpleType.getSchemaType().getEnumerationValueCount();
        int k = 0;
        while (k <= numberOfValues) {
            name = prefix + String.valueOf(k);
            if (!simpleType.getSchemaType().hasEnumerationValue(name)) break;
            ++k;
        }
        return name;
    }

    public static void renameEnumerationValues(DtSimpleType simpleType) {
        DtEnumerationValue[] enumValues = null;
        DtEnumerationValue enumValue = null;
        if (!simpleType.hasSchemaType()) {
            return;
        }
        RefactoringRequest request = simpleType.getSchemaType().getMetamodel().createRefactoringRequest();
        RefactoringTask task = null;
        enumValues = simpleType.getSchemaType().getEnumerationValues();
        int numberOfValues = simpleType.getSchemaType().getEnumerationValueCount();
        int j = 0;
        while (j < numberOfValues) {
            enumValue = enumValues[j];
            task = request.createRefactoringTask((DevelopmentObject)enumValue);
            task.setNewName(enumValue.getName() + "$$$$");
            ++j;
        }
        request.minimizeRefactoringScope();
        try {
            request.execute();
        }
        catch (RefactoringException e1) {
            throw new RuntimeException();
        }
        RefactoringRequest request2 = simpleType.getSchemaType().getMetamodel().createRefactoringRequest();
        int j2 = 0;
        while (j2 < numberOfValues) {
            enumValue = enumValues[j2];
            task = request2.createRefactoringTask((DevelopmentObject)enumValue);
            task.setNewName(String.valueOf(j2));
            ++j2;
        }
        request2.minimizeRefactoringScope();
        try {
            request2.execute();
        }
        catch (RefactoringException e1) {
            throw new RuntimeException();
        }
    }

    public static void createEnumerationValue(DtSimpleType simpleType, String value, String description, boolean withRename) {
        if (!simpleType.hasSchemaType()) {
            try {
                simpleType.createSchemaType();
            }
            catch (CreateException e) {
                throw new RuntimeException();
            }
        }
        DtEnumerationValue enumValue = null;
        String name = SimpletypeEnumerationTableModel.createEnumerationValueName(simpleType);
        try {
            enumValue = simpleType.getSchemaType().createEnumerationValue(name);
            enumValue.setValue(value);
            enumValue.setDescription(description);
            if (withRename) {
                SimpletypeEnumerationTableModel.renameEnumerationValues(simpleType);
            }
        }
        catch (CreateException e) {
            throw new RuntimeException();
        }
    }

    public static boolean canModifyOrDeleteEnumerationValue(DtSimpleType simpleType, int row) {
        if (!simpleType.hasSchemaType()) {
            return false;
        }
        return simpleType.getSchemaType().getEnumerationValue(row) != null;
    }

    public static void modifyEnumerationValue(DtSimpleType simpleType, int row, String value, String description) {
        if (!simpleType.hasSchemaType()) {
            throw new RuntimeException();
        }
        DtEnumerationValue enumValue = simpleType.getSchemaType().getEnumerationValue(row);
        if (enumValue == null) {
            throw new RuntimeException();
        }
        enumValue.setValue(value);
        enumValue.setDescription(description);
    }

    public static void deleteEnumerationValue(DtSimpleType simpleType, int row, boolean withRename) {
        block7: {
            if (!simpleType.hasSchemaType()) {
                throw new RuntimeException();
            }
            DtEnumerationValue enumValue = simpleType.getSchemaType().getEnumerationValue(row);
            if (enumValue == null) {
                throw new RuntimeException();
            }
            try {
                enumValue.delete();
                if (enumValue.getDescriptionAsTranslatableText() == null) break block7;
                try {
                    enumValue.getDescriptionAsTranslatableText().delete();
                }
                catch (DeleteException e) {
                    throw new RuntimeException();
                }
            }
            catch (DeleteException e) {
                throw new RuntimeException();
            }
        }
        if (withRename) {
            SimpletypeEnumerationTableModel.renameEnumerationValues(simpleType);
        }
    }

    public void deleteAllEnumerationValues() {
        DtEnumerationValue[] enumValues = null;
        DtEnumerationValue enumValue = null;
        enumValues = this.getSchemaType().getEnumerationValues();
        int numberOfValues = this.getSchemaType().getEnumerationValueCount();
        int j = 0;
        while (j < numberOfValues) {
            try {
                enumValue = enumValues[j];
                if (enumValue.getDescriptionAsTranslatableText() != null) {
                    try {
                        enumValue.getDescriptionAsTranslatableText().delete();
                    }
                    catch (DeleteException e) {
                        SimpletypeConstants.errMsg("Text object could not be deleted");
                    }
                }
                enumValue.delete();
            }
            catch (DeleteException e) {
                SimpletypeConstants.errMsg("Enumeration value could not be deleted");
            }
            ++j;
        }
    }
}

